/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.util.ConstantsVuze;

public class ContentNetworkUtils {
    public static String getUrl(ContentNetwork cn, int serviceID) {
        try {
            if (!cn.isServiceSupported(serviceID)) {
            }
            return cn.getServiceURL(serviceID);
        }
        finally {
            return null;
        }
    }

    public static ContentNetwork getContentNetworkFromTarget(String target) {
        ContentNetwork cn = null;
        if (target != null && target.startsWith("ContentNetwork.")) {
            long networkID = Long.parseLong(target.substring(15));
            cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(networkID);
        }
        if (cn == null) {
            cn = ConstantsVuze.getDefaultContentNetwork();
        }
        return cn;
    }

    public static String getTarget(ContentNetwork cn) {
        return "ContentNetwork." + (cn == null ? ConstantsVuze.getDefaultContentNetwork().getID() : cn.getID());
    }
}

