/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.viewtitleinfo;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import org.gudy.azureus2.core3.util.Debug;

public class ViewTitleInfoManager {
    public static CopyOnWriteList<ViewTitleInfoListener> listeners = new CopyOnWriteList();

    public static void addListener(ViewTitleInfoListener l) {
        listeners.addIfNotPresent(l);
    }

    public static void removeListener(ViewTitleInfoListener l) {
        listeners.remove(l);
    }

    public static void refreshTitleInfo(ViewTitleInfo titleinfo) {
        if (titleinfo == null) {
            return;
        }
        for (ViewTitleInfoListener l : listeners) {
            try {
                l.viewTitleInfoRefresh(titleinfo);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }
}

