/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnCoreCreationListener;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.impl.CoreTableColumn;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.common.table.impl.TableColumnInfoImpl;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class TableColumnManager {
    private static final String CONFIG_FILE = "tables.config";
    private static TableColumnManager instance;
    private static AEMonitor class_mon;
    private Map<String, Map> items;
    private AEMonitor items_mon = new AEMonitor("TableColumnManager:items");
    private Map autoHideOrder = new LightHashMap();
    private Object tablesConfig;
    private long lastTableConfigAccess;
    private static Comparator<TableColumn> orderComparator;
    private Map<String, TableColumnCreationListener> mapColumnIDsToListener = new LightHashMap<String, TableColumnCreationListener>();
    private Map<Class, List> mapDataSourceTypeToColumnIDs = new LightHashMap<Class, List>();
    private Map<String, String[]> mapTableDefaultColumns = new LightHashMap<String, String[]>();
    private Map<String, Class[]> mapTableIDsDSTs = new LightHashMap<String, Class[]>();
    private static final Map<String, String> mapResetTable_Version;
    private static final boolean RERESET = false;

    static {
        COConfigurationManager.addResetToDefaultsListener(new COConfigurationManager.ResetToDefaultsListener(){

            @Override
            public void reset() {
                TableColumnManager.getInstance().resetAllTables();
            }
        });
        class_mon = new AEMonitor("TableColumnManager");
        orderComparator = new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn col0, TableColumn col1) {
                int i;
                int iPositionB;
                if (col0 == null || col1 == null) {
                    return 0;
                }
                int iPositionA = col0.getPosition();
                if (iPositionA < 0) {
                    iPositionA += 65535;
                }
                if ((iPositionB = col1.getPosition()) < 0) {
                    iPositionB += 65535;
                }
                if ((i = iPositionA - iPositionB) != 0 || iPositionA == 65533) {
                    return i;
                }
                String name0 = col0.getName();
                String name1 = col1.getName();
                String[] names = TableColumnManager.getInstance().getDefaultColumnNames(col0.getTableID());
                if (names != null) {
                    String[] stringArray = names;
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (name.equals(name0)) {
                            return -1;
                        }
                        if (name.equals(name1)) {
                            return 1;
                        }
                        ++n2;
                    }
                }
                return name0.compareTo(name1);
            }
        };
        mapResetTable_Version = new HashMap<String, String>();
        mapResetTable_Version.put("DeviceLibrary", "4.4.0.7");
        mapResetTable_Version.put("TranscodeQueue", "4.4.0.7");
        mapResetTable_Version.put("MySeeders.big", "4.4.0.7");
        mapResetTable_Version.put("MyLibrary.big", "4.4.0.7");
        mapResetTable_Version.put("MyTorrents.big", "4.4.0.7");
        mapResetTable_Version.put("Unopened.big", "4.6.0.1");
        mapResetTable_Version.put("Unopened", "4.6.0.1");
    }

    private TableColumnManager() {
        this.items = new HashMap<String, Map>();
    }

    public static TableColumnManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableColumnManager();
            }
            TableColumnManager tableColumnManager = instance;
            return tableColumnManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addColumns(TableColumnCore[] itemsToAdd) {
        try {
            try {
                TableColumnCore item;
                this.items_mon.enter();
                int i = 0;
                while (i < itemsToAdd.length) {
                    item = itemsToAdd[i];
                    if (item != null && !item.isRemoved()) {
                        String name = item.getName();
                        String sTableID = item.getTableID();
                        LinkedHashMap<String, TableColumnCore> mTypes = this.items.get(sTableID);
                        if (mTypes == null) {
                            mTypes = new LinkedHashMap<String, TableColumnCore>();
                            this.items.put(sTableID, mTypes);
                        }
                        if (!mTypes.containsKey(name)) {
                            mTypes.put(name, item);
                            Map mapColumnConfig = this.getTableConfigMap(sTableID);
                            item.loadSettings(mapColumnConfig);
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < itemsToAdd.length) {
                    item = itemsToAdd[i];
                    if (item != null && !item.isRemoved() && !item.getColumnAdded()) {
                        item.setColumnAdded();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("Error while adding Table Column Extension");
                Debug.printStackTrace(e);
                this.items_mon.exit();
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public void removeColumns(TableColumnCore[] itemsToRemove) {
        try {
            try {
                this.items_mon.enter();
                int i = 0;
                while (i < itemsToRemove.length) {
                    TableColumnCore item = itemsToRemove[i];
                    String name = item.getName();
                    String sTableID = item.getTableID();
                    Map mTypes = this.items.get(sTableID);
                    if (mTypes != null) {
                        mTypes.remove(name);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("Error while adding Table Column Extension");
                Debug.printStackTrace(e);
                this.items_mon.exit();
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public Map<String, TableColumnCore> getTableColumnsAsMap(Class forDataSourceType, String sTableID) {
        try {
            this.items_mon.enter();
            LinkedHashMap<String, TableColumnCore> mReturn = new LinkedHashMap<String, TableColumnCore>();
            Map<String, TableColumnCore> mTypes = this.getAllTableColumnCore(forDataSourceType, sTableID);
            if (mTypes != null) {
                mReturn.putAll(mTypes);
            }
            LinkedHashMap<String, TableColumnCore> linkedHashMap = mReturn;
            return linkedHashMap;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public int getTableColumnCount(String sTableID) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return 0;
        }
        return mTypes.size();
    }

    public TableColumnCore[] getAllTableColumnCoreAsArray(Class forDataSourceType, String tableID) {
        Map<String, TableColumnCore> mTypes = this.getAllTableColumnCore(forDataSourceType, tableID);
        TableColumnCore[] columns = mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        return columns;
    }

    public String[] getDefaultColumnNames(String tableID) {
        String[] columnNames = this.mapTableDefaultColumns.get(tableID);
        return columnNames;
    }

    public void setDefaultColumnNames(String tableID, TableColumn[] columns) {
        ArrayList<String> names = new ArrayList<String>(columns.length);
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.isVisible()) {
                names.add(column.getName());
            }
            ++n2;
        }
        this.setDefaultColumnNames(tableID, names.toArray(new String[names.size()]));
    }

    public void setDefaultColumnNames(String tableID, String[] columnNames) {
        this.mapTableDefaultColumns.put(tableID, columnNames);
    }

    private Map<String, TableColumnCore> getAllTableColumnCore(Class forDataSourceType, String tableID) {
        LinkedHashMap<String, TableColumnCore> mapExisting = null;
        try {
            this.items_mon.enter();
            mapExisting = this.items.get(tableID);
            if (mapExisting == null) {
                mapExisting = new LinkedHashMap<String, TableColumnCore>();
                this.items.put(tableID, mapExisting);
            }
            if (forDataSourceType != null) {
                HashMap mapDST = new HashMap();
                List listDST = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
                if (listDST != null && listDST.size() > 0) {
                    mapDST.put(forDataSourceType, listDST);
                }
                if (forDataSourceType.equals(DownloadTypeComplete.class) || forDataSourceType.equals(DownloadTypeIncomplete.class)) {
                    listDST = this.mapDataSourceTypeToColumnIDs.get(Download.class);
                    if (listDST != null && listDST.size() > 0) {
                        mapDST.put(Download.class, listDST);
                    }
                } else if (Download.class.equals((Object)forDataSourceType)) {
                    listDST = this.mapDataSourceTypeToColumnIDs.get(DownloadTypeComplete.class);
                    if (listDST != null && listDST.size() > 0) {
                        mapDST.put(DownloadTypeComplete.class, listDST);
                    }
                    if ((listDST = this.mapDataSourceTypeToColumnIDs.get(DownloadTypeIncomplete.class)) != null && listDST.size() > 0) {
                        mapDST.put(DownloadTypeIncomplete.class, listDST);
                    }
                }
                this.doAddCreate(mapExisting, tableID, mapDST);
            }
        }
        finally {
            this.items_mon.exit();
        }
        return mapExisting;
    }

    private void doAddCreate(Map mTypes, String tableID, Map<Class<?>, List> mapDST) {
        this.mapTableIDsDSTs.put(tableID, mapDST.keySet().toArray(new Class[0]));
        ArrayList<TableColumnCore> listAdded = new ArrayList<TableColumnCore>();
        for (Class<?> forDataSourceType : mapDST.keySet()) {
            List listDST = mapDST.get(forDataSourceType);
            for (String columnID : listDST) {
                if (mTypes.containsKey(columnID)) continue;
                try {
                    TableColumnCreationListener l = this.mapColumnIDsToListener.get(forDataSourceType + "." + columnID);
                    TableColumnCore tc = null;
                    if (l instanceof TableColumnCoreCreationListener) {
                        tc = ((TableColumnCoreCreationListener)l).createTableColumnCore(forDataSourceType, tableID, columnID);
                    }
                    if (tc == null) {
                        tc = new TableColumnImpl(tableID, columnID);
                        tc.addDataSourceType(forDataSourceType);
                    }
                    if (l != null) {
                        l.tableColumnCreated(tc);
                    }
                    listAdded.add(tc);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        this.addColumns(listAdded.toArray(new TableColumnCore[0]));
    }

    public String[] getTableIDs() {
        try {
            this.items_mon.enter();
            Set<String> ids = this.items.keySet();
            String[] stringArray = ids.toArray(new String[ids.size()]);
            return stringArray;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public String[] appendLists(String[] list1, String[] list2) {
        int size = list1.length + list2.length;
        String[] list = new String[size];
        System.arraycopy(list1, 0, list, 0, list1.length);
        System.arraycopy(list2, 0, list, list1.length, list2.length);
        return list;
    }

    public TableColumnCore getTableColumnCore(String sTableID, String sColumnName) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return null;
        }
        return (TableColumnCore)mTypes.get(sColumnName);
    }

    public void ensureIntegrety(Class dataSourceType, String sTableID) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return;
        }
        TableColumnCore[] tableColumns = mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        int iPos = 0;
        int i = 0;
        while (i < tableColumns.length) {
            int iCurPos = tableColumns[i].getPosition();
            if (iCurPos == -1) {
                tableColumns[i].setVisible(false);
            } else {
                tableColumns[i].setPositionNoShift(iPos++);
            }
            ++i;
        }
        if (iPos == 0) {
            this.resetColumns(dataSourceType, sTableID);
        }
    }

    public String getDefaultSortColumnName(String tableID) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        Object object = mapTableConfig.get("SortColumn");
        if (object instanceof byte[]) {
            object = new String((byte[])object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        String s = COConfigurationManager.getStringParameter(String.valueOf(tableID) + ".sortColumn");
        if (s != null) {
            COConfigurationManager.removeParameter(String.valueOf(tableID) + ".sortColumn");
            COConfigurationManager.removeParameter(String.valueOf(tableID) + ".sortAsc");
        }
        return s;
    }

    public void setDefaultSortColumnName(String tableID, String columnName) {
        this.setDefaultSortColumnName(tableID, columnName, false);
    }

    public void setDefaultSortColumnName(String tableID, String columnName, boolean force) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        Object existing = mapTableConfig.get("SortColumn");
        if (existing != null) {
            String str;
            if (!force) {
                return;
            }
            String string = str = existing instanceof byte[] ? new String((byte[])existing) : (String)existing;
            if (str.equals(columnName)) {
                return;
            }
        }
        mapTableConfig.put("SortColumn", columnName);
        this.saveTableConfigs();
    }

    private void saveTableConfigs() {
        if (this.tablesConfig instanceof Map) {
            FileUtil.writeResilientConfigFile(CONFIG_FILE, (Map)this.tablesConfig);
        }
    }

    public void saveTableColumns(Class forDataSourceType, String sTableID) {
        try {
            Map mapTableConfig = this.getTableConfigMap(sTableID);
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            int i = 0;
            while (i < tcs.length) {
                if (tcs[i] != null) {
                    tcs[i].saveSettings(mapTableConfig);
                }
                ++i;
            }
            this.saveTableConfigs();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public boolean loadTableColumnSettings(Class forDataSourceType, String sTableID) {
        Map mapTableConfig;
        block8: {
            block7: {
                mapTableConfig = this.getTableConfigMap(sTableID);
                int size = mapTableConfig.size();
                if (size != 0) break block7;
                return false;
            }
            boolean hasColumnInfo = false;
            for (Object key : mapTableConfig.keySet()) {
                if (!(key instanceof String) || !((String)key).startsWith("Column.")) continue;
                hasColumnInfo = true;
                break;
            }
            if (hasColumnInfo) break block8;
            return false;
        }
        try {
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            int i = 0;
            while (i < tcs.length) {
                if (tcs[i] != null) {
                    tcs[i].loadSettings(mapTableConfig);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return true;
    }

    private Map getTablesConfigMap() {
        this.lastTableConfigAccess = SystemTime.getMonotonousTime();
        if (this.tablesConfig == null) {
            this.tablesConfig = FileUtil.readResilientConfigFile(CONFIG_FILE);
            SimpleTimer.addEvent("DisposeTableConfigMap", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    TableColumnManager tableColumnManager = TableColumnManager.this;
                    synchronized (tableColumnManager) {
                        long now = SystemTime.getMonotonousTime();
                        if (now - TableColumnManager.this.lastTableConfigAccess > 25000L) {
                            TableColumnManager.this.tablesConfig = null;
                        } else {
                            SimpleTimer.addEvent("DisposeTableConfigMap", SystemTime.getOffsetTime(30000L), this);
                        }
                    }
                }
            });
        }
        return (Map)this.tablesConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTableConfigMap(String sTableID) {
        TableColumnManager tableColumnManager = this;
        synchronized (tableColumnManager) {
            String key = "Table." + sTableID;
            Map mapTablesConfig = this.getTablesConfigMap();
            HashMap<String, String> mapTableConfig = (HashMap<String, String>)mapTablesConfig.get(key);
            if (mapTableConfig == null) {
                mapTableConfig = new HashMap<String, String>();
                mapTablesConfig.put("Table." + sTableID, mapTableConfig);
            } else {
                String lastReset;
                String resetIfLastResetBelowVersion = mapResetTable_Version.get(sTableID);
                if (resetIfLastResetBelowVersion != null && Constants.compareVersions(lastReset = MapUtils.getMapString(mapTableConfig, "last.reset", "0.0.0.0"), resetIfLastResetBelowVersion) < 0) {
                    mapTableConfig.clear();
                    mapTableConfig.put("last.reset", Constants.getBaseVersion());
                    this.saveTableConfigs();
                    mapResetTable_Version.remove(sTableID);
                }
            }
            return mapTableConfig;
        }
    }

    public void setAutoHideOrder(String sTableID, String[] autoHideOrderColumnIDs) {
        ArrayList<TableColumnCore> autoHideOrderList = new ArrayList<TableColumnCore>(autoHideOrderColumnIDs.length);
        int i = 0;
        while (i < autoHideOrderColumnIDs.length) {
            String sColumnID = autoHideOrderColumnIDs[i];
            TableColumnCore column = this.getTableColumnCore(sTableID, sColumnID);
            if (column != null) {
                autoHideOrderList.add(column);
            }
            ++i;
        }
        this.autoHideOrder.put(sTableID, autoHideOrderList);
    }

    public List getAutoHideOrder(String sTableID) {
        List list = (List)this.autoHideOrder.get(sTableID);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public void generateDiagnostics(IndentWriter writer) {
        try {
            try {
                this.items_mon.enter();
                writer.println("TableColumns");
                for (String sTableID : this.items.keySet()) {
                    Map mTypes = this.items.get(sTableID);
                    writer.indent();
                    writer.println(String.valueOf(sTableID) + ": " + mTypes.size() + " columns:");
                    writer.indent();
                    for (TableColumnCore tc : mTypes.values()) {
                        tc.generateDiagnostics(writer);
                    }
                    writer.exdent();
                    writer.exdent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.items_mon.exit();
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public static Comparator<TableColumn> getTableColumnOrderComparator() {
        return orderComparator;
    }

    public void registerColumn(Class forDataSourceType, String columnID, TableColumnCreationListener listener) {
        if (listener != null) {
            this.mapColumnIDsToListener.put(forDataSourceType + "." + columnID, listener);
        }
        try {
            this.items_mon.enter();
            ArrayList<String> list = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
            if (list == null) {
                list = new ArrayList<String>(1);
                this.mapDataSourceTypeToColumnIDs.put(forDataSourceType, list);
            }
            if (!list.contains(columnID)) {
                list.add(columnID);
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public void unregisterColumn(Class forDataSourceType, String columnID, TableColumnCreationListener listener) {
        try {
            this.items_mon.enter();
            this.mapColumnIDsToListener.remove(forDataSourceType + "." + columnID);
            List list = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
            if (list != null) {
                list.remove(columnID);
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public TableColumnInfo getColumnInfo(Class forDataSourceType, String forTableID, String columnID) {
        TableColumnCore column = this.getTableColumnCore(forTableID, columnID);
        return column == null ? null : this.getColumnInfo(column);
    }

    public TableColumnInfo getColumnInfo(TableColumnCore column) {
        TableColumnInfoImpl columnInfo = new TableColumnInfoImpl(column);
        List<TableColumnExtraInfoListener> listeners = column.getColumnExtraInfoListeners();
        for (TableColumnExtraInfoListener l : listeners) {
            l.fillTableColumnInfo(columnInfo);
        }
        if (columnInfo.getCategories() == null && !(column instanceof CoreTableColumn)) {
            columnInfo.addCategories(new String[]{"plugin"});
            columnInfo.setProficiency((byte)0);
        }
        return columnInfo;
    }

    private void resetAllTables() {
        for (String tableID : new ArrayList<String>(this.mapTableDefaultColumns.keySet())) {
            Class[] dataSourceTypes = this.mapTableIDsDSTs.get(tableID);
            if (dataSourceTypes == null || dataSourceTypes.length == 0) {
                this.resetColumns(null, tableID);
                continue;
            }
            Class[] classArray = dataSourceTypes;
            int n = dataSourceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class dataSourceType = classArray[n2];
                this.resetColumns(dataSourceType, tableID);
                ++n2;
            }
        }
    }

    public Object getColumnData(String columnID, String key) {
        Map mapConfig;
        Map mapTablesConfig = this.getTablesConfigMap();
        Map mapColumns = MapUtils.getMapMap(mapTablesConfig, "Columns", null);
        if (mapColumns != null && (mapConfig = MapUtils.getMapMap(mapColumns, columnID, null)) != null) {
            return mapConfig.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnData(String columnID, String key, Object value) {
        Object object = this.tablesConfig;
        synchronized (object) {
            LightHashMap mapConfig;
            Map mapTablesConfig = this.getTablesConfigMap();
            LightHashMap mapColumns = MapUtils.getMapMap(mapTablesConfig, "Columns", null);
            if (mapColumns == null) {
                mapColumns = new LightHashMap(2);
                mapTablesConfig.put("Columns", mapColumns);
            }
            if ((mapConfig = MapUtils.getMapMap(mapColumns, columnID, null)) == null) {
                mapConfig = new LightHashMap(2);
                mapColumns.put(columnID, mapConfig);
            }
            mapConfig.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumnData(String columnID, String key) {
        Object object = this.tablesConfig;
        synchronized (object) {
            Map mapConfig;
            Map mapTablesConfig = this.getTablesConfigMap();
            Map mapColumns = MapUtils.getMapMap(mapTablesConfig, "Columns", null);
            if (mapColumns != null && (mapConfig = MapUtils.getMapMap(mapColumns, columnID, null)) != null) {
                mapConfig.remove(key);
                if (mapConfig.size() < 1) {
                    mapColumns.remove(columnID);
                }
            }
        }
    }

    public void resetColumns(Class dataSourceType, String tableID) {
        String[] defaultColumnNames;
        TableColumnCore[] allTableColumns = this.getAllTableColumnCoreAsArray(dataSourceType, tableID);
        if (allTableColumns != null) {
            TableColumnCore[] tableColumnCoreArray = allTableColumns;
            int n = allTableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnCore column = tableColumnCoreArray[n2];
                if (column != null) {
                    column.setVisible(false);
                    column.reset();
                }
                ++n2;
            }
        }
        if ((defaultColumnNames = this.getDefaultColumnNames(tableID)) != null) {
            int i = 0;
            String[] stringArray = defaultColumnNames;
            int n = defaultColumnNames.length;
            int n3 = 0;
            while (n3 < n) {
                String name = stringArray[n3];
                TableColumnCore column = this.getTableColumnCore(tableID, name);
                if (column != null) {
                    column.setVisible(true);
                    column.setPositionNoShift(i++);
                }
                ++n3;
            }
        }
        this.saveTableColumns(dataSourceType, tableID);
        TableStructureEventDispatcher.getInstance(tableID).tableStructureChanged(true, dataSourceType);
    }
}

