/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.bouncycastle.util.encoders.Base64;

public class XMRPCClientUtils {
    private String session_id;

    public static byte[] getFromURLBasic(String url) throws XMRPCClientException {
        try {
            int len;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new XMRPCClientException("HTTP GET for " + url + " failed", e);
        }
    }

    protected String getFromURL(String url) throws XMRPCClientException {
        try {
            byte[] bytes = this.getFromURL(url, null, null, null, null);
            String result = new String(bytes, "UTF-8");
            System.out.println(String.valueOf(url) + " -> " + result);
            return result;
        }
        catch (IOException e) {
            throw new XMRPCClientException("HTTP GET for " + url + " failed", e);
        }
    }

    protected byte[] getFromURL(String url, Map<String, String> headers_in, Map<String, String> headers_out, String username, String password) throws XMRPCClientException {
        try {
            int i = 0;
            while (i < 2) {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestProperty("Connection", "Keep-Alive");
                if (headers_in != null) {
                    for (Map.Entry<String, String> entry : headers_in.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (username != null) {
                    String login = String.valueOf(username) + ":" + password;
                    String encodedLogin = new String(Base64.encode(login.getBytes("UTF-8")));
                    connection.setRequestProperty("Authorization", "Basic " + encodedLogin);
                }
                if (this.session_id != null) {
                    connection.setRequestProperty("X-Transmission-Session-Id", this.session_id);
                }
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                try {
                    int len;
                    InputStream is = connection.getInputStream();
                    if (headers_out != null) {
                        Map<String, List<String>> temp = connection.getHeaderFields();
                        for (Map.Entry<String, List<String>> entry : temp.entrySet()) {
                            String key = entry.getKey();
                            List<String> values = entry.getValue();
                            if (values.size() <= 0) continue;
                            headers_out.put(key, values.get(0));
                        }
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                    byte[] buffer = new byte[8192];
                    while ((len = is.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    String str;
                    if (connection.getResponseCode() != 409 || (str = connection.getHeaderField("x-transmission-session-id")) == null || this.session_id != null && this.session_id.equals(str)) {
                        throw e;
                    }
                    this.session_id = str;
                    ++i;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new XMRPCClientException("HTTP GET for " + url + " failed", e);
        }
    }

    protected byte[] postToURL(String url, byte[] payload) throws XMRPCClientException {
        return this.postToURL(url, payload, null, null);
    }

    protected byte[] postToURL(String url, byte[] payload, String username, String password) throws XMRPCClientException {
        try {
            int i = 0;
            while (i < 2) {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Connection", "Keep-Alive");
                if (username != null) {
                    String login = String.valueOf(username) + ":" + password;
                    String encodedLogin = new String(Base64.encode(login.getBytes("UTF-8")));
                    connection.setRequestProperty("Authorization", "Basic " + encodedLogin);
                }
                if (this.session_id != null) {
                    connection.setRequestProperty("X-Transmission-Session-Id", this.session_id);
                }
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.setDoOutput(true);
                connection.getOutputStream().write(payload);
                try {
                    int len;
                    InputStream is = connection.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                    byte[] buffer = new byte[8192];
                    while ((len = is.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    String str;
                    block12: {
                        block11: {
                            block10: {
                                if (connection.getResponseCode() != 409) break block10;
                                str = connection.getHeaderField("x-transmission-session-id");
                                if (str == null || this.session_id != null && this.session_id.equals(str)) break block11;
                                break block12;
                            }
                            if (e instanceof ProtocolException) {
                                String msg = connection.getResponseMessage();
                                String e_msg = Debug.getNestedExceptionMessage(e);
                                if (!e_msg.contains(msg)) {
                                    throw new IOException(String.valueOf(msg) + ": " + e_msg);
                                }
                            }
                        }
                        throw e;
                    }
                    this.session_id = str;
                    ++i;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new XMRPCClientException("HTTP POST for " + url + " failed", e);
        }
    }

    protected XMRPCClient.HTTPResponse createHTTPResponse(final Map<String, String> headers, final byte[] data, final int offset) {
        return new XMRPCClient.HTTPResponse(){

            @Override
            public Map<String, String> getHeaders() {
                return headers;
            }

            @Override
            public byte[] getDataBuffer() {
                return data;
            }

            @Override
            public int getDataBufferOffset() {
                return offset;
            }
        };
    }
}

