/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class XMRPCClientIndirect
implements XMRPCClient {
    private XMRPCClientUtils utils = new XMRPCClientUtils();
    private String pair_server;
    private String access_code;
    private String binding_url;

    public XMRPCClientIndirect(String ps, String ac) {
        this.pair_server = ps;
        this.access_code = ac;
    }

    private String getCurrentBinding() throws XMRPCClientException {
        if (this.binding_url == null) {
            String str = this.utils.getFromURL(String.valueOf(this.pair_server) + "pairing/remote/getBinding?ac=" + this.access_code + "&sid=" + "xmwebui");
            System.out.println("Binding result: " + str);
            Map map = JSONUtils.decodeJSON(str);
            JSONObject error = (JSONObject)map.get("error");
            if (error != null) {
                long code = (Long)error.get("code");
                if (code == 1L) {
                    throw new XMRPCClientException(2);
                }
                if (code == 2L || code == 3L) {
                    throw new XMRPCClientException(3);
                }
                throw new XMRPCClientException("Uknown error creating tunnel: " + str);
            }
            Map result = (Map)map.get("result");
            String protocol = (String)result.get("protocol");
            String ip = (String)result.get("ip");
            String port = (String)result.get("port");
            this.binding_url = String.valueOf(protocol) + "://" + ip + ":" + port;
        }
        return this.binding_url;
    }

    @Override
    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        try {
            String url = this.getCurrentBinding();
            url = String.valueOf(url) + "/transmission/rpc";
            String json = JSONUtils.encodeToJSON(request2);
            byte[] reply = this.utils.postToURL(url, json.getBytes("UTF-8"), "vuze", this.access_code);
            Map m = JSONUtils.decodeJSON(new String(reply, "UTF-8"));
            JSONObject result = new JSONObject();
            result.putAll(m);
            return result;
        }
        catch (IOException e) {
            throw new XMRPCClientException("unexpected");
        }
    }

    @Override
    public XMRPCClient.HTTPResponse call(String method, String url_suffix, Map<String, String> headers_in, byte[] data) throws XMRPCClientException {
        if (method.equals("GET")) {
            String url = this.getCurrentBinding();
            url = String.valueOf(url) + url_suffix;
            HashMap<String, String> headers_out = new HashMap<String, String>();
            byte[] output_data = this.utils.getFromURL(url, headers_in, headers_out, "vuze", this.access_code);
            return this.utils.createHTTPResponse(headers_out, output_data, 0);
        }
        throw new XMRPCClientException("Not supported");
    }

    @Override
    public void destroy() {
    }
}

