/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client.rpc;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.json.simple.JSONObject;

public class XMRPCClientCached
implements XMRPCClient {
    private XMRPCClient base;
    private int cache_millis;
    private int max_active_rpcs = 32;
    private int active_calls;
    private boolean destroyed;
    private Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();

    protected XMRPCClientCached(XMRPCClient _base, int _cache_millis) {
        this.base = _base;
        this.cache_millis = _cache_millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject call(JSONObject request2) throws XMRPCClientException {
        Map<String, CacheEntry> map;
        JSONObject jSONObject;
        String method = (String)request2.get("method");
        Map args = (Map)request2.get("arguments");
        String key = String.valueOf(method) + ": " + args;
        System.out.println("cache key: " + key);
        CacheEntry entry = null;
        Map<String, CacheEntry> map2 = this.cache;
        synchronized (map2) {
            if (this.destroyed) {
                throw new XMRPCClientException("RPC has been destroyed");
            }
            if (this.active_calls >= this.max_active_rpcs) {
                throw new XMRPCClientException("Too many active calls");
            }
            if (this.cache.size() > 64) {
                Debug.out("Cache is too full, something borkified: " + this.cache.keySet());
                this.cache.clear();
            }
            if (method.equals("session-stats") || method.equals("session-get") || method.equals("torrent-get")) {
                entry = this.cache.get(key);
                if (entry == null || entry.hasExpired()) {
                    entry = new CacheEntry();
                    this.cache.put(key, entry);
                }
            } else {
                this.cache.clear();
            }
            ++this.active_calls;
        }
        try {
            JSONObject result = entry == null ? this.base.call(request2) : entry.call(request2);
            jSONObject = result;
            map = this.cache;
        }
        catch (Throwable throwable) {
            Map<String, CacheEntry> map3 = this.cache;
            synchronized (map3) {
                --this.active_calls;
            }
            throw throwable;
        }
        synchronized (map) {
            --this.active_calls;
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMRPCClient.HTTPResponse call(String method, String url, Map<String, String> headers, byte[] data) throws XMRPCClientException {
        Map<String, CacheEntry> map;
        XMRPCClient.HTTPResponse hTTPResponse;
        Map<String, CacheEntry> map2 = this.cache;
        synchronized (map2) {
            if (this.destroyed) {
                throw new XMRPCClientException("RPC has been destroyed");
            }
            if (this.active_calls >= this.max_active_rpcs) {
                throw new XMRPCClientException("Too many active calls");
            }
            ++this.active_calls;
        }
        try {
            hTTPResponse = this.base.call(method, url, headers, data);
            map = this.cache;
        }
        catch (Throwable throwable) {
            Map<String, CacheEntry> map3 = this.cache;
            synchronized (map3) {
                --this.active_calls;
            }
            throw throwable;
        }
        synchronized (map) {
            --this.active_calls;
        }
        return hTTPResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<String, CacheEntry> map = this.cache;
        synchronized (map) {
            this.destroyed = true;
            this.cache.clear();
        }
        this.base.destroy();
    }

    private class CacheEntry {
        private long time = -1L;
        private AESemaphore sem;
        private JSONObject result;
        private XMRPCClientException error;

        private CacheEntry() {
        }

        private boolean hasExpired() {
            return this.time >= 0L && SystemTime.getMonotonousTime() - this.time > (long)XMRPCClientCached.this.cache_millis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JSONObject call(JSONObject request2) throws XMRPCClientException {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                block13: {
                    if (this.sem == null) {
                        this.sem = new AESemaphore("rpccache:call");
                        try {
                            System.out.println("    -> calling");
                            this.result = XMRPCClientCached.this.base.call(request2);
                        }
                        catch (XMRPCClientException e) {
                            this.error = e;
                            this.time = SystemTime.getMonotonousTime();
                            this.sem.releaseForever();
                            break block13;
                        }
                        catch (Throwable e) {
                            try {
                                this.error = new XMRPCClientException("Call failed", e);
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                this.time = SystemTime.getMonotonousTime();
                                this.sem.releaseForever();
                            }
                        }
                        this.time = SystemTime.getMonotonousTime();
                        this.sem.releaseForever();
                    } else {
                        System.out.println("    -> using cache");
                    }
                }
            }
            this.sem.reserve();
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }
    }
}

