/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui.client;

import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClient;
import com.aelitis.azureus.plugins.xmwebui.client.rpc.XMRPCClientFactory;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.json.simple.JSONObject;

public class XMRPCClientTest {
    private static void test1(String access_code) throws Exception {
        String line;
        HttpURLConnection connection;
        int retry_count = 0;
        String session_id = null;
        do {
            String str = "{\"arguments\":{ \"download-dir\":\"G::\\.....\\Downloads\",\"ratio-limit-enabled\":true, \"ratio-limit\":2,\"speed-limit-down-enabled\":true, \"speed-limit-down\":5,\"speed-limit-up-enabled\":true, \"speed-limit-up\":5},\"method\":\"session-set\"}";
            connection = (HttpURLConnection)new URL("http://127.0.0.1:9091/transmission/rpc").openConnection();
            if (session_id != null) {
                connection.setRequestProperty("X-Transmission-Session-Id", session_id);
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
            pw.println(str);
            pw.flush();
            if (connection.getResponseCode() != 409) break;
            session_id = connection.getHeaderField("x-transmission-session-id");
        } while (++retry_count < 2);
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        StringBuffer request_json_str = new StringBuffer(2048);
        while ((line = lnr.readLine()) != null) {
            request_json_str.append(line);
        }
        System.out.println(request_json_str.toString());
    }

    private static void test2(String code, String password) throws Exception {
        XMRPCClient client = XMRPCClientFactory.createDirect(true, "127.0.0.1", 9091, "vuze", password);
        try {
            JSONObject request2 = new JSONObject();
            request2.put("method", "session-set");
            HashMap<String, Comparable<Boolean>> arg_map = new HashMap<String, Comparable<Boolean>>();
            request2.put("arguments", arg_map);
            arg_map.put("speed-limit-up-enabled", Boolean.valueOf(true));
            arg_map.put("speed-limit-up", Integer.valueOf(5));
            JSONObject reply = client.call(request2);
            System.out.println(reply);
            request2 = new JSONObject();
            request2.put("method", "session-get");
            JSONObject reply2 = client.call(request2);
            System.out.println(reply2);
        }
        finally {
            client.destroy();
        }
    }

    public static void main(String[] args) {
        try {
            XMRPCClientTest.test1(args[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

