/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.core.content.AzureusContentDirectory;
import com.aelitis.azureus.core.content.AzureusContentDirectoryListener;
import com.aelitis.azureus.core.content.AzureusContentDirectoryManager;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusContentFilter;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceUPnP;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.azureus.core.util.UUIDGenerator;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaChannel;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaRenderer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaRendererLocal;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaRendererRemote;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerContentDirectory;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerContentServer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerErrorListener;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerHTTP;
import com.aelitis.azureus.plugins.upnpmediaserver.ui.UPnPMediaServerUI;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPSSDP;
import com.aelitis.net.upnp.UPnPSSDPListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIDataSourceListener;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuBuilder;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.PowerManagementListener;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPMediaServer
implements UnloadablePlugin,
AzureusContentDirectoryListener,
PowerManagementListener,
UIDataSourceListener {
    private static final int HTTP_PORT_DEFAULT = 6901;
    private static final boolean DISABLE_MENUS_FOR_INCOMPLETE = false;
    private static final int EVENT_TIMEOUT_SECONDS = 1800;
    private static final String ORIGINAL_SOURCE_PROTOCOLS = "http-get:*:*:*";
    private static final String DNLA_SOURCE_PROTOCOLS = "http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_TN;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/gif:DLNA.ORG_PN=GIF_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/L16;rate=32000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=24000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=16000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=12000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=11025;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=8000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/3gpp:DLNA.ORG_PN=MPEG4_H263_MP4_P0_L10_AAC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_PAL;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_NTSC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_BASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-matroska:*,http-get:*:video/x-mkv:*,http-get:*:audio/x-matroska:*,http-get:*:video/avi:*,http-get:*:image/png:DLNA.ORG_PN=PNG_TN;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAPRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAFULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=HEAAC_L2_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=AAC_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMABASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:*:*";
    private static final String CM_SOURCE_PROTOCOLS = "http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_TN;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/gif:DLNA.ORG_PN=GIF_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/L16;rate=32000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=24000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=16000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=12000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=11025;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=8000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/3gpp:DLNA.ORG_PN=MPEG4_H263_MP4_P0_L10_AAC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_PAL;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_NTSC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_BASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-matroska:*,http-get:*:video/x-mkv:*,http-get:*:audio/x-matroska:*,http-get:*:video/avi:*,http-get:*:image/png:DLNA.ORG_PN=PNG_TN;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAPRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAFULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=HEAAC_L2_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=AAC_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMABASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:*:*";
    private static final String CM_SINK_PROTOCOLS = "";
    private String UUID_rootdevice;
    private String service_name;
    private String[] upnp_entities;
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private UPnPSSDP ssdp;
    private UPnPSSDPListener ssdp_listener;
    private UPnP upnp;
    private UPnPListener upnp_listener;
    private boolean alive = true;
    private Map events = new HashMap();
    private List new_events = new ArrayList();
    private Set container_update_events;
    private UPnPMediaServerContentServer content_server;
    private Set<UPnPMediaRenderer> renderers = new HashSet<UPnPMediaRenderer>();
    private Map<UPnPMediaRenderer, DeviceManagerListener> renderer_listeners = new HashMap<UPnPMediaRenderer, DeviceManagerListener>();
    private CopyOnWriteList<IPCInterface> browse_listeners = new CopyOnWriteList();
    private int stream_id_next;
    private boolean enable_upnp = true;
    private boolean enable_lan_publish = true;
    private int stream_port = 0;
    private UPnPMediaServerUI media_server_ui;
    private List logged_searches = new ArrayList();
    private boolean quickTimeAvail = false;
    private BasicPluginConfigModel config_model;
    private BasicPluginViewModel view_model;
    private List<MenuItem> menus = new ArrayList<MenuItem>();
    private UTTimer timer2;
    private UTTimerEvent timer2_event;
    private UTTimer timer3;
    private UTTimerEvent timer3_event;
    private DownloadManagerListener dm_listener;
    private TrackerWebContext ssdp_web_context;
    private byte[] BLANK_PASSWORD;
    private BooleanParameter stream_port_upnp_param;
    private BooleanParameter apply_bind;
    private BooleanParameter main_auth;
    private BooleanParameter main_auth_ext_only;
    private StringParameter main_username;
    private PasswordParameter main_password;
    private BooleanParameter http_enable_param;
    private IntParameter http_port_param;
    private BooleanParameter http_port_upnp_param;
    private UPnPMediaServerHTTP http_server;
    private BooleanParameter http_auth;
    private BooleanParameter http_auth_same;
    private StringParameter http_username;
    private PasswordParameter http_password;
    private IntParameter speed_bit_rate_mult;
    private IntParameter speed_max_kb_sec;
    private IntParameter speed_min_kb_sec;
    private StringListParameter sort_order;
    private BooleanParameter sort_order_ascending;
    private boolean use_categories;
    private boolean use_tags;
    private BooleanParameter show_percent_done;
    private BooleanParameter show_eta;
    private BooleanParameter prevent_sleep_param;
    private UPnPMediaServerContentDirectory content_directory;
    private Set<AzureusContentDirectory> registered_directories = new HashSet<AzureusContentDirectory>();
    private volatile boolean unloaded;
    private volatile boolean initialised;
    private Object startup_lock = new Object();
    private boolean starting = false;
    private AESemaphore startup_sem = new AESemaphore("UPnPMediaServer:Startup");
    protected UIInstance uiInstance;

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        try {
            PluginConfig plugin_config;
            this.plugin_interface = _plugin_interface;
            this.BLANK_PASSWORD = this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(new byte[0]);
            this.logger = this.plugin_interface.getLogger().getTimeStampedChannel("MediaServer");
            LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
            loc_utils.integrateLocalisedMessageBundle("com.aelitis.azureus.plugins.upnpmediaserver.internat.Messages");
            Utilities utils = this.plugin_interface.getUtilities();
            this.timer2 = utils.createTimer("alive", true);
            this.timer3 = utils.createTimer("eventDispatch", false);
            PluginConfig config = this.plugin_interface.getPluginconfig();
            this.UUID_rootdevice = config.getPluginStringParameter("uuid", CM_SINK_PROTOCOLS);
            if (this.UUID_rootdevice.length() == 0) {
                this.UUID_rootdevice = "uuid:" + UUIDGenerator.generateUUIDString();
                config.setPluginParameter("uuid", this.UUID_rootdevice);
                try {
                    COConfigurationManager.setDirty();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.upnp_entities = new String[]{"upnp:rootdevice", "urn:schemas-upnp-org:device:MediaServer:1", "urn:schemas-upnp-org:service:ConnectionManager:1", "urn:schemas-upnp-org:service:ContentDirectory:1", this.UUID_rootdevice};
            final UIManager ui_manager = this.plugin_interface.getUIManager();
            this.view_model = ui_manager.createBasicPluginViewModel(loc_utils.getLocalisedMessageText("upnpmediaserver.name"));
            this.view_model.getActivity().setVisible(false);
            this.view_model.getProgress().setVisible(false);
            this.logger.addListener(new LoggerChannelListener(){

                @Override
                public void messageLogged(int type, String content2) {
                    UPnPMediaServer.this.view_model.getLogArea().appendText(String.valueOf(content2) + "\n");
                }

                @Override
                public void messageLogged(String str, Throwable error) {
                    if (str.length() > 0) {
                        UPnPMediaServer.this.view_model.getLogArea().appendText(String.valueOf(str) + "\n");
                    }
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    error.printStackTrace(pw);
                    pw.flush();
                    UPnPMediaServer.this.view_model.getLogArea().appendText(String.valueOf(sw.toString()) + "\n");
                }
            });
            this.logger.setDiagnostic();
            this.logger.setForce(true);
            this.view_model.setConfigSectionID("upnpmediaserver.name");
            this.logger.log("RootDevice: " + this.UUID_rootdevice);
            this.config_model = ui_manager.createBasicPluginConfigModel("upnpmediaserver.name");
            this.config_model.addLabelParameter2("upnpmediaserver.info");
            this.config_model.addHyperlinkParameter2("upnpmediaserver.web_link", "http://www.azureuswiki.com/index.php/UG_Plugins#UPnP_Media_Server");
            final BooleanParameter enable_upnp_p = this.config_model.addBooleanParameter2("upnpmediaserver.enable_upnp", "upnpmediaserver.enable_upnp", true);
            this.enable_upnp = enable_upnp_p.getValue();
            final IntParameter stream_port_p = this.config_model.addIntParameter2("upnpmediaserver.stream.port", "upnpmediaserver.stream.port", 0);
            final InfoParameter active_port = this.config_model.addInfoParameter2("upnpmediaserver.stream.port.active", CM_SINK_PROTOCOLS);
            this.stream_port = stream_port_p.getValue();
            stream_port_p.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    int port = stream_port_p.getValue();
                    if (port != UPnPMediaServer.this.stream_port) {
                        UPnPMediaServer.this.stream_port = port;
                        if (UPnPMediaServer.this.stream_port == 0) {
                            UPnPMediaServer.this.setContentPort(0);
                        }
                        UPnPMediaServer.this.createContentServer(active_port, false);
                    }
                }
            });
            this.stream_port_upnp_param = this.config_model.addBooleanParameter2("upnpmediaserver.stream_port_upnp", "upnpmediaserver.stream_port_upnp", false);
            this.apply_bind = this.config_model.addBooleanParameter2("upnpmediaserver.bind.use.default", "upnpmediaserver.bind.use.default", true);
            String default_name = null;
            try {
                String cn = this.plugin_interface.getPlatformManager().getComputerName();
                if (cn != null) {
                    default_name = "Vuze on " + cn;
                }
            }
            catch (Throwable cn) {
                // empty catch block
            }
            if (default_name == null && (default_name = (plugin_config = this.plugin_interface.getPluginconfig()).getPluginStringParameter("upnpmediaserver.name.default", CM_SINK_PROTOCOLS)).length() == 0) {
                try {
                    List<NetworkInterface> interfaces = NetUtils.getNetworkInterfaces();
                    InetAddress ipv4 = null;
                    InetAddress ipv6 = null;
                    for (NetworkInterface networkInterface2 : interfaces) {
                        Enumeration<InetAddress> addresses = networkInterface2.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress address = addresses.nextElement();
                            if (address.isLoopbackAddress()) continue;
                            if (address instanceof Inet4Address) {
                                ipv4 = address;
                                continue;
                            }
                            ipv6 = address;
                        }
                    }
                    default_name = ipv4 != null ? "Vuze on " + ipv4.getHostAddress() : (ipv6 != null ? "Vuze on " + ipv6.getHostAddress() : "Vuze");
                }
                catch (Throwable e) {
                    default_name = "Vuze";
                }
                plugin_config.setPluginParameter("upnpmediaserver.name.default", default_name);
            }
            final StringParameter snp = this.config_model.addStringParameter2("upnpmediaserver.service_name", "upnpmediaserver.service_name", default_name);
            this.service_name = snp.getValue();
            snp.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UPnPMediaServer.this.service_name = snp.getValue();
                }
            });
            this.sort_order = this.config_model.addStringListParameter2("upnpmediaserver.sortorder", "upnpmediaserver.sortorder", new String[]{"0", "1", "2"}, new String[]{loc_utils.getLocalisedMessageText("upnpmediaserver.sortorder.default"), loc_utils.getLocalisedMessageText("upnpmediaserver.sortorder.alpha"), loc_utils.getLocalisedMessageText("upnpmediaserver.sortorder.date")}, "0");
            this.sort_order_ascending = this.config_model.addBooleanParameter2("upnpmediaserver.sortorder.asc", "upnpmediaserver.sortorder.asc", true);
            ParameterListener sort_order_listener = new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UPnPMediaServer.this.sort_order_ascending.setEnabled(!UPnPMediaServer.this.sort_order.getValue().equals("0"));
                }
            };
            sort_order_listener.parameterChanged(null);
            this.sort_order.addListener(sort_order_listener);
            this.show_percent_done = this.config_model.addBooleanParameter2("upnpmediaserver.show_percent_done", "upnpmediaserver.show_percent_done", false);
            this.show_eta = this.config_model.addBooleanParameter2("upnpmediaserver.show_eta", "upnpmediaserver.show_eta", false);
            BooleanParameter separate_by_category = this.config_model.addBooleanParameter2("upnpmediaserver.sep_by_cat", "upnpmediaserver.sep_by_cat", false);
            this.use_categories = separate_by_category.getValue();
            BooleanParameter separate_by_tags = this.config_model.addBooleanParameter2("upnpmediaserver.sep_by_tags", "upnpmediaserver.sep_by_tags", false);
            this.use_tags = separate_by_tags.getValue();
            LabelParameter speed_lab = this.config_model.addLabelParameter2("upnpmediaserver.stream.speed");
            this.speed_bit_rate_mult = this.config_model.addIntParameter2("upnpmediaserver.stream.speed_br_mult", "upnpmediaserver.stream.speed_br_mult", 10, 0, Integer.MAX_VALUE);
            this.speed_min_kb_sec = this.config_model.addIntParameter2("upnpmediaserver.stream.speed_min_kbs", "upnpmediaserver.stream.speed_min_kbs", 4096, 0, Integer.MAX_VALUE);
            this.speed_max_kb_sec = this.config_model.addIntParameter2("upnpmediaserver.stream.speed_max_kbs", "upnpmediaserver.stream.speed_max_kbs", 0, 0, Integer.MAX_VALUE);
            boolean supports_sleep = this.plugin_interface.getUtilities().supportsPowerStateControl(1);
            if (supports_sleep) {
                this.prevent_sleep_param = this.config_model.addBooleanParameter2("upnpmediaserver.prevent_sleep", "upnpmediaserver.prevent_sleep", true);
            }
            final BooleanParameter enable_publish_p = this.config_model.addBooleanParameter2("upnpmediaserver.enable_publish", "upnpmediaserver.enable_publish", false);
            this.enable_lan_publish = enable_publish_p.getValue();
            enable_publish_p.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UPnPMediaServer.this.enable_lan_publish = enable_publish_p.getValue();
                }
            });
            enable_upnp_p.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UPnPMediaServer.this.enable_upnp = enable_upnp_p.getValue();
                    snp.setEnabled(UPnPMediaServer.this.enable_upnp);
                    enable_publish_p.setEnabled(UPnPMediaServer.this.enable_upnp);
                }
            });
            if (!this.enable_upnp) {
                snp.setEnabled(false);
                enable_publish_p.setEnabled(false);
            }
            this.main_auth = this.config_model.addBooleanParameter2("upnpmediaserver.auth.enable", "upnpmediaserver.auth.enable", false);
            this.main_auth_ext_only = this.config_model.addBooleanParameter2("upnpmediaserver.auth.ext_only", "upnpmediaserver.auth.ext_only", false);
            this.main_username = this.config_model.addStringParameter2("upnpmediaserver.auth.user", "upnpmediaserver.auth.user", CM_SINK_PROTOCOLS);
            this.main_password = this.config_model.addPasswordParameter2("upnpmediaserver.auth.password", "upnpmediaserver.auth.password", 2, new byte[0]);
            this.main_auth.addEnabledOnSelection(this.main_auth_ext_only);
            this.main_auth.addEnabledOnSelection(this.main_username);
            this.main_auth.addEnabledOnSelection(this.main_password);
            this.config_model.createGroup("upnpmediaserver.media_group", new Parameter[]{enable_upnp_p, stream_port_p, active_port, this.stream_port_upnp_param, this.apply_bind, snp, this.sort_order, this.sort_order_ascending, this.show_percent_done, this.show_eta, separate_by_category, separate_by_tags, enable_publish_p, speed_lab, this.speed_bit_rate_mult, this.speed_min_kb_sec, this.speed_max_kb_sec, this.prevent_sleep_param, this.main_auth, this.main_auth_ext_only, this.main_username, this.main_password});
            this.http_enable_param = this.config_model.addBooleanParameter2("upnpmediaserver.http_enable", "upnpmediaserver.http_enable", false);
            this.http_port_param = this.config_model.addIntParameter2("upnpmediaserver.http_port", "upnpmediaserver.http_port", 6901);
            this.http_port_upnp_param = this.config_model.addBooleanParameter2("upnpmediaserver.http_port_upnp", "upnpmediaserver.http_port_upnp", false);
            this.http_auth = this.config_model.addBooleanParameter2("upnpmediaserver.httpauth.enable", "upnpmediaserver.httpauth.enable", false);
            this.http_auth_same = this.config_model.addBooleanParameter2("upnpmediaserver.httpauth.same", "upnpmediaserver.httpauth.same", true);
            this.http_username = this.config_model.addStringParameter2("upnpmediaserver.httpauth.user", "upnpmediaserver.auth.user", CM_SINK_PROTOCOLS);
            this.http_password = this.config_model.addPasswordParameter2("upnpmediaserver.httpauth.password", "upnpmediaserver.auth.password", 2, new byte[0]);
            this.http_auth.addEnabledOnSelection(this.http_auth_same);
            this.http_auth.addEnabledOnSelection(this.http_username);
            this.http_auth.addEnabledOnSelection(this.http_password);
            this.http_auth_same.addDisabledOnSelection(this.http_username);
            this.http_auth_same.addDisabledOnSelection(this.http_password);
            this.http_enable_param.addEnabledOnSelection(this.http_port_param);
            this.http_enable_param.addEnabledOnSelection(this.http_port_upnp_param);
            this.http_enable_param.addEnabledOnSelection(this.http_auth);
            this.http_enable_param.addEnabledOnSelection(this.http_auth_same);
            this.http_enable_param.addEnabledOnSelection(this.http_username);
            this.http_enable_param.addEnabledOnSelection(this.http_password);
            this.config_model.createGroup("upnpmediaserver.http_group", new Parameter[]{this.http_enable_param, this.http_port_param, this.http_port_upnp_param, this.http_auth, this.http_auth_same, this.http_username, this.http_password});
            BooleanParameter menu_param = this.config_model.addBooleanParameter2("upnpmediaserver.enable_menus", "upnpmediaserver.enable_menus", true);
            if (menu_param.getValue()) {
                this.buildMenu();
            }
            ActionParameter print = this.config_model.addActionParameter2("upnpmediaserver.printcd.label", "upnpmediaserver.printcd.button");
            print.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UPnPMediaServer.this.content_directory.print();
                }
            });
            ui_manager.addUIListener(new UIManagerListener(){

                @Override
                public void UIAttached(UIInstance instance) {
                    UPnPMediaServer.this.uiInstance = instance;
                    if (instance.getUIType() == 1) {
                        ui_manager.removeUIListener(this);
                        ui_manager.addDataSourceListener(UPnPMediaServer.this, false);
                        UPnPMediaServer.this.log("SWT user interface bound");
                        try {
                            UPnPMediaServer.this.media_server_ui = (UPnPMediaServerUI)Class.forName("com.aelitis.azureus.plugins.upnpmediaserver.ui.swt.UPnPMediaServerUISWT").newInstance();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public void UIDetached(UIInstance instance) {
                }
            });
            this.createContentServer(active_port, true);
            this.content_directory = new UPnPMediaServerContentDirectory(this);
            this.plugin_interface.addListener(new PluginListener(){

                @Override
                public void initializationComplete() {
                    DelayedTask dt = UPnPMediaServer.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                        @Override
                        public void run() {
                            Thread t = new Thread("UPnPMediaServer::init"){

                                @Override
                                public void run() {
                                    UPnPMediaServer.this.start();
                                }
                            };
                            t.setPriority(1);
                            t.setDaemon(true);
                            t.start();
                        }
                    });
                    dt.queue();
                }

                @Override
                public void closedownInitiated() {
                    if (UPnPMediaServer.this.ssdp != null) {
                        UPnPMediaServer.this.stop();
                    }
                    if (UPnPMediaServer.this.http_server != null) {
                        UPnPMediaServer.this.http_server.destroy();
                    }
                    if (UPnPMediaServer.this.content_directory != null) {
                        UPnPMediaServer.this.content_directory.destroy();
                    }
                }

                @Override
                public void closedownComplete() {
                }
            });
            if (supports_sleep) {
                this.plugin_interface.getUtilities().addPowerManagementListener(this);
            }
        }
        finally {
            this.initialised = true;
            if (this.unloaded) {
                this.unload();
            }
        }
    }

    private void handleUPnP(int port, String name, boolean enabled) {
        PluginInterface pi_upnp = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pi_upnp == null) {
            this.log("No UPnP plugin available, not attempting port mapping");
        } else {
            PluginConfig config = this.plugin_interface.getPluginconfig();
            String key = "upnp.port.for." + name;
            int existing_port = config.getPluginIntParameter(key, 0);
            if (!enabled || existing_port != port) {
                if (existing_port != 0) {
                    this.log("Removing UPnP mapping: port=" + existing_port + ", name='" + name + "'");
                    UPnPMapping m = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(name, true, existing_port, false);
                    m.destroy();
                }
                config.setPluginParameter(key, 0);
            }
            if (enabled) {
                if (port == 0) {
                    this.log("Invalid port for UPnP mapping, ignoring");
                } else {
                    this.log("Creating UPnP mapping: port=" + port + ", name='" + name + "'");
                    ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(name, true, port, true);
                    config.setPluginParameter(key, port);
                }
            }
        }
    }

    private void doContentUPnP() {
        this.handleUPnP(this.content_server == null ? 0 : this.content_server.getPort(), "Media Server Content", this.stream_port_upnp_param.getValue());
    }

    protected int getAverageBitRateMultiplier() {
        return this.speed_bit_rate_mult.getValue();
    }

    protected int getMinBytesPerSecond() {
        return this.speed_min_kb_sec.getValue() * 1024;
    }

    protected int getMaxBytesPerSecond() {
        return this.speed_max_kb_sec.getValue() * 1024;
    }

    private void createContentServer(InfoParameter info, boolean init) {
        if (this.content_server != null) {
            this.log("Destroying existing content server on port " + this.content_server.getPort());
            this.content_server.destroy();
            this.content_server = null;
        }
        try {
            this.content_server = new UPnPMediaServerContentServer(this);
            int active_port = this.content_server.getPort();
            this.log("Content port = " + active_port);
            info.setValue(String.valueOf(active_port));
            if (init) {
                this.plugin_interface.addListener(new PluginListener(){

                    @Override
                    public void initializationComplete() {
                        UPnPMediaServer.this.plugin_interface.removeListener(this);
                        UPnPMediaServer.this.doContentUPnP();
                    }

                    @Override
                    public void closedownInitiated() {
                    }

                    @Override
                    public void closedownComplete() {
                    }
                });
            } else {
                this.doContentUPnP();
            }
        }
        catch (Throwable e) {
            this.log("Failed to initialise content server", e);
        }
    }

    protected UPnPMediaServerContentServer getContentServer() {
        return this.content_server;
    }

    protected boolean authContentPort(String client_address) {
        if (!this.main_auth.getValue()) {
            return false;
        }
        if (this.main_auth_ext_only.getValue()) {
            if (client_address == null) {
                this.log("Authentication failed, client address unavailable");
                return true;
            }
            try {
                InetAddress ia = InetAddress.getByName(client_address);
                if (ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) {
                    return false;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
                this.log("Authentication failed", e);
                return true;
            }
        }
        return true;
    }

    protected boolean doContentAuth(String client_address, String user, String password) {
        if (!this.main_auth.getValue()) {
            return true;
        }
        byte[] p_sha1 = this.main_password.getValue();
        if (p_sha1.length == 0 || Arrays.equals(p_sha1, this.BLANK_PASSWORD)) {
            return true;
        }
        if (!user.equals(this.main_username.getValue())) {
            this.log("Authentication failed: userame '" + user + "' invalid, client=" + client_address);
            return false;
        }
        boolean ok = Arrays.equals(p_sha1, this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(password.getBytes()));
        if (!ok) {
            this.log("Authentication failed: incorrect password, client=" + client_address);
        }
        return ok;
    }

    protected boolean doHTTPAuth(String username, String password) {
        byte[] target_password;
        String target_user;
        if (!this.http_auth.getValue()) {
            return true;
        }
        if (this.http_auth_same.getValue()) {
            target_user = this.main_username.getValue();
            target_password = this.main_password.getValue();
        } else {
            target_user = this.http_username.getValue();
            target_password = this.http_password.getValue();
        }
        if (target_password.length == 0 || Arrays.equals(target_password, this.BLANK_PASSWORD)) {
            return true;
        }
        if (!username.equals(target_user)) {
            return false;
        }
        return Arrays.equals(target_password, this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(password.getBytes()));
    }

    private void buildMenu() {
        String[] menuContexts;
        TableManager tableManager = this.plugin_interface.getUIManager().getTableManager();
        MenuBuilder fillTopMenu = new MenuBuilder(){

            @Override
            public void buildSubmenu(MenuItem menu, Object target) {
                UPnPMediaServer.this.fillSubMenu(menu);
            }
        };
        MenuManager mm = this.plugin_interface.getUIManager().getMenuManager();
        String[] stringArray = menuContexts = new String[]{"download_context", "file_context"};
        int n = menuContexts.length;
        int n2 = 0;
        while (n2 < n) {
            String menuContext = stringArray[n2];
            MenuItem menu_item_mediaserver = mm.addMenuItem(menuContext, "upnpmediaserver.contextmenu");
            this.menus.add(menu_item_mediaserver);
            menu_item_mediaserver.setStyle(5);
            menu_item_mediaserver.addFillListener(new MenuItemFillListener(){

                @Override
                public void menuWillBeShown(MenuItem menu, Object data) {
                    boolean visible = false;
                    if (data instanceof Download[]) {
                        Download[] downloads = (Download[])data;
                        if (downloads.length == 1) {
                            visible = true;
                        }
                    } else if (data instanceof DiskManagerFileInfo[]) {
                        DiskManagerFileInfo[] fileInfos = (DiskManagerFileInfo[])data;
                        try {
                            if (fileInfos.length == 1) {
                                visible = true;
                            }
                        }
                        catch (DownloadException downloadException) {
                            // empty catch block
                        }
                    }
                    menu.setVisible(visible);
                }
            });
            menu_item_mediaserver.setSubmenuBuilder(fillTopMenu);
            ++n2;
        }
    }

    protected void fillSubMenu(MenuItem menu) {
        MenuManager mm = this.plugin_interface.getUIManager().getMenuManager();
        MenuItemFillListener menu_fill_simple_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object _target) {
                Object obj = null;
                obj = _target instanceof Object[] ? ((Object[])_target)[0] : _target;
                if (obj == null) {
                    menu.setEnabled(false);
                    return;
                }
                if (obj instanceof Download) {
                    Download download = (Download)obj;
                } else if (obj instanceof DiskManagerFileInfo) {
                    DiskManagerFileInfo diskManagerFileInfo = (DiskManagerFileInfo)obj;
                }
                menu.setEnabled(true);
            }
        };
        MenuItemListener menu_listener_play_external = new MenuItemListener(){

            @Override
            public void selected(MenuItem _menu, Object _target) {
                if (_target == null) {
                    return;
                }
                try {
                    UPnPMediaServer.this.play(_target);
                }
                catch (IPCException e) {
                    UPnPMediaServer.this.log("Failed to play '" + _target + "'", e);
                }
            }
        };
        MenuItem menup = mm.addMenuItem(menu, "upnpmediaserver.contextmenu.playExternal");
        this.buildPlayOnRenderersMenuItems(mm, menu);
        menup.addListener(menu_listener_play_external);
        menup.addFillListener(menu_fill_simple_listener);
        MenuItemListener menu_listener = new MenuItemListener(){

            @Override
            public void selected(MenuItem _menu, Object _target) {
                if (_target == null) {
                    return;
                }
                Download download = null;
                DiskManagerFileInfo file = null;
                if (_target instanceof Download) {
                    download = (Download)_target;
                    file = download.getDiskManagerFileInfo()[0];
                } else if (_target instanceof DiskManagerFileInfo) {
                    file = (DiskManagerFileInfo)_target;
                    try {
                        download = file.getDownload();
                    }
                    catch (DownloadException e) {
                        Debug.printStackTrace(e);
                        return;
                    }
                }
                if (download == null) {
                    return;
                }
                String id = UPnPMediaServer.getContentResourceID(file);
                UPnPMediaServerContentDirectory.contentItem item = UPnPMediaServer.this.content_directory.getContentFromResourceID(id);
                if (item != null) {
                    try {
                        String ip = "Global".equals(_menu.getData()) ? UPnPMediaServer.this.plugin_interface.getUtilities().getPublicAddress().getHostAddress() : ("Local".equals(_menu.getData()) ? InetAddress.getLocalHost().getHostAddress() : UPnPMediaServer.this.getLocalIP());
                        UPnPMediaServer.this.plugin_interface.getUIManager().copyToClipBoard(item.getURI(ip, -1));
                    }
                    catch (Throwable e) {
                        UPnPMediaServer.this.log("Failed to copy to clipboard", e);
                    }
                }
            }
        };
        MenuItem menuClip = mm.addMenuItem(menu, "upnpmediaserver.contextmenu.toclipboard");
        menuClip.addFillListener(menu_fill_simple_listener);
        menuClip.addListener(menu_listener);
        MenuItem menuClipPublic = mm.addMenuItem(menu, "upnpmediaserver.contextmenu.publictoclipboard");
        menuClipPublic.addFillListener(menu_fill_simple_listener);
        menuClipPublic.addListener(menu_listener);
        menuClipPublic.setData("Global");
        MenuItem menuClipLocal = mm.addMenuItem(menu, "upnpmediaserver.contextmenu.localtoclipboard");
        menuClipLocal.addFillListener(menu_fill_simple_listener);
        menuClipLocal.addListener(menu_listener);
        menuClipLocal.setData("Local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPlayOnRenderersMenuItems(MenuManager menuManager, MenuItem menu) {
        MenuItemListener menuPlayOnRenderer_listener = new MenuItemListener(){

            @Override
            public void selected(MenuItem _menu, Object _target) {
                if (_target == null) {
                    return;
                }
                Download download = null;
                DiskManagerFileInfo file = null;
                if (_target instanceof Download) {
                    download = (Download)_target;
                    file = download.getPrimaryFile();
                } else if (_target instanceof DiskManagerFileInfo) {
                    file = (DiskManagerFileInfo)_target;
                    try {
                        download = file.getDownload();
                    }
                    catch (DownloadException e) {
                        Debug.printStackTrace(e);
                        return;
                    }
                }
                if (download == null) {
                    return;
                }
                UPnPMediaRenderer renderer = (UPnPMediaRenderer)_menu.getData();
                UPnPMediaServer.this.playOnRenderer(renderer, download, file);
            }
        };
        MenuItemFillListener menuPlayOnRenderer_fill_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object _target) {
                Object obj = null;
                obj = _target instanceof Object[] ? ((Object[])_target)[0] : _target;
                if (obj == null) {
                    menu.setEnabled(false);
                    return;
                }
                if (obj instanceof Download) {
                    Download download = (Download)obj;
                } else {
                    DiskManagerFileInfo diskManagerFileInfo = (DiskManagerFileInfo)obj;
                }
                UPnPMediaRenderer renderer = (UPnPMediaRenderer)menu.getData();
                boolean enabled = false;
                if (renderer != null) {
                    UPnPMediaRendererRemote rendererRemote;
                    UPnPRootDevice device;
                    String friendlyName;
                    if (!renderer.isBusy()) {
                        enabled = true;
                    }
                    if (renderer instanceof UPnPMediaRendererRemote && (friendlyName = (device = (rendererRemote = (UPnPMediaRendererRemote)renderer).getDevice()).getDevice().getFriendlyName()) != null) {
                        String resourceKey = menu.getResourceKey();
                        String defaultTitle = MessageText.getString(resourceKey);
                        menu.setText(String.valueOf(defaultTitle) + " " + friendlyName);
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        Set<UPnPMediaRenderer> set = this.renderers;
        synchronized (set) {
            for (UPnPMediaRenderer renderer : this.renderers) {
                if (renderer.isBusy()) continue;
                MenuItem menuPlayOnRenderer = menuManager.addMenuItem(menu, "upnpmediaserver.contextmenu.play");
                menuPlayOnRenderer.setData(renderer);
                menuPlayOnRenderer.addListener(menuPlayOnRenderer_listener);
                menuPlayOnRenderer.addFillListener(menuPlayOnRenderer_fill_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playOnRenderer(UPnPMediaRenderer renderer, Download download, DiskManagerFileInfo file) {
        try {
            byte[] hash = file.getDownloadHash();
        }
        catch (DownloadException e1) {
            if (download == null) {
                return;
            }
            byte[] hash = download.getTorrentHash();
        }
        String id = UPnPMediaServer.getContentResourceID(file);
        UPnPMediaServerContentDirectory.contentItem item = this.content_directory.getContentFromResourceID(id);
        if (item != null && renderer != null && !renderer.isBusy()) {
            int stream_id;
            UPnPMediaServer uPnPMediaServer = this;
            synchronized (uPnPMediaServer) {
                stream_id = this.stream_id_next++;
            }
            renderer.play(item, stream_id, new UPnPMediaServerErrorListener(){

                @Override
                public void upnpSoapException(UPnPException e) {
                    if (UPnPMediaServer.this.uiInstance == null) {
                        return;
                    }
                    String title = MessageText.getString("upnpmediaserver.playto.error.title");
                    if (e.fault != null && e.fault.length() > 0) {
                        UPnPMediaServer.this.uiInstance.promptUser(title, String.valueOf(e.fault_code) + ": " + e.fault, new String[]{"Ok"}, 0);
                        return;
                    }
                    SimpleXMLParserDocument cfr_ignored_0 = e.resp_doc;
                    Throwable cause = e.getCause();
                    if (cause instanceof SocketTimeoutException) {
                        UPnPMediaServer.this.uiInstance.promptUser(title, MessageText.getString("upnpmediaserver.playto.error.timeout"), new String[]{"Ok"}, 0);
                        return;
                    }
                    UPnPMediaServer.this.uiInstance.promptUser(title, e.getMessage(), new String[]{"Ok"}, 0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        this.unloaded = true;
        if (!this.initialised) {
            return;
        }
        this.log("Unload starts");
        try {
            try {
                HashSet<UPnPMediaRenderer> rends;
                UIToolBarManager tbm;
                this.ensureStarted();
                if (this.timer2_event != null) {
                    this.timer2_event.cancel();
                }
                if (this.timer3_event != null) {
                    this.timer3_event.cancel();
                }
                this.timer2.destroy();
                this.timer3.destroy();
                this.config_model.destroy();
                this.view_model.destroy();
                int i22 = 0;
                while (i22 < this.menus.size()) {
                    this.menus.get(i22).remove();
                    ++i22;
                }
                if (this.upnp != null && this.upnp_listener != null) {
                    this.upnp.removeRootDeviceListener(this.upnp_listener);
                }
                if (this.ssdp != null && this.ssdp_listener != null) {
                    this.ssdp.removeListener(this.ssdp_listener);
                }
                if (this.dm_listener != null) {
                    this.plugin_interface.getDownloadManager().removeListener(this.dm_listener);
                }
                if (this.ssdp_web_context != null) {
                    this.ssdp_web_context.destroy();
                }
                if (this.http_server != null) {
                    try {
                        this.http_server.destroy();
                    }
                    catch (Throwable i22) {
                        // empty catch block
                    }
                }
                if (this.uiInstance != null && (tbm = this.uiInstance.getToolBarManager()) != null) {
                    for (UPnPMediaRenderer uPnPMediaRenderer : this.renderers) {
                        tbm.removeToolBarItem(CM_SINK_PROTOCOLS + uPnPMediaRenderer.hashCode());
                    }
                }
                Set<UPnPMediaRenderer> set = this.renderers;
                synchronized (set) {
                    rends = new HashSet<UPnPMediaRenderer>(this.renderers);
                    this.renderers.clear();
                }
                for (UPnPMediaRenderer uPnPMediaRenderer : rends) {
                    uPnPMediaRenderer.destroy();
                }
                this.content_server.destroy();
                if (this.content_directory != null) {
                    this.content_directory.destroy();
                }
                for (AzureusContentDirectory azureusContentDirectory : this.registered_directories) {
                    azureusContentDirectory.removeListener(this);
                }
                if (this.plugin_interface != null) {
                    this.plugin_interface.getUtilities().removePowerManagementListener(this);
                    UIManager uIManager = this.plugin_interface.getUIManager();
                    if (uIManager != null) {
                        uIManager.removeDataSourceListener(this);
                    }
                }
            }
            catch (Throwable e) {
                this.log("Unload failed", e);
                this.log("Unload complete");
            }
        }
        finally {
            this.log("Unload complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AzureusContentDirectory[] getAzureusContentDirectories() {
        AzureusContentDirectory[] directories;
        AzureusContentDirectory[] azureusContentDirectoryArray = directories = AzureusContentDirectoryManager.getDirectories();
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            AzureusContentDirectory directory = azureusContentDirectoryArray[n2];
            Set<AzureusContentDirectory> set = this.registered_directories;
            synchronized (set) {
                if (!this.registered_directories.contains(directory)) {
                    directory.addListener(this);
                    this.registered_directories.add(directory);
                }
            }
            ++n2;
        }
        return directories;
    }

    @Override
    public void contentChanged(AzureusContentFile file, String property) {
        if (property.equals("cats") && this.use_categories || property.equals("tags") && this.use_tags) {
            this.content_directory.contentChanged(file);
        }
    }

    protected boolean useCategories() {
        return this.use_categories;
    }

    protected boolean useTags() {
        return this.use_tags;
    }

    protected boolean showPercentDone() {
        return this.show_percent_done.getValue();
    }

    protected boolean showETA() {
        return this.show_eta.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRenderer(UPnPMediaRenderer renderer) {
        UIToolBarManager tbm;
        Set<UPnPMediaRenderer> set = this.renderers;
        synchronized (set) {
            this.renderers.remove(renderer);
            DeviceManagerListener l = this.renderer_listeners.remove(renderer);
            if (l != null) {
                DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                deviceManager.removeListener(l);
            }
        }
        if (this.uiInstance != null && (tbm = this.uiInstance.getToolBarManager()) != null) {
            tbm.removeToolBarItem(CM_SINK_PROTOCOLS + renderer.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRenderer(final UPnPMediaRenderer new_renderer) {
        Set<UPnPMediaRenderer> set = this.renderers;
        synchronized (set) {
            this.renderers.add(new_renderer);
        }
        UIManager ui_manager = this.plugin_interface.getUIManager();
        if (this.uiInstance == null) {
            return;
        }
        UIToolBarManager tbm = this.uiInstance.getToolBarManager();
        if (tbm == null) {
            return;
        }
        final UIToolBarItem toolBarItem = tbm.createToolBarItem(CM_SINK_PROTOCOLS + new_renderer.hashCode());
        this.dataSourceChanged(ui_manager.getDataSource());
        toolBarItem.setGroupID("players");
        toolBarItem.setDefaultActivationListener(new UIToolBarActivationListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                Object singleDS = null;
                if (datasource instanceof Object[]) {
                    if (((Object[])datasource).length != 1) return false;
                    singleDS = ((Object[])datasource)[0];
                } else if (datasource != null) {
                    singleDS = datasource;
                }
                Download download = null;
                DiskManagerFileInfo file = null;
                if (singleDS instanceof Download) {
                    download = (Download)singleDS;
                    file = download.getDiskManagerFileInfo()[0];
                } else if (singleDS instanceof DiskManagerFileInfo) {
                    file = (DiskManagerFileInfo)singleDS;
                    try {
                        download = file.getDownload();
                    }
                    catch (DownloadException e) {
                        return false;
                    }
                } else {
                    if (!(singleDS instanceof TranscodeFile)) return false;
                    try {
                        file = ((TranscodeFile)singleDS).getTargetFile();
                        download = file.getDownload();
                    }
                    catch (Exception exception) {}
                }
                UPnPMediaServer.this.playOnRenderer(new_renderer, download, file);
                return true;
            }
        });
        toolBarItem.setImageID("image.sidebar.device.samsung.big");
        if (new_renderer instanceof UPnPMediaRendererRemote) {
            UPnPMediaRendererRemote rendererRemote = (UPnPMediaRendererRemote)new_renderer;
            UPnPRootDevice rootDevice = rendererRemote.getDevice();
            final UPnPDevice upnpDevice = rootDevice.getDevice();
            toolBarItem.setToolTip("Play to " + upnpDevice.getFriendlyName());
            boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
            if (isAZ3) {
                final DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                Device device = deviceManager.findDevice(upnpDevice);
                if (device != null) {
                    String imageID = device.getImageID();
                    if (imageID != null) {
                        toolBarItem.setImageID(imageID);
                    }
                } else {
                    DeviceManagerListener old;
                    DeviceManagerListener l = new DeviceManagerListener(){

                        @Override
                        public void deviceRemoved(Device device) {
                        }

                        @Override
                        public void deviceManagerLoaded() {
                        }

                        @Override
                        public void deviceChanged(Device device) {
                            this.checkForImage(device);
                        }

                        @Override
                        public void deviceAttentionRequest(Device device) {
                        }

                        @Override
                        public void deviceAdded(Device device) {
                            this.checkForImage(device);
                        }

                        public void checkForImage(Device device) {
                            DeviceUPnP deviceUPnP;
                            UPnPDevice uPnPDevice2;
                            if (device instanceof DeviceUPnP && upnpDevice.equals(uPnPDevice2 = (deviceUPnP = (DeviceUPnP)device).getUPnPDevice())) {
                                deviceManager.removeListener(this);
                                String imageID = device.getImageID();
                                if (imageID != null) {
                                    toolBarItem.setImageID(imageID);
                                }
                            }
                        }
                    };
                    Set<UPnPMediaRenderer> set2 = this.renderers;
                    synchronized (set2) {
                        old = this.renderer_listeners.put(new_renderer, l);
                    }
                    if (old != null) {
                        deviceManager.removeListener(old);
                    }
                    deviceManager.addListener(l);
                }
            }
        }
        tbm.addToolBarItem(toolBarItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPMediaRendererRemote findRendererByIP(String ip) {
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        if (isAZ3) {
            Set<UPnPMediaRenderer> set = this.renderers;
            synchronized (set) {
                for (UPnPMediaRenderer renderer : this.renderers) {
                    String remoteIP;
                    InetAddress address;
                    if (!(renderer instanceof UPnPMediaRendererRemote)) continue;
                    UPnPMediaRendererRemote rendererRemote = (UPnPMediaRendererRemote)renderer;
                    UPnPRootDevice rootDevice = rendererRemote.getDevice();
                    UPnPDevice uPnPDevice = rootDevice.getDevice();
                    DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                    Device device = deviceManager.findDevice(uPnPDevice);
                    if (device == null || (address = device.getAddress()) == null || !(remoteIP = address.getHostAddress()).equals(ip)) continue;
                    return rendererRemote;
                }
            }
        }
        return null;
    }

    protected List<AzureusContentFilter> receivedBrowse(TrackerWebPageRequest request2, boolean is_http) {
        ArrayList<AzureusContentFilter> filters = new ArrayList<AzureusContentFilter>();
        HashMap<String, String> browse_args = new HashMap<String, String>();
        browse_args.put("source", is_http ? "http" : "upnp");
        for (IPCInterface ipc : this.browse_listeners) {
            try {
                AzureusContentFilter filter2;
                Map result = (Map)ipc.invoke("browseReceived", new Object[]{request2, browse_args});
                if (result == null || (filter2 = (AzureusContentFilter)result.get("filter")) == null) continue;
                filters.add(filter2);
            }
            catch (Throwable e) {
                this.log("browse callback failed", e);
            }
        }
        return filters;
    }

    @Override
    public String getPowerName() {
        return "MediaServer";
    }

    @Override
    public boolean requestPowerStateChange(int new_state, Object data) {
        UPnPMediaServerContentServer cs;
        return this.prevent_sleep_param == null || !this.prevent_sleep_param.getValue() || (cs = this.content_server) == null || cs.getConnectionCount() <= 0;
    }

    @Override
    public void informPowerStateChange(int new_state, Object data) {
    }

    public void addBrowseListener(IPCInterface callback) {
        this.browse_listeners.add(callback);
    }

    public void removeBrowseListener(IPCInterface callback) {
        this.browse_listeners.remove(callback);
    }

    public void addContent(AzureusContentFile file) {
        this.content_directory.addContent(file);
    }

    public void removeContent(AzureusContentFile file) {
        this.content_directory.removeContent(file);
    }

    public int addLocalRenderer(IPCInterface callback) {
        UPnPMediaRendererLocal renderer = new UPnPMediaRendererLocal(this, callback);
        this.addRenderer(renderer);
        return renderer.getID();
    }

    public long getStreamBufferBytes(int content_id, int stream_id) throws IPCException {
        long available;
        UPnPMediaServerContentDirectory.content c = this.content_directory.getContentFromID(content_id);
        if (c == null || !(c instanceof UPnPMediaServerContentDirectory.contentItem)) {
            throw new IPCException("Content id " + content_id + " not found");
        }
        UPnPMediaServerContentDirectory.contentItem item = (UPnPMediaServerContentDirectory.contentItem)c;
        DiskManagerFileInfo file = item.getFile();
        if (file.getLength() == file.getDownloaded()) {
            return Long.MAX_VALUE;
        }
        UPnPMediaServerContentServer.streamInfo stream_info = this.content_server.getStreamInfo(stream_id);
        if (stream_info == null) {
            return -1L;
        }
        long remaining = stream_info.getRemaining();
        if (remaining == (available = stream_info.getAvailableBytes())) {
            if (available == -1L) {
                return -1L;
            }
            return Long.MAX_VALUE;
        }
        return available;
    }

    public int getStreamType(int content_id) throws IPCException {
        UPnPMediaServerContentDirectory.content c = this.content_directory.getContentFromID(content_id);
        if (c == null || !(c instanceof UPnPMediaServerContentDirectory.contentItem)) {
            throw new IPCException("Content id " + content_id + " not found");
        }
        UPnPMediaServerContentDirectory.contentItem item = (UPnPMediaServerContentDirectory.contentItem)c;
        String cla = item.getContentClass();
        if (cla == "object.item.audioItem.musicTrack") {
            return 0;
        }
        if (cla == "object.item.videoItem.movie") {
            return 1;
        }
        return -1;
    }

    public void playDownload(Download download) throws IPCException {
        this.play(download);
    }

    public void playFile(DiskManagerFileInfo file) throws IPCException {
        this.play(file);
    }

    public String getContentURL(Download download) throws IPCException {
        return this.peekContentURL(download.getDiskManagerFileInfo()[0]);
    }

    public String getContentURL(DiskManagerFileInfo file) throws IPCException {
        return this.peekContentURL(file);
    }

    public String peekContentURL(Download download) throws IPCException {
        return this.peekContentURL(download.getDiskManagerFileInfo()[0]);
    }

    public String peekContentURL(DiskManagerFileInfo file) throws IPCException {
        try {
            return UPnPMediaServer.getContentResourceURI(file, this.getLocalIP(), this.getActivePort(), -1);
        }
        catch (Throwable t) {
            throw new IPCException(t);
        }
    }

    public String[] getMimeTypes(DiskManagerFileInfo file) throws IPCException {
        try {
            String id = UPnPMediaServer.getContentResourceID(file);
            UPnPMediaServerContentDirectory.contentItem item = this.content_directory.getContentFromResourceID(id);
            if (item != null) {
                try {
                    return item.getContentTypes();
                }
                catch (Throwable e) {
                    this.log("Failed to get content type", e);
                }
            }
            return new String[]{CM_SINK_PROTOCOLS};
        }
        catch (Throwable t) {
            throw new IPCException(t);
        }
    }

    public void invalidateDirectory() {
        this.content_directory.invalidate();
    }

    public void setQuickTimeAvailable(boolean avail) {
        this.quickTimeAvail = avail;
    }

    public boolean isRecognisedMedia(DiskManagerFileInfo file) {
        UPnPMediaServerContentDirectory.contentItem item;
        block3: {
            try {
                String id = UPnPMediaServer.getContentResourceID(file);
                item = this.content_directory.getContentFromResourceID(id);
                if (item != null) break block3;
                return false;
            }
            catch (Throwable e) {
                this.logger.log(e);
                return false;
            }
        }
        String cla = item.getContentClass();
        return cla == "object.item.audioItem.musicTrack" || cla == "object.item.imageItem.photo" || cla == "object.item.videoItem.movie";
    }

    public String getServiceName() {
        return this.service_name;
    }

    protected PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected String getServerName() {
        return String.valueOf(System.getProperty("os.name")) + "/" + System.getProperty("os.version") + " UPnP/1.0 " + "Azureus" + "/" + "5.7.4.1_CVS";
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    protected void log(String str, Throwable e) {
        this.logger.log(str, e);
    }

    protected void logAlert(String str) {
        this.logger.logAlertRepeatable(3, "UPnP Media Server: " + str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void start() {
        var1_1 = this.startup_lock;
        synchronized (var1_1) {
            if (this.starting) {
                return;
            }
            this.starting = true;
        }
        this.logger.log("Server starts: upnp enabled=" + this.enable_upnp);
        try {
            if (this.unloaded) {
                return;
            }
            if (!this.enable_upnp) ** GOTO lbl39
            this.doContentUPnP();
            adapter = new UPnPAdapter(){

                @Override
                public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                    return UPnPMediaServer.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
                }

                @Override
                public ResourceDownloaderFactory getResourceDownloaderFactory() {
                    return UPnPMediaServer.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                }

                @Override
                public UTTimer createTimer(String name) {
                    return UPnPMediaServer.this.plugin_interface.getUtilities().createTimer(name);
                }

                @Override
                public void createThread(String name, Runnable runnable) {
                    UPnPMediaServer.this.plugin_interface.getUtilities().createThread(name, runnable);
                }

                @Override
                public Comparator getAlphanumericComparator() {
                    return UPnPMediaServer.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
                }

                @Override
                public void log(Throwable e) {
                    Debug.printStackTrace(e);
                }

                @Override
                public void trace(String str) {
                }

                @Override
                public void log(String str) {
                }

                @Override
                public String getTraceDir() {
                    return UPnPMediaServer.this.plugin_interface.getPluginDirectoryName();
                }
            };
            this.ssdp = UPnPFactory.getSSDP(adapter, "239.255.255.250", 1900, 0, null);
            ssdp_port = this.ssdp.getControlPort();
            this.logger.log("SSDP port: " + ssdp_port);
            this.createContent();
            if (this.unloaded) {
                return;
            }
            this.ssdp_web_context = this.plugin_interface.getTracker().createWebContext(ssdp_port, 1);
            this.ssdp_web_context.addAuthenticationListener(new TrackerAuthenticationAdapter(){

                @Override
                public boolean authenticate(String headers, URL resource, String user, String password) {
                    String client = this.getHeaderField(headers, "X-Real-IP");
                    if (UPnPMediaServer.this.authContentPort(client)) {
                        return UPnPMediaServer.this.doContentAuth(client, user, password);
                    }
                    return true;
                }

                private String getHeaderField(String headers, String field) {
                    int p2;
                    String lc_headers = headers.toLowerCase();
                    int p1 = lc_headers.indexOf(String.valueOf(field.toLowerCase()) + ":");
                    if (p1 != -1 && (p2 = lc_headers.indexOf(10, p1)) != -1) {
                        return headers.substring(p1 + field.length() + 1, p2).trim();
                    }
                    return null;
                }
            });
            this.ssdp_web_context.addPageGenerator(new TrackerWebPageGenerator(){

                @Override
                public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                    List<AzureusContentFilter> filters = UPnPMediaServer.this.receivedBrowse(request2, false);
                    String url = request2.getURL();
                    String header = request2.getHeader();
                    Map headers = request2.getHeaders();
                    String action = (String)headers.get("soapaction");
                    if (url.equals("/ConnectionManager/Event") || url.equals("/ContentDirectory/Event")) {
                        HashMap headers_out = new HashMap();
                        String result = UPnPMediaServer.this.processEvent(url.equals("/ContentDirectory/Event"), request2.getClientAddress2(), headers_out, header.startsWith("SUBSCRIBE"), (String)headers.get("callback"), (String)headers.get("sid"), (String)headers.get("timeout"));
                        response.setHeader("SERVER", UPnPMediaServer.this.getServerName());
                        for (String name : headers_out.keySet()) {
                            String value = (String)headers_out.get(name);
                            response.setHeader(name, value);
                        }
                        response.useStream("xml", new ByteArrayInputStream(result.getBytes("UTF-8")));
                        return true;
                    }
                    if (action == null) {
                        if ((url = url.trim()).indexOf("..") == -1 && !url.endsWith("/")) {
                            String AV_Client_Info;
                            String UA;
                            int pos = url.lastIndexOf("/");
                            if (pos != -1) {
                                url = url.substring(pos);
                            }
                            if ((UA = (String)headers.get("user-agent")) != null && UA.toLowerCase().startsWith("xbox")) {
                                url = url.replaceAll("RootDevice", "RootDeviceXbox");
                            }
                            if ((AV_Client_Info = (String)headers.get("x-av-client-info")) != null && ((AV_Client_Info = AV_Client_Info.toLowerCase()).contains("bravia") || AV_Client_Info.contains("sony") && AV_Client_Info.contains("blu-ray")) && url.endsWith(".jpg")) {
                                url = String.valueOf(url.substring(0, url.length() - 4)) + "b.jpg";
                            }
                            String resource = "/com/aelitis/azureus/plugins/upnpmediaserver/resources" + url;
                            InputStream stream = this.getClass().getResourceAsStream(resource);
                            if (stream != null) {
                                try {
                                    String ext;
                                    if (url.startsWith("/RootDevice")) {
                                        int len;
                                        byte[] buffer = new byte[1024];
                                        String content2 = UPnPMediaServer.CM_SINK_PROTOCOLS;
                                        while ((len = stream.read(buffer)) > 0) {
                                            content2 = String.valueOf(content2) + new String(buffer, 0, len, "UTF-8");
                                        }
                                        content2 = content2.replaceAll("%UUID%", UPnPMediaServer.this.UUID_rootdevice);
                                        content2 = content2.replaceAll("%SERVICENAME%", UPnPMediaServer.this.service_name);
                                        stream.close();
                                        stream = new ByteArrayInputStream(content2.getBytes("UTF-8"));
                                    }
                                    response.useStream((ext = FileUtil.getExtension(resource)).length() <= 1 ? "xml" : ext.substring(1), stream);
                                    return true;
                                }
                                finally {
                                    stream.close();
                                }
                            }
                        }
                        String temp = header.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
                        UPnPMediaServer.this.logger.log("HTTP: no match for " + url);
                        UPnPMediaServer.this.logger.log("    header: " + temp);
                        UPnPMediaServer.this.logger.log("    decoded: " + headers);
                        return false;
                    }
                    String host = (String)headers.get("host");
                    if (host == null) {
                        host = UPnPMediaServer.this.getLocalIP();
                    } else {
                        int pos = host.indexOf(58);
                        if (pos != -1) {
                            host = host.substring(0, pos);
                        }
                        host = host.trim();
                    }
                    String client = (String)headers.get("user-agent");
                    client = client == null ? request2.getClientAddress() : String.valueOf(client) + ":" + request2.getClientAddress();
                    try {
                        String result;
                        int len;
                        String action_content = UPnPMediaServer.CM_SINK_PROTOCOLS;
                        byte[] buffer = new byte[1024];
                        InputStream is = request2.getInputStream();
                        while ((len = is.read(buffer)) >= 0) {
                            action_content = String.valueOf(action_content) + new String(buffer, 0, len, "UTF-8");
                        }
                        action_content = action_content.trim();
                        try {
                            result = UPnPMediaServer.this.processAction(host, client, url, action, UPnPMediaServer.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(action_content), filters);
                        }
                        catch (Throwable e) {
                            UPnPMediaServer.this.logger.log("Failed to process action '" + action_content + "' - " + Debug.getNestedExceptionMessage(e));
                            result = null;
                        }
                        if (result == null) {
                            response.setReplyStatus(501);
                        } else {
                            response.setHeader("SERVER", UPnPMediaServer.this.getServerName());
                            response.useStream("xml", new ByteArrayInputStream(result.getBytes("UTF-8")));
                        }
                        return true;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        UPnPMediaServer.this.logger.log(e);
                        return false;
                    }
                }
            });
            this.ssdp_listener = new UPnPSSDPListener(){

                @Override
                public void receivedResult(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String USN, URL location, String ST, String AL) {
                }

                @Override
                public void receivedNotify(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String USN, URL location, String NT, String NTS) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String[] receivedSearch(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String ST) {
                    int i = 0;
                    while (i < UPnPMediaServer.this.upnp_entities.length) {
                        if (ST.equals(UPnPMediaServer.this.upnp_entities[i])) {
                            List list = UPnPMediaServer.this.logged_searches;
                            synchronized (list) {
                                if (!UPnPMediaServer.this.logged_searches.contains(originator)) {
                                    UPnPMediaServer.this.logged_searches.add(originator);
                                    UPnPMediaServer.this.logger.log("SSDP: search from " + originator);
                                }
                            }
                            return new String[]{UPnPMediaServer.this.UUID_rootdevice, "RootDevice.xml"};
                        }
                        ++i;
                    }
                    return null;
                }

                @Override
                public void interfaceChanged(NetworkInterface network_interface) {
                }
            };
            this.ssdp.addListener(this.ssdp_listener);
            this.sendAlive();
            this.upnp = UPnPFactory.getSingleton(adapter, null);
            this.upnp_listener = new UPnPListener(){

                @Override
                public boolean deviceDiscovered(String USN, URL location) {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void rootDeviceFound(UPnPRootDevice device) {
                    if (device.getDevice().getDeviceType().equals("urn:schemas-upnp-org:device:MediaRenderer:1")) {
                        UPnPMediaRendererRemote new_renderer = null;
                        Set set = UPnPMediaServer.this.renderers;
                        synchronized (set) {
                            Iterator it = UPnPMediaServer.this.renderers.iterator();
                            while (it.hasNext()) {
                                UPnPMediaRenderer renderer = (UPnPMediaRenderer)it.next();
                                if (!(renderer instanceof UPnPMediaRendererRemote) || !((UPnPMediaRendererRemote)renderer).getDevice().getUSN().equals(device.getUSN())) continue;
                                it.remove();
                                renderer.destroy();
                            }
                            new_renderer = new UPnPMediaRendererRemote(UPnPMediaServer.this, device);
                            UPnPMediaServer.this.addRenderer(new_renderer);
                        }
                        if (UPnPMediaServer.this.unloaded && new_renderer != null) {
                            new_renderer.destroy();
                        }
                    }
                }
            };
            this.upnp.addRootDeviceListener(this.upnp_listener);
            if (this.http_enable_param.getValue()) {
                this.http_server = new UPnPMediaServerHTTP(this, this.http_port_param.getValue());
                this.handleUPnP(this.http_port_param.getValue(), "Media Server HTTP", this.http_port_upnp_param.getValue());
            }
            this.timer2_event = this.timer2.addPeriodicEvent(60000L, new UTTimerEventPerformer(){

                @Override
                public void perform(UTTimerEvent event2) {
                    UPnPMediaServer.this.sendAlive();
                }
            });
            this.timer3_event = this.timer3.addPeriodicEvent(2000L, new UTTimerEventPerformer(){
                int ticks = 0;

                @Override
                public void perform(UTTimerEvent event2) {
                    ++this.ticks;
                    UPnPMediaServer.this.sendEvents(this.ticks % 30 == 0);
                    UITextField status = UPnPMediaServer.this.view_model.getStatus();
                    UPnPMediaServerContentServer cs = UPnPMediaServer.this.content_server;
                    status.setText("connections=" + (cs == null ? 0 : UPnPMediaServer.this.content_server.getConnectionCount()) + ", up=" + DisplayFormatters.formatByteCountToKiBEtc(UPnPMediaChannel.getTotalUp()) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(UPnPMediaChannel.getAverageUpSpeed()) + ")");
                }
            });
            return;
lbl39:
            // 1 sources

            this.createContent();
            return;
        }
        catch (Throwable var1_2) {
            return;
        }
        finally {
            this.startup_sem.releaseForever();
        }
    }

    protected void ensureStarted() {
        if (this.startup_sem.isReleasedForever()) {
            return;
        }
        this.start();
        if (!this.startup_sem.reserve(30000L)) {
            this.log("Timeout waiting for startup");
        }
    }

    protected boolean isUserSelectedContentPort() {
        return this.stream_port != 0;
    }

    protected UPnPMediaServerContentDirectory getContentDirectory() {
        return this.content_directory;
    }

    protected boolean getApplyBindIPs() {
        return this.apply_bind.getValue();
    }

    protected int getContentPort() {
        if (this.stream_port != 0) {
            return this.stream_port;
        }
        PluginConfig config = this.plugin_interface.getPluginconfig();
        return config.getPluginIntParameter("content_port", 0);
    }

    protected void setContentPort(int port) {
        PluginConfig config = this.plugin_interface.getPluginconfig();
        config.setPluginParameter("content_port", port, true);
    }

    public String getLocalIP() {
        InetAddress bip;
        UPnPMediaServerContentServer cs = this.content_server;
        InetAddress inetAddress = bip = cs == null ? null : cs.getBindIP();
        if (bip == null) {
            return "127.0.0.1";
        }
        return bip.getHostAddress();
    }

    public int getActivePort() {
        if (this.content_server == null) {
            return -1;
        }
        return this.content_server.getPort();
    }

    protected void createContent() {
        this.dm_listener = new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                if (download.getTorrent() == null) {
                    return;
                }
                UPnPMediaServer.this.content_directory.addContent(download);
            }

            @Override
            public void downloadRemoved(Download download) {
                if (download.getTorrent() == null) {
                    return;
                }
                UPnPMediaServer.this.content_directory.removeContent(download);
            }
        };
        this.plugin_interface.getDownloadManager().addListener(this.dm_listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String processAction(String host, String client, String url, String action, SimpleXMLParserDocument doc, List<AzureusContentFilter> filters) {
        boolean directory;
        String xmlns;
        int client_type = -1;
        String mp_prefix = "windows-media-player/";
        int pos = client.toLowerCase().indexOf(mp_prefix);
        if (pos != -1) {
            try {
                int mp_version;
                String ver = client.substring(pos + mp_prefix.length());
                pos = ver.indexOf(32);
                if (pos != -1) {
                    ver = ver.substring(0, pos).trim();
                }
                if ((pos = ver.indexOf(46)) != -1) {
                    ver = ver.substring(0, pos);
                }
                if ((mp_version = Integer.parseInt(ver)) >= 12) {
                    client_type = 3;
                }
            }
            catch (Throwable ver) {
                // empty catch block
            }
        }
        if (client_type == -1) {
            int n = client_type = client.toLowerCase().startsWith("xbox") ? 2 : 1;
        }
        if (url.equals("/ContentDirectory/Control")) {
            xmlns = "urn:schemas-upnp-org:service:ContentDirectory:1";
            directory = true;
        } else {
            xmlns = "urn:schemas-upnp-org:service:ConnectionManager:1";
            directory = false;
        }
        SimpleXMLParserDocumentNode body = doc.getChild("Body");
        SimpleXMLParserDocumentNode call = body.getChildren()[0];
        String command = call.getName();
        SimpleXMLParserDocumentNode[] args = call.getChildren();
        HashMap<String, String> arg_map = new HashMap<String, String>();
        String arg_str = CM_SINK_PROTOCOLS;
        int i = 0;
        while (i < args.length) {
            SimpleXMLParserDocumentNode arg = args[i];
            arg_map.put(arg.getName(), arg.getValue());
            arg_str = String.valueOf(arg_str) + (i == 0 ? CM_SINK_PROTOCOLS : ",") + arg.getName() + " -> " + arg.getValue();
            ++i;
        }
        this.logger.log("Action (client=" + client + "): " + url + ":" + command + ", arg=" + arg_str);
        resultEntries result = new resultEntries();
        if (directory) {
            if (command.equals("GetSearchCapabilities")) {
                this.getSearchCapabilities(arg_map, result);
            } else if (command.equals("GetSortCapabilities")) {
                this.getSortCapabilities(arg_map, result);
            } else if (command.equals("GetSystemUpdateID")) {
                this.getSystemUpdateID(arg_map, result);
            } else if (command.equals("Browse")) {
                int num = this.browseOrSearch(host, arg_map, false, client_type, filters, result);
                this.logger.log("    -> " + num + " entries");
            } else {
                if (!command.equals("Search")) return null;
                int num = this.browseOrSearch(host, arg_map, true, client_type, filters, result);
                this.logger.log("    -> " + num + " entries");
            }
        } else if (command.equals("GetProtocolInfo")) {
            this.getProtocolInfo(arg_map, result);
        } else if (command.equals("GetCurrentConnectionIDs")) {
            this.getCurrentConnectionIDs(arg_map, result);
        } else {
            if (!command.equals("GetCurrentConnectionInfo")) return null;
            this.getCurrentConnectionInfo(arg_map, result);
        }
        String response = "<?xml version=\"1.0\" encoding=\"utf-8\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body>";
        response = String.valueOf(response) + "<u:" + command + "Response xmlns:u=\"" + xmlns + "\">";
        List result_args = result.getArgs();
        List result_vals = result.getValues();
        int i2 = 0;
        while (i2 < result_args.size()) {
            String arg = (String)result_args.get(i2);
            String val = (String)result_vals.get(i2);
            response = String.valueOf(response) + "<" + arg + ">" + val + "</" + arg + ">";
            ++i2;
        }
        response = String.valueOf(response) + "</u:" + command + "Response>";
        return String.valueOf(response) + "</s:Body></s:Envelope>";
    }

    protected void getProtocolInfo(Map args, resultEntries result) {
        result.add("Source", "http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_TN;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/gif:DLNA.ORG_PN=GIF_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/L16;rate=32000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=24000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=16000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=12000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=11025;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=8000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/3gpp:DLNA.ORG_PN=MPEG4_H263_MP4_P0_L10_AAC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_PAL;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_NTSC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_BASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-matroska:*,http-get:*:video/x-mkv:*,http-get:*:audio/x-matroska:*,http-get:*:video/avi:*,http-get:*:image/png:DLNA.ORG_PN=PNG_TN;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAPRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAFULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=HEAAC_L2_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=AAC_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMABASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:*:*");
        result.add("Sink", CM_SINK_PROTOCOLS);
    }

    protected void getCurrentConnectionIDs(Map args, resultEntries result) {
        result.add("ConnectionIDs", CM_SINK_PROTOCOLS);
    }

    protected void getCurrentConnectionInfo(Map args, resultEntries result) {
        result.add("RcsID", "0");
        result.add("AVTransportID", "0");
        result.add("ProtocolInfo", CM_SINK_PROTOCOLS);
        result.add("PeerConnectionManager", CM_SINK_PROTOCOLS);
        result.add("PeerConnectionID", "-1");
        result.add("Direction", "Input");
        result.add("Status", "Unknown");
    }

    protected void getSearchCapabilities(Map args, resultEntries result) {
        result.add("SearchCaps", CM_SINK_PROTOCOLS);
    }

    protected void getSortCapabilities(Map args, resultEntries result) {
        result.add("SortCaps", "dc:title");
    }

    protected void getSystemUpdateID(Map args, resultEntries result) {
        result.add("Id", String.valueOf(this.content_directory.getSystemUpdateID()));
    }

    protected int browseOrSearch(String host, Map args, boolean is_search, int client_type, List<AzureusContentFilter> az_filters, resultEntries result) {
        int requested_count;
        HashMap<String, Object> az_filter_args = new HashMap<String, Object>();
        String oid = (String)args.get("ObjectID");
        String browseFlag = (String)args.get("BrowseFlag");
        String searchCriteria = (String)args.get("SearchCriteria");
        String sortCriteria = (String)args.get("SortCriteria");
        String start_str = (String)args.get("StartingIndex");
        String request_str = (String)args.get("RequestedCount");
        if (oid == null) {
            if (client_type == 2) {
                String container_id = (String)args.get("ContainerID");
                if (container_id != null) {
                    oid = container_id.equals("15") ? String.valueOf(this.content_directory.getMoviesContainer().getID()) : (container_id.equals("16") ? String.valueOf(this.content_directory.getPicturesContainer().getID()) : (container_id.equals("4") || container_id.equals("5") || container_id.equals("6") || container_id.equals("7") || container_id.equals("F") ? String.valueOf(this.content_directory.getMusicContainer().getID()) : container_id));
                }
            } else if (client_type == 3 && searchCriteria != null) {
                oid = searchCriteria.contains("object.item.imageItem") ? String.valueOf(this.content_directory.getPicturesContainer().getID()) : (searchCriteria.contains("object.item.audioItem") ? String.valueOf(this.content_directory.getMusicContainer().getID()) : String.valueOf(this.content_directory.getMoviesContainer().getID()));
            }
        }
        if (oid == null) {
            this.log("'oid' missing from request, using root");
            oid = String.valueOf(this.content_directory.getRootContainer().getID());
        }
        if (is_search && browseFlag == null) {
            browseFlag = "BrowseDirectChildren";
        }
        int start_index = start_str == null ? 0 : Integer.parseInt(start_str);
        int n = requested_count = request_str == null ? 0 : Integer.parseInt(request_str);
        if (requested_count == 0) {
            requested_count = Integer.MAX_VALUE;
        }
        String didle = CM_SINK_PROTOCOLS;
        int num_returned = 0;
        int total_matches = 0;
        int update_id = this.content_directory.getSystemUpdateID();
        UPnPMediaServerContentDirectory.content cont = this.content_directory.getContentFromID(oid.length() == 0 ? 0 : Integer.parseInt(oid));
        if (cont == null) {
            this.log("Object '" + oid + "' not found");
        } else {
            if (cont instanceof UPnPMediaServerContentDirectory.contentContainer) {
                update_id = ((UPnPMediaServerContentDirectory.contentContainer)cont).getUpdateID();
            }
            if (browseFlag.equals("BrowseMetadata")) {
                didle = this.content_directory.getDIDL(cont, host, client_type, az_filters, az_filter_args);
                num_returned = 1;
                total_matches = 1;
            } else if (browseFlag.equals("BrowseDirectChildren")) {
                boolean ok = false;
                if (this.enable_lan_publish || az_filters.size() > 0) {
                    ok = true;
                } else {
                    try {
                        ok = InetAddress.getByName(host).isLoopbackAddress();
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                if (ok) {
                    UPnPMediaServerContentDirectory.contentContainer container = (UPnPMediaServerContentDirectory.contentContainer)cont;
                    List<UPnPMediaServerContentDirectory.content> children = container.getChildren();
                    this.sortContent(children);
                    int added = 0;
                    int visible = 0;
                    int i = 0;
                    while (i < children.size()) {
                        UPnPMediaServerContentDirectory.content child = children.get(i);
                        boolean vis = this.isVisible(child, az_filters, az_filter_args);
                        if (vis) {
                            ++visible;
                            if (start_index > 0) {
                                --start_index;
                            } else if (added < requested_count) {
                                didle = String.valueOf(didle) + this.content_directory.getDIDL(child, host, client_type, az_filters, az_filter_args);
                                ++added;
                            }
                        }
                        ++i;
                    }
                    num_returned = added;
                    total_matches = visible;
                } else {
                    num_returned = 0;
                    total_matches = 0;
                }
            }
        }
        didle = "<DIDL-Lite xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\">" + didle + "</DIDL-Lite>";
        result.add("Result", didle);
        result.add("NumberReturned", CM_SINK_PROTOCOLS + num_returned);
        result.add("TotalMatches", CM_SINK_PROTOCOLS + total_matches);
        result.add("UpdateID", CM_SINK_PROTOCOLS + update_id);
        return num_returned;
    }

    protected void sortContent(List<UPnPMediaServerContentDirectory.content> content2) {
        final int order = Integer.parseInt(this.sort_order.getValue());
        final boolean asc = this.sort_order_ascending.getValue();
        Collections.sort(content2, new Comparator<UPnPMediaServerContentDirectory.content>(){
            private Comparator<String> alpha_comp;
            {
                this.alpha_comp = UPnPMediaServer.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
            }

            @Override
            public int compare(UPnPMediaServerContentDirectory.content o1, UPnPMediaServerContentDirectory.content o2) {
                boolean reverse_order;
                int result = 0;
                boolean bl = reverse_order = order != 0 && !asc;
                if (order == 2) {
                    long l1 = o1.getDateMillis();
                    long l2 = o2.getDateMillis();
                    if (l2 > l1) {
                        result = -1;
                    } else if (l1 > l2) {
                        result = 1;
                    } else {
                        reverse_order = false;
                    }
                }
                if (result == 0) {
                    result = this.alpha_comp.compare(o1.getName(), o2.getName());
                }
                if (reverse_order) {
                    result = -result;
                }
                return result;
            }
        });
    }

    protected boolean isVisible(UPnPMediaServerContentDirectory.content c, List<AzureusContentFilter> filters, Map<String, Object> filter_args) {
        boolean vis = false;
        if (filters.size() == 0) {
            vis = true;
        } else if (c instanceof UPnPMediaServerContentDirectory.contentItem) {
            AzureusContentFile acf = ((UPnPMediaServerContentDirectory.contentItem)c).getACF();
            for (AzureusContentFilter filter2 : filters) {
                if (!filter2.isVisible(acf, filter_args)) continue;
                vis = true;
            }
        } else {
            AzureusContentDownload acd = ((UPnPMediaServerContentDirectory.contentContainer)c).getACD();
            if (acd == null) {
                vis = true;
            } else {
                for (AzureusContentFilter filter3 : filters) {
                    if (!filter3.isVisible(acd, filter_args)) continue;
                    vis = true;
                }
            }
        }
        return vis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processEvent(boolean content_directory, InetSocketAddress client, Map headers, boolean subscribe, String callback, String sid, String timeout) {
        if (subscribe) {
            if (sid == null) {
                sid = "uuid:" + UUIDGenerator.generateUUIDString();
                event ev = new event(client, callback, sid, content_directory);
                Map map = this.events;
                synchronized (map) {
                    this.events.put(sid, ev);
                    this.new_events.add(ev);
                }
                this.logger.log("Event: Subscribe - " + ev.getString());
            } else {
                Map map = this.events;
                synchronized (map) {
                    event ev = (event)this.events.get(sid);
                    if (ev == null) {
                        System.out.println("can't renew event subscription for " + sid + ", not found");
                    } else {
                        ev.renew();
                        this.logger.log("Event: Renew - " + ev.getString());
                    }
                }
            }
            headers.put("DATE", TimeFormatter.getHTTPDate(SystemTime.getCurrentTime()));
            headers.put("SID", sid);
            headers.put("TIMEOUT", "Second-1800");
        } else if (sid != null) {
            Map map = this.events;
            synchronized (map) {
                event ev = (event)this.events.remove(sid);
                if (ev == null) {
                    this.logger.log("Event: Unsubscribe - unknown event " + sid);
                } else {
                    this.logger.log("Event: Unsubscribe - " + ev.getString());
                }
            }
        }
        return CM_SINK_PROTOCOLS;
    }

    protected void stop() {
        this.sendDead();
    }

    protected void play(Object obj) throws IPCException {
        DiskManagerFileInfo file;
        if (this.media_server_ui == null) {
            throw new IPCException("Media server UI not bound");
        }
        if (obj instanceof TableRow) {
            TableRow row = (TableRow)obj;
            obj = row.getDataSource();
        }
        if (obj instanceof Download) {
            Download download = (Download)obj;
            file = download.getDiskManagerFileInfo()[0];
        } else {
            file = (DiskManagerFileInfo)obj;
            try {
                Download download = file.getDownload();
            }
            catch (DownloadException e) {
                throw new IPCException("Failed to get download from file", e);
            }
        }
        String id = UPnPMediaServer.getContentResourceID(file);
        System.out.println("play: " + id);
        UPnPMediaServerContentDirectory.contentItem item = this.content_directory.getContentFromResourceID(id);
        if (item == null) {
            throw new IPCException("Failed to find item for id '" + id + "'");
        }
        String url = item.getURI(this.getLocalIP(), -1);
        try {
            String playCode;
            File playList;
            String user_dir = this.plugin_interface.getUtilities().getAzureusUserDir();
            List<String> content_types = Arrays.asList(item.getContentTypes());
            boolean isQuickTime = content_types.contains("video/quicktime");
            boolean forceWMP = false;
            if (this.plugin_interface.getUtilities().isOSX() && (content_types.contains("video/mpeg") || isQuickTime || content_types.contains("video/x-ms-wmv")) || isQuickTime && this.quickTimeAvail) {
                File playLists = new File(user_dir, "playlists");
                if (!playLists.exists()) {
                    playLists.mkdir();
                }
                String fileName = "azplay" + SystemTime.getCurrentTime() / 1000L + ".qtl";
                playList = new File(playLists, fileName);
                playCode = "<?xml version=\"1.0\"?><?quicktime type=\"application/x-quicktime-media-link\"?><embed autoplay=\"true\" fullscreen=\"full\" moviename=\"" + item.getTitle() + "\" " + "src=\"" + url + "\" />";
            } else {
                playList = new File(user_dir, "azplay.asx");
                playCode = "<ASX version = \"3.0\"><Entry><Ref href = \"" + url + "\" />" + "</Entry>" + "</ASX>";
                forceWMP = Constants.isWindows;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(playList));
            bw.write(playCode);
            bw.close();
            if (forceWMP) {
                this.media_server_ui.runInMediaPlayer(playList.getAbsolutePath(), true);
            } else {
                this.media_server_ui.play(playList);
            }
        }
        catch (Exception e) {
            throw new IPCException("Play operation failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAlive() {
        UPnPMediaServer uPnPMediaServer = this;
        synchronized (uPnPMediaServer) {
            if (this.alive) {
                this.sendNotify("ssdp:alive");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDead() {
        UPnPMediaServer uPnPMediaServer = this;
        synchronized (uPnPMediaServer) {
            this.alive = false;
            this.sendNotify("ssdp:byebye");
        }
    }

    protected void sendNotify(String status) {
        if (this.ssdp != null) {
            int i = 0;
            while (i < this.upnp_entities.length) {
                this.ssdp.notify(this.upnp_entities[i], status, this.upnp_entities[i] == this.UUID_rootdevice ? null : this.UUID_rootdevice, "RootDevice.xml");
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contentContainerUpdated(UPnPMediaServerContentDirectory.contentContainer c) {
        Map map = this.events;
        synchronized (map) {
            if (this.container_update_events == null) {
                this.container_update_events = new HashSet();
            }
            this.container_update_events.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvents(boolean check_timeouts) {
        ArrayList targets;
        Set to_send;
        Object ev;
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        ArrayList<Object> new_dir_targets = new ArrayList<Object>();
        ArrayList<Object> new_con_targets = new ArrayList<Object>();
        Map map = this.events;
        synchronized (map) {
            Iterator<Object> it = this.new_events.iterator();
            while (it.hasNext()) {
                ev = (event)it.next();
                if (((event)ev).getStartTime() <= now && now - ((event)ev).getStartTime() <= 1000L) continue;
                it.remove();
                if (((event)ev).isContentDirectory()) {
                    new_dir_targets.add(ev);
                    continue;
                }
                new_con_targets.add(ev);
            }
            if (check_timeouts) {
                it = this.events.values().iterator();
                while (it.hasNext()) {
                    ev = (event)it.next();
                    long t = ((event)ev).getStartTime();
                    if (t > now) {
                        ((event)ev).renew();
                        continue;
                    }
                    if (now - t <= 2400000L) continue;
                    this.logger.log("Event: Timeout - " + ((event)ev).getString());
                    it.remove();
                }
            }
        }
        if (new_dir_targets.size() > 0) {
            this.sendDirEvents(new_dir_targets, CM_SINK_PROTOCOLS + this.content_directory.getRootContainer().getUpdateID(), CM_SINK_PROTOCOLS, CM_SINK_PROTOCOLS);
        }
        if (new_con_targets.size() > 0) {
            this.sendConEvents(new_con_targets);
        }
        ev = this.events;
        synchronized (ev) {
            to_send = this.container_update_events;
            this.container_update_events = null;
            if (to_send == null || to_send.size() == 0 || this.events.size() == 0) {
                return;
            }
            targets = new ArrayList(this.events.values());
        }
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            event ev2 = (event)it.next();
            if (ev2.isContentDirectory()) continue;
            it.remove();
        }
        if (targets.size() == 0) {
            return;
        }
        it = to_send.iterator();
        String system_update = null;
        String container_update = null;
        while (it.hasNext()) {
            UPnPMediaServerContentDirectory.contentContainer container = (UPnPMediaServerContentDirectory.contentContainer)it.next();
            int id = container.getID();
            int update_id = container.getUpdateID();
            if (container.getParent() == null) {
                system_update = CM_SINK_PROTOCOLS + update_id;
            }
            if (container_update == null) {
                container_update = CM_SINK_PROTOCOLS;
            }
            container_update = String.valueOf(container_update) + (container_update.length() == 0 ? CM_SINK_PROTOCOLS : ",") + id + "," + update_id;
        }
        this.sendDirEvents(targets, system_update, container_update, null);
    }

    protected void sendDirEvents(List targets, String system_update, String container_update, String transfer_ids) {
        String xml = "<e:propertyset xmlns:e=\"urn:schemas-upnp-org:event-1-0\">";
        if (system_update != null) {
            xml = String.valueOf(xml) + "<e:property><SystemUpdateID>" + system_update + "</SystemUpdateID>" + "</e:property>";
        }
        if (container_update != null) {
            xml = String.valueOf(xml) + "<e:property><ContainerUpdateIDs>" + container_update + "</ContainerUpdateIDs>" + "</e:property>";
        }
        if (transfer_ids != null) {
            xml = String.valueOf(xml) + "<e:property><TransferIDs></TransferIDs></e:property>";
        }
        xml = String.valueOf(xml) + "</e:propertyset>";
        try {
            byte[] xml_bytes = xml.getBytes("UTF-8");
            for (event ev : targets) {
                ev.sendEvent(xml_bytes);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void sendConEvents(List targets) {
        String xml = "<e:propertyset xmlns:e=\"urn:schemas-upnp-org:event-1-0\">";
        xml = String.valueOf(xml) + "<e:property><SourceProtocolInfo>http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_TN;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/gif:DLNA.ORG_PN=GIF_LRG;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/L16;rate=32000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=24000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=16000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=12000;channels=2:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=11025;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=8000;channels=1:DLNA.ORG_PN=LPCM_low;DLNA.ORG_CI=1;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_PRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVHIGH_FULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/3gpp:DLNA.ORG_PN=MPEG4_H263_MP4_P0_L10_AAC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_NA_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_NA;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_PAL;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_PS_NTSC;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-ms-wmv:DLNA.ORG_PN=WMVMED_BASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:video/x-matroska:*,http-get:*:video/x-mkv:*,http-get:*:audio/x-matroska:*,http-get:*:video/avi:*,http-get:*:image/png:DLNA.ORG_PN=PNG_TN;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:image/png:DLNA.ORG_PN=PNG_LRG;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=00f00000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAPRO;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMAFULL;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=HEAAC_L2_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/mp4:DLNA.ORG_PN=AAC_ISO;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=48000;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=2:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/L16;rate=44100;channels=1:DLNA.ORG_PN=LPCM;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:audio/x-ms-wma:DLNA.ORG_PN=WMABASE;DLNA.ORG_OP=11;DLNA.ORG_FLAGS=01700000000000000000000000000000,http-get:*:*:*</SourceProtocolInfo></e:property>";
        xml = String.valueOf(xml) + "<e:property><SinkProtocolInfo></SinkProtocolInfo></e:property>";
        xml = String.valueOf(xml) + "<e:property><CurrentConnectionIDs></CurrentConnectionIDs></e:property>";
        xml = String.valueOf(xml) + "</e:propertyset>";
        try {
            byte[] xml_bytes = xml.getBytes("UTF-8");
            for (event ev : targets) {
                ev.sendEvent(xml_bytes);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected String escapeXML(String str) {
        if (str == null) {
            return CM_SINK_PROTOCOLS;
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataSourceChanged(Object datasource) {
        if (this.uiInstance == null) {
            return;
        }
        boolean enable = true;
        Object singleDS = null;
        if (datasource instanceof Object[]) {
            if (((Object[])datasource).length == 1) {
                singleDS = ((Object[])datasource)[0];
            } else {
                enable = false;
            }
        } else if (datasource != null) {
            singleDS = datasource;
        }
        enable = singleDS instanceof Download || singleDS instanceof DiskManagerFileInfo || singleDS instanceof TranscodeFile;
        UIToolBarManager tbm = this.uiInstance.getToolBarManager();
        if (tbm == null) {
            return;
        }
        Set<UPnPMediaRenderer> set = this.renderers;
        synchronized (set) {
            for (UPnPMediaRenderer renderer : this.renderers) {
                UIToolBarItem toolBarItem = tbm.getToolBarItem(CM_SINK_PROTOCOLS + renderer.hashCode());
                if (toolBarItem == null) continue;
                toolBarItem.setState(enable ? 1L : 0L);
            }
        }
    }

    public static String getContentResourceURI(DiskManagerFileInfo file, String host, int port, int stream_id) {
        return "http://" + UrlUtils.convertIPV6Host(host) + ":" + port + "/Content/" + UPnPMediaServer.getContentResourceID(file) + (stream_id == -1 ? CM_SINK_PROTOCOLS : "?sid=" + stream_id);
    }

    public static String getContentResourceKey(byte[] hash, int index) {
        return String.valueOf(ByteFormatter.encodeString(hash)) + "-" + index;
    }

    public static String getContentResourceID(DiskManagerFileInfo file) {
        byte[] hash;
        try {
            hash = file.getDownloadHash();
        }
        catch (DownloadException e) {
            hash = new byte[]{};
        }
        String res = UPnPMediaServer.getContentResourceKey(hash, file.getIndex());
        String name = file.getFile().getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1 && !name.endsWith(".")) {
            res = String.valueOf(res) + name.substring(pos);
        }
        return res;
    }

    protected class event {
        private static final String NL = "\r\n";
        private boolean content_directory;
        private String sid;
        private long create_renew_time;
        private long event_seq;
        private List callbacks = new ArrayList();

        protected event(InetSocketAddress address, String callback, String _sid, boolean _content_directory) {
            this.sid = _sid;
            this.content_directory = _content_directory;
            this.create_renew_time = UPnPMediaServer.this.plugin_interface.getUtilities().getCurrentSystemTime();
            StringTokenizer tok = new StringTokenizer(callback, ">");
            while (tok.hasMoreTokens()) {
                String c = tok.nextToken().trim().substring(1);
                if (!c.toLowerCase().startsWith("http")) {
                    if (c.startsWith("/")) {
                        c = c.substring(1);
                    }
                    c = "http://" + address.getAddress().getHostAddress() + ":" + address.getPort() + "/" + c;
                }
                try {
                    URL url = new URL(c);
                    this.callbacks.add(url);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }

        protected boolean isContentDirectory() {
            return this.content_directory;
        }

        protected void renew() {
            this.create_renew_time = UPnPMediaServer.this.plugin_interface.getUtilities().getCurrentSystemTime();
        }

        protected long getStartTime() {
            return this.create_renew_time;
        }

        protected String getString() {
            String cb = UPnPMediaServer.CM_SINK_PROTOCOLS;
            int i = 0;
            while (i < this.callbacks.size()) {
                cb = String.valueOf(cb) + (i == 0 ? UPnPMediaServer.CM_SINK_PROTOCOLS : ",") + this.callbacks.get(i);
                ++i;
            }
            return "sid=" + this.sid + ",callbacks=" + cb + ",seq=" + this.event_seq + ",cd=" + this.content_directory;
        }

        protected void sendEvent(byte[] bytes) {
            int i = 0;
            while (i < this.callbacks.size()) {
                block15: {
                    URL url = (URL)this.callbacks.get(i);
                    Socket socket = null;
                    try {
                        try {
                            socket = new Socket();
                            socket.setSoTimeout(10000);
                            socket.connect(new InetSocketAddress(url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort()), 10000);
                            OutputStream os = socket.getOutputStream();
                            this.write(os, "NOTIFY " + URLEncoder.encode(url.getPath(), "UTF-8") + " HTTP/1.1" + NL);
                            this.write(os, "HOST: " + url.getHost() + ":" + socket.getPort() + NL);
                            this.write(os, "CONTENT-TYPE: text/xml\r\n");
                            this.write(os, "CONTENT-LENGTH: " + bytes.length + NL);
                            this.write(os, "NT: upnp:event\r\n");
                            this.write(os, "NTS: upnp:propchange\r\n");
                            this.write(os, "SID: " + this.sid + NL);
                            this.write(os, "SEQ: " + this.event_seq + NL + NL);
                            os.write(bytes);
                            os.flush();
                            InputStream is = socket.getInputStream();
                            is.read();
                            UPnPMediaServer.this.logger.log("Event: sent to  " + url);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (socket != null) {
                                    socket.close();
                                }
                                break block15;
                            }
                            catch (Throwable throwable2) {}
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
            ++this.event_seq;
        }

        protected void write(OutputStream os, String str) throws IOException {
            os.write(str.getBytes("UTF-8"));
        }
    }

    protected class resultEntries {
        private List names = new ArrayList();
        private List values = new ArrayList();

        protected resultEntries() {
        }

        public void add(String name, String value) {
            this.names.add(name);
            this.values.add(UPnPMediaServer.this.escapeXML(value));
        }

        public List getArgs() {
            return this.names;
        }

        public List getValues() {
            return this.values;
        }
    }
}

