/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.util.PlatformTorrentUtils;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class MagnetPluginMDDownloader {
    private static final Set<String> active_set = new HashSet<String>();
    private final PluginInterface plugin_interface;
    private final MagnetPlugin plugin;
    private final byte[] hash;
    private final Set<String> networks;
    private final InetSocketAddress[] addresses;
    private final String args;
    private volatile boolean started;
    private volatile boolean cancelled;
    private volatile boolean completed;
    private List<DiskManagerRequest> requests = new ArrayList<DiskManagerRequest>();
    private AESemaphore running_sem = new AESemaphore("MPMDD:run");
    private AESemaphore complete_sem = new AESemaphore("MPMDD:comp");

    protected MagnetPluginMDDownloader(MagnetPlugin _plugin, PluginInterface _plugin_interface, byte[] _hash, Set<String> _networks, InetSocketAddress[] _addresses, String _args) {
        this.plugin = _plugin;
        this.plugin_interface = _plugin_interface;
        this.hash = _hash;
        this.networks = _networks;
        this.addresses = _addresses;
        this.args = _args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(final DownloadListener listener) {
        MagnetPluginMDDownloader magnetPluginMDDownloader = this;
        synchronized (magnetPluginMDDownloader) {
            if (this.started) {
                listener.failed(new Exception("Already started"));
                return;
            }
            if (this.cancelled || this.completed) {
                listener.failed(new Exception("Already cancelled/completed"));
                return;
            }
            this.started = true;
            new AEThread2("MagnetPluginMDDownloader"){

                @Override
                public void run() {
                    MagnetPluginMDDownloader.this.startSupport(listener);
                }
            }.start();
        }
    }

    protected void cancel() {
        this.cancelSupport(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSupport(boolean internal) {
        boolean wait_for_complete = !internal;
        try {
            ArrayList<DiskManagerRequest> to_cancel;
            MagnetPluginMDDownloader magnetPluginMDDownloader = this;
            synchronized (magnetPluginMDDownloader) {
                block11: {
                    if (!this.started) {
                        Debug.out("Not started!");
                        wait_for_complete = false;
                    }
                    if (!this.cancelled && !this.completed) break block11;
                    return;
                }
                this.cancelled = true;
                to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                this.requests.clear();
            }
            for (DiskManagerRequest request2 : to_cancel) {
                request2.cancel();
            }
        }
        finally {
            this.running_sem.releaseForever();
            if (wait_for_complete) {
                this.complete_sem.reserve();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSupport(final DownloadListener listener) {
        block132: {
            Download download;
            File torrent_file;
            File data_file;
            File tmp_dir;
            String hash_str;
            block131: {
                Throwable throwable3;
                block133: {
                    Set<String> set;
                    hash_str = ByteFormatter.encodeString(this.hash);
                    tmp_dir = null;
                    data_file = null;
                    torrent_file = null;
                    DownloadManager download_manager = this.plugin_interface.getDownloadManager();
                    download = null;
                    final Throwable[] error = new Throwable[1];
                    final ByteArrayOutputStream result = new ByteArrayOutputStream(32768);
                    Object url_sets = null;
                    try {
                        try {
                            InetSocketAddress[] tracker;
                            String[] lhs22;
                            Set<String> set2 = active_set;
                            synchronized (set2) {
                                if (active_set.contains(hash_str)) {
                                    throw new Exception("Download already active for hash " + hash_str);
                                }
                                active_set.add(hash_str);
                            }
                            Download existing_download = download_manager.getDownload(this.hash);
                            if (existing_download != null) {
                                throw new Exception("download already exists");
                            }
                            tmp_dir = AETemporaryFileHandler.createTempDir();
                            int rand = RandomUtils.generateRandomIntUpto(10000);
                            data_file = new File(tmp_dir, String.valueOf(hash_str) + "_" + rand + ".torrent");
                            torrent_file = new File(tmp_dir, String.valueOf(hash_str) + "_" + rand + ".metatorrent");
                            RandomAccessFile raf = new RandomAccessFile(data_file, "rw");
                            try {
                                byte[] buffer = new byte[524288];
                                Arrays.fill(buffer, (byte)-1);
                                long i = 0L;
                                while (i < 0x4000000L) {
                                    raf.write(buffer);
                                    i += (long)buffer.length;
                                }
                            }
                            finally {
                                raf.close();
                            }
                            URL announce_url = TorrentUtils.getDecentralisedURL(this.hash);
                            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(data_file, announce_url, 16384L);
                            TOTorrent meta_torrent = creator.create();
                            String[] bits = this.args.split("&");
                            ArrayList<Object> trackers = new ArrayList<Object>();
                            String name = "magnet:" + Base32.encode(this.hash);
                            HashMap<String[], InetSocketAddress[]> magnet_args = new HashMap<String[], InetSocketAddress[]>();
                            String[] stringArray = bits;
                            int n = bits.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String bit = stringArray[n2];
                                String[] x = bit.split("=");
                                if (x.length == 2) {
                                    lhs22 = x[0].toLowerCase();
                                    InetSocketAddress[] rhs = UrlUtils.decode(x[1]);
                                    magnet_args.put(lhs22, rhs);
                                    if (lhs22.equals("tr")) {
                                        tracker = rhs;
                                        trackers.add(tracker);
                                    } else if (lhs22.equals("dn")) {
                                        name = rhs;
                                    }
                                }
                                ++n2;
                            }
                            if (trackers.size() > 0) {
                                trackers.add(0, announce_url.toExternalForm());
                                TOTorrentAnnounceURLGroup ag = meta_torrent.getAnnounceURLGroup();
                                ArrayList<TOTorrentAnnounceURLSet> sets = new ArrayList<TOTorrentAnnounceURLSet>();
                                for (String string : trackers) {
                                    try {
                                        URL tracker_url = new URL(string);
                                        sets.add(ag.createAnnounceURLSet(new URL[]{tracker_url}));
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                if (sets.size() > 0) {
                                    url_sets = sets.toArray(new TOTorrentAnnounceURLSet[sets.size()]);
                                    ag.setAnnounceURLSets((TOTorrentAnnounceURLSet[])url_sets);
                                }
                            }
                            if (!data_file.delete()) {
                                throw new Exception("Failed to delete " + data_file);
                            }
                            meta_torrent.setHashOverride(this.hash);
                            TorrentUtils.setFlag(meta_torrent, 2, true);
                            TorrentUtils.setFlag(meta_torrent, 1, true);
                            meta_torrent.serialiseToBEncodedFile(torrent_file);
                            download_manager.clearNonPersistentDownloadState(this.hash);
                            download = download_manager.addNonPersistentDownloadStopped(PluginCoreUtils.wrap(meta_torrent), torrent_file, data_file);
                            String display_name = MessageText.getString("MagnetPlugin.use.md.download.name", new String[]{name});
                            DownloadManagerState state = PluginCoreUtils.unwrap(download).getDownloadState();
                            state.setDisplayName(String.valueOf(display_name) + ".torrent");
                            if (this.networks.size() == 0 || this.networks.size() == 1 && this.networks.contains("Public")) {
                                lhs22 = AENetworkClassifier.AT_NETWORKS;
                                int e = AENetworkClassifier.AT_NETWORKS.length;
                                int n3 = 0;
                                while (n3 < e) {
                                    String string = lhs22[n3];
                                    state.setNetworkEnabled(string, true);
                                    ++n3;
                                }
                            } else {
                                for (String string : this.networks) {
                                    state.setNetworkEnabled(string, true);
                                }
                                if (!this.networks.contains("Public")) {
                                    state.setNetworkEnabled("Public", false);
                                }
                            }
                            if (!this.plugin.isNetworkEnabled("Public")) {
                                state.setNetworkEnabled("Public", false);
                            }
                            final ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
                            if (this.addresses != null && this.addresses.length > 0) {
                                String[] enabled_nets = state.getNetworks();
                                tracker = this.addresses;
                                int rhs = this.addresses.length;
                                int lhs22 = 0;
                                while (lhs22 < rhs) {
                                    InetSocketAddress address = tracker[lhs22];
                                    String host = AddressUtils.getHostAddress(address);
                                    String net = AENetworkClassifier.categoriseAddress(host);
                                    String[] stringArray2 = enabled_nets;
                                    int n4 = enabled_nets.length;
                                    int n5 = 0;
                                    while (n5 < n4) {
                                        String n6 = stringArray2[n5];
                                        if (n6 == net) {
                                            arrayList.add(address);
                                            break;
                                        }
                                        ++n5;
                                    }
                                    ++lhs22;
                                }
                            }
                            final HashSet<String> peer_networks = new HashSet<String>();
                            final ArrayList peers_for_cache = new ArrayList();
                            download.addPeerListener(new DownloadPeerListener(){

                                @Override
                                public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                                    if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                                        download.removePeerListener(this);
                                        return;
                                    }
                                    final PEPeerManager pm = PluginCoreUtils.unwrap(peer_manager);
                                    peer_manager.addListener(new PeerManagerListener2(){
                                        private PeerManagerListener2 pm_listener = this;
                                        private int md_size;

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void eventOccurred(PeerManagerEvent event2) {
                                            if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                                                peer_manager.removeListener(this);
                                                return;
                                            }
                                            if (event2.getType() != 1) {
                                                return;
                                            }
                                            final Peer peer = event2.getPeer();
                                            try {
                                                String peer_ip = peer.getIp();
                                                String network = AENetworkClassifier.categoriseAddress(peer_ip);
                                                Set set = peer_networks;
                                                synchronized (set) {
                                                    peer_networks.add(network);
                                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                                    peers_for_cache.add(map);
                                                    map.put("ip", peer_ip.getBytes("UTF-8"));
                                                    map.put("port", new Long(peer.getPort()));
                                                }
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                            peer.addListener(new PeerListener2(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public void eventOccurred(PeerEvent event2) {
                                                    if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed || md_size > 0) {
                                                        peer.removeListener(this);
                                                        return;
                                                    }
                                                    if (event2.getType() != 1) {
                                                        return;
                                                    }
                                                    if ((Integer)event2.getData() != 30) {
                                                        return;
                                                    }
                                                    PeerManagerListener2 peerManagerListener2 = pm_listener;
                                                    synchronized (peerManagerListener2) {
                                                        if (md_size > 0) {
                                                            return;
                                                        }
                                                        md_size = pm.getTorrentInfoDictSize();
                                                        if (md_size <= 0) {
                                                            return;
                                                        }
                                                        peer_manager.removeListener(pm_listener);
                                                    }
                                                    listener.reportProgress(0, md_size);
                                                    new AEThread2(""){

                                                        /*
                                                         * WARNING - Removed try catching itself - possible behaviour change.
                                                         * Loose catch block
                                                         */
                                                        @Override
                                                        public void run() {
                                                            DiskManagerChannel channel2 = null;
                                                            try {
                                                                channel2 = download.getDiskManagerFileInfo()[0].createChannel();
                                                                final DiskManagerRequest request2 = channel2.createRequest();
                                                                request2.setType(1);
                                                                request2.setOffset(0L);
                                                                request2.setLength(md_size);
                                                                request2.setMaximumReadChunkSize(16384);
                                                                request2.addListener(new DiskManagerListener(){

                                                                    /*
                                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                                     */
                                                                    @Override
                                                                    public void eventOccurred(DiskManagerEvent event2) {
                                                                        int type = event2.getType();
                                                                        if (type == 2) {
                                                                            error[0] = event2.getFailure();
                                                                            MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                        } else if (type == 1) {
                                                                            PooledByteBuffer buffer = null;
                                                                            try {
                                                                                try {
                                                                                    int dl_size;
                                                                                    buffer = event2.getBuffer();
                                                                                    byte[] bytes = buffer.toByteArray();
                                                                                    MagnetPluginMDDownloader magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                                                    synchronized (magnetPluginMDDownloader) {
                                                                                        result.write(bytes);
                                                                                        dl_size = result.size();
                                                                                        if (dl_size == md_size) {
                                                                                            MagnetPluginMDDownloader.this.completed = true;
                                                                                            listener.reportProgress(md_size, md_size);
                                                                                            MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                                        }
                                                                                    }
                                                                                    if (!MagnetPluginMDDownloader.this.completed) {
                                                                                        listener.reportProgress(dl_size, md_size);
                                                                                    }
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    error[0] = e;
                                                                                    request2.cancel();
                                                                                    MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                                    if (buffer != null) {
                                                                                        buffer.returnToPool();
                                                                                    }
                                                                                }
                                                                            }
                                                                            finally {
                                                                                if (buffer != null) {
                                                                                    buffer.returnToPool();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                });
                                                                MagnetPluginMDDownloader magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                                synchronized (magnetPluginMDDownloader) {
                                                                    block14: {
                                                                        if (!MagnetPluginMDDownloader.this.cancelled) break block14;
                                                                        return;
                                                                        {
                                                                            catch (Throwable throwable) {
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                    }
                                                                    try {
                                                                        MagnetPluginMDDownloader.this.requests.add(request2);
                                                                        // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 6] lbl20 : MonitorExitStatement: MONITOREXIT : var3_4
                                                                        request2.run();
                                                                        magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                                        synchronized (magnetPluginMDDownloader) {
                                                                            MagnetPluginMDDownloader.this.requests.remove(request2);
                                                                        }
                                                                    }
                                                                    catch (Throwable e) {
                                                                        error[0] = e;
                                                                        MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                    }
                                                                }
                                                            }
                                                            finally {
                                                                if (channel2 != null) {
                                                                    channel2.destroy();
                                                                }
                                                            }
                                                            {
                                                                return;
                                                            }
                                                        }
                                                    }.start();
                                                }
                                            });
                                        }
                                    });
                                }

                                @Override
                                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                                }
                            });
                            final Download f_download = download;
                            DownloadManagerListener dl_listener = new DownloadManagerListener(){
                                private Object lock = this;
                                private TimerEventPeriodic timer_event;
                                private boolean removed;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void downloadAdded(final Download download) {
                                    if (download == f_download) {
                                        Object object = this.lock;
                                        synchronized (object) {
                                            if (!this.removed) {
                                                if (this.timer_event == null) {
                                                    this.timer_event = SimpleTimer.addPeriodicEvent("announcer", 30000L, new TimerEventPerformer(){

                                                        /*
                                                         * WARNING - Removed try catching itself - possible behaviour change.
                                                         */
                                                        @Override
                                                        public void perform(TimerEvent event2) {
                                                            Object object = lock;
                                                            synchronized (object) {
                                                                if (removed) {
                                                                    return;
                                                                }
                                                                if (MagnetPluginMDDownloader.this.running_sem.isReleasedForever()) {
                                                                    if (timer_event != null) {
                                                                        timer_event.cancel();
                                                                        timer_event = null;
                                                                    }
                                                                    return;
                                                                }
                                                            }
                                                            download.requestTrackerAnnounce(true);
                                                            this.injectPeers(download);
                                                        }
                                                    });
                                                }
                                                if (arrayList.size() > 0) {
                                                    SimpleTimer.addEvent("injecter", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                                                        @Override
                                                        public void perform(TimerEvent event2) {
                                                            this.injectPeers(download);
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }

                                private void injectPeers(Download download) {
                                    PeerManager pm = download.getPeerManager();
                                    if (pm != null) {
                                        for (InetSocketAddress address : arrayList) {
                                            pm.addPeer(AddressUtils.getHostAddress(address), address.getPort());
                                        }
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void downloadRemoved(Download dl) {
                                    if (dl == f_download) {
                                        Object object = this.lock;
                                        synchronized (object) {
                                            this.removed = true;
                                            if (this.timer_event != null) {
                                                this.timer_event.cancel();
                                                this.timer_event = null;
                                            }
                                        }
                                        if (!MagnetPluginMDDownloader.this.cancelled && !MagnetPluginMDDownloader.this.completed) {
                                            error[0] = new Exception("Download manually removed");
                                            MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                        }
                                    }
                                }
                            };
                            download_manager.addListener(dl_listener, true);
                            try {
                                download.moveTo(1);
                                download.setForceStart(true);
                                download.setFlag(4L, true);
                                this.running_sem.reserve();
                            }
                            finally {
                                download_manager.removeListener(dl_listener);
                            }
                            if (this.completed) {
                                byte[] bytes = result.toByteArray();
                                Map<String, Object> info = BDecoder.decode(bytes);
                                HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
                                map.put("info", info);
                                TOTorrent torrent = TOTorrentFactory.deserialiseFromMap(map);
                                byte[] final_hash = torrent.getHash();
                                if (!Arrays.equals(this.hash, final_hash)) {
                                    throw new Exception("Metadata torrent hash mismatch: expected=" + ByteFormatter.encodeString(this.hash) + ", actual=" + ByteFormatter.encodeString(final_hash));
                                }
                                if (url_sets != null) {
                                    ArrayList<TOTorrentAnnounceURLSet> updated = new ArrayList<TOTorrentAnnounceURLSet>();
                                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = url_sets;
                                    int n7 = ((TOTorrentAnnounceURLSet[])url_sets).length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        TOTorrentAnnounceURLSet set3 = tOTorrentAnnounceURLSetArray[n8];
                                        if (!TorrentUtils.isDecentralised(set3.getAnnounceURLs()[0])) {
                                            updated.add(set3);
                                        }
                                        ++n8;
                                    }
                                    url_sets = updated.size() == 0 ? null : updated.toArray(new TOTorrentAnnounceURLSet[updated.size()]);
                                }
                                if (url_sets != null) {
                                    torrent.setAnnounceURL(url_sets[0].getAnnounceURLs()[0]);
                                    torrent.getAnnounceURLGroup().setAnnounceURLSets((TOTorrentAnnounceURLSet[])url_sets);
                                } else {
                                    torrent.setAnnounceURL(TorrentUtils.getDecentralisedURL(this.hash));
                                }
                                if (peers_for_cache.size() > 0) {
                                    HashMap peer_cache = new HashMap();
                                    peer_cache.put("tracker_peers", peers_for_cache);
                                    TorrentUtils.setPeerCache(torrent, peer_cache);
                                }
                                try {
                                    String pfi_str;
                                    String dn = (String)magnet_args.get("dn");
                                    if (dn != null) {
                                        PlatformTorrentUtils.setContentTitle(torrent, dn);
                                    }
                                    if ((pfi_str = (String)magnet_args.get("pfi")) != null) {
                                        PlatformTorrentUtils.setContentPrimaryFileIndex(torrent, Integer.parseInt(pfi_str));
                                    }
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                listener.complete(torrent, peer_networks);
                                break block131;
                            }
                            if (this.cancelled) {
                                throw new Exception("Download cancelled");
                            }
                            this.cancelSupport(true);
                            try {
                                if (error[0] != null) {
                                    throw error[0];
                                }
                                throw new Exception("Download terminated prematurely");
                            }
                            catch (Throwable e) {
                                listener.failed(e);
                                Debug.out(e);
                                throw e;
                            }
                        }
                        catch (Throwable e) {
                            boolean was_cancelled = this.cancelled;
                            this.cancelSupport(true);
                            if (!was_cancelled) {
                                listener.failed(e);
                                Debug.out(e);
                            }
                            try {
                                try {
                                    ArrayList<DiskManagerRequest> to_cancel;
                                    if (download != null) {
                                        try {
                                            download.stop();
                                        }
                                        catch (Throwable throwable3) {
                                            // empty catch block
                                        }
                                        try {
                                            download.remove();
                                        }
                                        catch (Throwable e2) {
                                            Debug.out(e2);
                                        }
                                    }
                                    MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                                    synchronized (magnetPluginMDDownloader) {
                                        to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                                        this.requests.clear();
                                    }
                                    for (DiskManagerRequest diskManagerRequest : to_cancel) {
                                        diskManagerRequest.cancel();
                                    }
                                    if (torrent_file != null) {
                                        torrent_file.delete();
                                    }
                                    if (data_file != null) {
                                        data_file.delete();
                                    }
                                    if (tmp_dir != null) {
                                        tmp_dir.delete();
                                    }
                                }
                                catch (Throwable e3) {
                                    Debug.out(e3);
                                    Set<String> set2 = active_set;
                                    synchronized (set2) {
                                        active_set.remove(hash_str);
                                    }
                                    this.complete_sem.releaseForever();
                                    break block132;
                                }
                            }
                            catch (Throwable throwable2) {
                                Set<String> set3 = active_set;
                                synchronized (set3) {
                                    active_set.remove(hash_str);
                                }
                                this.complete_sem.releaseForever();
                                throw throwable2;
                            }
                        }
                        set = active_set;
                    }
                    catch (Throwable throwable3) {
                        try {
                            try {
                                ArrayList<DiskManagerRequest> to_cancel;
                                if (download != null) {
                                    try {
                                        download.stop();
                                    }
                                    catch (Throwable e3) {
                                        // empty catch block
                                    }
                                    try {
                                        download.remove();
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                                synchronized (magnetPluginMDDownloader) {
                                    to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                                    this.requests.clear();
                                }
                                for (DiskManagerRequest diskManagerRequest : to_cancel) {
                                    diskManagerRequest.cancel();
                                }
                                if (torrent_file != null) {
                                    torrent_file.delete();
                                }
                                if (data_file != null) {
                                    data_file.delete();
                                }
                                if (tmp_dir != null) {
                                    tmp_dir.delete();
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Set<String> set4 = active_set;
                                synchronized (set4) {
                                    active_set.remove(hash_str);
                                }
                                this.complete_sem.releaseForever();
                                break block133;
                            }
                        }
                        catch (Throwable throwable4) {
                            Set<String> set5 = active_set;
                            synchronized (set5) {
                                active_set.remove(hash_str);
                            }
                            this.complete_sem.releaseForever();
                            throw throwable4;
                        }
                    }
                    synchronized (set) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                    break block132;
                    Set<String> set6 = active_set;
                    synchronized (set6) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                }
                throw throwable3;
            }
            try {
                try {
                    ArrayList<DiskManagerRequest> to_cancel;
                    if (download != null) {
                        try {
                            download.stop();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            download.remove();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                    synchronized (magnetPluginMDDownloader) {
                        to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                        this.requests.clear();
                    }
                    for (DiskManagerRequest diskManagerRequest : to_cancel) {
                        diskManagerRequest.cancel();
                    }
                    if (torrent_file != null) {
                        torrent_file.delete();
                    }
                    if (data_file != null) {
                        data_file.delete();
                    }
                    if (tmp_dir != null) {
                        tmp_dir.delete();
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    Set<String> set = active_set;
                    synchronized (set) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                    break block132;
                }
            }
            catch (Throwable throwable) {
                Set<String> set = active_set;
                synchronized (set) {
                    active_set.remove(hash_str);
                }
                this.complete_sem.releaseForever();
                throw throwable;
            }
            Set<String> set = active_set;
            synchronized (set) {
                active_set.remove(hash_str);
            }
            this.complete_sem.releaseForever();
        }
    }

    protected static interface DownloadListener {
        public void reportProgress(int var1, int var2);

        public void complete(TOTorrent var1, Set<String> var2);

        public void failed(Throwable var1);
    }
}

