/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;

public class VuzeFileImpl
implements VuzeFile {
    private final VuzeFileHandler handler;
    private VuzeFileComponent[] components;

    protected VuzeFileImpl(VuzeFileHandler _handler) {
        this.handler = _handler;
        this.components = new VuzeFileComponent[0];
    }

    protected VuzeFileImpl(VuzeFileHandler _handler, Map map) {
        this.handler = _handler;
        List l_comps = (List)map.get("components");
        this.components = new VuzeFileComponent[l_comps.size()];
        int i = 0;
        while (i < l_comps.size()) {
            Map comp2 = (Map)l_comps.get(i);
            int type = ((Long)comp2.get("type")).intValue();
            Map content2 = (Map)comp2.get("content");
            this.components[i] = new comp(type, content2);
            ++i;
        }
    }

    @Override
    public String getName() {
        String str = "";
        VuzeFileComponent[] vuzeFileComponentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            VuzeFileComponent comp2 = vuzeFileComponentArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + comp2.getTypeName();
            ++n2;
        }
        return str;
    }

    @Override
    public VuzeFileComponent[] getComponents() {
        return this.components;
    }

    @Override
    public VuzeFileComponent addComponent(int type, Map content2) {
        comp comp2 = new comp(type, content2);
        int old_len = this.components.length;
        VuzeFileComponent[] res = new VuzeFileComponent[old_len + 1];
        System.arraycopy(this.components, 0, res, 0, old_len);
        res[old_len] = comp2;
        this.components = res;
        return comp2;
    }

    @Override
    public Map exportToMap() throws IOException {
        HashMap map = new HashMap();
        HashMap vuze_map = new HashMap();
        map.put("vuze", vuze_map);
        ArrayList list = new ArrayList();
        vuze_map.put("components", list);
        int i = 0;
        while (i < this.components.length) {
            VuzeFileComponent comp2 = this.components[i];
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("type", new Long(comp2.getType()));
            entry.put("content", comp2.getContent());
            list.add(entry);
            ++i;
        }
        return map;
    }

    @Override
    public byte[] exportToBytes() throws IOException {
        return BEncoder.encode(this.exportToMap());
    }

    @Override
    public String exportToJSON() throws IOException {
        return BEncoder.encodeToJSON(this.exportToMap());
    }

    @Override
    public void write(File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        try {
            fos.write(this.exportToBytes());
        }
        finally {
            fos.close();
        }
    }

    protected static class comp
    implements VuzeFileComponent {
        private final int type;
        private final Map contents;
        private boolean processed;
        private Map user_data;

        protected comp(int _type, Map _contents) {
            this.type = _type;
            this.contents = _contents;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getTypeName() {
            switch (this.type) {
                case 0: {
                    return "None";
                }
                case 1: {
                    return "Search Template";
                }
                case 2: {
                    return "Navigation";
                }
                case 4: {
                    return "Condition Check";
                }
                case 8: {
                    return "Plugin";
                }
                case 16: {
                    return "Subscription";
                }
                case 32: {
                    return "Subscription";
                }
                case 64: {
                    return "Customization";
                }
                case 128: {
                    return "Content Network";
                }
                case 256: {
                    return "Search Operation";
                }
                case 512: {
                    return "Device";
                }
                case 1024: {
                    return "Config Settings";
                }
            }
            return "Unknown";
        }

        @Override
        public Map getContent() {
            return this.contents;
        }

        @Override
        public void setProcessed() {
            this.processed = true;
        }

        @Override
        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public synchronized void setData(Object key, Object value) {
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            this.user_data.put(key, value);
        }

        @Override
        public synchronized Object getData(Object key) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(key);
        }
    }
}

