/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.png;

import com.aelitis.azureus.core.util.png.CRCedChunk;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class IDATChunk
extends CRCedChunk {
    private static final byte[] type = new byte[]{73, 68, 65, 84};
    private final int width;
    private final int height;

    public IDATChunk(int width, int height) {
        super(type);
        this.width = width;
        this.height = height;
    }

    @Override
    public byte[] getContentPayload() {
        byte[] payload = new byte[(this.width + 1) * this.height];
        int i = 0;
        while (i < this.height) {
            int offset = i * (this.width + 1);
            payload[offset++] = 0;
            int j = 0;
            while (j < this.width) {
                payload[offset + j] = 127;
                ++j;
            }
            ++i;
        }
        Deflater deflater = new Deflater(-1);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream((this.width + 1) * this.height);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, deflater);
        try {
            compBytes.write(payload);
            compBytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] compPayload = outBytes.toByteArray();
        return compPayload;
    }
}

