/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.http;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.http.HTTPAuthHelperListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.ThreadPool;

public class HTTPAuthHelper {
    public static final boolean TRACE = false;
    public static final int MAX_PROCESSORS = 32;
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int READ_TIMEOUT = 30000;
    private final HTTPAuthHelper parent;
    private final Map children = new HashMap();
    private final URL delegate_to;
    final String delegate_to_host;
    final int delegate_to_port;
    final boolean delegate_is_https;
    private Proxy delegate_to_proxy;
    private final CopyOnWriteList listeners = new CopyOnWriteList();
    private int port;
    private ServerSocket server_socket;
    private boolean http_only_detected;
    private final Map cookie_names_set = new HashMap();
    final ThreadPool thread_pool = new ThreadPool("HTTPSniffer", 32, true);
    final List processors = new ArrayList();
    private volatile boolean destroyed;

    public HTTPAuthHelper(URL url) throws Exception {
        this(null, url);
    }

    private HTTPAuthHelper(HTTPAuthHelper _parent, URL _delegate_to) throws Exception {
        this.parent = _parent;
        this.delegate_to = _delegate_to;
        this.delegate_to_host = this.delegate_to.getHost();
        this.delegate_is_https = this.delegate_to.getProtocol().toLowerCase().equals("https");
        this.delegate_to_port = this.delegate_to.getPort() == -1 ? this.delegate_to.getDefaultPort() : this.delegate_to.getPort();
        this.server_socket = new ServerSocket();
        this.server_socket.setReuseAddress(true);
        this.server_socket.bind(new InetSocketAddress("127.0.0.1", 0));
        this.port = this.server_socket.getLocalPort();
    }

    public void setProxy(Proxy _proxy) {
        this.delegate_to_proxy = _proxy;
    }

    public void start() {
        new AEThread2("HTTPSniffingProxy: " + this.delegate_to_host + ":" + this.delegate_to_port + "/" + this.delegate_is_https + "/" + this.port, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    try {
                        while (!HTTPAuthHelper.this.destroyed) {
                            Socket socket = HTTPAuthHelper.this.server_socket.accept();
                            socket.setSoTimeout(30000);
                            HTTPAuthHelper hTTPAuthHelper = HTTPAuthHelper.this;
                            synchronized (hTTPAuthHelper) {
                                if (HTTPAuthHelper.this.processors.size() >= 32) {
                                    try {
                                        Debug.out("Too many processors");
                                        socket.close();
                                    }
                                    catch (Throwable throwable) {}
                                } else {
                                    processor proc = new processor(socket);
                                    HTTPAuthHelper.this.processors.add(proc);
                                    proc.start();
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (HTTPAuthHelper.this.destroyed) break block10;
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    public int getPort() {
        return this.port;
    }

    public boolean wasHTTPOnlyCookieDetected() {
        return this.http_only_detected;
    }

    private void setHTTPOnlyCookieDetected() {
        this.http_only_detected = true;
        if (this.parent != null) {
            this.parent.setHTTPOnlyCookieDetected();
        }
    }

    private String getKey(URL url) {
        int child_port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String key = String.valueOf(url.getProtocol()) + ":" + url.getHost() + ":" + child_port;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPAuthHelper getChild(String url_str, boolean optional) throws Exception {
        if (this.parent != null) {
            return this.parent.getChild(url_str, optional);
        }
        String lc_url_str = url_str.toLowerCase();
        if (lc_url_str.startsWith("http://") || lc_url_str.startsWith("https://")) {
            URL child_url = new URL(url_str);
            String child_key = this.getKey(child_url);
            if (child_key.equals(this.getKey(this.delegate_to))) {
                return this;
            }
            HTTPAuthHelper hTTPAuthHelper = this;
            synchronized (hTTPAuthHelper) {
                if (this.destroyed) {
                    throw new Exception("Destroyed");
                }
                HTTPAuthHelper child = (HTTPAuthHelper)this.children.get(child_key);
                if (optional) {
                    String child_dom;
                    String base_host = this.delegate_to.getHost();
                    String child_host = child_url.getHost();
                    int base_pos = base_host.lastIndexOf(46);
                    base_pos = base_host.lastIndexOf(46, base_pos - 1);
                    int child_pos = child_host.lastIndexOf(46);
                    child_pos = child_host.lastIndexOf(46, child_pos - 1);
                    String base_dom = base_host.substring(base_pos, base_host.length());
                    if (base_dom.equals(child_dom = child_host.substring(child_pos, child_host.length()))) {
                        optional = false;
                    }
                }
                if (child == null && !optional) {
                    child = new HTTPAuthHelper(this, new URL(url_str));
                    this.children.put(child_key, child);
                    child.start();
                }
                return child;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSetCookieName(String name, String value) {
        if (this.parent != null) {
            this.parent.addSetCookieName(name, value);
        } else {
            boolean new_entry;
            Map map = this.cookie_names_set;
            synchronized (map) {
                this.trace("SetCookieName: " + name);
                String old_value = this.cookie_names_set.put(name, value);
                new_entry = old_value == null || !old_value.equals(value);
            }
            if (new_entry) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((HTTPAuthHelperListener)it.next()).cookieFound(this, name, value);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSetCookieName(String name) {
        if (this.parent != null) {
            return this.parent.hasSetCookieName(name);
        }
        Map map = this.cookie_names_set;
        synchronized (map) {
            this.trace("GetCookieName: " + name);
            return this.cookie_names_set.containsKey(name);
        }
    }

    public void addListener(HTTPAuthHelperListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList processors_to_destroy;
        ArrayList chidren_to_destroy;
        HTTPAuthHelper hTTPAuthHelper = this;
        synchronized (hTTPAuthHelper) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            chidren_to_destroy = new ArrayList(this.children.values());
            this.children.clear();
            processors_to_destroy = new ArrayList(this.processors);
            this.processors.clear();
            try {
                this.server_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < chidren_to_destroy.size()) {
            try {
                ((HTTPAuthHelper)chidren_to_destroy.get(i)).destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < processors_to_destroy.size()) {
            try {
                ((processor)processors_to_destroy.get(i)).destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
    }

    private void trace(String str) {
    }

    public static void main(String[] args) {
        try {
            HTTPAuthHelper proxy = new HTTPAuthHelper(new URL("https://client.vuze.com/"));
            proxy.start();
            System.out.println("port=" + proxy.getPort());
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private class processor {
        private static final String NL = "\r\n";
        final Socket socket_in;
        private Socket socket_out;
        private volatile boolean destroyed;

        private processor(Socket _socket) {
            this.socket_in = _socket;
        }

        private void start() {
            HTTPAuthHelper.this.thread_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    try {
                        processor.this.sniff();
                    }
                    catch (Throwable throwable) {
                        HTTPAuthHelper hTTPAuthHelper = HTTPAuthHelper.this;
                        synchronized (hTTPAuthHelper) {
                            ((processor)processor.this).HTTPAuthHelper.this.processors.remove(processor.this);
                        }
                        throw throwable;
                    }
                    HTTPAuthHelper hTTPAuthHelper = HTTPAuthHelper.this;
                    synchronized (hTTPAuthHelper) {
                        ((processor)processor.this).HTTPAuthHelper.this.processors.remove(processor.this);
                    }
                }
            });
        }

        private void sniff() {
            try {
                InputStream is = this.socket_in.getInputStream();
                String request_header = this.readHeader(is);
                this.connectToDelegate();
                this.process(request_header);
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    Debug.out(e);
                }
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectToDelegate() throws IOException {
            block31: {
                try {
                    try {
                        if (HTTPAuthHelper.this.delegate_is_https) {
                            TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                            SSLContext sc = SSLContext.getInstance("SSL");
                            sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                            SSLSocketFactory factory = sc.getSocketFactory();
                            try {
                                if (HTTPAuthHelper.this.delegate_to_proxy == null) {
                                    this.socket_out = factory.createSocket();
                                    this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                                    break block31;
                                }
                                Socket plain_socket = new Socket(HTTPAuthHelper.this.delegate_to_proxy);
                                plain_socket.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                                this.socket_out = factory.createSocket(plain_socket, HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port, true);
                            }
                            catch (SSLException ssl_excep) {
                                if (this.socket_out != null) {
                                    try {
                                        this.socket_out.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                factory = SESecurityManager.installServerCertificates("AZ-sniffer:" + HTTPAuthHelper.this.delegate_to_host + ":" + HTTPAuthHelper.this.port, HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port);
                                if (HTTPAuthHelper.this.delegate_to_proxy == null) {
                                    this.socket_out = factory.createSocket();
                                    this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                                    break block31;
                                }
                                Socket plain_socket = new Socket(HTTPAuthHelper.this.delegate_to_proxy);
                                plain_socket.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                                this.socket_out = factory.createSocket(plain_socket, HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port, true);
                            }
                            break block31;
                        }
                        this.socket_out = HTTPAuthHelper.this.delegate_to_proxy == null ? new Socket() : new Socket(HTTPAuthHelper.this.delegate_to_proxy);
                        this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                    }
                    catch (Throwable e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw new IOException(e.toString());
                    }
                }
                catch (Throwable throwable) {
                    if (this.socket_out != null) {
                        processor processor2 = this;
                        synchronized (processor2) {
                            if (this.destroyed) {
                                block33: {
                                    try {
                                        try {
                                            this.socket_out.close();
                                        }
                                        catch (Throwable throwable2) {
                                            this.socket_out = null;
                                            break block33;
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        this.socket_out = null;
                                        throw throwable3;
                                    }
                                    this.socket_out = null;
                                }
                                throw new IOException("destroyed");
                            }
                        }
                    }
                    throw throwable;
                }
            }
            if (this.socket_out != null) {
                processor processor3 = this;
                synchronized (processor3) {
                    if (this.destroyed) {
                        block35: {
                            try {
                                try {
                                    this.socket_out.close();
                                }
                                catch (Throwable throwable) {
                                    this.socket_out = null;
                                    break block35;
                                }
                            }
                            catch (Throwable throwable) {
                                this.socket_out = null;
                                throw throwable;
                            }
                            this.socket_out = null;
                        }
                        throw new IOException("destroyed");
                    }
                }
            }
        }

        private void process(String request_header) throws Exception {
            String name;
            final OutputStream target_os = this.socket_out.getOutputStream();
            String[] request_lines = this.splitHeader(request_header);
            String target_url = request_lines[0];
            int space_pos = target_url.indexOf(32);
            if (space_pos == -1) {
                System.out.println("eh?");
            }
            target_url = target_url.substring(space_pos).trim();
            space_pos = target_url.indexOf(32);
            target_url = target_url.substring(0, space_pos).trim();
            HTTPAuthHelper.this.trace("Page request for " + target_url);
            ArrayList<String> cookies_to_remove = new ArrayList<String>();
            int i = 0;
            while (i < request_lines.length) {
                String line_out = request_lines[i];
                String line_in = line_out.trim().toLowerCase();
                String[] bits = line_in.split(":");
                if (bits.length >= 2) {
                    String lhs = bits[0].trim();
                    if (lhs.equals("host")) {
                        String port_str = HTTPAuthHelper.this.delegate_to_port == 80 || HTTPAuthHelper.this.delegate_to_port == 443 ? "" : ":" + HTTPAuthHelper.this.delegate_to_port;
                        line_out = "Host: " + HTTPAuthHelper.this.delegate_to_host + port_str;
                    } else if (lhs.equals("connection")) {
                        line_out = "Connection: close";
                    } else if (lhs.equals("referer")) {
                        String page = line_out.substring(line_out.indexOf(58) + 1).trim();
                        int pos = (page = page.substring(page.indexOf("://") + 3)).indexOf(47);
                        page = pos >= 0 ? page.substring(pos) : "/";
                        String port_str = HTTPAuthHelper.this.delegate_to_port == 80 || HTTPAuthHelper.this.delegate_to_port == 443 ? "" : ":" + HTTPAuthHelper.this.delegate_to_port;
                        line_out = "Referer: http" + (HTTPAuthHelper.this.delegate_is_https ? "s" : "") + "://" + HTTPAuthHelper.this.delegate_to_host + port_str + page;
                    } else if (lhs.equals("cookie")) {
                        String cookies_str = line_out.substring(line_out.indexOf(58) + 1).trim();
                        String[] cookies = cookies_str.split(";");
                        String cookies_out = "";
                        int j = 0;
                        while (j < cookies.length) {
                            String cookie = cookies[j];
                            name = cookie.split("=")[0].trim();
                            if (HTTPAuthHelper.this.hasSetCookieName(name)) {
                                cookies_out = String.valueOf(cookies_out) + (cookies_out.length() == 0 ? "" : "; ") + cookie;
                            } else {
                                cookies_to_remove.add(name);
                            }
                            ++j;
                        }
                        line_out = cookies_out.length() > 0 ? "Cookie: " + cookies_out : null;
                    }
                }
                if (line_out != null) {
                    HTTPAuthHelper.this.trace("-> " + line_out);
                    target_os.write((String.valueOf(line_out) + NL).getBytes());
                }
                ++i;
            }
            target_os.write(NL.getBytes());
            target_os.flush();
            new AEThread2("HTTPSniffingProxy:proc:2", true){

                @Override
                public void run() {
                    try {
                        InputStream source_is = processor.this.socket_in.getInputStream();
                        byte[] buffer = new byte[32000];
                        while (!processor.this.destroyed) {
                            int len = source_is.read(buffer);
                            if (len > 0) {
                                target_os.write(buffer, 0, len);
                                HTTPAuthHelper.this.trace("POST:" + new String(buffer, 0, len));
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
            InputStream target_is = this.socket_out.getInputStream();
            OutputStream source_os = this.socket_in.getOutputStream();
            String reply_header = this.readHeader(target_is);
            String[] reply_lines = this.splitHeader(reply_header);
            String content_type = null;
            String content_charset = "ISO-8859-1";
            int i2 = 0;
            while (i2 < reply_lines.length) {
                String lhs;
                String line_in = reply_lines[i2].trim().toLowerCase();
                String[] bits = line_in.split(":");
                if (bits.length >= 2 && (lhs = bits[0].trim()).equals("content-type")) {
                    String cc;
                    int pos;
                    String rhs = reply_lines[i2].substring(line_in.indexOf(58) + 1).trim();
                    String[] x = rhs.split(";");
                    content_type = x[0];
                    if (x.length > 1 && (pos = rhs.toLowerCase().indexOf("charset")) >= 0 && (pos = (cc = rhs.substring(pos + 1)).indexOf(61)) != -1 && Charset.isSupported(cc = cc.substring(pos + 1).trim())) {
                        content_charset = cc;
                    }
                }
                ++i2;
            }
            boolean rewrite = false;
            boolean chunked = false;
            String content_encoding = null;
            if (content_type == null) {
                rewrite = true;
            } else if ((content_type = content_type.toLowerCase()).contains("text/")) {
                rewrite = true;
            }
            int i3 = 0;
            while (i3 < reply_lines.length) {
                String line_out = reply_lines[i3];
                String line_in = line_out.trim().toLowerCase();
                String[] bits = line_in.split(":");
                if (bits.length >= 2) {
                    String value;
                    String name2;
                    int pos;
                    String entry;
                    int j;
                    String modified_cookie;
                    String cookie;
                    int c;
                    String cookies_out;
                    String[] cookies;
                    String cookies_in;
                    String lhs = bits[0].trim();
                    if (lhs.equals("set-cookie")) {
                        cookies_in = line_out.substring(line_out.indexOf(58) + 1);
                        cookies = !cookies_in.toLowerCase().contains("expires") ? cookies_in.split(",") : new String[]{cookies_in};
                        cookies_out = "";
                        c = 0;
                        while (c < cookies.length) {
                            cookie = cookies[c];
                            String[] x = cookie.split(";");
                            modified_cookie = "";
                            j = 0;
                            while (j < x.length) {
                                entry = x[j].trim();
                                if (entry.equalsIgnoreCase("httponly")) {
                                    HTTPAuthHelper.this.setHTTPOnlyCookieDetected();
                                } else if (!(entry.equalsIgnoreCase("secure") || entry.toLowerCase().startsWith("domain") || entry.toLowerCase().startsWith("expires"))) {
                                    if (j == 0) {
                                        pos = entry.indexOf(61);
                                        name2 = entry.substring(0, pos).trim();
                                        value = entry.substring(pos + 1).trim();
                                        HTTPAuthHelper.this.addSetCookieName(name2, value);
                                    }
                                    modified_cookie = String.valueOf(modified_cookie) + (modified_cookie.length() == 0 ? "" : "; ") + entry;
                                }
                                ++j;
                            }
                            cookies_out = String.valueOf(cookies_out) + (c == 0 ? "" : ", ") + modified_cookie;
                            ++c;
                        }
                        line_out = "Set-Cookie: " + cookies_out;
                    } else if (lhs.equals("set-cookie2")) {
                        cookies_in = line_out.substring(line_out.indexOf(58) + 1);
                        cookies = cookies_in.split(",");
                        cookies_out = "";
                        c = 0;
                        while (c < cookies.length) {
                            cookie = cookies[c];
                            String[] x = cookie.split(";");
                            modified_cookie = "";
                            j = 0;
                            while (j < x.length) {
                                entry = x[j].trim();
                                if (!(entry.equalsIgnoreCase("secure") || entry.equalsIgnoreCase("discard") || entry.toLowerCase().startsWith("domain") || entry.toLowerCase().startsWith("port"))) {
                                    if (j == 0) {
                                        pos = entry.indexOf(61);
                                        name2 = entry.substring(0, pos).trim();
                                        value = entry.substring(pos + 1).trim();
                                        HTTPAuthHelper.this.addSetCookieName(name2, value);
                                    }
                                    modified_cookie = String.valueOf(modified_cookie) + (modified_cookie.length() == 0 ? "" : "; ") + entry;
                                }
                                ++j;
                            }
                            cookies_out = String.valueOf(cookies_out) + (c == 0 ? "" : ", ") + modified_cookie + "; Discard";
                            ++c;
                        }
                        line_out = "Set-Cookie2: " + cookies_out;
                    } else if (lhs.equals("connection")) {
                        line_out = "Connection: close";
                    } else if (lhs.equals("location")) {
                        String page = line_out.substring(line_out.indexOf(58) + 1).trim();
                        String child_url = page.trim();
                        HTTPAuthHelper child = HTTPAuthHelper.this.getChild(child_url, false);
                        int pos2 = page.indexOf("://");
                        if (pos2 >= 0) {
                            page = (pos2 = (page = page.substring(pos2 + 3)).indexOf(47)) >= 0 ? page.substring(pos2) : "/";
                        } else if (!page.startsWith("/")) {
                            String temp = target_url;
                            int marker = temp.indexOf("://");
                            if (marker != -1) {
                                temp = (marker = (temp = temp.substring(marker + 3)).indexOf("/")) == -1 ? "/" : temp.substring(marker);
                            } else if (!temp.startsWith("/")) {
                                temp = "/" + temp;
                            }
                            marker = temp.lastIndexOf("/");
                            if (marker >= 0) {
                                temp = temp.substring(0, marker + 1);
                            }
                            page = String.valueOf(temp) + page;
                        }
                        line_out = "Location: http://127.0.0.1:" + child.getPort() + page;
                    } else if (lhs.equals("content-encoding")) {
                        String encoding;
                        if (rewrite && ((encoding = bits[1].trim()).equalsIgnoreCase("gzip") || encoding.equalsIgnoreCase("deflate"))) {
                            content_encoding = encoding;
                            line_out = null;
                        }
                    } else if (lhs.equals("content-length")) {
                        if (rewrite) {
                            line_out = null;
                        }
                    } else if (lhs.equals("transfer-encoding") && bits[1].contains("chunked")) {
                        chunked = true;
                        if (rewrite) {
                            line_out = null;
                        }
                    }
                }
                if (line_out != null) {
                    HTTPAuthHelper.this.trace("<- " + line_out);
                    source_os.write((String.valueOf(line_out) + NL).getBytes());
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < cookies_to_remove.size()) {
                name = (String)cookies_to_remove.get(i3);
                if (!HTTPAuthHelper.this.hasSetCookieName(name)) {
                    String remove_str = "Set-Cookie: " + name + "=X; expires=Sun, 01 Jan 2000 01:00:00 GMT";
                    HTTPAuthHelper.this.trace("<- (cookie removal) " + remove_str);
                    source_os.write((String.valueOf(remove_str) + NL).getBytes());
                    remove_str = "Set-Cookie2: " + name + "=X; Max-Age=0; Version=1";
                    HTTPAuthHelper.this.trace("<- (cookie removal) " + remove_str);
                    source_os.write((String.valueOf(remove_str) + NL).getBytes());
                }
                ++i3;
            }
            byte[] buffer = new byte[32000];
            if (rewrite) {
                StringBuffer sb = new StringBuffer();
                if (chunked) {
                    int len;
                    while ((len = target_is.read(buffer)) > 0) {
                        sb.append(new String(buffer, 0, len, "ISO-8859-1"));
                    }
                    StringBuilder sb_dechunked = new StringBuilder(sb.length());
                    String chunk = "";
                    int total_length = 0;
                    int sb_pos = 0;
                    while (sb_pos < sb.length()) {
                        int chunk_length;
                        if (!(chunk = String.valueOf(chunk) + sb.charAt(sb_pos++)).endsWith(NL) || chunk.length() <= 2) continue;
                        int semi_pos = chunk.indexOf(59);
                        if (semi_pos != -1) {
                            chunk = chunk.substring(0, semi_pos);
                        }
                        if ((chunk_length = Integer.parseInt(chunk = chunk.trim(), 16)) <= 0) break;
                        if ((total_length += chunk_length) > 0x200000) {
                            throw new IOException("Chunk size " + chunk_length + " too large");
                        }
                        char[] chunk_buffer = new char[chunk_length];
                        sb.getChars(sb_pos, sb_pos + chunk_length, chunk_buffer, 0);
                        sb_dechunked.append(chunk_buffer);
                        sb_pos += chunk_length;
                        chunk = "";
                    }
                    target_is = new ByteArrayInputStream(sb_dechunked.toString().getBytes("ISO-8859-1"));
                }
                if (content_encoding != null) {
                    if (content_encoding.equalsIgnoreCase("gzip")) {
                        target_is = new GZIPInputStream(target_is);
                    } else if (content_encoding.equalsIgnoreCase("deflate")) {
                        target_is = new InflaterInputStream(target_is);
                    }
                }
                sb.setLength(0);
                while (!this.destroyed) {
                    int len = target_is.read(buffer);
                    if (len <= 0) break;
                    sb.append(new String(buffer, 0, len, content_charset));
                }
                String str = sb.toString();
                String lc_str = str.toLowerCase();
                StringBuffer result = null;
                int str_pos = 0;
                while (true) {
                    int url_start;
                    int n = url_start = str.length() - str_pos >= 10 ? lc_str.indexOf("http", str_pos) : -1;
                    if (url_start == -1) break;
                    int match_pos = lc_str.charAt(url_start + 4) == 's' ? url_start + 5 : url_start + 4;
                    if (lc_str.substring(match_pos, match_pos + 3).equals("://")) {
                        int url_end = -1;
                        int i4 = match_pos + 3;
                        while (true) {
                            char c;
                            if ((c = lc_str.charAt(i4)) == '/') {
                                url_end = i4 + 1;
                                break;
                            }
                            if (!(c == '.' || c == '-' || c == ':' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z')) {
                                url_end = i4;
                                break;
                            }
                            if (i4 == lc_str.length() - 1) {
                                url_end = i4;
                            }
                            ++i4;
                        }
                        if (url_end <= url_start) break;
                        String url_str = str.substring(url_start, url_end);
                        boolean appended = false;
                        try {
                            URL url = new URL(url_str);
                            if (url.getHost().length() > 0) {
                                boolean existing_only = true;
                                int i5 = url_start - 1;
                                while (i5 >= 0 && url_start - i5 < 512) {
                                    if (lc_str.charAt(i5) == '<') {
                                        String prefix = lc_str.substring(i5, url_start);
                                        if (prefix.contains("form")) {
                                            existing_only = false;
                                            break;
                                        }
                                        if (!prefix.contains("meta") || !prefix.contains("http-equiv")) break;
                                        existing_only = false;
                                        break;
                                    }
                                    --i5;
                                }
                                HTTPAuthHelper child = HTTPAuthHelper.this.getChild(url_str, existing_only);
                                if (child != null) {
                                    String replacement = "http://127.0.0.1:" + child.getPort();
                                    if (url_str.endsWith("/")) {
                                        replacement = String.valueOf(replacement) + "/";
                                    }
                                    if (result == null) {
                                        result = new StringBuffer(str.length());
                                        if (url_start > 0) {
                                            result.append(str.subSequence(0, url_start));
                                        }
                                    } else if (url_start > str_pos) {
                                        result.append(str.subSequence(str_pos, url_start));
                                    }
                                    HTTPAuthHelper.this.trace("Replacing " + url_str + " with " + replacement);
                                    result.append(replacement);
                                    appended = true;
                                } else {
                                    HTTPAuthHelper.this.trace("    No child for " + url_str);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (result != null && !appended) {
                            result.append(str.subSequence(str_pos, url_end));
                        }
                        str_pos = url_end;
                        continue;
                    }
                    if (result != null) {
                        result.append(str.subSequence(str_pos, match_pos));
                    }
                    str_pos = match_pos;
                }
                if (result != null) {
                    if (str_pos < str.length()) {
                        result.append(str.subSequence(str_pos, str.length()));
                    }
                    sb = result;
                }
                source_os.write(("Content-Length: " + sb.length() + NL).getBytes());
                source_os.write(NL.getBytes());
                source_os.write(sb.toString().getBytes(content_charset));
            } else {
                source_os.write(NL.getBytes());
                while (!this.destroyed) {
                    int len = target_is.read(buffer);
                    if (len <= 0) break;
                    source_os.write(buffer, 0, len);
                }
            }
        }

        private String readHeader(InputStream is) throws IOException {
            String header = "";
            byte[] buffer = new byte[1];
            boolean found = false;
            while (is.read(buffer) == 1) {
                if (!(header = String.valueOf(header) + (char)buffer[0]).endsWith("\r\n\r\n")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("End of stream reading header");
            }
            return header;
        }

        private String[] splitHeader(String str) {
            String[] bits = str.split(NL);
            return bits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            processor processor2 = this;
            synchronized (processor2) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
            }
            if (this.socket_out != null) {
                try {
                    this.socket_out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.socket_in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

