/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class PlatformTorrentUtils {
    private static final String TOR_AZ_PROP_MAP = "Content";
    private static final String TOR_AZ_PROP_CVERSION = "_Version_";
    private static final String TOR_AZ_PROP_TITLE = "Title";
    private static final String TOR_AZ_PROP_DESCRIPTION = "Description";
    private static final String TOR_AZ_PROP_PRIMARY_FILE = "Primary File Index";
    private static final String TOR_AZ_PROP_THUMBNAIL = "Thumbnail";
    private static final String TOR_AZ_PROP_THUMBNAIL_TYPE = "Thumbnail.type";
    private static final String TOR_AZ_PROP_THUMBNAIL_URL = "Thumbnail.url";

    public static Map getContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("azureus_properties");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    static Map getTempContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return new HashMap();
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("attributes");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("attributes", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    public static String getContentMapString(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void setContentMapString(TOTorrent torrent, String key, String value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
        PlatformTorrentUtils.incVersion(mapContent);
    }

    private static long getContentMapLong(TOTorrent torrent, String key, long def) {
        if (torrent == null) {
            return def;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            if (obj instanceof byte[]) {
                return Long.parseLong(new String((byte[])obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public static Map getContentMapMap(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private static void setContentMapLong(TOTorrent torrent, String key, long value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, new Long(value));
        PlatformTorrentUtils.incVersion(mapContent);
    }

    public static void setContentMapMap(TOTorrent torrent, String key, Map value) {
        if (torrent == null) {
            return;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        mapContent.put(key, value);
        PlatformTorrentUtils.incVersion(mapContent);
    }

    private static void putOrRemove(Map map, String key, Object obj) {
        if (obj == null) {
            map.remove(key);
        } else {
            map.put(key, obj);
        }
    }

    private static void writeTorrentIfExists(TOTorrent torrent) {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (core == null || !core.isStarted()) {
            return;
        }
        GlobalManager gm = core.getGlobalManager();
        if (gm == null || gm.getDownloadManager(torrent) == null) {
            return;
        }
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    private static void incVersion(Map mapContent) {
        Long v = (Long)mapContent.get(TOR_AZ_PROP_CVERSION);
        mapContent.put(TOR_AZ_PROP_CVERSION, v == null ? 0L : v + 1L);
    }

    public static int getContentVersion(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Long v = (Long)mapContent.get(TOR_AZ_PROP_CVERSION);
        return v == null ? 0 : v.intValue();
    }

    public static String getContentTitle(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_TITLE);
    }

    public static void setContentTitle(TOTorrent torrent, String title) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_TITLE, title);
    }

    public static byte[] getContentThumbnail(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(TOR_AZ_PROP_THUMBNAIL);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public static String getContentDescription(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION);
    }

    public static void setContentDescription(TOTorrent torrent, String desc) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION, desc);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static String getContentThumbnailUrl(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_URL);
    }

    public static void setContentThumbnailUrl(TOTorrent torrent, String url) {
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_URL, url);
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        PlatformTorrentUtils.incVersion(mapContent);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail, String type) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        PlatformTorrentUtils.incVersion(mapContent);
        PlatformTorrentUtils.setContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_TYPE, type);
        PlatformTorrentUtils.writeTorrentIfExists(torrent);
    }

    public static String getContentThumbnailType(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_THUMBNAIL_TYPE);
    }

    public static int getContentPrimaryFileIndex(TOTorrent torrent) {
        return (int)PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PRIMARY_FILE, -1L);
    }

    public static void setContentPrimaryFileIndex(TOTorrent torrent, int index) {
        PlatformTorrentUtils.setContentMapLong(torrent, TOR_AZ_PROP_PRIMARY_FILE, index);
    }
}

