/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class AEProxyAddressMapperImpl
implements AEProxyAddressMapper {
    protected static final AEProxyAddressMapper singleton = new AEProxyAddressMapperImpl();
    protected boolean enabled;
    protected String prefix;
    protected long next_value;
    protected final Map<String, String> map = new HashMap<String, String>();
    protected final Map<String, String> reverse_map = new HashMap<String, String>();
    protected final AEMonitor this_mon = new AEMonitor("AEProxyAddressMapper");
    final Map<Integer, PortMappingImpl> port_mappings = new HashMap<Integer, PortMappingImpl>();

    public static AEProxyAddressMapper getSingleton() {
        return singleton;
    }

    protected AEProxyAddressMapperImpl() {
        if (COConfigurationManager.getBooleanParameter("Enable.Proxy") && COConfigurationManager.getBooleanParameter("Enable.SOCKS")) {
            String host = COConfigurationManager.getStringParameter("Proxy.Host");
            try {
                if (host.length() > 0 && InetAddress.getByName(host).isLoopbackAddress()) {
                    this.enabled = true;
                    byte[] b = new byte[120];
                    int i = 0;
                    while (i < b.length) {
                        b[i] = (byte)RandomUtils.nextInt(256);
                        ++i;
                    }
                    this.prefix = ByteFormatter.encodeString(b);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public String internalise(String address) {
        String target;
        if (!this.enabled) {
            return address;
        }
        if (address.length() < 256) {
            return address;
        }
        try {
            this.this_mon.enter();
            target = this.reverse_map.get(address);
            if (target == null) {
                StringBuilder target_b = new StringBuilder(256);
                target_b.append(this.prefix);
                target_b.append(this.next_value++);
                while (target_b.length() < 255) {
                    target_b.append("0");
                }
                target = target_b.toString();
                this.map.put(target, address);
                this.reverse_map.put(address, target);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return target;
    }

    @Override
    public String externalise(String address) {
        if (!this.enabled || address.length() < 255) {
            return address;
        }
        String target = this.map.get(address);
        if (target == null) {
            target = address;
        }
        return target;
    }

    @Override
    public URL internalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 256) {
            return url;
        }
        String new_host = this.internalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }

    @Override
    public URL externalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 255) {
            return url;
        }
        String new_host = this.externalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.PortMapping registerPortMapping(int local_port, String ip) {
        PortMappingImpl mapping = new PortMappingImpl(ip, local_port, null);
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            this.port_mappings.put(local_port, mapping);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.PortMapping registerPortMapping(int local_port, String ip, Map<String, Object> properties) {
        PortMappingImpl mapping = new PortMappingImpl(ip, local_port, properties);
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            this.port_mappings.put(local_port, mapping);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AEProxyAddressMapper.AppliedPortMapping applyPortMapping(InetAddress address, int port) {
        InetSocketAddress result;
        PortMappingImpl mapping;
        Map<Integer, PortMappingImpl> map = this.port_mappings;
        synchronized (map) {
            mapping = this.port_mappings.get(port);
        }
        if (mapping == null) {
            result = new InetSocketAddress(address, port);
        } else {
            String ip;
            InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (bind_ip == null || bind_ip.isAnyLocalAddress()) {
                bind_ip = null;
            }
            result = bind_ip == null && address.isLoopbackAddress() || bind_ip != null && bind_ip.equals(address) ? (AENetworkClassifier.categoriseAddress(ip = mapping.getIP()) == "Public" ? new InetSocketAddress(ip, port) : InetSocketAddress.createUnresolved(ip, 6881)) : new InetSocketAddress(address, port);
        }
        return new AppliedPortMappingImpl(result, mapping == null ? null : mapping.getProperties());
    }

    private static class AppliedPortMappingImpl
    implements AEProxyAddressMapper.AppliedPortMapping {
        private final InetSocketAddress address;
        private final Map<String, Object> properties;

        private AppliedPortMappingImpl(InetSocketAddress _address, Map<String, Object> _properties) {
            this.address = _address;
            this.properties = _properties;
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.address;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    private class PortMappingImpl
    implements AEProxyAddressMapper.PortMapping {
        private final String ip;
        private final int port;
        private final Map<String, Object> properties;

        private PortMappingImpl(String _ip, int _port, Map<String, Object> _properties) {
            this.ip = _ip;
            this.port = _port;
            this.properties = _properties;
        }

        private String getIP() {
            return this.ip;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister() {
            Map<Integer, PortMappingImpl> map = AEProxyAddressMapperImpl.this.port_mappings;
            synchronized (map) {
                AEProxyAddressMapperImpl.this.port_mappings.remove(this.port);
            }
        }
    }
}

