/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy;

import com.aelitis.azureus.core.proxy.AEProxy;
import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEPluginProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEProxyAddressMapperImpl;
import com.aelitis.azureus.core.proxy.impl.AEProxyImpl;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;

public class AEProxyFactory {
    public static final String PO_PEER_NETWORKS = "peer_networks";
    public static final String SP_HOST = "host";
    public static final String SP_PORT = "port";
    public static final String DP_DOWNLOAD = "download";
    public static final String DP_NETWORKS = "networks";

    public static AEProxy create(int port, long connect_timeout, long read_timeout, AEProxyHandler state_factory) throws AEProxyException {
        return new AEProxyImpl(port, connect_timeout, read_timeout, state_factory);
    }

    public static AEProxyAddressMapper getAddressMapper() {
        return AEProxyAddressMapperImpl.getSingleton();
    }

    public static PluginProxy getPluginProxy(String reason, URL target) {
        return AEProxyFactory.getPluginProxy(reason, target, false);
    }

    public static PluginProxy getPluginProxy(String reason, URL target, boolean can_wait) {
        return AEProxyFactory.getPluginProxy(reason, target, null, can_wait);
    }

    public static PluginProxy getPluginProxy(String reason, URL target, Map<String, Object> proxy_options, boolean can_wait) {
        return AEPluginProxyHandler.getPluginProxy(reason, target, proxy_options, can_wait);
    }

    public static PluginProxy getPluginProxy(String reason, String host, int port) {
        return AEProxyFactory.getPluginProxy(reason, host, port, null);
    }

    public static PluginProxy getPluginProxy(String reason, String host, int port, Map<String, Object> proxy_options) {
        return AEPluginProxyHandler.getPluginProxy(reason, host, port, proxy_options);
    }

    public static PluginProxy getPluginProxy(Proxy proxy) {
        return AEPluginProxyHandler.getPluginProxy(proxy);
    }

    public static boolean isPluginProxy(SocketAddress address) {
        return AEPluginProxyHandler.isPluginProxy(address);
    }

    public static Boolean testPluginHTTPProxy(URL target, boolean can_wait) {
        return AEPluginProxyHandler.testPluginHTTPProxy(target, can_wait);
    }

    public static PluginHTTPProxy getPluginHTTPProxy(String reason, URL target, boolean can_wait) {
        return AEPluginProxyHandler.getPluginHTTPProxy(reason, target, can_wait);
    }

    public static List<PluginInterface> getPluginHTTPProxyProviders(boolean can_wait) {
        return AEPluginProxyHandler.getPluginHTTPProxyProviders(can_wait);
    }

    public static boolean hasPluginProxy() {
        return AEPluginProxyHandler.hasPluginProxy();
    }

    public static Map<String, Object> getPluginServerProxy(String reason, String network, String server_uid, Map<String, Object> options) {
        return AEPluginProxyHandler.getPluginServerProxy(reason, network, server_uid, options);
    }

    public static DHTPluginInterface getPluginDHTProxy(String reason, String network, Map<String, Object> options) {
        return AEPluginProxyHandler.getPluginDHTProxy(reason, network, options);
    }

    public static interface PluginHTTPProxy {
        public Proxy getProxy();

        public String proxifyURL(String var1);

        public void destroy();
    }

    public static interface PluginProxy {
        public String getTarget();

        public PluginProxy getChildProxy(String var1, URL var2);

        public Proxy getProxy();

        public URL getURL();

        public String getURLHostRewrite();

        public String getHost();

        public int getPort();

        public void setOK(boolean var1);
    }

    public static class UnknownHostException
    extends RuntimeException {
        public UnknownHostException(String host) {
            super(host);
        }
    }
}

