/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class MessageManager {
    private static final MessageManager instance = new MessageManager();
    private final ByteArrayHashMap message_map = new ByteArrayHashMap();
    private final List messages = new ArrayList();
    protected final AEMonitor this_mon = new AEMonitor("MessageManager");

    private MessageManager() {
    }

    public static MessageManager getSingleton() {
        return instance;
    }

    public void initialize() {
        AZMessageFactory.init();
        BTMessageFactory.init();
        LTMessageFactory.init();
    }

    public void registerMessageType(Message message) throws MessageException {
        try {
            this.this_mon.enter();
            byte[] id_bytes = message.getIDBytes();
            if (this.message_map.containsKey(id_bytes)) {
                throw new MessageException("message type [" + message.getID() + "] already registered!");
            }
            this.message_map.put(id_bytes, message);
            this.messages.add(message);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void deregisterMessageType(Message message) {
        try {
            this.this_mon.enter();
            this.message_map.remove(message.getIDBytes());
            this.messages.remove(message);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Message createMessage(byte[] id_bytes, DirectByteBuffer message_data, byte version) throws MessageException {
        Message message = (Message)this.message_map.get(id_bytes);
        if (message == null) {
            throw new MessageException("message id[" + new String(id_bytes) + "] not registered");
        }
        return message.deserialize(message_data, version);
    }

    public Message lookupMessage(String id) {
        return (Message)this.message_map.get(id.getBytes());
    }

    public Message lookupMessage(byte[] id_bytes) {
        return (Message)this.message_map.get(id_bytes);
    }

    public Message[] getRegisteredMessages() {
        return this.messages.toArray(new Message[this.messages.size()]);
    }
}

