/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnection;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPSelector;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.Debug;

public class UTPTransportHelper
implements TransportHelper {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final int READ_TIMEOUT = 30000;
    public static final int CONNECT_TIMEOUT = 20000;
    private UTPConnectionManager manager;
    private UTPSelector selector;
    private InetSocketAddress address;
    private UTPTransport transport;
    private boolean incoming;
    private UTPConnection connection;
    private TransportHelper.selectListener read_listener;
    private Object read_attachment;
    private boolean read_selects_paused;
    private TransportHelper.selectListener write_listener;
    private Object write_attachment;
    private boolean write_selects_paused = true;
    private boolean connected;
    private boolean closed;
    private IOException failed;
    private ByteBuffer[] pending_partial_writes;
    private Map<Object, Object> user_data;

    public UTPTransportHelper(UTPConnectionManager _manager, InetSocketAddress _address, UTPTransport _transport) throws IOException {
        this.manager = _manager;
        this.address = _address;
        this.transport = _transport;
        this.incoming = false;
        this.connection = this.manager.connect(this.address, this);
        this.selector = this.connection.getSelector();
    }

    public UTPTransportHelper(UTPConnectionManager _manager, InetSocketAddress _address, UTPConnection _connection) {
        this.manager = _manager;
        this.address = _address;
        this.connection = _connection;
        this.connected = true;
        this.incoming = true;
        this.selector = this.connection.getSelector();
    }

    protected void setTransport(UTPTransport _transport) {
        this.transport = _transport;
    }

    protected UTPTransport getTransport() {
        return this.transport;
    }

    protected int getMss() {
        if (this.transport == null) {
            return UTPNetworkManager.getUdpMssSize();
        }
        return this.transport.getMssSize();
    }

    @Override
    public boolean minimiseOverheads() {
        return false;
    }

    @Override
    public int getConnectTimeout() {
        return 20000;
    }

    @Override
    public int getReadTimeout() {
        return 30000;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public String getName(boolean verbose) {
        return "uTP";
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    protected UTPConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnected() {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            if (this.connected) {
                return;
            }
            this.connected = true;
        }
        this.transport.connected();
    }

    @Override
    public boolean delayWrite(ByteBuffer buffer) {
        if (this.pending_partial_writes == null) {
            this.pending_partial_writes = new ByteBuffer[]{buffer};
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDelayedWrite() {
        return this.pending_partial_writes != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer buffer, boolean partial_write) throws IOException {
        block15: {
            var3_3 = this;
            synchronized (var3_3) {
                if (this.failed != null) {
                    throw this.failed;
                }
                if (this.closed) {
                    throw new IOException("Transport closed");
                }
            }
            buffer_rem = buffer.remaining();
            if (!partial_write || buffer_rem >= 128) break block15;
            if (this.pending_partial_writes == null) {
                this.pending_partial_writes = new ByteBuffer[1];
                copy = ByteBuffer.allocate(buffer_rem);
                copy.put(buffer);
                copy.position(0);
                this.pending_partial_writes[0] = copy;
                return buffer_rem;
            }
            queued = 0;
            i = 0;
            while (i < this.pending_partial_writes.length) {
                queued += this.pending_partial_writes[i].remaining();
                ++i;
            }
            if (queued + buffer_rem > 512) break block15;
            new_ppw = new ByteBuffer[this.pending_partial_writes.length + 1];
            i = 0;
            if (true) ** GOTO lbl43
        }
        if (this.pending_partial_writes == null) {
            return this.connection.write(new ByteBuffer[]{buffer}, 0, 1);
        }
        ppw_len = this.pending_partial_writes.length;
        ppw_rem = 0;
        buffers2 = new ByteBuffer[ppw_len + 1];
        i = 0;
        if (true) ** GOTO lbl56
        do {
            new_ppw[i] = this.pending_partial_writes[i];
            ++i;
lbl43:
            // 2 sources

        } while (i < this.pending_partial_writes.length);
        copy = ByteBuffer.allocate(buffer_rem);
        copy.put(buffer);
        copy.position(0);
        new_ppw[this.pending_partial_writes.length] = copy;
        this.pending_partial_writes = new_ppw;
        return buffer_rem;
        do {
            buffers2[i] = this.pending_partial_writes[i];
            ppw_rem += buffers2[i].remaining();
            ++i;
lbl56:
            // 2 sources

        } while (i < ppw_len);
        buffers2[ppw_len] = buffer;
        try {
            written = this.connection.write(buffers2, 0, buffers2.length);
            if (written >= ppw_rem) {
                var9_13 = written - ppw_rem;
                return var9_13;
            }
        }
        finally {
            ppw_rem = 0;
            i = 0;
            ** while (i < ppw_len)
        }
lbl-1000:
        // 1 sources

        {
            ppw_rem += buffers2[i].remaining();
            ++i;
            continue;
        }
lbl71:
        // 1 sources

        if (ppw_rem != 0) return var9_13;
        this.pending_partial_writes = null;
        return var9_13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        var4_4 = this;
        synchronized (var4_4) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        if (this.pending_partial_writes == null) return this.connection.write(buffers, array_offset, length);
        ppw_len = this.pending_partial_writes.length;
        ppw_rem = 0;
        buffers2 = new ByteBuffer[length + ppw_len];
        i = 0;
        while (i < ppw_len) {
            buffers2[i] = this.pending_partial_writes[i];
            ppw_rem += buffers2[i].remaining();
            ++i;
        }
        pos = ppw_len;
        i = array_offset;
        while (i < array_offset + length) {
            buffers2[pos++] = buffers[i];
            ++i;
        }
        try {
            written = this.connection.write(buffers2, 0, buffers2.length);
            if (written >= ppw_rem) {
                var10_10 = written - ppw_rem;
                return var10_10;
            }
        }
        finally {
            ppw_rem = 0;
            i = 0;
            ** while (i < ppw_len)
        }
lbl-1000:
        // 1 sources

        {
            ppw_rem += buffers2[i].remaining();
            ++i;
            continue;
        }
lbl40:
        // 1 sources

        if (ppw_rem != 0) return var10_10;
        this.pending_partial_writes = null;
        return var10_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buffer) throws IOException {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        return this.connection.read(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        long total = 0L;
        int i = array_offset;
        while (i < array_offset + length) {
            ByteBuffer buffer = buffers[i];
            int max = buffer.remaining();
            int read = this.connection.read(buffer);
            total += (long)read;
            if (read < max) break;
            ++i;
        }
        return total;
    }

    protected void canRead() {
        this.fireReadSelect();
    }

    protected void canWrite() {
        this.fireWriteSelect();
    }

    @Override
    public synchronized void pauseReadSelects() {
        if (this.read_listener != null) {
            this.selector.cancel(this, this.read_listener);
        }
        this.read_selects_paused = true;
    }

    @Override
    public synchronized void pauseWriteSelects() {
        if (this.write_listener != null) {
            this.selector.cancel(this, this.write_listener);
        }
        this.write_selects_paused = true;
    }

    @Override
    public synchronized void resumeReadSelects() {
        this.read_selects_paused = false;
        this.fireReadSelect();
    }

    @Override
    public synchronized void resumeWriteSelects() {
        this.write_selects_paused = false;
        this.fireWriteSelect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForReadSelects(TransportHelper.selectListener listener, Object attachment) {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            this.read_listener = listener;
            this.read_attachment = attachment;
        }
        this.resumeReadSelects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForWriteSelects(TransportHelper.selectListener listener, Object attachment) {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            this.write_listener = listener;
            this.write_attachment = attachment;
        }
        this.resumeWriteSelects();
    }

    @Override
    public synchronized void cancelReadSelects() {
        this.selector.cancel(this, this.read_listener);
        this.read_selects_paused = true;
        this.read_listener = null;
        this.read_attachment = null;
    }

    @Override
    public synchronized void cancelWriteSelects() {
        this.selector.cancel(this, this.write_listener);
        this.write_selects_paused = true;
        this.write_listener = null;
        this.write_attachment = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireReadSelect() {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            if (this.read_listener != null && !this.read_selects_paused) {
                if (this.failed != null) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, this.failed);
                } else if (this.closed) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canRead()) {
                    this.selector.ready(this, this.read_listener, this.read_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWriteSelect() {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            if (this.write_listener != null && !this.write_selects_paused) {
                if (this.failed != null) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, this.failed);
                } else if (this.closed) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canWrite()) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment);
                }
            }
        }
    }

    @Override
    public void failed(Throwable reason) {
        this.close(Debug.getNestedExceptionMessage(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String reason) {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            this.closed = true;
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        if (this.transport != null) {
            this.transport.closed();
        }
        if (this.connection != null) {
            this.connection.closeSupport(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        UTPTransportHelper uTPTransportHelper = this;
        synchronized (uTPTransportHelper) {
            this.fireReadSelect();
            this.fireWriteSelect();
        }
    }

    @Override
    public synchronized void setUserData(Object key, Object data) {
        if (this.user_data == null) {
            this.user_data = new HashMap<Object, Object>();
        }
        this.user_data.put(key, data);
    }

    @Override
    public synchronized Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(key);
    }

    @Override
    public void setTrace(boolean on) {
    }

    @Override
    public void setScatteringMode(long forBytes) {
    }
}

