/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;

public class UDPPacket {
    public static final byte PROTOCOL_VERSION = 1;
    public static final byte COMMAND_CRYPTO = 0;
    public static final byte COMMAND_DATA = 1;
    public static final byte COMMAND_ACK = 2;
    public static final byte COMMAND_CLOSE = 3;
    public static final byte COMMAND_STAT_REQUEST = 4;
    public static final byte COMMAND_STAT_REPLY = 5;
    public static final byte FLAG_NONE = 0;
    public static final byte FLAG_LAZY_ACK = 1;
    private final UDPConnection connection;
    private final int sequence;
    private final int alt_sequence;
    private final byte command;
    private final byte[] buffer;
    private final long unack_in_sequence_count;
    private boolean auto_retransmit = true;
    private short sent_count;
    private short resend_count;
    private boolean received;
    private long send_tick_count;

    protected UDPPacket(UDPConnection _connection, int[] _sequences, byte _command, byte[] _buffer, long _unack_in_sequence_count) {
        this.connection = _connection;
        this.sequence = _sequences[1];
        this.alt_sequence = _sequences[3];
        this.command = _command;
        this.buffer = _buffer;
        this.unack_in_sequence_count = _unack_in_sequence_count;
    }

    protected UDPConnection getConnection() {
        return this.connection;
    }

    protected int getSequence() {
        return this.sequence;
    }

    protected int getAlternativeSequence() {
        return this.alt_sequence;
    }

    protected byte getCommand() {
        return this.command;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    protected long getUnAckInSequenceCount() {
        return this.unack_in_sequence_count;
    }

    protected boolean isAutoRetransmit() {
        return this.auto_retransmit;
    }

    protected void setAutoRetransmit(boolean b) {
        this.auto_retransmit = b;
    }

    protected short sent(long tick_count) {
        this.sent_count = (short)(this.sent_count + 1);
        this.send_tick_count = tick_count;
        return this.sent_count;
    }

    protected short getResendCount() {
        return this.resend_count;
    }

    protected void resent() {
        this.resend_count = (short)(this.resend_count + 1);
    }

    protected long getSendTickCount() {
        return this.send_tick_count;
    }

    protected void setHasBeenReceived() {
        this.received = true;
    }

    protected boolean hasBeenReceived() {
        return this.received;
    }

    protected int getSentCount() {
        return this.sent_count;
    }

    protected String getString() {
        return "seq=" + this.sequence + ",type=" + this.command + ",retrans=" + this.auto_retransmit + ",sent=" + this.sent_count + ",len=" + this.buffer.length;
    }
}

