/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPPacket;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.bouncycastle.crypto.engines.RC4Engine;
import org.gudy.bouncycastle.crypto.params.KeyParameter;

public class UDPConnectionSet {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean DEBUG_SEQUENCES = false;
    private static final byte[] KEYA_IV = "UDPDriverKeyA".getBytes();
    private static final byte[] KEYB_IV = "UDPDriverKeyB".getBytes();
    private static final byte[] KEYC_IV = "UDPDriverKeyC".getBytes();
    private static final byte[] KEYD_IV = "UDPDriverKeyD".getBytes();
    private static final int MIN_MSS = 256;
    private static final int MAX_HEADER = 128;
    public static final int MIN_WRITE_PAYLOAD = 128;
    public static final int MAX_BUFFERED_PAYLOAD = 512;
    private final UDPConnectionManager manager;
    private final UDPSelector selector;
    private final int local_port;
    private final InetSocketAddress remote_address;
    private boolean outgoing;
    private final String connection_key;
    private Random random;
    private UDPConnection lead_connection;
    private RC4Engine header_cipher_out;
    private RC4Engine header_cipher_in;
    private SequenceGenerator in_seq_generator;
    private SequenceGenerator out_seq_generator;
    private volatile boolean crypto_done;
    private volatile boolean failed;
    private final Map connections = new HashMap();
    private final LinkedList connection_writers = new LinkedList();
    private long total_tick_count;
    private static final int STATS_LOG_TIMER = 60000;
    private static final int STATS_LOG_TICKS = Math.max(1, 2400);
    private int stats_log_ticks = STATS_LOG_TICKS;
    private static final int IDLE_TIMER = 10000;
    private static final int IDLE_TICKS = Math.max(1, 400);
    private int idle_ticks = 0;
    private static final int TIMER_BASE_DEFAULT = 300;
    private static final int TIMER_BASE_MIN = 100;
    private static final int TIMER_BASE_MAX = 15000;
    private int current_timer_base;
    private int old_timer_base = this.current_timer_base = 300;
    private boolean timer_is_adjusting;
    private int stats_packets_unique_sent;
    private int stats_packets_resent_via_timer;
    private int stats_packets_unique_received;
    private int stats_packets_duplicates;
    private static final int STATS_RESET_TIMER = 30000;
    private long stats_reset_time = SystemTime.getCurrentTime();
    private int total_packets_sent = 0;
    private int total_data_sent = 0;
    private int total_data_resent = 0;
    private int total_protocol_sent = 0;
    private int total_protocol_resent = 0;
    private int total_packets_unique_sent = 0;
    private int total_packets_received = 0;
    private int total_packets_unique_received = 0;
    private int total_packets_duplicates = 0;
    private int total_packets_out_of_order = 0;
    private int total_packets_resent_via_timer = 0;
    private int total_packets_resent_via_ack = 0;
    private int retransmit_ticks = 0;
    private UDPPacket current_retransmit_target;
    private static final int RETRANSMIT_COUNT_LIMIT = 5;
    private static final int MIN_RETRANSMIT_TIMER = 100;
    private static final int MIN_RETRANSMIT_TICKS = Math.max(1, 4);
    private static final int MAX_RETRANSMIT_TIMER = 20000;
    private static final int MAX_RETRANSMIT_TICKS = Math.max(1, 800);
    private static final int MAX_TRANSMIT_UNACK_DATA_PACKETS = 10;
    private static final int MAX_TRANSMIT_UNACK_PACKETS = 14;
    private final List transmit_unack_packets = new ArrayList();
    private static final int MAX_CONTIGUOUS_RETRANS_FOR_ACK = 3;
    private static final int MIN_KEEPALIVE_TIMER = 10000;
    private static final int MIN_KEEPALIVE_TICKS = Math.max(1, 400);
    private static final int MAX_KEEPALIVE_TIMER = 20000;
    private static final int MAX_KEEPALIVE_TICKS = Math.max(1, 800);
    private int keep_alive_ticks;
    private int receive_last_inorder_sequence = -1;
    private int receive_last_inorder_alt_sequence = -1;
    private int receive_their_last_inorder_sequence = -1;
    private static final int RECEIVE_UNACK_IN_SEQUENCE_LIMIT = 3;
    private long current_receive_unack_in_sequence_count = 0L;
    private long sent_receive_unack_in_sequence_count = 0L;
    private static final int RECEIVE_OUT_OF_ORDER_ACK_LIMIT = 3;
    private long current_receive_out_of_order_count = 0L;
    private long sent_receive_out_of_order_count = 0L;
    private static final int RECEIVE_DONE_SEQ_MAX = 128;
    private final LinkedList receive_done_sequences = new LinkedList();
    private static final int RECEIVE_OUT_OF_ORDER_PACKETS_MAX = 64;
    private final List receive_out_of_order_packets = new LinkedList();
    private int explicitack_ticks = 0;
    private static final int MAX_SEQ_MEMORY = Math.max(64, 14);

    protected UDPConnectionSet(UDPConnectionManager _manager, String _connection_key, UDPSelector _selector, int _local_port, InetSocketAddress _remote_address) {
        this.manager = _manager;
        this.connection_key = _connection_key;
        this.selector = _selector;
        this.local_port = _local_port;
        this.remote_address = _remote_address;
    }

    protected UDPSelector getSelector() {
        return this.selector;
    }

    protected InetSocketAddress getRemoteAddress() {
        return this.remote_address;
    }

    protected String getKey() {
        return this.connection_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(UDPConnection connection) throws IOException {
        UDPConnection old_connection = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            old_connection = this.connections.put(new Integer(connection.getID()), connection);
            if (this.connections.size() == 1 && this.lead_connection == null) {
                this.lead_connection = connection;
                this.outgoing = true;
            }
        }
        if (old_connection != null) {
            Debug.out("Duplicate connection");
            old_connection.close("Duplication connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(UDPConnection connection) {
        Map map = this.connections;
        synchronized (map) {
            this.connections.remove(new Integer(connection.getID()));
            return this.connections.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        Map map = this.connections;
        synchronized (map) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                ((UDPConnection)it.next()).poll();
            }
        }
    }

    protected void setSecret(UDPConnection connection, byte[] session_secret) {
        try {
            if (connection == this.lead_connection) {
                if (this.manager.trace()) {
                    this.trace("crypto done");
                }
                SHA1Hasher hasher = new SHA1Hasher();
                hasher.update(KEYA_IV);
                hasher.update(session_secret);
                byte[] a_key = hasher.getDigest();
                hasher = new SHA1Hasher();
                hasher.update(KEYB_IV);
                hasher.update(session_secret);
                byte[] b_key = hasher.getDigest();
                hasher = new SHA1Hasher();
                hasher.update(KEYC_IV);
                hasher.update(session_secret);
                byte[] c_key = hasher.getDigest();
                hasher = new SHA1Hasher();
                hasher.update(KEYD_IV);
                hasher.update(session_secret);
                byte[] d_key = hasher.getDigest();
                RC4Engine rc4_engine_a = this.getCipher(a_key);
                RC4Engine rc4_engine_b = this.getCipher(b_key);
                RC4Engine rc4_engine_c = this.getCipher(c_key);
                RC4Engine rc4_engine_d = this.getCipher(d_key);
                if (this.lead_connection.isIncoming()) {
                    this.header_cipher_out = rc4_engine_a;
                    this.header_cipher_in = rc4_engine_b;
                    this.out_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(d_key)), rc4_engine_c, false);
                    this.in_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(c_key)), rc4_engine_d, true);
                    this.random = new Random(this.bytesToLong(d_key, 8));
                } else {
                    this.header_cipher_out = rc4_engine_b;
                    this.header_cipher_in = rc4_engine_a;
                    this.in_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(d_key)), rc4_engine_c, true);
                    this.out_seq_generator = new SequenceGenerator(new Random(this.bytesToLong(c_key)), rc4_engine_d, false);
                    this.random = new Random(this.bytesToLong(c_key, 8));
                }
                this.out_seq_generator.getNextSequenceNumber();
                int[] initial_in_seqs = this.in_seq_generator.getNextSequenceNumber();
                this.receive_last_inorder_alt_sequence = initial_in_seqs[3];
                this.crypto_done = true;
            } else if (!this.crypto_done) {
                Debug.out("Secondary setSecret but crypto not done");
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            connection.close("Crypto problems: " + Debug.getNestedExceptionMessage(e));
        }
    }

    private RC4Engine getCipher(byte[] key) {
        SecretKeySpec secret_key_spec = new SecretKeySpec(key, "RC4");
        RC4Engine rc4_engine = new RC4Engine();
        KeyParameter params_a = new KeyParameter(secret_key_spec.getEncoded());
        rc4_engine.init(true, params_a);
        byte[] temp = new byte[1024];
        rc4_engine.processBytes(temp, 0, temp.length, temp, 0);
        return rc4_engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTimerBase() {
        if (!this.outgoing) {
            return;
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            if (this.timer_is_adjusting) {
                return;
            }
            if (this.stats_packets_unique_sent > 2) {
                float resend_ratio;
                int new_timer_base = this.current_timer_base;
                if (this.stats_packets_resent_via_timer > 0 && (double)(resend_ratio = (float)this.stats_packets_resent_via_timer / (float)this.stats_packets_unique_sent) >= 0.25) {
                    new_timer_base = (int)((float)this.current_timer_base * (resend_ratio + 1.0f));
                    new_timer_base = new_timer_base / 10 * 10;
                    if ((new_timer_base = Math.min(15000, new_timer_base)) != this.current_timer_base && this.manager.trace()) {
                        this.trace("Increasing timer base from " + this.current_timer_base + " to " + new_timer_base + " due to resends (ratio=" + resend_ratio + ")");
                    }
                }
                if (new_timer_base == this.current_timer_base && this.stats_packets_unique_received > 2) {
                    float duplicate_ratio = (float)this.stats_packets_duplicates / (float)this.stats_packets_unique_received;
                    if ((double)(duplicate_ratio /= 2.0f) >= 0.25) {
                        new_timer_base = (int)((float)this.current_timer_base * (duplicate_ratio + 1.0f));
                        new_timer_base = new_timer_base / 10 * 10;
                        if ((new_timer_base = Math.min(15000, new_timer_base)) != this.current_timer_base && this.manager.trace()) {
                            this.trace("Increasing timer base from " + this.current_timer_base + " to " + new_timer_base + " due to duplicates (ratio=" + duplicate_ratio + ")");
                        }
                    }
                }
                if (new_timer_base == this.current_timer_base && this.stats_packets_unique_received > 2 && this.stats_packets_resent_via_timer == 0 && this.stats_packets_duplicates == 0) {
                    new_timer_base = this.current_timer_base - this.current_timer_base / 10;
                    new_timer_base = new_timer_base / 10 * 10;
                    if ((new_timer_base = Math.max(new_timer_base, 100)) != this.current_timer_base && this.manager.trace()) {
                        this.trace("Decreasing timer base from " + this.current_timer_base + " to " + new_timer_base);
                    }
                }
                boolean reset_stats = false;
                long now = SystemTime.getCurrentTime();
                if (new_timer_base == this.current_timer_base) {
                    if (now < this.stats_reset_time || now - this.stats_reset_time > 30000L) {
                        reset_stats = true;
                    }
                } else {
                    this.timer_is_adjusting = true;
                    this.old_timer_base = this.current_timer_base;
                    this.current_timer_base = new_timer_base;
                    reset_stats = true;
                }
                if (reset_stats) {
                    this.resetTimerStats();
                }
            }
        }
    }

    private void resetTimerStats() {
        this.stats_reset_time = SystemTime.getCurrentTime();
        this.stats_packets_unique_sent = 0;
        this.stats_packets_resent_via_timer = 0;
        this.stats_packets_duplicates = 0;
        this.stats_packets_unique_received = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveTimerBase(int theirs) {
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            if (theirs != this.current_timer_base && this.manager.trace()) {
                this.trace("Received timer base: current=" + this.current_timer_base + ",theirs=" + theirs + "(adj=" + this.timer_is_adjusting + ")");
            }
            if (this.outgoing) {
                if (theirs == this.current_timer_base && this.timer_is_adjusting) {
                    this.timer_is_adjusting = false;
                    this.resetTimerStats();
                }
            } else {
                this.current_timer_base = theirs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerTick() throws IOException {
        boolean retrans_expired = false;
        boolean ack_expired = false;
        boolean keep_alive_expired = false;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            this.idle_ticks = this.connections.size() == 0 ? ++this.idle_ticks : 0;
            ++this.total_tick_count;
            if (this.retransmit_ticks > 0) {
                --this.retransmit_ticks;
                if (this.retransmit_ticks == 0) {
                    retrans_expired = true;
                }
            }
            if (this.explicitack_ticks > 0) {
                --this.explicitack_ticks;
                if (this.explicitack_ticks == 0) {
                    ack_expired = true;
                }
            }
            if (this.keep_alive_ticks > 0) {
                --this.keep_alive_ticks;
                if (this.keep_alive_ticks == 0) {
                    keep_alive_expired = true;
                }
            }
            --this.stats_log_ticks;
            if (this.stats_log_ticks == 0) {
                this.logStats();
                this.stats_log_ticks = STATS_LOG_TICKS;
            }
        }
        if (retrans_expired) {
            this.retransmitExpired();
        }
        if (ack_expired) {
            this.sendAckCommand(true);
        }
        if (keep_alive_expired) {
            this.sendStatsRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRetransmitTicks() {
        int timer_to_use;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            timer_to_use = this.timer_is_adjusting ? (this.current_timer_base > this.old_timer_base ? this.current_timer_base : this.old_timer_base) : this.current_timer_base;
        }
        int timer = timer_to_use * 5 / 3;
        return Math.max(1, timer / 25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getExplicitAckTicks() {
        int timer_to_use;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            timer_to_use = this.timer_is_adjusting ? (this.current_timer_base > this.old_timer_base ? this.old_timer_base : this.current_timer_base) : this.current_timer_base;
        }
        return Math.max(1, timer_to_use / 25);
    }

    protected void startKeepAliveTimer() {
        this.keep_alive_ticks = MIN_KEEPALIVE_TICKS + this.random.nextInt(MAX_KEEPALIVE_TICKS - MIN_KEEPALIVE_TICKS);
    }

    protected void stopKeepAliveTimer() {
        this.keep_alive_ticks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean idleLimitExceeded() {
        if (this.idle_ticks > IDLE_TICKS + RandomUtils.nextInt(2000) / 25) {
            Map map = this.connections;
            synchronized (map) {
                block5: {
                    if (this.connections.size() != 0) break block5;
                    this.failed = true;
                    return true;
                }
            }
        }
        return false;
    }

    protected UDPPacket getRetransmitPacket() {
        Iterator it = this.transmit_unack_packets.iterator();
        while (it.hasNext()) {
            boolean auto_retrans;
            UDPPacket p = (UDPPacket)it.next();
            if (p.hasBeenReceived() || !(auto_retrans = p.isAutoRetransmit()) && !it.hasNext()) continue;
            return p;
        }
        return null;
    }

    protected int getRetransmitTicks(int resend_count) {
        int ticks = this.getRetransmitTicks();
        int res = resend_count == 0 ? ticks : ticks + (MAX_RETRANSMIT_TICKS - ticks) * resend_count / 4;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retransmitExpired() throws IOException {
        UDPPacket packet_to_send = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            packet_to_send = this.getRetransmitPacket();
            if (packet_to_send != null) {
                ++this.stats_packets_resent_via_timer;
                ++this.total_packets_resent_via_timer;
                packet_to_send.resent();
            }
        }
        if (packet_to_send != null) {
            if (this.manager.trace()) {
                this.trace("Retransmit: " + packet_to_send.getString());
            }
            this.send(packet_to_send);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean remoteLastInSequence(int alt_sequence) {
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            int i = 0;
            while (i < this.transmit_unack_packets.size()) {
                UDPPacket packet = (UDPPacket)this.transmit_unack_packets.get(i);
                if (packet.getAlternativeSequence() == alt_sequence) {
                    this.receive_their_last_inorder_sequence = packet.getSequence();
                    int j = 0;
                    while (j <= i) {
                        this.transmit_unack_packets.remove(0);
                        ++j;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected synchronized void dumpState() {
        if (this.manager.trace()) {
            String str = "State:";
            String unack = "";
            int i = 0;
            while (i < this.transmit_unack_packets.size()) {
                UDPPacket packet = (UDPPacket)this.transmit_unack_packets.get(i);
                unack = String.valueOf(unack) + (i == 0 ? "" : ",") + packet.getString();
                ++i;
            }
            str = String.valueOf(str) + "unack=" + unack + ",last_in_order=" + this.receive_last_inorder_sequence + ",current_in_seq=" + this.current_receive_unack_in_sequence_count + ",sent_in_seq=" + this.sent_receive_unack_in_sequence_count + ",current_oo=" + this.current_receive_out_of_order_count + ",sent_oo=" + this.sent_receive_out_of_order_count;
            String oo = "";
            int i2 = 0;
            while (i2 < this.receive_out_of_order_packets.size()) {
                Object[] entry = (Object[])this.receive_out_of_order_packets.get(i2);
                oo = String.valueOf(oo) + (i2 == 0 ? "" : ",") + entry[0] + "/" + entry[1] + "/" + (entry[2] == null ? "null" : String.valueOf(((ByteBuffer)entry[2]).remaining()));
                ++i2;
            }
            str = String.valueOf(str) + ",oo=" + oo;
            str = String.valueOf(str) + ",sent_data=" + this.total_data_sent + "/" + this.total_data_resent + ",sent_prot=" + this.total_protocol_sent + "/" + this.total_protocol_resent;
            this.trace(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(UDPPacket packet) throws IOException {
        if (this.failed) {
            throw new IOException("Connection set has failed");
        }
        byte[] payload = packet.getBuffer();
        if (this.manager.trace()) {
            this.trace(packet.getConnection(), "Write: " + packet.getString());
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            short send_count;
            UDPPacket retransmit_target;
            ++this.total_packets_sent;
            short resend_count = packet.getResendCount();
            if (resend_count > 5) {
                throw new IOException("Packet resend limit exceeded");
            }
            long unackin = packet.getUnAckInSequenceCount();
            if (unackin > this.sent_receive_unack_in_sequence_count) {
                this.sent_receive_unack_in_sequence_count = unackin;
            }
            if ((retransmit_target = this.getRetransmitPacket()) == null) {
                this.retransmit_ticks = 0;
            } else if (retransmit_target != this.current_retransmit_target || retransmit_target == packet) {
                this.retransmit_ticks = this.getRetransmitTicks(resend_count);
            } else if (this.retransmit_ticks == 0) {
                this.retransmit_ticks = this.getRetransmitTicks(resend_count);
            }
            this.current_retransmit_target = retransmit_target;
            if (packet.getAlternativeSequence() != -1) {
                byte[] alt = this.intToBytes(this.receive_last_inorder_alt_sequence);
                payload[0] = alt[0];
                payload[1] = alt[1];
                payload[8] = alt[2];
                payload[9] = alt[3];
            }
            if ((send_count = packet.sent(this.total_tick_count)) == 1) {
                if (packet.getCommand() == 1) {
                    ++this.total_data_sent;
                } else {
                    ++this.total_protocol_sent;
                }
            } else if (packet.getCommand() == 1) {
                ++this.total_data_resent;
            } else {
                ++this.total_protocol_resent;
            }
        }
        this.manager.send(this.local_port, this.remote_address, payload);
    }

    /*
     * Exception decompiling
     */
    public void receive(byte[] initial_data, int initial_data_length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 101[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendCrypto(ByteBuffer[] buffers, int offset, int length) throws IOException {
        int payload_to_send = 0;
        int i = offset;
        while (i < offset + length) {
            payload_to_send += buffers[i].remaining();
            ++i;
        }
        byte[] packet_bytes = new byte[payload_to_send];
        ByteBuffer packet_buffer = ByteBuffer.wrap(packet_bytes);
        int i2 = offset;
        while (i2 < offset + length) {
            packet_buffer.put(buffers[i2]);
            ++i2;
        }
        UDPPacket packet_to_send = new UDPPacket(this.lead_connection, new int[]{-1, -1, -1, -1}, 0, packet_bytes, 0L);
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            ++this.stats_packets_unique_sent;
            ++this.total_packets_unique_sent;
            this.transmit_unack_packets.add(packet_to_send);
        }
        if (this.manager.trace()) {
            this.trace("sendCrypto: seq=" + packet_to_send.getSequence() + ", len=" + payload_to_send);
        }
        this.send(packet_to_send);
        return payload_to_send;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveCrypto(ByteBuffer buffer) throws IOException {
        boolean new_connection = false;
        UDPConnection connection = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            if (this.connections.size() == 0) {
                connection = new UDPConnection(this, -1);
                this.connections.put(new Integer(connection.getID()), connection);
                this.lead_connection = connection;
                new_connection = true;
            } else {
                connection = this.lead_connection;
            }
        }
        if (new_connection) {
            this.manager.accept(this.local_port, this.remote_address, connection);
        }
        if (this.manager.trace()) {
            this.trace(connection, "readCrypto: rem=" + buffer.remaining());
        }
        connection.receive(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendDataCommand(UDPConnection connection, ByteBuffer[] buffers, int offset, int length) throws IOException {
        UDPPacket packet_to_send;
        int payload_to_send = 0;
        int i = offset;
        while (i < offset + length) {
            payload_to_send += buffers[i].remaining();
            ++i;
        }
        byte[] header = new byte[256];
        ByteBuffer header_buffer = ByteBuffer.wrap(header);
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            long unack_in_sequence_count = this.current_receive_unack_in_sequence_count;
            int[] sequence_numbers = this.writeHeaderStart(header_buffer, (byte)1, (byte)0);
            header_buffer.putInt(connection.getID());
            int header_size = this.writeHeaderEnd(header_buffer, false);
            int mss = connection.getTransport().getMss();
            if (mss < 256) {
                mss = 256;
            }
            if (payload_to_send > mss - header_size) {
                payload_to_send = mss - header_size;
            }
            if (payload_to_send < 0) {
                payload_to_send = 0;
            }
            byte[] packet_bytes = new byte[header_size + payload_to_send];
            ByteBuffer packet_buffer = ByteBuffer.wrap(packet_bytes);
            packet_buffer.put(header, 0, header_size);
            int rem = payload_to_send;
            int i2 = offset;
            while (i2 < offset + length) {
                ByteBuffer buffer = buffers[i2];
                int limit = buffer.limit();
                try {
                    if (buffer.remaining() > rem) {
                        buffer.limit(buffer.position() + rem);
                    }
                    packet_buffer.put(buffer);
                }
                finally {
                    buffer.limit(limit);
                }
                if ((rem -= buffer.remaining()) == 0) break;
                ++i2;
            }
            packet_to_send = new UDPPacket(connection, sequence_numbers, 1, packet_bytes, unack_in_sequence_count);
            this.transmit_unack_packets.add(packet_to_send);
        }
        if (this.manager.trace()) {
            this.trace(connection, "sendData: seq=" + packet_to_send.getSequence() + ",data=" + payload_to_send);
        }
        this.send(packet_to_send);
        return payload_to_send;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveDataCommand(int sequence, ByteBuffer buffer, int header_length) throws IOException {
        int connection_id = buffer.getInt();
        UDPConnection connection = null;
        boolean new_connection = false;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            connection = (UDPConnection)this.connections.get(new Integer(connection_id));
            if (connection == null && (connection = (UDPConnection)this.connections.remove(new Integer(-1))) != null) {
                connection.setID(connection_id);
                this.connections.put(new Integer(connection_id), connection);
            }
            if (connection == null) {
                if (this.connections.size() == 128) {
                    throw new IOException("Connection limit reached");
                }
                connection = new UDPConnection(this, connection_id);
                this.connections.put(new Integer(connection.getID()), connection);
                new_connection = true;
            }
        }
        buffer.position(header_length);
        if (new_connection) {
            this.manager.accept(this.local_port, this.remote_address, connection);
        }
        if (this.manager.trace()) {
            this.trace(connection, "receiveData: seq=" + sequence + ",data=" + buffer.remaining());
        }
        connection.receive(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAckCommand(boolean timer_expired) throws IOException {
        UDPPacket packet_to_send = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (UDPPacket packet : this.transmit_unack_packets) {
                if (packet.getCommand() != 2) continue;
                if (this.total_tick_count - packet.getSendTickCount() >= (long)this.getExplicitAckTicks()) {
                    if (this.manager.trace()) {
                        this.trace(packet.getConnection(), "retransAck:" + packet.getString());
                    }
                    packet_to_send = packet;
                    break;
                }
                return;
            }
            if (packet_to_send == null) {
                byte[] header_bytes = new byte[516];
                ByteBuffer header = ByteBuffer.wrap(header_bytes);
                long unack_in_sequence_count = this.current_receive_unack_in_sequence_count;
                boolean no_retrans = this.transmit_unack_packets.size() == 0 && timer_expired && this.receive_out_of_order_packets.size() == 0;
                int[] sequences = this.writeHeaderStart(header, (byte)2, no_retrans ? (byte)1 : 0);
                Iterator it = this.receive_out_of_order_packets.iterator();
                String oos_str = "";
                int count = 0;
                while (it.hasNext() && count < 3) {
                    Object[] entry = (Object[])it.next();
                    if (entry[2] == null) continue;
                    int out_of_order_seq = (Integer)entry[0];
                    int out_of_rep_seq = (Integer)entry[1];
                    oos_str = String.valueOf(oos_str) + (oos_str.length() == 0 ? "" : ",") + out_of_order_seq + "/" + out_of_rep_seq;
                    header.putInt(out_of_order_seq);
                    ++count;
                }
                header.putInt(-1);
                if (count == 0) {
                    this.sent_receive_out_of_order_count = this.current_receive_out_of_order_count;
                } else {
                    this.sent_receive_out_of_order_count += (long)count;
                    if (this.sent_receive_out_of_order_count > this.current_receive_out_of_order_count) {
                        this.sent_receive_out_of_order_count = this.current_receive_out_of_order_count;
                    }
                }
                int size = this.writeHeaderEnd(header, true);
                byte[] packet_bytes = new byte[size];
                System.arraycopy(header_bytes, 0, packet_bytes, 0, size);
                packet_to_send = new UDPPacket(this.lead_connection, sequences, 2, packet_bytes, unack_in_sequence_count);
                if (no_retrans) {
                    packet_to_send.setAutoRetransmit(false);
                    this.startKeepAliveTimer();
                }
                this.transmit_unack_packets.add(packet_to_send);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendAck: in_seq=" + this.receive_last_inorder_sequence + ",out_of_seq=" + oos_str);
                }
            }
        }
        this.send(packet_to_send);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveAckCommand(ByteBuffer buffer) throws IOException {
        ArrayList<UDPPacket> resend_list = new ArrayList<UDPPacket>();
        String oos_str = "";
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            Iterator it = this.transmit_unack_packets.iterator();
            block3: while (resend_list.size() < 3) {
                int out_of_order_seq = buffer.getInt();
                if (out_of_order_seq == -1) break;
                if (this.manager.trace()) {
                    oos_str = String.valueOf(oos_str) + (oos_str.length() == 0 ? "" : ",") + out_of_order_seq;
                }
                while (it.hasNext() && resend_list.size() < 3) {
                    UDPPacket packet = (UDPPacket)it.next();
                    if (packet.getSequence() == out_of_order_seq) {
                        packet.setHasBeenReceived();
                        continue block3;
                    }
                    if (this.total_tick_count - packet.getSendTickCount() < (long)MIN_RETRANSMIT_TICKS || resend_list.contains(packet)) continue;
                    resend_list.add(packet);
                }
            }
            this.total_packets_resent_via_ack += resend_list.size();
        }
        if (this.manager.trace()) {
            this.trace("receiveAck: in_seq=" + this.receive_their_last_inorder_sequence + ",out_of_seq=" + oos_str);
        }
        int i = 0;
        while (i < resend_list.size()) {
            this.send((UDPPacket)resend_list.get(i));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStatsRequest() throws IOException {
        UDPPacket packet_to_send = null;
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (UDPPacket packet : this.transmit_unack_packets) {
                if (packet.getCommand() != 4) continue;
                if (this.total_tick_count - packet.getSendTickCount() >= (long)MIN_RETRANSMIT_TICKS) {
                    if (this.manager.trace()) {
                        this.trace(packet.getConnection(), "retransStatsRequest:" + packet.getString());
                    }
                    packet_to_send = packet;
                    break;
                }
                return;
            }
            if (packet_to_send == null) {
                byte[] header_bytes = new byte[256];
                ByteBuffer header = ByteBuffer.wrap(header_bytes);
                long unack_in_sequence_count = this.current_receive_unack_in_sequence_count;
                int[] sequences = this.writeHeaderStart(header, (byte)4, (byte)0);
                int size = this.writeHeaderEnd(header, true);
                byte[] packet_bytes = new byte[size];
                System.arraycopy(header_bytes, 0, packet_bytes, 0, size);
                packet_to_send = new UDPPacket(this.lead_connection, sequences, 4, packet_bytes, unack_in_sequence_count);
                this.transmit_unack_packets.add(packet_to_send);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendStatsRequest");
                }
            }
        }
        this.send(packet_to_send);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveStatsRequest(ByteBuffer buffer) throws IOException {
        UDPPacket packet_to_send = null;
        if (this.manager.trace()) {
            this.trace("ReceiveStatsRequest");
        }
        UDPConnectionSet uDPConnectionSet = this;
        synchronized (uDPConnectionSet) {
            for (UDPPacket packet : this.transmit_unack_packets) {
                if (packet.getCommand() != 5) continue;
                if (this.total_tick_count - packet.getSendTickCount() >= (long)MIN_RETRANSMIT_TICKS) {
                    if (this.manager.trace()) {
                        this.trace(packet.getConnection(), "retransStatsReply:" + packet.getString());
                    }
                    packet_to_send = packet;
                    break;
                }
                return;
            }
            if (packet_to_send == null) {
                byte[] header_bytes = new byte[256];
                ByteBuffer header = ByteBuffer.wrap(header_bytes);
                long unack_in_sequence_count = this.current_receive_unack_in_sequence_count;
                boolean no_retrans = this.transmit_unack_packets.size() == 0 && this.receive_out_of_order_packets.size() == 0;
                int[] sequences = this.writeHeaderStart(header, (byte)5, no_retrans ? (byte)1 : 0);
                int size = this.writeHeaderEnd(header, true);
                byte[] packet_bytes = new byte[size];
                System.arraycopy(header_bytes, 0, packet_bytes, 0, size);
                packet_to_send = new UDPPacket(this.lead_connection, sequences, 5, packet_bytes, unack_in_sequence_count);
                if (no_retrans) {
                    packet_to_send.setAutoRetransmit(false);
                }
                this.transmit_unack_packets.add(packet_to_send);
                if (this.manager.trace()) {
                    this.trace(this.lead_connection, "sendStatsReply");
                }
            }
        }
        this.send(packet_to_send);
    }

    protected void receiveStatsReply(ByteBuffer buffer) throws IOException {
        if (this.manager.trace()) {
            this.trace("receiveStatsReply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseCommand(UDPConnection connection) throws IOException {
        UDPPacket packet_to_send;
        if (this.crypto_done) {
            UDPConnectionSet uDPConnectionSet = this;
            synchronized (uDPConnectionSet) {
                byte[] header_bytes = new byte[256];
                ByteBuffer header = ByteBuffer.wrap(header_bytes);
                long unack_in_sequence_count = this.current_receive_unack_in_sequence_count;
                int[] sequences = this.writeHeaderStart(header, (byte)3, (byte)0);
                header.putInt(connection.getID());
                int size = this.writeHeaderEnd(header, true);
                byte[] packet_bytes = new byte[size];
                System.arraycopy(header_bytes, 0, packet_bytes, 0, size);
                if (this.manager.trace()) {
                    this.trace(connection, "sendClose");
                }
                packet_to_send = new UDPPacket(this.lead_connection, sequences, 3, packet_bytes, unack_in_sequence_count);
                this.transmit_unack_packets.add(packet_to_send);
            }
        } else {
            IOException failure = new IOException("Connection failed during setup phase");
            this.failed(failure);
            throw failure;
        }
        this.send(packet_to_send);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveCloseCommand(ByteBuffer buffer) throws IOException {
        int connection_id = buffer.getInt();
        UDPConnection connection = null;
        Map map = this.connections;
        synchronized (map) {
            if (this.failed) {
                throw new IOException("Connection set has failed");
            }
            connection = (UDPConnection)this.connections.get(new Integer(connection_id));
        }
        if (this.manager.trace()) {
            this.trace("receiveClose: con=" + (connection == null ? "<null>" : "" + connection.getID()));
        }
        if (connection != null) {
            connection.close("Remote has closed the connection");
        }
    }

    protected int[] writeHeaderStart(ByteBuffer buffer, byte command, byte flags) throws IOException {
        this.sendTimerBase();
        ++this.stats_packets_unique_sent;
        ++this.total_packets_unique_sent;
        int[] sequence_numbers = this.out_seq_generator.getNextSequenceNumber();
        int seq = sequence_numbers[1];
        buffer.putInt(sequence_numbers[0]);
        buffer.putInt(seq);
        buffer.putInt(sequence_numbers[2]);
        buffer.putShort((short)0);
        buffer.put((byte)1);
        buffer.put(flags);
        buffer.putShort((short)(this.current_timer_base / 10));
        buffer.put(command);
        return sequence_numbers;
    }

    protected int writeHeaderEnd(ByteBuffer buffer, boolean randomise_size) throws IOException {
        if (randomise_size) {
            int pad = this.random.nextInt(8);
            int i = 0;
            while (i < pad) {
                buffer.put((byte)0);
                ++i;
            }
        }
        short total_length = (short)buffer.position();
        buffer.position(12);
        buffer.putShort((short)(total_length + 4));
        byte[] buffer_bytes = buffer.array();
        SHA1Hasher hasher = new SHA1Hasher();
        hasher.update(buffer_bytes, 4, 4);
        hasher.update(buffer_bytes, 12, total_length - 12);
        byte[] hash = hasher.getDigest();
        buffer.position(total_length);
        buffer.put(hash, 0, 4);
        total_length = (short)(total_length + 4);
        this.header_cipher_out.processBytes(buffer_bytes, 12, total_length - 12, buffer_bytes, 12);
        if (total_length > 128) {
            Debug.out("MAX_HEADER exceeded!!!!");
            throw new IOException("MAX_HEADER exceeded");
        }
        return total_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write(UDPConnection connection, ByteBuffer[] buffers, int offset, int length) throws IOException {
        if (!this.canWrite(connection)) {
            return 0;
        }
        LinkedList linkedList = this.connection_writers;
        synchronized (linkedList) {
            int size = this.connection_writers.size();
            if (size == 0) {
                this.connection_writers.add(connection);
            } else if (this.connection_writers.size() != 1 || this.connection_writers.get(0) != connection) {
                this.connection_writers.remove(connection);
                this.connection_writers.addLast(connection);
            }
        }
        if (this.total_packets_sent == 0) {
            return this.sendCrypto(buffers, offset, length);
        }
        return this.sendDataCommand(connection, buffers, offset, length);
    }

    protected boolean canWrite(UDPConnection connection) {
        if (!this.crypto_done) {
            if (connection != this.lead_connection) {
                return false;
            }
            if (this.total_packets_sent > 0) {
                return false;
            }
        }
        boolean space = this.transmit_unack_packets.size() < 10;
        return space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(UDPConnection connection, String reason) {
        boolean found;
        if (this.manager.trace()) {
            this.trace(connection, "close: " + reason);
        }
        Map map = this.connections;
        synchronized (map) {
            found = this.connections.containsValue(connection);
        }
        if (found) {
            try {
                this.sendCloseCommand(connection);
            }
            catch (Throwable e) {
                this.failed(e);
            }
        }
        connection.poll();
        this.manager.remove(this, connection);
    }

    public void failed(UDPConnection connection, Throwable reason) {
        if (this.manager.trace()) {
            this.trace(connection, "Failed: " + Debug.getNestedExceptionMessage(reason));
        }
        connection.poll();
        this.manager.remove(this, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed(Throwable e) {
        ArrayList conns = null;
        Map map = this.connections;
        synchronized (map) {
            if (!this.failed) {
                if (this.manager.trace()) {
                    this.trace("Connection set failed: " + Debug.getNestedExceptionMessage(e));
                }
                this.failed = true;
                conns = new ArrayList(this.connections.values());
            }
        }
        if (conns != null) {
            int i = 0;
            while (i < conns.size()) {
                try {
                    ((UDPConnection)conns.get(i)).failed(e);
                }
                catch (Throwable f) {
                    Debug.printStackTrace(f);
                }
                ++i;
            }
            this.manager.failed(this);
        }
    }

    protected boolean hasFailed() {
        return this.failed;
    }

    protected void removed() {
        this.logStats();
    }

    static void forDocumentation() {
        PRUDPPacketReply.registerDecoders(new HashMap());
    }

    protected int cipherInt(RC4Engine cipher, int i) {
        byte[] bytes = this.intToBytes(i);
        cipher.processBytes(bytes, 0, bytes.length, bytes, 0);
        return this.bytesToInt(bytes, 0);
    }

    protected int bytesToInt(byte[] bytes, int offset) {
        int res = bytes[offset++] << 24 & 0xFF000000 | bytes[offset++] << 16 & 0xFF0000 | bytes[offset++] << 8 & 0xFF00 | bytes[offset++] & 0xFF;
        return res;
    }

    protected byte[] intToBytes(int i) {
        byte[] res = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return res;
    }

    protected long bytesToLong(byte[] bytes) {
        return this.bytesToLong(bytes, 0);
    }

    protected long bytesToLong(byte[] bytes, int offset) {
        long i1 = (long)(bytes[offset++] << 24) & 0xFF000000L | (long)(bytes[offset++] << 16) & 0xFF0000L | (long)(bytes[offset++] << 8) & 0xFF00L | (long)bytes[offset++] & 0xFFL;
        long i2 = (long)(bytes[offset++] << 24) & 0xFF000000L | (long)(bytes[offset++] << 16) & 0xFF0000L | (long)(bytes[offset++] << 8) & 0xFF00L | (long)bytes[offset++] & 0xFFL;
        long res = i1 << 32 | i2;
        return res;
    }

    protected String getName() {
        return "loc=" + this.local_port + " - " + this.remote_address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logStats() {
        if (Logger.isEnabled()) {
            UDPConnectionSet uDPConnectionSet = this;
            synchronized (uDPConnectionSet) {
                String str = "sent: tot=" + this.total_packets_sent + ",uni=" + this.total_packets_unique_sent + ",ds=" + this.total_data_sent + ",dr=" + this.total_data_resent + ",ps=" + this.total_protocol_sent + ",pr=" + this.total_protocol_resent + ",rt=" + this.total_packets_resent_via_timer + ",ra=" + this.total_packets_resent_via_ack;
                str = String.valueOf(str) + " recv: tot=" + this.total_packets_received + ",uni=" + this.total_packets_unique_received + ",du=" + this.total_packets_duplicates + ",oo=" + this.total_packets_out_of_order;
                str = String.valueOf(str) + " timer=" + this.current_timer_base + ",adj=" + this.timer_is_adjusting;
                Logger.log(new LogEvent(LOGID, "UDP " + this.getName() + " - " + str));
            }
        }
    }

    protected void trace(String str) {
        if (this.manager.trace()) {
            this.manager.trace("UDP " + this.getName() + ": " + str);
        }
    }

    protected void trace(UDPConnection connection, String str) {
        if (this.manager.trace()) {
            this.manager.trace("UDP " + this.getName() + " (" + connection.getID() + "): " + str);
        }
    }

    protected class SequenceGenerator {
        private final Random generator;
        private final RC4Engine cipher;
        private final boolean in;
        private final int[] seq_memory;
        private final int[] alt_seq_memory;
        private int seq_memory_pos;
        private int debug_seq_in_next;
        private int debug_seq_out_next;

        protected SequenceGenerator(Random _generator, RC4Engine _cipher, boolean _in) {
            this.debug_seq_in_next = UDPConnectionSet.this.outgoing ? 0 : 1000000;
            this.debug_seq_out_next = UDPConnectionSet.this.outgoing ? 1000000 : 0;
            this.generator = _generator;
            this.cipher = _cipher;
            this.in = _in;
            this.seq_memory = new int[MAX_SEQ_MEMORY];
            this.alt_seq_memory = new int[MAX_SEQ_MEMORY];
            Arrays.fill(this.seq_memory, -1);
            Arrays.fill(this.alt_seq_memory, -1);
        }

        protected synchronized int[] getNextSequenceNumber() {
            int seq4;
            int seq3;
            int seq2;
            int seq1;
            int mask = -2048;
            while (true) {
                seq1 = this.generator.nextInt();
                seq2 = this.generator.nextInt();
                seq3 = this.generator.nextInt();
                seq4 = this.generator.nextInt();
                seq1 = UDPConnectionSet.this.cipherInt(this.cipher, seq1);
                seq2 = UDPConnectionSet.this.cipherInt(this.cipher, seq2);
                seq3 = UDPConnectionSet.this.cipherInt(this.cipher, seq3);
                seq4 = UDPConnectionSet.this.cipherInt(this.cipher, seq4);
                if ((seq1 & 0xFFFFF800) == 0 || seq2 == -1 || (seq3 & 0xFFFFF800) == 0 || (seq4 & 0xFFFF0000) == 0 || (seq4 & 0xFFFF) == 0) continue;
                boolean bad = false;
                int i = 0;
                while (i < MAX_SEQ_MEMORY) {
                    if (this.seq_memory[i] == seq2 || this.alt_seq_memory[i] == seq4) {
                        bad = true;
                        break;
                    }
                    ++i;
                }
                if (!bad) break;
            }
            this.seq_memory[this.seq_memory_pos] = seq2;
            this.alt_seq_memory[this.seq_memory_pos++] = seq4;
            if (this.seq_memory_pos == MAX_SEQ_MEMORY) {
                this.seq_memory_pos = 0;
            }
            return new int[]{seq1, seq2, seq3, seq4};
        }

        protected boolean isValidAlterativeSequence(int seq) {
            int i = 0;
            while (i < MAX_SEQ_MEMORY) {
                if (this.alt_seq_memory[i] == seq) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

