/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionSet;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;

public class UDPConnection {
    private final UDPConnectionSet set;
    private int id;
    private UDPTransportHelper transport;
    private final List read_buffers = new LinkedList();
    private final AESemaphore read_buffer_sem = new AESemaphore("UDPConnection", 64);
    private volatile boolean connected = true;

    protected UDPConnection(UDPConnectionSet _set, int _id, UDPTransportHelper _transport) {
        this.set = _set;
        this.id = _id;
        this.transport = _transport;
    }

    protected UDPConnection(UDPConnectionSet _set, int _id) {
        this.set = _set;
        this.id = _id;
    }

    protected UDPSelector getSelector() {
        return this.set.getSelector();
    }

    protected int getID() {
        return this.id;
    }

    protected void setID(int _id) {
        this.id = _id;
    }

    public boolean isIncoming() {
        return this.transport.isIncoming();
    }

    protected void setSecret(byte[] session_secret) {
        this.set.setSecret(this, session_secret);
    }

    protected void setTransport(UDPTransportHelper _transport) {
        this.transport = _transport;
    }

    protected UDPTransportHelper getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(ByteBuffer data) throws IOException {
        int rem = data.remaining();
        if (rem < 256) {
            byte[] temp = new byte[rem];
            data.get(temp);
            data = ByteBuffer.wrap(temp);
        }
        this.read_buffer_sem.reserve();
        if (!this.connected) {
            throw new IOException("Transport closed");
        }
        boolean was_empty = false;
        List list = this.read_buffers;
        synchronized (list) {
            was_empty = this.read_buffers.size() == 0;
            this.read_buffers.add(data);
        }
        if (was_empty) {
            this.transport.canRead();
        }
    }

    protected void sent() {
        this.transport.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canRead() {
        List list = this.read_buffers;
        synchronized (list) {
            return this.read_buffers.size() > 0;
        }
    }

    protected boolean canWrite() {
        return this.set.canWrite(this);
    }

    protected int write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        int written = this.set.write(this, buffers, offset, length);
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(ByteBuffer buffer) throws IOException {
        int total = 0;
        List list = this.read_buffers;
        synchronized (list) {
            while (this.read_buffers.size() > 0) {
                int rem = buffer.remaining();
                if (rem == 0) break;
                ByteBuffer b = (ByteBuffer)this.read_buffers.get(0);
                int old_limit = b.limit();
                if (b.remaining() > rem) {
                    b.limit(b.position() + rem);
                }
                buffer.put(b);
                b.limit(old_limit);
                total += rem - buffer.remaining();
                if (b.hasRemaining()) break;
                this.read_buffers.remove(0);
                this.read_buffer_sem.release();
            }
        }
        return total;
    }

    protected void close(String reason) {
        if (this.transport != null) {
            this.transport.close(reason);
        } else {
            this.closeSupport(reason);
        }
    }

    protected void failed(Throwable reason) {
        if (this.transport != null) {
            this.transport.failed(reason);
        } else {
            this.failedSupport(reason);
        }
    }

    protected void closeSupport(String reason) {
        this.connected = false;
        this.read_buffer_sem.releaseForever();
        this.set.close(this, reason);
    }

    protected void failedSupport(Throwable reason) {
        this.connected = false;
        this.read_buffer_sem.releaseForever();
        this.set.failed(this, reason);
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected void poll() {
        if (this.transport != null) {
            this.transport.poll();
        }
    }
}

