/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlue;
import com.aelitis.azureus.core.networkmanager.impl.udp.NetworkGlueListener;
import com.aelitis.azureus.core.util.AEPriorityMixin;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkGlueUDP
implements NetworkGlue,
PRUDPPrimordialHandler,
AEPriorityMixin {
    private static final LogIDs LOGID = LogIDs.NET;
    private final NetworkGlueListener listener;
    private PRUDPPacketHandler handler;
    final LinkedList msg_queue = new LinkedList();
    final AESemaphore msg_queue_sem = new AESemaphore("NetworkGlueUDP");
    final AESemaphore msg_queue_slot_sem = new AESemaphore("NetworkGlueUDP", 128);
    private long total_packets_received;
    private long total_bytes_received;
    private long total_packets_sent;
    private long total_bytes_sent;

    protected NetworkGlueUDP(NetworkGlueListener _listener) {
        this.listener = _listener;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"UDP.Listen.Port", "UDP.Listen.Port.Enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                boolean enabled = COConfigurationManager.getBooleanParameter("UDP.Listen.Port.Enable");
                if (enabled) {
                    int port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                    if (NetworkGlueUDP.this.handler == null || port != NetworkGlueUDP.this.handler.getPort()) {
                        if (NetworkGlueUDP.this.handler != null) {
                            Logger.log(new LogEvent(LOGID, "Deactivating UDP listener on port " + NetworkGlueUDP.this.handler.getPort()));
                            NetworkGlueUDP.this.handler.removePrimordialHandler(NetworkGlueUDP.this);
                        }
                        Logger.log(new LogEvent(LOGID, "Activating UDP listener on port " + port));
                        NetworkGlueUDP.this.handler = PRUDPPacketHandlerFactory.getHandler(port);
                        NetworkGlueUDP.this.handler.addPrimordialHandler(NetworkGlueUDP.this);
                    }
                } else if (NetworkGlueUDP.this.handler != null) {
                    Logger.log(new LogEvent(LOGID, "Deactivating UDP listener on port " + NetworkGlueUDP.this.handler.getPort()));
                    NetworkGlueUDP.this.handler.removePrimordialHandler(NetworkGlueUDP.this);
                }
            }
        });
        new AEThread("NetworkGlueUDP", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                while (true) {
                    InetSocketAddress target_address = null;
                    byte[] data = null;
                    NetworkGlueUDP.this.msg_queue_sem.reserve();
                    LinkedList linkedList = NetworkGlueUDP.this.msg_queue;
                    synchronized (linkedList) {
                        Object[] entry = (Object[])NetworkGlueUDP.this.msg_queue.removeFirst();
                        target_address = (InetSocketAddress)entry[0];
                        data = (byte[])entry[1];
                    }
                    NetworkGlueUDP.this.msg_queue_slot_sem.release();
                    NetworkGlueUDP networkGlueUDP = NetworkGlueUDP.this;
                    networkGlueUDP.total_packets_sent = networkGlueUDP.total_packets_sent + 1L;
                    NetworkGlueUDP networkGlueUDP2 = NetworkGlueUDP.this;
                    networkGlueUDP2.total_bytes_sent = networkGlueUDP2.total_bytes_sent + (long)data.length;
                    try {
                        try {
                            NetworkGlueUDP.this.handler.primordialSend(data, target_address);
                        }
                        catch (Throwable e) {
                            Logger.log(new LogEvent(LOGID, "Primordial UDP send failed: " + Debug.getNestedExceptionMessage(e)));
                            try {
                                Thread.sleep(3L);
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            Thread.sleep(3L);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        Thread.sleep(3L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }.start();
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean packetReceived(DatagramPacket packet) {
        byte[] data;
        if (!(packet.getLength() < 12 || ((data = packet.getData())[0] & 0xFF) == 0 && (data[1] & 0xFF) == 0 && (data[2] & 0xF8) == 0 || (data[8] & 0xFF) == 0 && (data[9] & 0xFF) == 0 && (data[10] & 0xF8) == 0)) {
            ++this.total_packets_received;
            this.total_bytes_received += (long)packet.getLength();
            this.listener.receive(this.handler.getPort(), new InetSocketAddress(packet.getAddress(), packet.getPort()), packet.getData(), packet.getLength());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(int local_port, InetSocketAddress target, byte[] data) throws IOException {
        this.msg_queue_slot_sem.reserve();
        LinkedList linkedList = this.msg_queue;
        synchronized (linkedList) {
            this.msg_queue.add(new Object[]{target, data});
        }
        this.msg_queue_sem.release();
        return data.length;
    }

    @Override
    public long[] getStats() {
        return new long[]{this.total_packets_sent, this.total_bytes_sent, this.total_packets_received, this.total_bytes_received};
    }
}

