/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterTransparent
implements TransportHelperFilter {
    private final TransportHelper transport;
    private final boolean is_plain;
    private ByteBuffer read_insert;

    public TransportHelperFilterTransparent(TransportHelper _transport, boolean _is_plain) {
        this.transport = _transport;
        this.is_plain = _is_plain;
    }

    protected void insertRead(ByteBuffer _read_insert) {
        this.read_insert = _read_insert;
    }

    @Override
    public boolean hasBufferedWrite() {
        return this.transport.hasDelayedWrite();
    }

    @Override
    public boolean hasBufferedRead() {
        return this.read_insert != null && this.read_insert.remaining() > 0;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.transport.write(buffers, array_offset, length);
    }

    public int write(ByteBuffer buffer, boolean partial_write) throws IOException {
        return this.transport.write(buffer, partial_write);
    }

    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        int len = 0;
        if (this.read_insert != null) {
            int pos_before = this.read_insert.position();
            int i = array_offset;
            while (i < array_offset + length) {
                ByteBuffer buffer = buffers[i];
                int space = buffer.remaining();
                if (space > 0) {
                    if (space < this.read_insert.remaining()) {
                        int old_limit = this.read_insert.limit();
                        this.read_insert.limit(this.read_insert.position() + space);
                        buffer.put(this.read_insert);
                        this.read_insert.limit(old_limit);
                    } else {
                        buffer.put(this.read_insert);
                    }
                    if (!this.read_insert.hasRemaining()) break;
                }
                ++i;
            }
            len = this.read_insert.position() - pos_before;
            if (this.read_insert.hasRemaining()) {
                return len;
            }
            this.read_insert = null;
        }
        return (long)len + this.transport.read(buffers, array_offset, length);
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.read_insert != null) {
            return (int)this.read(new ByteBuffer[]{buffer}, 0, 1);
        }
        return this.transport.read(buffer);
    }

    @Override
    public TransportHelper getHelper() {
        return this.transport;
    }

    @Override
    public void setTrace(boolean on) {
        this.transport.setTrace(on);
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public String getName(boolean verbose) {
        String proto_str = this.getHelper().getName(verbose);
        if (proto_str.length() > 0) {
            proto_str = " (" + proto_str + ")";
        }
        return String.valueOf(this.is_plain ? "Plain" : "None") + proto_str;
    }
}

