/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerDownloader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerDownloader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForRead(waiter) != 0L) {
            return false;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        return allowed[0] >= 1;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        boolean protocol_is_free;
        if (this.connection.getTransportBase().isReadyForRead(waiter) != 0L) {
            return 0;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        int num_bytes_allowed = allowed[0];
        boolean bl = protocol_is_free = allowed[1] > 0;
        if (num_bytes_allowed < 1) {
            return 0;
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        int bytes_read = 0;
        int data_bytes_read = 0;
        int protocol_bytes_read = 0;
        try {
            int[] read = this.connection.getIncomingMessageQueue().receiveFromTransport(num_bytes_allowed, protocol_is_free);
            data_bytes_read = read[0];
            protocol_bytes_read = read[1];
            bytes_read = data_bytes_read + protocol_bytes_read;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                Debug.printStackTrace(e);
            }
            this.connection.notifyOfException(e);
            return 0;
        }
        if (bytes_read < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(data_bytes_read, protocol_bytes_read);
        return bytes_read;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount(EventWaiter waiter) {
        return 1;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForRead(waiter) == 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() {
        return "SPD: " + this.connection.getString();
    }
}

