/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.Transport;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ConnectionEndpoint {
    private final InetSocketAddress notional_address;
    private ProtocolEndpoint[] protocols;
    private Map<String, Object> properties;

    public ConnectionEndpoint(InetSocketAddress _notional_address) {
        this.notional_address = _notional_address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Map<String, Object> p) {
        ConnectionEndpoint connectionEndpoint = this;
        synchronized (connectionEndpoint) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>(p);
            } else {
                this.properties.putAll(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        ConnectionEndpoint connectionEndpoint = this;
        synchronized (connectionEndpoint) {
            if (this.properties != null) {
                return this.properties.get(name);
            }
        }
        return null;
    }

    public InetSocketAddress getNotionalAddress() {
        return this.notional_address;
    }

    public ProtocolEndpoint[] getProtocols() {
        if (this.protocols == null) {
            return new ProtocolEndpoint[0];
        }
        return this.protocols;
    }

    public void addProtocol(ProtocolEndpoint ep) {
        if (this.protocols == null) {
            this.protocols = new ProtocolEndpoint[]{ep};
        } else {
            int i = 0;
            while (i < this.protocols.length) {
                if (this.protocols[i] == ep) {
                    return;
                }
                ++i;
            }
            ProtocolEndpoint[] new_ep = new ProtocolEndpoint[this.protocols.length + 1];
            System.arraycopy(this.protocols, 0, new_ep, 0, this.protocols.length);
            new_ep[this.protocols.length] = ep;
            this.protocols = new_ep;
        }
        ep.setConnectionEndpoint(this);
    }

    public ConnectionEndpoint getLANAdjustedEndpoint() {
        ConnectionEndpoint result = new ConnectionEndpoint(this.notional_address);
        int i = 0;
        while (i < this.protocols.length) {
            ProtocolEndpoint ep = this.protocols[i];
            InetSocketAddress address = ep.getAdjustedAddress(true);
            ProtocolEndpointFactory.createEndpoint(ep.getType(), result, address);
            ++i;
        }
        return result;
    }

    public ConnectionAttempt connectOutbound(final boolean connect_with_crypto, final boolean allow_fallback, final byte[][] shared_secrets, ByteBuffer initial_data, final int priority, final Transport.ConnectListener listener) {
        if (this.protocols.length == 1) {
            ProtocolEndpoint protocol = this.protocols[0];
            final Transport transport = protocol.connectOutbound(connect_with_crypto, allow_fallback, shared_secrets, initial_data, priority, listener);
            return new ConnectionAttempt(){

                @Override
                public void abandon() {
                    if (transport != null) {
                        transport.close("Connection attempt abandoned");
                    }
                }
            };
        }
        final boolean[] connected = new boolean[1];
        final boolean[] abandoned = new boolean[1];
        final ArrayList<Transport> transports = new ArrayList<Transport>(this.protocols.length);
        final Transport.ConnectListener listener_delegate = new Transport.ConnectListener(){
            private int timeout = Integer.MIN_VALUE;
            private int fail_count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int connectAttemptStarted(int default_connect_timeout) {
                boolean[] blArray = connected;
                synchronized (connected) {
                    if (this.timeout == Integer.MIN_VALUE) {
                        this.timeout = listener.connectAttemptStarted(default_connect_timeout);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.timeout;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectSuccess(Transport transport, ByteBuffer remaining_initial_data) {
                boolean[] blArray = connected;
                synchronized (connected) {
                    boolean disconnect = abandoned[0];
                    if (!disconnect) {
                        if (!connected[0]) {
                            connected[0] = true;
                        } else {
                            disconnect = true;
                        }
                    }
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    if (disconnect) {
                        transport.close("Transparent not required");
                    } else {
                        listener.connectSuccess(transport, remaining_initial_data);
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectFailure(Throwable failure_msg) {
                boolean[] blArray = connected;
                synchronized (connected) {
                    ++this.fail_count;
                    boolean inform = this.fail_count == ConnectionEndpoint.this.protocols.length;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    if (inform) {
                        listener.connectFailure(failure_msg);
                    }
                    return;
                }
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return listener.getConnectionProperty(property_name);
            }
        };
        boolean ok = true;
        if (this.protocols.length != 2) {
            ok = false;
        } else {
            ProtocolEndpoint p1 = this.protocols[0];
            ProtocolEndpoint p2 = this.protocols[1];
            if (p1.getType() != 1 || p2.getType() != 3) {
                if (p2.getType() == 1 && p1.getType() == 3) {
                    ProtocolEndpoint temp = p1;
                    p1 = p2;
                    p2 = temp;
                } else {
                    ok = false;
                }
            }
            if (ok) {
                final ByteBuffer initial_data_copy = initial_data != null ? initial_data.duplicate() : null;
                Transport transport = p2.connectOutbound(connect_with_crypto, allow_fallback, shared_secrets, initial_data, priority, new ConnectListenerEx(listener_delegate));
                transports.add(transport);
                final ProtocolEndpoint tcp_ep = p1;
                SimpleTimer.addEvent("delay:tcp:connect", SystemTime.getCurrentTime() + 750L, false, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        boolean[] blArray = connected;
                        synchronized (connected) {
                            if (connected[0] || abandoned[0]) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            Transport transport = tcp_ep.connectOutbound(connect_with_crypto, allow_fallback, shared_secrets, initial_data_copy, priority, new ConnectListenerEx(listener_delegate));
                            boolean[] blArray2 = connected;
                            synchronized (connected) {
                                if (abandoned[0]) {
                                    transport.close("Connection attempt abandoned");
                                } else {
                                    transports.add(transport);
                                }
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                });
            }
        }
        if (!ok) {
            Debug.out("No supportified!");
            listener.connectFailure(new Exception("Not Supported"));
        }
        return new ConnectionAttempt(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abandon() {
                boolean[] blArray = connected;
                synchronized (connected) {
                    abandoned[0] = true;
                    ArrayList to_kill = new ArrayList(transports);
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    for (Transport transport : to_kill) {
                        transport.close("Connection attempt abandoned");
                    }
                    return;
                }
            }
        };
    }

    public String getDescription() {
        String str = "[";
        int i = 0;
        while (i < this.protocols.length) {
            str = String.valueOf(str) + (i == 0 ? "" : ",") + this.protocols[i].getDescription();
            ++i;
        }
        return String.valueOf(str) + "]";
    }

    private static class ConnectListenerEx
    implements Transport.ConnectListener {
        private final Transport.ConnectListener listener;
        private boolean ok;
        private boolean failed;

        private ConnectListenerEx(Transport.ConnectListener _listener) {
            this.listener = _listener;
        }

        @Override
        public int connectAttemptStarted(int default_connect_timeout) {
            return this.listener.connectAttemptStarted(default_connect_timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectSuccess(Transport transport, ByteBuffer remaining_initial_data) {
            ConnectListenerEx connectListenerEx = this;
            synchronized (connectListenerEx) {
                if (this.ok || this.failed) {
                    if (this.ok) {
                        Debug.out("Double doo doo");
                    }
                    return;
                }
                this.ok = true;
            }
            this.listener.connectSuccess(transport, remaining_initial_data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectFailure(Throwable failure_msg) {
            ConnectListenerEx connectListenerEx = this;
            synchronized (connectListenerEx) {
                if (this.ok || this.failed) {
                    return;
                }
                this.failed = true;
            }
            this.listener.connectFailure(failure_msg);
        }

        @Override
        public Object getConnectionProperty(String property_name) {
            return this.listener.getConnectionProperty(property_name);
        }
    }
}

