/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class CookieParser {
    public static boolean cookiesContain(String[] requiredCookies, String cookies) {
        if (cookies == null) {
            return false;
        }
        boolean[] cookieFound = new boolean[requiredCookies.length];
        String[] names = CookieParser.getCookiesNames(cookies);
        int j = 0;
        while (j < names.length) {
            String cookieName = names[j];
            int i = 0;
            while (i < requiredCookies.length) {
                if (requiredCookies[i].equals(cookieName)) {
                    cookieFound[i] = true;
                }
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < cookieFound.length) {
            if (!cookieFound[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] getCookiesNames(String cookies) {
        if (cookies == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(cookies, "; ");
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken();
            int separator = cookie.indexOf("=");
            if (separator <= -1) continue;
            names.add(cookie.substring(0, separator));
        }
        String[] result = names.toArray(new String[names.size()]);
        return result;
    }
}

