/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.browser.listeners.MessageCompletionListener;
import com.aelitis.azureus.util.ConstantsVuze;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public class BrowserMessage {
    public static final String MESSAGE_PREFIX = "AZMSG";
    public static final String MESSAGE_DELIM = ";";
    public static String MESSAGE_DELIM_ENCODED;
    public static final int NO_PARAM = 0;
    public static final int OBJECT_PARAM = 1;
    public static final int ARRAY_PARAM = 2;
    private String listenerId;
    private String operationId;
    private Map decodedParams;
    private ArrayList completionListeners = new ArrayList();
    private boolean completed;
    private boolean completeDelayed;
    private String referer;

    static {
        try {
            MESSAGE_DELIM_ENCODED = URLEncoder.encode(MESSAGE_DELIM, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MESSAGE_DELIM_ENCODED = MESSAGE_DELIM;
        }
    }

    public BrowserMessage(String listenerId, String operationId, Map<?, ?> params) {
        this.listenerId = listenerId;
        this.operationId = operationId;
        this.decodedParams = params;
    }

    public void addCompletionListener(MessageCompletionListener l) {
        this.completionListeners.add(l);
    }

    public void complete(boolean bOnlyNonDelayed, boolean success, Object data) {
        if (this.completed || bOnlyNonDelayed && this.completeDelayed) {
            return;
        }
        this.triggerCompletionListeners(success, data);
        this.completed = true;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable t) {
        try {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
            String out = "[" + this.getListenerId() + ":" + this.getOperationId() + "] " + message;
            diag_logger.log(out);
            if (t != null) {
                diag_logger.log(t);
            }
            if (ConstantsVuze.DIAG_TO_STDOUT) {
                System.out.println(out);
                if (t != null) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t2) {
            Debug.out(t2);
        }
    }

    public Map getDecodedMap() {
        return this.decodedParams == null ? Collections.EMPTY_MAP : this.decodedParams;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getReferer() {
        return this.referer;
    }

    public void removeCompletionListener(MessageCompletionListener l) {
        this.completionListeners.remove(l);
    }

    public void setCompleteDelayed(boolean bCompleteDelayed) {
        this.completeDelayed = bCompleteDelayed;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String toString() {
        return String.valueOf(this.listenerId) + "." + this.operationId + "(" + this.decodedParams + ")";
    }

    private void triggerCompletionListeners(boolean success, Object data) {
        for (MessageCompletionListener l : this.completionListeners) {
            try {
                l.completed(success, data);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }
}

