/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.lws.LWSDownload;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseTTTorrent;

public class LightWeightSeedManager {
    private static final LightWeightSeedManager singleton = new LightWeightSeedManager();
    private final Map lws_map = new HashMap();
    private boolean started;
    final Set<LWSDownload> dht_add_queue = new HashSet<LWSDownload>();
    private boolean borked;
    private DHTTrackerPlugin public_dht_tracker_plugin;
    private IPCInterface anon_dht_tracker_plugin;
    private DDBaseTTTorrent tttorrent;
    private TimerEventPeriodic timer;
    final AESemaphore init_sem = new AESemaphore("LWSM");

    public static LightWeightSeedManager getSingleton() {
        return singleton;
    }

    protected LightWeightSeedManager() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                LightWeightSeedManager.this.startUp();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() {
        block12: {
            LightWeightSeedManager lightWeightSeedManager = this;
            synchronized (lightWeightSeedManager) {
                if (this.started) {
                    return;
                }
                this.started = true;
            }
            boolean release_now = true;
            try {
                final PluginManager plugin_manager = AzureusCoreFactory.getSingleton().getPluginManager();
                PluginInterface pi = plugin_manager.getPluginInterfaceByClass(DHTTrackerPlugin.class);
                if (pi != null) {
                    final DHTTrackerPlugin plugin = (DHTTrackerPlugin)pi.getPlugin();
                    new AEThread2("LWS:waitForPlug", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                HashSet<LWSDownload> to_add;
                                plugin.waitUntilInitialised();
                                if (plugin.isRunning()) {
                                    LightWeightSeedManager.this.tttorrent = DDBaseImpl.getSingleton(AzureusCoreFactory.getSingleton()).getTTTorrent();
                                }
                                try {
                                    PluginInterface anon_pi = plugin_manager.getPluginInterfaceByID("azneti2phelper");
                                    if (anon_pi != null) {
                                        LightWeightSeedManager.this.anon_dht_tracker_plugin = anon_pi.getIPC();
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                2 e = this;
                                synchronized (e) {
                                    LightWeightSeedManager.this.public_dht_tracker_plugin = plugin;
                                    to_add = new HashSet<LWSDownload>(LightWeightSeedManager.this.dht_add_queue);
                                    LightWeightSeedManager.this.dht_add_queue.clear();
                                }
                                Iterator it = to_add.iterator();
                                while (it.hasNext()) {
                                    LightWeightSeedManager.this.addDownload((LWSDownload)it.next());
                                }
                            }
                            finally {
                                LightWeightSeedManager.this.init_sem.releaseForever();
                            }
                        }
                    }.start();
                    release_now = false;
                    break block12;
                }
                Set<LWSDownload> set = this.dht_add_queue;
                synchronized (set) {
                    this.borked = true;
                    this.dht_add_queue.clear();
                }
            }
            finally {
                if (release_now) {
                    this.init_sem.releaseForever();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightSeed add(String name, HashWrapper hash, URL url, File data_location, String network, LightWeightSeedAdapter adapter) throws Exception {
        LightWeightSeed lws;
        if (!TorrentUtils.isDecentralised(url)) {
            throw new Exception("Only decentralised torrents supported");
        }
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            if (this.lws_map.containsKey(hash)) {
                throw new Exception("Seed for hash '" + ByteFormatter.encodeString(hash.getBytes()) + "' already added");
            }
            lws = new LightWeightSeed(this, name, hash, url, data_location, network, adapter);
            this.lws_map.put(hash, lws);
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("LWSManager:timer", 60000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        LightWeightSeedManager.this.processTimer();
                    }
                });
            }
            this.log("Added LWS: " + name + ", " + UrlUtils.getMagnetURI(hash.getBytes()));
        }
        lws.start();
        return lws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightSeed get(HashWrapper hw) {
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            return (LightWeightSeed)this.lws_map.get(hw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTimer() {
        ArrayList to_process;
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            to_process = new ArrayList(this.lws_map.values());
        }
        int i = 0;
        while (i < to_process.size()) {
            try {
                ((LightWeightSeed)to_process.get(i)).checkDeactivation();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(LightWeightSeed lws) {
        lws.stop();
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            this.lws_map.remove(lws.getHash());
            if (this.lws_map.size() == 0 && this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.log("Added LWS: " + lws.getName() + ", " + UrlUtils.getMagnetURI(lws.getHash().getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToDHTTracker(LWSDownload download) {
        Set<LWSDownload> set = this.dht_add_queue;
        synchronized (set) {
            if (this.borked) {
                return;
            }
            if (this.public_dht_tracker_plugin == null) {
                this.dht_add_queue.add(download);
                return;
            }
        }
        this.init_sem.reserve();
        this.addDownload(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromDHTTracker(LWSDownload download) {
        Set<LWSDownload> set = this.dht_add_queue;
        synchronized (set) {
            if (this.borked) {
                return;
            }
            if (this.public_dht_tracker_plugin == null) {
                this.dht_add_queue.remove(download);
                return;
            }
        }
        this.init_sem.reserve();
        this.removeDownload(download);
    }

    protected void addDownload(LWSDownload download) {
        if (download.getLWS().getNetwork() == "Public") {
            this.public_dht_tracker_plugin.addDownload(download);
        } else if (this.anon_dht_tracker_plugin != null) {
            try {
                this.anon_dht_tracker_plugin.invoke("addDownloadToTracker", new Object[]{download, new HashMap()});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.tttorrent != null) {
            this.tttorrent.addDownload(download);
        }
    }

    protected void removeDownload(LWSDownload download) {
        if (download.getLWS().getNetwork() == "Public") {
            this.public_dht_tracker_plugin.removeDownload(download);
        } else if (this.anon_dht_tracker_plugin != null) {
            try {
                this.anon_dht_tracker_plugin.invoke("removeDownloadFromTracker", new Object[]{download, new HashMap()});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.tttorrent != null) {
            this.tttorrent.removeDownload(download);
        }
    }

    protected void log(String str) {
        Logger.log(new LogEvent(LogIDs.CORE, str));
    }

    protected void log(String str, Throwable e) {
        Logger.log(new LogEvent(LogIDs.CORE, str, e));
    }
}

