/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessController;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;

public abstract class FMFileImpl
implements FMFile {
    protected static final String READ_ACCESS_MODE = "r";
    protected static final String WRITE_ACCESS_MODE = "rw";
    private static final Map file_map = new HashMap();
    private static final AEMonitor file_map_mon = new AEMonitor("FMFile:map");
    private static final boolean OUTPUT_REOPEN_RELATED_ERRORS = true;
    private final FMFileManagerImpl manager;
    private final FMFileOwner owner;
    private int access_mode = 1;
    private File linked_file;
    private String canonical_path;
    private RandomAccessFile raf;
    private FMFileAccessController file_access;
    private File created_dirs_leaf;
    private List created_dirs;
    protected final AEMonitor this_mon = new AEMonitor("FMFile");
    private boolean clone;

    static {
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            @Override
            public void generate(IndentWriter writer) {
                FMFileImpl.generateEvidence(writer);
            }
        });
    }

    protected FMFileImpl(FMFileOwner _owner, FMFileManagerImpl _manager, File _file, int _type) throws FMFileManagerException {
        this.owner = _owner;
        this.manager = _manager;
        TOTorrentFile tf = this.owner.getTorrentFile();
        this.linked_file = this.manager.getFileLink(tf.getTorrent(), tf.getIndex(), _file);
        boolean file_was_created = false;
        boolean file_reserved = false;
        boolean ok = false;
        try {
            try {
                try {
                    this.canonical_path = this.linked_file.getCanonicalPath();
                    if (this.canonical_path.equals(this.linked_file.getPath())) {
                        this.canonical_path = this.linked_file.getPath();
                    }
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if (msg != null && msg.contains("There are no more files")) {
                        String abs_path = this.linked_file.getAbsolutePath();
                        String error = "Caught 'There are no more files' exception during file.getCanonicalPath(). os=[" + Constants.OSName + "], file.getPath()=[" + this.linked_file.getPath() + "], file.getAbsolutePath()=[" + abs_path + "]. ";
                        Debug.out(error, ioe);
                    }
                    throw ioe;
                }
                this.createDirs(this.linked_file);
                this.reserveFile();
                file_reserved = true;
                this.file_access = new FMFileAccessController(this, _type);
                ok = true;
            }
            catch (Throwable e) {
                if (file_was_created) {
                    this.linked_file.delete();
                }
                this.deleteDirs();
                if (e instanceof FMFileManagerException) {
                    throw (FMFileManagerException)e;
                }
                throw new FMFileManagerException("initialisation failed", e);
            }
        }
        finally {
            if (file_reserved && !ok) {
                this.releaseFile();
            }
        }
    }

    protected FMFileImpl(FMFileImpl basis) throws FMFileManagerException {
        this.owner = basis.owner;
        this.manager = basis.manager;
        this.linked_file = basis.linked_file;
        this.canonical_path = basis.canonical_path;
        this.clone = true;
        try {
            this.file_access = new FMFileAccessController(this, basis.file_access.getStorageType());
        }
        catch (Throwable e) {
            if (e instanceof FMFileManagerException) {
                throw (FMFileManagerException)e;
            }
            throw new FMFileManagerException("initialisation failed", e);
        }
    }

    protected FMFileManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.linked_file.toString();
    }

    @Override
    public boolean exists() {
        return this.linked_file.exists();
    }

    @Override
    public FMFileOwner getOwner() {
        return this.owner;
    }

    @Override
    public boolean isClone() {
        return this.clone;
    }

    @Override
    public void setStorageType(int new_type) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            boolean was_open = this.isOpen();
            if (was_open) {
                this.closeSupport(false);
            }
            try {
                this.file_access.setStorageType(new_type);
            }
            finally {
                if (was_open) {
                    this.openSupport("Re-open after storage type change");
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getStorageType() {
        return this.file_access.getStorageType();
    }

    @Override
    public int getAccessMode() {
        return this.access_mode;
    }

    protected void setAccessModeSupport(int mode) {
        this.access_mode = mode;
    }

    protected File getLinkedFile() {
        return this.linked_file;
    }

    @Override
    public void moveFile(File new_unlinked_file) throws FMFileManagerException {
        block17: {
            try {
                String new_canonical_path;
                this.this_mon.enter();
                TOTorrentFile tf = this.owner.getTorrentFile();
                File new_linked_file = this.manager.getFileLink(tf.getTorrent(), tf.getIndex(), new_unlinked_file);
                try {
                    try {
                        new_canonical_path = new_linked_file.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        String msg = ioe.getMessage();
                        if (msg != null && msg.contains("There are no more files")) {
                            String abs_path = new_linked_file.getAbsolutePath();
                            String error = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + new_linked_file.getPath() + "], new_file.getAbsolutePath()=[" + abs_path + "]. ";
                            Debug.out(error, ioe);
                        }
                        throw ioe;
                    }
                }
                catch (Throwable e) {
                    throw new FMFileManagerException("getCanonicalPath fails", e);
                }
                if (new_linked_file.exists()) {
                    throw new FMFileManagerException("moveFile fails - file '" + new_canonical_path + "' already exists");
                }
                boolean was_open = this.isOpen();
                this.close();
                this.createDirs(new_linked_file);
                if (!this.linked_file.exists() || FileUtil.renameFile(this.linked_file, new_linked_file)) {
                    this.linked_file = new_linked_file;
                    this.canonical_path = new_canonical_path;
                    this.reserveFile();
                    if (was_open) {
                        this.ensureOpen("moveFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                if (was_open) {
                    try {
                        this.ensureOpen("moveFile recovery");
                    }
                    catch (FMFileManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw new FMFileManagerException("moveFile fails");
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void renameFile(String new_name) throws FMFileManagerException {
        block17: {
            try {
                String new_canonical_path;
                this.this_mon.enter();
                File new_linked_file = new File(this.linked_file.getParentFile(), new_name);
                try {
                    try {
                        new_canonical_path = new_linked_file.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        String msg = ioe.getMessage();
                        if (msg != null && msg.contains("There are no more files")) {
                            String abs_path = new_linked_file.getAbsolutePath();
                            String error = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + new_linked_file.getPath() + "], new_file.getAbsolutePath()=[" + abs_path + "]. ";
                            Debug.out(error, ioe);
                        }
                        throw ioe;
                    }
                }
                catch (Throwable e) {
                    throw new FMFileManagerException("getCanonicalPath fails", e);
                }
                if (new_linked_file.exists()) {
                    throw new FMFileManagerException("renameFile fails - file '" + new_canonical_path + "' already exists");
                }
                boolean was_open = this.isOpen();
                this.close();
                if (!this.linked_file.exists() || this.linked_file.renameTo(new_linked_file)) {
                    this.linked_file = new_linked_file;
                    this.canonical_path = new_canonical_path;
                    this.reserveFile();
                    if (was_open) {
                        this.ensureOpen("renameFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                if (was_open) {
                    try {
                        this.ensureOpen("renameFile recovery");
                    }
                    catch (FMFileManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw new FMFileManagerException("renameFile fails");
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void ensureOpen(String reason) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (this.isOpen()) {
                return;
            }
            this.openSupport(reason);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getLengthSupport() throws FMFileManagerException {
        try {
            return this.file_access.getLength(this.raf);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                return this.file_access.getLength(this.raf);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    protected void setLengthSupport(long length) throws FMFileManagerException {
        try {
            this.file_access.setLength(this.raf, length);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.setLength(this.raf, length);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    protected void reopen(FMFileManagerException cause) throws Throwable {
        if (!cause.isRecoverable()) {
            throw cause;
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.file_access.aboutToOpen();
        this.raf = new RandomAccessFile(this.linked_file, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
        Debug.outNoStack("Recovered connection to " + this.getName() + " after access failure");
    }

    protected void openSupport(String reason) throws FMFileManagerException {
        if (this.raf != null) {
            throw new FMFileManagerException("file already open");
        }
        this.reserveAccess(reason);
        try {
            this.file_access.aboutToOpen();
            this.raf = new RandomAccessFile(this.linked_file, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
        }
        catch (FileNotFoundException e) {
            int st = this.file_access.getStorageType();
            boolean ok = false;
            try {
                this.linked_file.getParentFile().mkdirs();
                this.linked_file.createNewFile();
                this.raf = new RandomAccessFile(this.linked_file, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
                ok = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!ok) {
                Debug.printStackTrace(e);
                throw new FMFileManagerException("open fails", e);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException("open fails", e);
        }
    }

    protected void closeSupport(boolean explicit) throws FMFileManagerException {
        FMFileManagerException flush_exception = null;
        try {
            this.flush();
        }
        catch (FMFileManagerException e) {
            flush_exception = e;
        }
        if (this.raf == null) {
            if (explicit) {
                this.releaseFile();
                this.deleteDirs();
            }
        } else {
            try {
                try {
                    this.raf.close();
                }
                catch (Throwable e) {
                    throw new FMFileManagerException("close fails", e);
                }
            }
            finally {
                this.raf = null;
                if (explicit) {
                    this.releaseFile();
                }
            }
        }
        if (flush_exception != null) {
            throw flush_exception;
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    protected boolean isPieceCompleteProcessingNeeded(int piece_number) throws FMFileManagerException {
        return this.file_access.isPieceCompleteProcessingNeeded(piece_number);
    }

    protected void setPieceCompleteSupport(int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        this.file_access.setPieceComplete(this.raf, piece_number, piece_data);
    }

    @Override
    public void delete() throws FMFileManagerException {
        this.close();
        if (this.linked_file.exists() && !this.linked_file.delete()) {
            throw new FMFileManagerException("Failed to delete '" + this.linked_file + "'");
        }
    }

    protected void readSupport(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        this.readSupport(new DirectByteBuffer[]{buffer}, position);
    }

    protected void readSupport(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.file_access.read(this.raf, buffers, position);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.read(this.raf, buffers, position);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    protected void writeSupport(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        this.writeSupport(new DirectByteBuffer[]{buffer}, position);
    }

    protected void writeSupport(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.file_access.write(this.raf, buffers, position);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.write(this.raf, buffers, position);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.raf != null;
    }

    private void reserveFile() throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            ArrayList<Object[]> owners = (ArrayList<Object[]>)file_map.get(this.canonical_path);
            if (owners == null) {
                owners = new ArrayList<Object[]>();
                file_map.put(this.canonical_path, owners);
            }
            for (Object[] entry : owners) {
                String entry_name = ((FMFileOwner)entry[0]).getName();
                if (!this.owner.getName().equals(entry_name)) continue;
                Debug.out("reserve file - entry already present");
                entry[1] = Boolean.FALSE;
                return;
            }
            owners.add(new Object[]{this.owner, Boolean.FALSE, "<reservation>"});
        }
        finally {
            file_map_mon.exit();
        }
    }

    private void reserveAccess(String reason) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List owners = (List)file_map.get(this.canonical_path);
            Object[] my_entry = null;
            if (owners == null) {
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' has not been reserved (no entries), '" + this.owner.getName() + "'");
            }
            for (Object[] entry : owners) {
                String entry_name = ((FMFileOwner)entry[0]).getName();
                if (!this.owner.getName().equals(entry_name)) continue;
                my_entry = entry;
            }
            if (my_entry == null) {
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' has not been reserved (not found), '" + this.owner.getName() + "'");
            }
            my_entry[1] = this.access_mode == 2;
            my_entry[2] = reason;
            int read_access = 0;
            int write_access = 0;
            int write_access_lax = 0;
            TOTorrentFile my_torrent_file = this.owner.getTorrentFile();
            StringBuilder users_sb = owners.size() == 1 ? null : new StringBuilder(128);
            for (Object[] entry : owners) {
                FMFileOwner this_owner = (FMFileOwner)entry[0];
                if (((Boolean)entry[1]).booleanValue()) {
                    ++write_access;
                    TOTorrentFile this_tf = this_owner.getTorrentFile();
                    if (my_torrent_file != null && this_tf != null && my_torrent_file.getLength() == this_tf.getLength()) {
                        ++write_access_lax;
                    }
                    if (users_sb == null) continue;
                    if (users_sb.length() > 0) {
                        users_sb.append(",");
                    }
                    users_sb.append(this_owner.getName());
                    users_sb.append(" [write]");
                    continue;
                }
                ++read_access;
                if (users_sb == null) continue;
                if (users_sb.length() > 0) {
                    users_sb.append(",");
                }
                users_sb.append(this_owner.getName());
                users_sb.append(" [read]");
            }
            if (write_access > 1 || write_access == 1 && read_access > 0) {
                if (!COConfigurationManager.getBooleanParameter("File.strict.locking") && write_access_lax == write_access) {
                    return;
                }
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' is in use by '" + (users_sb == null ? "eh?" : users_sb.toString()) + "'");
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    private void releaseFile() {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List owners = (List)file_map.get(this.canonical_path);
            if (owners != null) {
                Iterator it = owners.iterator();
                while (it.hasNext()) {
                    Object[] entry = (Object[])it.next();
                    if (!this.owner.getName().equals(((FMFileOwner)entry[0]).getName())) continue;
                    it.remove();
                    break;
                }
                if (owners.size() == 0) {
                    file_map.remove(this.canonical_path);
                }
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    protected void createDirs(File target) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        this.deleteDirs();
        File parent = target.getParentFile();
        if (!parent.exists()) {
            ArrayList<File> new_dirs = new ArrayList<File>();
            File current = parent;
            while (current != null && !current.exists()) {
                new_dirs.add(current);
                current = current.getParentFile();
            }
            this.created_dirs_leaf = target;
            this.created_dirs = new ArrayList();
            if (FileUtil.mkdirs(parent)) {
                this.created_dirs = new_dirs;
            } else {
                try {
                    Thread.sleep(RandomUtils.nextInt(1000));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                FileUtil.mkdirs(parent);
                if (parent.isDirectory()) {
                    this.created_dirs = new_dirs;
                } else {
                    throw new FMFileManagerException("Failed to create parent directory '" + parent + "'");
                }
            }
        }
    }

    protected void deleteDirs() {
        if (this.clone) {
            return;
        }
        if (this.created_dirs_leaf != null) {
            if (!this.created_dirs_leaf.exists()) {
                for (File dir : this.created_dirs) {
                    File[] entries;
                    if (!dir.exists() || !dir.isDirectory() || (entries = dir.listFiles()) != null && entries.length != 0) break;
                    dir.delete();
                }
            }
            this.created_dirs_leaf = null;
            this.created_dirs = null;
        }
    }

    protected String getString() {
        File cPath = new File(this.canonical_path);
        String sPaths = cPath.equals(this.linked_file) ? "can/link=" + Debug.secretFileName(this.canonical_path) : "can=" + Debug.secretFileName(this.canonical_path) + ",link=" + Debug.secretFileName(this.linked_file.toString());
        return String.valueOf(sPaths) + ",raf=" + this.raf + ",acc=" + this.access_mode + ",ctrl = " + this.file_access.getString();
    }

    protected static void generateEvidence(IndentWriter writer) {
        writer.println(String.valueOf(file_map.size()) + " FMFile Reservations");
        try {
            writer.indent();
            try {
                file_map_mon.enter();
                for (String key : file_map.keySet()) {
                    List owners = (List)file_map.get(key);
                    Iterator it2 = owners.iterator();
                    String str = "";
                    while (it2.hasNext()) {
                        Object[] entry = (Object[])it2.next();
                        FMFileOwner owner = (FMFileOwner)entry[0];
                        Boolean write = (Boolean)entry[1];
                        String reason = (String)entry[2];
                        str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + owner.getName() + "[" + (write != false ? "write" : "read") + "/" + reason + "]";
                    }
                    writer.println(String.valueOf(Debug.secretFileName(key)) + " -> " + str);
                }
            }
            finally {
                file_map_mon.exit();
            }
            FMFileManagerImpl.generateEvidence(writer);
        }
        finally {
            writer.exdent();
        }
    }
}

