/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskAccessControllerInstance {
    private final int aggregation_request_limit;
    private final int aggregation_byte_limit;
    private final String name;
    final boolean enable_aggregation;
    final boolean invert_threads = !COConfigurationManager.getBooleanParameter("diskmanager.perf.queue.torrent.bias");
    final int max_threads;
    private int max_mb_queued;
    private final groupSemaphore max_mb_sem;
    private long request_bytes_queued;
    private long requests_queued;
    private long total_requests;
    private long total_single_requests_made;
    private long total_aggregated_requests_made;
    private long total_bytes;
    private long total_single_bytes;
    private long total_aggregated_bytes;
    private long io_time;
    private long io_count;
    private final requestDispatcher[] dispatchers;
    private long last_check = 0L;
    private final Map torrent_dispatcher_map = new HashMap();
    private static final int REQUEST_NUM_LOG_CHUNK = 100;
    private static final int REQUEST_BYTE_LOG_CHUNK = 0x100000;
    private int next_request_num_log = 100;
    private long next_request_byte_log = 0x100000L;
    static final ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };

    public DiskAccessControllerInstance(String _name, boolean _enable_aggregation, int _aggregation_request_limit, int _aggregation_byte_limit, int _max_threads, int _max_mb) {
        this.name = _name;
        this.enable_aggregation = _enable_aggregation;
        this.aggregation_request_limit = _aggregation_request_limit;
        this.aggregation_byte_limit = _aggregation_byte_limit;
        this.max_mb_queued = _max_mb;
        this.max_mb_sem = new groupSemaphore(this.max_mb_queued);
        this.max_threads = _max_threads;
        this.dispatchers = new requestDispatcher[this.invert_threads ? 1 : this.max_threads];
        int i = 0;
        while (i < this.dispatchers.length) {
            this.dispatchers[i] = new requestDispatcher(i);
            ++i;
        }
    }

    protected String getName() {
        return this.name;
    }

    protected long getBlockCount() {
        return this.max_mb_sem.getBlockCount();
    }

    protected long getQueueSize() {
        return this.requests_queued;
    }

    protected long getQueuedBytes() {
        return this.request_bytes_queued;
    }

    protected long getTotalRequests() {
        return this.total_requests;
    }

    protected long getTotalSingleRequests() {
        return this.total_single_requests_made;
    }

    protected long getTotalAggregatedRequests() {
        return this.total_aggregated_requests_made;
    }

    public long getTotalBytes() {
        return this.total_bytes;
    }

    public long getTotalSingleBytes() {
        return this.total_single_bytes;
    }

    public long getTotalAggregatedBytes() {
        return this.total_aggregated_bytes;
    }

    public long getIOTime() {
        return this.io_time;
    }

    public long getIOCount() {
        return this.io_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(DiskAccessRequestImpl request2) {
        requestDispatcher dispatcher;
        if (this.dispatchers.length == 1) {
            dispatcher = this.dispatchers[0];
        } else {
            Map map = this.torrent_dispatcher_map;
            synchronized (map) {
                TOTorrent torrent;
                long now = System.currentTimeMillis();
                boolean check = false;
                if (now - this.last_check > 60000L || now < this.last_check) {
                    check = true;
                    this.last_check = now;
                }
                if (check) {
                    Iterator it = this.torrent_dispatcher_map.values().iterator();
                    while (it.hasNext()) {
                        requestDispatcher d = (requestDispatcher)it.next();
                        long last_active = d.getLastRequestTime();
                        if (now - last_active > 60000L) {
                            it.remove();
                            continue;
                        }
                        if (now >= last_active) continue;
                        d.setLastRequestTime(now);
                    }
                }
                if ((dispatcher = (requestDispatcher)this.torrent_dispatcher_map.get(torrent = request2.getFile().getTorrentFile().getTorrent())) == null) {
                    int min_index = 0;
                    int min_size = Integer.MAX_VALUE;
                    int i = 0;
                    while (i < this.dispatchers.length) {
                        int size = this.dispatchers[i].size();
                        if (size == 0) {
                            min_index = i;
                            break;
                        }
                        if (size < min_size) {
                            min_size = size;
                            min_index = i;
                        }
                        ++i;
                    }
                    dispatcher = this.dispatchers[min_index];
                    this.torrent_dispatcher_map.put(torrent, dispatcher);
                }
                dispatcher.setLastRequestTime(now);
            }
        }
        dispatcher.queue(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued += (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = new_mb - old_mb;
            if (mb_diff > this.max_mb_queued) {
                this.max_mb_sem.releaseGroup(mb_diff - this.max_mb_queued);
                this.max_mb_queued = mb_diff;
            }
            ++this.requests_queued;
            if (this.requests_queued >= (long)this.next_request_num_log) {
                this.next_request_num_log += 100;
            }
            if (this.request_bytes_queued >= this.next_request_byte_log) {
                this.next_request_byte_log += 0x100000L;
            }
        }
        if (mb_diff > 0) {
            this.max_mb_sem.reserveGroup(mb_diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued -= (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = old_mb - new_mb;
            --this.requests_queued;
        }
        if (mb_diff > 0) {
            this.max_mb_sem.releaseGroup(mb_diff);
        }
    }

    protected String getString() {
        return String.valueOf(this.name) + ",agg=" + this.enable_aggregation + ",max_t=" + this.max_threads + ",max_mb=" + this.max_mb_queued + ",q_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.request_bytes_queued) + ",q_req=" + this.requests_queued + ",t_req=" + this.total_requests + ",t_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_bytes) + ",io=" + this.io_count;
    }

    public static void main(String[] args) {
        final groupSemaphore sem = new groupSemaphore(9);
        int i = 0;
        while (i < 10) {
            new Thread(){

                @Override
                public void run() {
                    int count = 0;
                    while (true) {
                        int group = RandomUtils.generateRandomIntUpto(10);
                        System.out.println(String.valueOf(Thread.currentThread().getName()) + " reserving " + group);
                        sem.reserveGroup(group);
                        try {
                            Thread.sleep(5 + RandomUtils.generateRandomIntUpto(5));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        sem.releaseGroup(group);
                        if (++count % 100 != 0) continue;
                        System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + count + " ops");
                    }
                }
            }.start();
            ++i;
        }
    }

    static /* synthetic */ long access$10(DiskAccessControllerInstance diskAccessControllerInstance) {
        return diskAccessControllerInstance.total_aggregated_requests_made;
    }

    static /* synthetic */ void access$11(DiskAccessControllerInstance diskAccessControllerInstance, long l) {
        diskAccessControllerInstance.total_aggregated_requests_made = l;
    }

    static /* synthetic */ int access$12(DiskAccessControllerInstance diskAccessControllerInstance) {
        return diskAccessControllerInstance.aggregation_request_limit;
    }

    static /* synthetic */ int access$13(DiskAccessControllerInstance diskAccessControllerInstance) {
        return diskAccessControllerInstance.aggregation_byte_limit;
    }

    static /* synthetic */ long access$14(DiskAccessControllerInstance diskAccessControllerInstance) {
        return diskAccessControllerInstance.io_time;
    }

    static /* synthetic */ void access$15(DiskAccessControllerInstance diskAccessControllerInstance, long l) {
        diskAccessControllerInstance.io_time = l;
    }

    static /* synthetic */ long access$16(DiskAccessControllerInstance diskAccessControllerInstance) {
        return diskAccessControllerInstance.total_aggregated_bytes;
    }

    static /* synthetic */ void access$17(DiskAccessControllerInstance diskAccessControllerInstance, long l) {
        diskAccessControllerInstance.total_aggregated_bytes = l;
    }

    protected static class groupSemaphore {
        private int value;
        private final List waiters = new LinkedList();
        private long blocks;

        protected groupSemaphore(int _value) {
            this.value = _value;
        }

        protected long getBlockCount() {
            return this.blocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reserveGroup(int num) {
            mutableInteger wait;
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (num <= this.value && this.waiters.size() == 0) {
                    this.value -= num;
                    return;
                }
                ++this.blocks;
                wait = new mutableInteger(num - this.value);
                this.value = 0;
                this.waiters.add(wait);
            }
            wait.reserve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void releaseGroup(int num) {
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (this.waiters.size() == 0) {
                    this.value += num;
                } else {
                    while (this.waiters.size() > 0) {
                        mutableInteger wait = (mutableInteger)this.waiters.get(0);
                        int wait_num = wait.getValue();
                        if (wait_num <= num) {
                            wait.release();
                            this.waiters.remove(0);
                            num -= wait_num;
                            continue;
                        }
                        wait.setValue(wait_num - num);
                        num = 0;
                        break;
                    }
                    this.value = num;
                }
                return;
            }
        }

        protected static class mutableInteger {
            private int i;
            private boolean released;

            protected mutableInteger(int _i) {
                this.i = _i;
            }

            protected int getValue() {
                return this.i;
            }

            protected void setValue(int _i) {
                this.i = _i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void release() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    this.released = true;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void reserve() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    if (this.released) {
                        return;
                    }
                    try {
                        int spurious_count = 0;
                        while (true) {
                            this.wait();
                            if (!this.released) {
                                if (++spurious_count > 1024) {
                                    Debug.out("DAC::mutableInteger: spurious wakeup limit exceeded");
                                    throw new RuntimeException("die die die");
                                }
                                Debug.out("DAC::mutableInteger: spurious wakeup, ignoring");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Semaphore: operation interrupted");
                    }
                }
            }
        }
    }

    protected class requestDispatcher {
        private final int index;
        final AEThread2[] threads;
        private int active_threads;
        final LinkedList requests;
        final Map request_map;
        private long last_request_map_tidy;
        final AESemaphore request_sem;
        final AESemaphore schedule_sem;
        private long last_request_time;

        protected requestDispatcher(int _index) {
            this.threads = new AEThread2[DiskAccessControllerInstance.this.invert_threads ? DiskAccessControllerInstance.this.max_threads : 1];
            this.requests = new LinkedList();
            this.request_map = new HashMap();
            this.request_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:request");
            this.schedule_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:schedule", 1);
            this.index = _index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue(DiskAccessRequestImpl request2) {
            if (tls.get() != null) {
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance diskAccessControllerInstance = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance.total_requests = diskAccessControllerInstance.total_requests + 1L;
                    DiskAccessControllerInstance diskAccessControllerInstance2 = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance2.total_single_requests_made = diskAccessControllerInstance2.total_single_requests_made + 1L;
                    DiskAccessControllerInstance diskAccessControllerInstance3 = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance3.total_bytes = diskAccessControllerInstance3.total_bytes + (long)request2.getSize();
                    DiskAccessControllerInstance diskAccessControllerInstance4 = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance4.total_single_bytes = diskAccessControllerInstance4.total_single_bytes + (long)request2.getSize();
                }
                try {
                    request2.runRequest();
                }
                catch (Throwable e) {
                    DiskAccessControllerInstance diskAccessControllerInstance = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance.io_count = diskAccessControllerInstance.io_count + 1L;
                    Debug.printStackTrace(e);
                }
            } else {
                DiskAccessControllerInstance.this.getSpaceAllowance(request2);
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance diskAccessControllerInstance = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance.total_requests = diskAccessControllerInstance.total_requests + 1L;
                    DiskAccessControllerInstance diskAccessControllerInstance5 = DiskAccessControllerInstance.this;
                    diskAccessControllerInstance5.total_bytes = diskAccessControllerInstance5.total_bytes + (long)request2.getSize();
                    boolean added = false;
                    int priority = request2.getPriority();
                    if (priority >= 0) {
                        int pos = 0;
                        for (DiskAccessRequestImpl r : this.requests) {
                            if (r.getPriority() < priority) {
                                this.requests.add(pos, request2);
                                added = true;
                                break;
                            }
                            ++pos;
                        }
                    }
                    if (!added) {
                        this.requests.add(request2);
                    }
                    if (DiskAccessControllerInstance.this.enable_aggregation) {
                        HashMap<Long, DiskAccessRequestImpl> m = (HashMap<Long, DiskAccessRequestImpl>)this.request_map.get(request2.getFile());
                        if (m == null) {
                            m = new HashMap<Long, DiskAccessRequestImpl>();
                            this.request_map.put(request2.getFile(), m);
                        }
                        m.put(new Long(request2.getOffset()), request2);
                        long now = SystemTime.getCurrentTime();
                        if (now < this.last_request_map_tidy || now - this.last_request_map_tidy > 30000L) {
                            this.last_request_map_tidy = now;
                            Iterator it = this.request_map.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                if (((HashMap)entry.getValue()).size() != 0 || ((CacheFile)entry.getKey()).isOpen()) continue;
                                it.remove();
                            }
                        }
                    }
                    this.request_sem.release();
                    this.requestQueued();
                }
            }
        }

        protected long getLastRequestTime() {
            return this.last_request_time;
        }

        protected void setLastRequestTime(long l) {
            this.last_request_time = l;
        }

        protected int size() {
            return this.requests.size();
        }

        protected void requestQueued() {
            if (this.active_threads < this.threads.length && (this.active_threads == 0 || this.requests.size() > 32)) {
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i] == null) {
                        ++this.active_threads;
                        final int thread_index = i;
                        this.threads[thread_index] = new AEThread2("DiskAccessController:dispatch(" + DiskAccessControllerInstance.this.getName() + ")[" + this.index + "/" + thread_index + "]", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                DiskAccessControllerInstance.tls.set(this);
                                while (true) {
                                    block36: {
                                        request = null;
                                        aggregated = null;
                                        try {
                                            if (requestDispatcher.access$2((requestDispatcher)requestDispatcher.this).invert_threads) {
                                                requestDispatcher.this.schedule_sem.reserve();
                                            }
                                            if (!requestDispatcher.this.request_sem.reserve(30000L)) break block36;
                                            var3_3 = requestDispatcher.this.requests;
                                            synchronized (var3_3) {
                                                request = (DiskAccessRequestImpl)requestDispatcher.this.requests.remove(0);
                                                if (requestDispatcher.access$2((requestDispatcher)requestDispatcher.this).enable_aggregation) {
                                                    file = request.getFile();
                                                    file_map = (HashMap<K, V>)requestDispatcher.this.request_map.get(file);
                                                    if (file_map == null) {
                                                        file_map = new HashMap<K, V>();
                                                    }
                                                    file_map.remove(new Long(request.getOffset()));
                                                    if (request.getPriority() < 0 && !request.isCancelled()) {
                                                        current = request;
                                                        aggregated_bytes = 0L;
                                                        try {
                                                            while (true) {
                                                                current_size = current.getSize();
                                                                end = current.getOffset() + (long)current_size;
                                                                next = (DiskAccessRequestImpl)file_map.remove(new Long(end));
                                                                if (next != null && !next.isCancelled() && next.canBeAggregatedWith(request)) {
                                                                    requestDispatcher.this.requests.remove(next);
                                                                    if (!requestDispatcher.this.request_sem.reserve(30000L)) {
                                                                        Debug.out("shouldn't happen");
                                                                    }
                                                                    if (aggregated == null) {
                                                                        aggregated = new ArrayList<DiskAccessRequestImpl>(8);
                                                                        aggregated.add(current);
                                                                        aggregated_bytes += (long)current_size;
                                                                    }
                                                                    aggregated.add(next);
                                                                    if (aggregated.size() <= DiskAccessControllerInstance.access$12(requestDispatcher.access$2(requestDispatcher.this)) && (aggregated_bytes += (long)next.getSize()) < (long)DiskAccessControllerInstance.access$13(requestDispatcher.access$2(requestDispatcher.this))) {
                                                                        current = next;
                                                                        continue;
                                                                    }
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        finally {
                                                            if (aggregated != null) {
                                                                v0 = requestDispatcher.access$2(requestDispatcher.this);
                                                                DiskAccessControllerInstance.access$11(v0, DiskAccessControllerInstance.access$10(v0) + 1L);
                                                            } else {
                                                                v1 = requestDispatcher.access$2(requestDispatcher.this);
                                                                DiskAccessControllerInstance.access$3(v1, DiskAccessControllerInstance.access$2(v1) + 1L);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        finally {
                                            if (requestDispatcher.access$2((requestDispatcher)requestDispatcher.this).invert_threads) {
                                                requestDispatcher.this.schedule_sem.release();
                                            }
                                        }
                                    }
                                    try {
                                        block38: {
                                            io_start = SystemTime.getHighPrecisionCounter();
                                            if (aggregated == null) break block38;
                                            requests = aggregated.toArray(new DiskAccessRequestImpl[aggregated.size()]);
                                            try {
                                                DiskAccessRequestImpl.runAggregated(request, requests);
                                            }
                                            finally {
                                                io_end = SystemTime.getHighPrecisionCounter();
                                                v3 = requestDispatcher.access$2(requestDispatcher.this);
                                                DiskAccessControllerInstance.access$15(v3, DiskAccessControllerInstance.access$14(v3) + (io_end - io_start));
                                                v4 = requestDispatcher.access$2(requestDispatcher.this);
                                                DiskAccessControllerInstance.access$9(v4, DiskAccessControllerInstance.access$8(v4) + 1L);
                                                i = 0;
                                                if (true) ** GOTO lbl108
                                            }
                                        }
                                        if (request != null) {
                                            try {
                                                request.runRequest();
                                                continue;
                                            }
                                            finally {
                                                io_end = SystemTime.getHighPrecisionCounter();
                                                v5 = requestDispatcher.access$2(requestDispatcher.this);
                                                DiskAccessControllerInstance.access$15(v5, DiskAccessControllerInstance.access$14(v5) + (io_end - io_start));
                                                v6 = requestDispatcher.access$2(requestDispatcher.this);
                                                DiskAccessControllerInstance.access$9(v6, DiskAccessControllerInstance.access$8(v6) + 1L);
                                                v7 = requestDispatcher.access$2(requestDispatcher.this);
                                                DiskAccessControllerInstance.access$7(v7, DiskAccessControllerInstance.access$6(v7) + (long)request.getSize());
                                                requestDispatcher.access$2(requestDispatcher.this).releaseSpaceAllowance(request);
                                                continue;
                                            }
                                        }
                                        var5_7 = requestDispatcher.this.requests;
                                        synchronized (var5_7) {
                                            if (requestDispatcher.this.requests.size() == 0) {
                                                requestDispatcher.this.threads[thread_index] = null;
                                                v8 = requestDispatcher.this;
                                                requestDispatcher.access$1(v8, requestDispatcher.access$0(v8) - 1);
                                                return;
                                            }
                                            continue;
                                        }
                                        do {
                                            r = requests[i];
                                            v10 = requestDispatcher.access$2(requestDispatcher.this);
                                            DiskAccessControllerInstance.access$17(v10, DiskAccessControllerInstance.access$16(v10) + (long)r.getSize());
                                            requestDispatcher.access$2(requestDispatcher.this).releaseSpaceAllowance(r);
                                            ++i;
lbl108:
                                            // 2 sources

                                        } while (i < requests.length);
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        continue;
                                    }
                                    break;
                                }
                            }
                        };
                        this.threads[thread_index].start();
                        break;
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ int access$0(requestDispatcher requestDispatcher2) {
            return requestDispatcher2.active_threads;
        }

        static /* synthetic */ void access$1(requestDispatcher requestDispatcher2, int n) {
            requestDispatcher2.active_threads = n;
        }

        static /* synthetic */ DiskAccessControllerInstance access$2(requestDispatcher requestDispatcher2) {
            return requestDispatcher2.DiskAccessControllerInstance.this;
        }
    }
}

