/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DHTLog {
    public static final boolean GLOBAL_BLOOM_TRACE = false;
    public static final boolean LOCAL_BLOOM_TRACE = false;
    public static final boolean CONTACT_VERIFY_TRACE = false;
    public static final boolean TRACE_VERSIONS = false;
    public static boolean logging_on = false;
    private static DHTLogger logger;

    protected static void setLogging(boolean on) {
        logging_on = on;
    }

    public static boolean isOn() {
        return logging_on;
    }

    public static void log(String str) {
        if (logging_on) {
            if (logger != null) {
                logger.log(str);
            } else {
                System.out.println(str);
            }
        }
    }

    public static void setLogger(DHTLogger l) {
        logger = l;
    }

    public static String getString(byte[] b) {
        if (logging_on) {
            return DHTLog.getString2(b);
        }
        return "";
    }

    public static String getString2(byte[] b) {
        String res = ByteFormatter.nicePrint(b);
        if (res.length() > 8) {
            res = String.valueOf(res.substring(0, 8)) + "...";
        }
        return res;
    }

    public static String getFullString(byte[] b) {
        return ByteFormatter.nicePrint(b);
    }

    public static String getString(HashWrapper w) {
        if (logging_on) {
            return DHTLog.getString(w.getHash());
        }
        return "";
    }

    public static String getString(DHTTransportContact[] contacts) {
        if (logging_on) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("{");
            int i = 0;
            while (i < contacts.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(DHTLog.getString(contacts[i].getID()));
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    public static String getString(DHTTransportContact contact) {
        if (logging_on) {
            return contact.getString();
        }
        return "";
    }

    public static String getString(List l) {
        if (logging_on) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("{");
            int i = 0;
            while (i < l.size()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(DHTLog.getString((DHTTransportContact)l.get(i)));
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    public static String getString(Set s) {
        if (logging_on) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("{");
            Iterator it = s.iterator();
            while (it.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append(DHTLog.getString((DHTTransportContact)it.next()));
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    public static String getString(Map s) {
        if (logging_on) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("{");
            Iterator it = s.keySet().iterator();
            while (it.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append(DHTLog.getString((HashWrapper)it.next()));
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    public static String getString(ByteArrayHashMap<?> s) {
        if (logging_on) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("{");
            List<byte[]> keys = s.keys();
            for (byte[] key : keys) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append(DHTLog.getString(key));
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    public static String getString(DHTTransportValue[] values) {
        if (logging_on) {
            if (values == null) {
                return "<null>";
            }
            StringBuilder sb = new StringBuilder(256);
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    sb.append(",");
                }
                DHTLog.getString(sb, values[i]);
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public static void getString(StringBuilder sb, DHTTransportValue value) {
        if (logging_on) {
            if (value == null) {
                sb.append("<null>");
            } else {
                sb.append(DHTLog.getString(value.getValue()));
                sb.append(" <");
                sb.append(value.isLocal() ? "loc" : "rem");
                sb.append(",flag=");
                sb.append(Integer.toHexString(value.getFlags()));
                sb.append(",life=");
                sb.append(value.getLifeTimeHours());
                sb.append(",rep=");
                sb.append(Integer.toHexString(value.getReplicationControl()));
                sb.append(",orig=");
                sb.append(value.getOriginator().getExternalAddress());
                sb.append(">");
            }
        }
    }

    public static String getString(DHTTransportValue value) {
        if (logging_on) {
            if (value == null) {
                return "<null>";
            }
            return String.valueOf(DHTLog.getString(value.getValue())) + " <" + (value.isLocal() ? "loc" : "rem") + ",flag=" + Integer.toHexString(value.getFlags()) + ",life=" + value.getLifeTimeHours() + ",rep=" + Integer.toHexString(value.getReplicationControl()) + ",orig=" + value.getOriginator().getExternalAddress() + ">";
        }
        return "";
    }
}

