/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;

public class RelatedContentSearcher
implements DistributedDatabaseTransferHandler {
    private static final boolean SEARCH_CVS_ONLY_DEFAULT = System.getProperty("azureus.rcm.search.cvs.only", "0").equals("1");
    private static final boolean TRACE_SEARCH = false;
    private static final int SEARCH_MIN_SEEDS_DEFAULT = -1;
    private static final int SEARCH_MIN_LEECHERS_DEFAULT = -1;
    private static final int SEARCH_POP_MIN_SEEDS_DEFAULT = 100;
    private static final int SEARCH_POP_MIN_LEECHERS_DEFAULT = 25;
    private static final int MAX_REMOTE_SEARCH_RESULTS = 30;
    private static final int MAX_REMOTE_SEARCH_CONTACTS = 50;
    private static final int MAX_REMOTE_SEARCH_MILLIS = 25000;
    private static final int REDUCED_REMOTE_SEARCH_MILLIS = 10000;
    private static final int MAX_LOCAL_POPULAR_RESULTS = 50;
    private static final int HARVEST_MAX_BLOOMS = 50;
    private static final int HARVEST_MAX_FAILS_HISTORY = 128;
    private static final int HARVEST_BLOOM_UPDATE_MILLIS = 900000;
    private static final int HARVEST_BLOOM_DISCARD_MILLIS = 3600000;
    private static final int HARVEST_BLOOM_OP_RESET_MILLIS = 300000;
    private static final int HARVEST_BLOOM_OP_RESET_TICKS = 10;
    private static final int HARVEST_BLOOM_SE_RESET_MILLIS = 60000;
    private static final int HARVEST_BLOOM_SE_RESET_TICKS = 2;
    private static final int KEY_BLOOM_LOAD_FACTOR = 8;
    private static final int KEY_BLOOM_MIN_BITS = 1000;
    private static final int KEY_BLOOM_MAX_BITS = 50000;
    private static final int KEY_BLOOM_MAX_ENTRIES = 6250;
    private volatile BloomFilter key_bloom_with_local;
    private volatile BloomFilter key_bloom_without_local;
    private volatile long last_key_bloom_update = -1L;
    private Set<String> ignore_words = new HashSet<String>();
    private ByteArrayHashMap<ForeignBloom> harvested_blooms;
    private ByteArrayHashMap<String> harvested_fails;
    private volatile BloomFilter harvest_op_requester_bloom;
    private volatile BloomFilter harvest_se_requester_bloom;
    private final AsyncDispatcher harvest_dispatcher;
    private final RelatedContentManager manager;
    private final DistributedDatabaseTransferType transfer_type;
    private final DHTPluginInterface dht_plugin;
    private DistributedDatabase ddb;

    protected RelatedContentSearcher(RelatedContentManager _manager, DistributedDatabaseTransferType _transfer_type, DHTPluginInterface _dht_plugin, boolean _defer_ddb_check) {
        String[] lame_entries;
        String ignore = "a, in, of, at, the, and, or, if, to, an, for, with";
        String[] stringArray = lame_entries = ignore.toLowerCase(Locale.US).split(",");
        int n = lame_entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if ((entry = entry.trim()).length() > 0) {
                this.ignore_words.add(entry);
            }
            ++n2;
        }
        this.harvested_blooms = new ByteArrayHashMap();
        this.harvested_fails = new ByteArrayHashMap();
        this.harvest_op_requester_bloom = BloomFilterFactory.createAddOnly(2048);
        this.harvest_se_requester_bloom = BloomFilterFactory.createAddRemove4Bit(512);
        this.harvest_dispatcher = new AsyncDispatcher();
        this.manager = _manager;
        this.transfer_type = _transfer_type;
        this.dht_plugin = _dht_plugin;
        if (!_defer_ddb_check) {
            this.checkDDB();
        }
    }

    protected DHTPluginInterface getDHTPlugin() {
        return this.dht_plugin;
    }

    protected void timerTick(boolean enabled, int tick_count) {
        this.checkDDB();
        if (enabled) {
            this.harvestBlooms();
            if (tick_count % 2 == 0) {
                this.harvest_se_requester_bloom = this.harvest_se_requester_bloom.getReplica();
            }
            if (tick_count % 10 == 0) {
                this.harvest_op_requester_bloom = this.harvest_op_requester_bloom.getReplica();
            }
        }
        this.checkKeyBloom();
        this.testKeyBloom();
    }

    private void checkDDB() {
        if (this.ddb == null) {
            try {
                List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(new String[]{this.dht_plugin.getNetwork()});
                if (ddbs.size() > 0) {
                    this.ddb = ddbs.get(0);
                    this.ddb.addTransferHandler(this.transfer_type, this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected SearchInstance searchRCM(Map<String, Object> search_parameters, SearchObserver _observer) throws SearchException {
        final String term = this.fixupTerm((String)search_parameters.get("s"));
        boolean is_popular = this.isPopularity(term);
        final int min_seeds = ImportExportUtils.importInt(search_parameters, "z", is_popular ? 100 : -1);
        final int min_leechers = ImportExportUtils.importInt(search_parameters, "l", is_popular ? 25 : -1);
        final MySearchObserver observer = new MySearchObserver(_observer, min_seeds, min_leechers);
        final SearchInstance si = new SearchInstance(){

            @Override
            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            observer.complete();
        } else {
            new AEThread2("RCM:search", true){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.start();
        }
        return si;
    }

    private String fixupTerm(String term) {
        if (term == null) {
            return null;
        }
        if (term.contains("|")) {
            while (term.contains(" |")) {
                term = term.replaceAll(" \\|", "|");
            }
            while (term.contains("| ")) {
                term = term.replaceAll("\\| ", "|");
            }
        }
        term = this.transformTerm(term);
        return term;
    }

    private String escapeTag(String tag) {
        if (tag.contains(" ")) {
            tag = tag.replaceAll(" ", "+");
        }
        return tag;
    }

    private String unescapeTag(String tag) {
        if (tag.contains("+")) {
            tag = tag.replaceAll("\\+", " ");
        }
        return tag;
    }

    private String transformTerm(String term) {
        Pattern p = Pattern.compile("\"([^\"]+)\"");
        Matcher m = p.matcher(term);
        boolean result = m.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            while (result) {
                String str = m.group(1);
                if (str.contains(" ")) {
                    str = str.replaceAll("\\s+", " ");
                    str = "(" + str.replaceAll(" ", ".*?") + ")";
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(str));
                result = m.find();
            }
            m.appendTail(sb);
            term = sb.toString();
        }
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RelatedContent> matchContent(String term, int min_seeds, int min_leechers, boolean is_local, boolean search_cvs_only) {
        int max;
        Iterator<RelatedContentManager.DownloadInfo> it2;
        final boolean is_popularity = this.isPopularity(term);
        String[] bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
        int[] bit_types = new int[bits.length];
        Pattern[] bit_patterns = new Pattern[bits.length];
        int i = 0;
        while (i < bits.length) {
            bits[i] = bits[i].trim();
            String bit = bits[i];
            if (bit.length() > 0) {
                char c = bit.charAt(0);
                if (c == '+') {
                    bit_types[i] = 1;
                    bit = bits[i] = bit.substring(1);
                } else if (c == '-') {
                    bit_types[i] = 2;
                    bit = bits[i] = bit.substring(1);
                }
                if (bit.startsWith("(") && bit.endsWith(")")) {
                    bit = bit.substring(1, bit.length() - 1);
                    try {
                        if (!RegExUtil.mightBeEvil(bit)) {
                            bit_patterns[i] = Pattern.compile(bit, 2);
                        }
                    }
                    catch (Throwable throwable) {}
                } else if (bit.contains("|") && !bit.contains("tag:")) {
                    try {
                        if (!RegExUtil.mightBeEvil(bit)) {
                            bit_patterns[i] = Pattern.compile(bit, 2);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        HashMap<String, RelatedContentManager.DownloadInfo> result = new HashMap<String, RelatedContentManager.DownloadInfo>();
        Iterator<RelatedContentManager.DownloadInfo> it1 = this.getDHTInfos(search_cvs_only).iterator();
        Object object = this.manager.rcm_lock;
        synchronized (object) {
            it2 = new ArrayList<RelatedContentManager.DownloadInfo>(RelatedContentManager.transient_info_cache.values()).iterator();
        }
        Iterator<RelatedContentManager.DownloadInfo> it3 = this.manager.getRelatedContentAsList().iterator();
        Iterator[] iteratorArray = new Iterator[]{it1, it2, it3};
        int n = iteratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator it = iteratorArray[n2];
            while (it.hasNext()) {
                RelatedContentManager.DownloadInfo c = (RelatedContentManager.DownloadInfo)it.next();
                if (c.getSeeds() < min_seeds || c.getLeechers() < min_leechers) continue;
                String title = c.getTitle();
                String lc_title = c.getTitle().toLowerCase();
                boolean match = true;
                boolean at_least_one = false;
                byte[] hash = c.getHash();
                if (term.startsWith("hash:") && hash != null && term.substring(5).equals(Base32.encode(hash))) {
                    at_least_one = true;
                } else if (title.equalsIgnoreCase(term) && term.trim().length() > 0) {
                    at_least_one = true;
                } else {
                    int i2 = 0;
                    while (i2 < bits.length) {
                        String bit = bits[i2];
                        if (bit.length() > 0) {
                            boolean hit;
                            if (bit_patterns[i2] == null) {
                                String[] sub_bits = bit.split("\\|");
                                hit = false;
                                String[] stringArray = sub_bits;
                                int n3 = sub_bits.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String sub_bit = stringArray[n4];
                                    if (sub_bit.startsWith("tag:")) {
                                        String[] tags = c.getTags();
                                        hit = false;
                                        if (tags != null && tags.length > 0) {
                                            String target_tag = sub_bit.substring(4).toLowerCase(Locale.US);
                                            target_tag = this.unescapeTag(target_tag);
                                            target_tag = this.manager.truncateTag(target_tag);
                                            String[] stringArray2 = tags;
                                            int n5 = tags.length;
                                            int n6 = 0;
                                            while (n6 < n5) {
                                                String t = stringArray2[n6];
                                                if (t.startsWith(target_tag)) {
                                                    hit = true;
                                                    break;
                                                }
                                                ++n6;
                                            }
                                        }
                                    } else {
                                        hit = lc_title.contains(sub_bit);
                                    }
                                    if (!hit) {
                                        ++n4;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                hit = bit_patterns[i2].matcher(lc_title).find();
                            }
                            int type = bit_types[i2];
                            if (hit) {
                                if (type == 2) {
                                    match = false;
                                    break;
                                }
                                at_least_one = true;
                            } else if (type == 2) {
                                at_least_one = true;
                            } else {
                                match = false;
                                break;
                            }
                        }
                        ++i2;
                    }
                }
                if (!match || !at_least_one) continue;
                String key = hash != null ? Base32.encode(hash) : this.manager.getPrivateInfoKey(c);
                result.put(key, c);
            }
            ++n2;
        }
        List<RelatedContent> list = new ArrayList<RelatedContent>(result.values());
        int n7 = is_local ? (is_popularity ? 50 : Integer.MAX_VALUE) : (max = 30);
        if (list.size() > max) {
            Collections.sort(list, new Comparator<RelatedContent>(){

                @Override
                public int compare(RelatedContent o1, RelatedContent o2) {
                    if (is_popularity) {
                        int v2;
                        int v1 = o1.getVersion();
                        if (v1 == (v2 = o2.getVersion())) {
                            long sl1 = o1.getSeeds() + o1.getLeechers();
                            long sl2 = o2.getSeeds() + o2.getLeechers();
                            long diff = sl2 - sl1;
                            if (diff < 0L) {
                                return -1;
                            }
                            if (diff > 0L) {
                                return 1;
                            }
                            return 0;
                        }
                        return v2 - v1;
                    }
                    return o2.getRank() - o1.getRank();
                }
            });
            list = list.subList(0, max);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DistributedDatabaseContact> sendRemoteSearch(SearchInstance si, Set<String> hashes_sync_me, final DistributedDatabaseContact contact, String term, int min_seeds, int min_leechers, final SearchObserver _observer) {
        SearchObserver observer = new SearchObserver(){

            @Override
            public void resultReceived(SearchInstance search, SearchResult result) {
                RelatedContentSearcher.logSearch("    result from " + contact.getName());
                _observer.resultReceived(search, result);
            }

            @Override
            public Object getProperty(int property) {
                return _observer.getProperty(property);
            }

            @Override
            public void complete() {
                _observer.complete();
            }

            @Override
            public void cancelled() {
                _observer.cancelled();
            }
        };
        try {
            DistributedDatabaseKey key;
            DistributedDatabaseValue value;
            Boolean supports_duplicates = (Boolean)observer.getProperty(2);
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("t", term);
            if (SEARCH_CVS_ONLY_DEFAULT) {
                request2.put("n", "c");
            }
            if (min_seeds > 0) {
                request2.put("s", Long.valueOf(min_seeds));
            }
            if (min_leechers > 0) {
                request2.put("l", Long.valueOf(min_leechers));
            }
            if ((value = contact.read(null, this.transfer_type, key = this.ddb.createKey(BEncoder.encode(request2)), contact.getAddress().isUnresolved() ? 20000 : 10000)) == null) {
            }
            Map<String, Object> reply = BDecoder.decode((byte[])value.getValue(byte[].class));
            List list = (List)reply.get("l");
            if (list != null) {
                for (final Map map : list) {
                    final String title = ImportExportUtils.importString(map, "n");
                    final byte[] hash = (byte[])map.get("h");
                    if (hash == null) continue;
                    String hash_str = Base32.encode(hash);
                    Set<String> set = hashes_sync_me;
                    synchronized (set) {
                        if (hashes_sync_me.contains(hash_str)) {
                            if (supports_duplicates == null || !supports_duplicates.booleanValue()) {
                                continue;
                            }
                        } else {
                            hashes_sync_me.add(hash_str);
                        }
                    }
                    long version = ImportExportUtils.importLong(map, "v", 0L);
                    SearchResult result = new SearchResult(){

                        /*
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public Object getProperty(int property_name) {
                            try {
                                if (property_name == 22) {
                                    return ImportExportUtils.importLong(map, "v", 0L);
                                }
                                if (property_name == 1) {
                                    return title;
                                }
                                if (property_name == 3) {
                                    return ImportExportUtils.importLong(map, "s");
                                }
                                if (property_name == 21) {
                                    return hash;
                                }
                                if (property_name == 17) {
                                    return ImportExportUtils.importLong(map, "r") / 4L;
                                }
                                if (property_name == 6) {
                                    long cnet = ImportExportUtils.importLong(map, "c", -1L);
                                    if (cnet == -1L) {
                                        return 0L;
                                    }
                                    return 1L;
                                }
                                if (property_name == 5) {
                                    return ImportExportUtils.importLong(map, "z");
                                }
                                if (property_name == 4) {
                                    return ImportExportUtils.importLong(map, "l");
                                }
                                if (property_name == 2) {
                                    long date = ImportExportUtils.importLong(map, "p", 0L) * 60L * 60L * 1000L;
                                    if (date <= 0L) {
                                        return null;
                                    }
                                    return new Date(date);
                                }
                                if (property_name == 23 || property_name == 12 || property_name == 16) {
                                    byte[] hash2 = (byte[])map.get("h");
                                    if (hash2 != null) {
                                        return UrlUtils.getMagnetURI(hash2, title, RelatedContentManager.convertNetworks((byte)ImportExportUtils.importLong(map, "o", 1L)));
                                    }
                                } else if (property_name == 7) {
                                    String[] tags = RelatedContentSearcher.this.manager.decodeTags((byte[])map.get("g"));
                                    if (tags != null) {
                                        String[] stringArray = tags;
                                        int n = tags.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String tag = stringArray[n2];
                                            if (!tag.startsWith("_")) {
                                                return tag;
                                            }
                                            ++n2;
                                        }
                                    }
                                } else {
                                    if (property_name == 50000) {
                                        long cnet = ImportExportUtils.importLong(map, "c", -1L);
                                        return cnet;
                                    }
                                    if (property_name == 50001) {
                                        return map.get("k");
                                    }
                                    if (property_name == 50002) {
                                        return map.get("w");
                                    }
                                    if (property_name == 50003) {
                                        return RelatedContentSearcher.this.manager.decodeTags((byte[])map.get("g"));
                                    }
                                    if (property_name == 50004) {
                                        return RelatedContentManager.convertNetworks((byte)ImportExportUtils.importLong(map, "o", 1L));
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return null;
                        }
                    };
                    observer.resultReceived(si, result);
                }
            }
            list = (List)reply.get("c");
            ArrayList<DistributedDatabaseContact> contacts = new ArrayList<DistributedDatabaseContact>();
            if (list != null) {
                for (Map m : list) {
                    try {
                        Map map = (Map)m.get("m");
                        if (map != null) {
                            DistributedDatabaseContact ddb_contact = this.ddb.importContact(map);
                            contacts.add(ddb_contact);
                            continue;
                        }
                        String host = ImportExportUtils.importString(m, "a");
                        int port = ImportExportUtils.importInt(m, "p");
                        DistributedDatabaseContact ddb_contact = this.ddb.importContact(new InetSocketAddress(InetAddress.getByName(host), port), DHTTransportUDP.PROTOCOL_VERSION_MIN, contact.getDHT());
                        contacts.add(ddb_contact);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return contacts;
        }
        finally {
            return null;
        }
    }

    protected BloomFilter sendRemoteFetch(DistributedDatabaseContact contact) {
        try {
            Map<String, Object> reply;
            Map m;
            HashMap<String, String> request2 = new HashMap<String, String>();
            request2.put("x", "f");
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseValue value = contact.read(null, this.transfer_type, key, contact.getAddress().isUnresolved() ? 15000 : 5000);
            if (value != null && (m = (Map)(reply = BDecoder.decode((byte[])value.getValue(byte[].class))).get("f")) != null) {
                return BloomFilterFactory.deserialiseFromMap(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected BloomFilter sendRemoteUpdate(ForeignBloom f_bloom) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("x", "u");
            request2.put("s", new Long(f_bloom.getFilter().getEntryCount()));
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseContact contact = f_bloom.getContact();
            DistributedDatabaseValue value = contact.read(null, this.transfer_type, key, contact.getAddress().isUnresolved() ? 15000 : 5000);
            if (value != null) {
                Map<String, Object> reply = BDecoder.decode((byte[])value.getValue(byte[].class));
                Map m = (Map)reply.get("f");
                if (m != null) {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " updated");
                    return BloomFilterFactory.deserialiseFromMap(m);
                }
                if (reply.containsKey("s")) {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " same size");
                } else {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " update not supported yet");
                }
                return f_bloom.getFilter();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " update failed");
        return null;
    }

    protected Map<String, Object> receiveRemoteRequest(DistributedDatabaseContact originator, Map<String, Object> request2) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            boolean originator_is_neighbour = false;
            DHTPluginInterface.DHTInterface[] dhts = this.dht_plugin.getDHTInterfaces();
            byte[] originator_id = originator.getID();
            byte[] originator_bytes = AddressUtils.getAddressBytes(originator.getAddress());
            DHTPluginInterface.DHTInterface[] dHTInterfaceArray = dhts;
            int n = dhts.length;
            int n2 = 0;
            while (n2 < n) {
                DHTPluginInterface.DHTInterface d = dHTInterfaceArray[n2];
                List<DHTPluginContact> contacts = d.getClosestContacts(d.getID(), true);
                for (DHTPluginContact c : contacts) {
                    if (!Arrays.equals(c.getID(), originator_id)) continue;
                    originator_is_neighbour = true;
                    break;
                }
                if (originator_is_neighbour) break;
                ++n2;
            }
            String req_type = ImportExportUtils.importString(request2, "x");
            if (req_type != null) {
                boolean dup = this.harvest_op_requester_bloom.contains(originator_bytes);
                RelatedContentSearcher.logSearch("Received remote request: " + BDecoder.decodeStrings(request2) + " from " + originator.getAddress() + "/" + originator.getDHT() + ", dup=" + dup + ", bs=" + this.harvest_op_requester_bloom.getEntryCount());
                if (!dup) {
                    BloomFilter filter2;
                    this.harvest_op_requester_bloom.add(originator_bytes);
                    if (req_type.equals("f")) {
                        BloomFilter filter3 = this.getKeyBloom(!originator_is_neighbour);
                        if (filter3 != null) {
                            response.put("f", filter3.serialiseToMap());
                        }
                    } else if (req_type.equals("u") && (filter2 = this.getKeyBloom(!originator_is_neighbour)) != null) {
                        int existing_size = ImportExportUtils.importInt(request2, "s", 0);
                        if (existing_size != filter2.getEntryCount()) {
                            response.put("f", filter2.serialiseToMap());
                        } else {
                            response.put("s", new Long(existing_size));
                        }
                    }
                }
            } else {
                int hits = this.harvest_se_requester_bloom.count(originator_bytes);
                String term = ImportExportUtils.importString(request2, "t");
                term = this.fixupTerm(term);
                String network = ImportExportUtils.importString(request2, "n", "");
                boolean search_cvs_only = network.equals("c");
                int min_seeds = ImportExportUtils.importInt(request2, "s", -1);
                int min_leechers = ImportExportUtils.importInt(request2, "l", -1);
                RelatedContentSearcher.logSearch("Received remote search: '" + term + "' from " + originator.getAddress() + ", hits=" + hits + ", bs=" + this.harvest_se_requester_bloom.getEntryCount());
                if (hits < 10) {
                    this.harvest_se_requester_bloom.add(originator_bytes);
                    if (term != null) {
                        List<RelatedContent> matches = this.matchContent(term, min_seeds, min_leechers, false, search_cvs_only);
                        ArrayList l_list = new ArrayList();
                        int i = 0;
                        while (i < matches.size()) {
                            byte nets;
                            String[] tags;
                            byte[] ws_keys;
                            byte[] tracker_keys;
                            RelatedContent c = matches.get(i);
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            l_list.add(map);
                            ImportExportUtils.exportLong(map, "v", c.getVersion());
                            ImportExportUtils.exportString(map, "n", c.getTitle());
                            ImportExportUtils.exportLong(map, "s", c.getSize());
                            ImportExportUtils.exportLong(map, "r", c.getRank());
                            ImportExportUtils.exportLong(map, "d", c.getLastSeenSecs());
                            ImportExportUtils.exportLong(map, "p", c.getPublishDate() / 3600000L);
                            ImportExportUtils.exportLong(map, "l", c.getLeechers());
                            ImportExportUtils.exportLong(map, "z", c.getSeeds());
                            ImportExportUtils.exportLong(map, "c", c.getContentNetwork());
                            byte[] hash = c.getHash();
                            if (hash != null) {
                                map.put("h", hash);
                            }
                            if ((tracker_keys = c.getTrackerKeys()) != null) {
                                map.put("k", tracker_keys);
                            }
                            if ((ws_keys = c.getWebSeedKeys()) != null) {
                                map.put("w", ws_keys);
                            }
                            if ((tags = c.getTags()) != null) {
                                map.put("g", this.manager.encodeTags(tags));
                            }
                            if ((nets = c.getNetworksInternal()) != 0 && nets != 1) {
                                map.put("o", new Long(nets & 0xFF));
                            }
                            ++i;
                        }
                        response.put("l", l_list);
                        List<DistributedDatabaseContact> bloom_hits = this.searchForeignBlooms(term);
                        if (bloom_hits.size() > 0) {
                            ArrayList c_list = new ArrayList();
                            for (DistributedDatabaseContact c : bloom_hits) {
                                HashMap<String, Object> m = new HashMap<String, Object>();
                                c_list.add(m);
                                InetSocketAddress address = c.getAddress();
                                if (address.isUnresolved()) {
                                    m.put("m", c.exportToMap());
                                    continue;
                                }
                                m.put("a", address.getAddress().getHostAddress());
                                m.put("p", new Long(address.getPort()));
                            }
                            response.put("c", c_list);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return response;
    }

    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey ddb_key) throws DistributedDatabaseException {
        Object o_key = ddb_key.getKey();
        try {
            byte[] key = (byte[])o_key;
            Map<String, Object> request2 = BDecoder.decode(key);
            Map<String, Object> result = this.receiveRemoteRequest(contact, request2);
            return this.ddb.createValue(BEncoder.encode(result));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public DistributedDatabaseValue write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKeyBloom() {
        if (this.last_key_bloom_update == -1L || SystemTime.getMonotonousTime() - this.last_key_bloom_update > 600000L) {
            Object object = this.manager.rcm_lock;
            synchronized (object) {
                this.updateKeyBloom(this.manager.loadRelatedContent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BloomFilter getKeyBloom(boolean include_dht_local) {
        if (this.key_bloom_with_local == null) {
            Object object = this.manager.rcm_lock;
            synchronized (object) {
                this.updateKeyBloom(this.manager.loadRelatedContent());
            }
        }
        if (include_dht_local) {
            return this.key_bloom_with_local;
        }
        return this.key_bloom_without_local;
    }

    private List<String> getDHTWords(RelatedContentManager.DownloadInfo info) {
        byte[] hash;
        String title = info.getTitle();
        title = title.toLowerCase(Locale.US);
        char[] chars = title.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetterOrDigit(chars[i])) {
                chars[i] = 32;
            }
            ++i;
        }
        String[] words = new String(chars).split(" ");
        ArrayList<String> result = new ArrayList<String>(words.length);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() > 0 && !this.ignore_words.contains(word)) {
                result.add(word);
            }
            ++n2;
        }
        String[] tags = info.getTags();
        if (tags != null) {
            String[] stringArray2 = tags;
            int n3 = tags.length;
            n = 0;
            while (n < n3) {
                String tag = stringArray2[n];
                tag = this.escapeTag(tag);
                int i2 = 1;
                while (i2 <= tag.length()) {
                    result.add("tag:" + tag.substring(0, i2));
                    ++i2;
                }
                ++n;
            }
        }
        if ((hash = info.getHash()) != null) {
            result.add("hash:" + Base32.encode(hash));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKeyBloom(RelatedContentManager.ContentCache cc) {
        Object object = this.manager.rcm_lock;
        synchronized (object) {
            HashSet<String> dht_only_words = new HashSet<String>();
            HashSet<String> non_dht_words = new HashSet<String>();
            List<RelatedContentManager.DownloadInfo> dht_infos = this.getDHTInfos(SEARCH_CVS_ONLY_DEFAULT);
            Iterator<RelatedContentManager.DownloadInfo> it_dht = dht_infos.iterator();
            Iterator<RelatedContentManager.DownloadInfo> it_transient = RelatedContentManager.transient_info_cache.values().iterator();
            Iterator<RelatedContentManager.DownloadInfo> it_rc = cc.related_content.values().iterator();
            Iterator[] iteratorArray = new Iterator[]{it_transient, it_rc, it_dht};
            int n = iteratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Iterator it = iteratorArray[n2];
                while (it.hasNext()) {
                    RelatedContentManager.DownloadInfo di = (RelatedContentManager.DownloadInfo)it.next();
                    List<String> words = this.getDHTWords(di);
                    for (String string : words) {
                        if (it == it_dht) {
                            if (non_dht_words.contains(string)) continue;
                            dht_only_words.add(string);
                            continue;
                        }
                        non_dht_words.add(string);
                    }
                }
                ++n2;
            }
            int all_desired_bits = (dht_only_words.size() + non_dht_words.size()) * 8;
            all_desired_bits = Math.max(all_desired_bits, 1000);
            all_desired_bits = Math.min(all_desired_bits, 50000);
            BloomFilter all_bloom = BloomFilterFactory.createAddOnly(all_desired_bits);
            int non_dht_desired_bits = non_dht_words.size() * 8;
            non_dht_desired_bits = Math.max(non_dht_desired_bits, 1000);
            non_dht_desired_bits = Math.min(non_dht_desired_bits, 50000);
            BloomFilter non_dht_bloom = BloomFilterFactory.createAddOnly(non_dht_desired_bits);
            ArrayList non_dht_words_rand = new ArrayList(non_dht_words);
            Collections.shuffle(non_dht_words_rand);
            for (String word : non_dht_words_rand) {
                try {
                    byte[] bytes = word.getBytes("UTF8");
                    all_bloom.add(bytes);
                    if (all_bloom.getEntryCount() >= 6250) break;
                    if (non_dht_bloom.getEntryCount() >= 6250) continue;
                    non_dht_bloom.add(bytes);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayList dht_only_words_rand = new ArrayList(dht_only_words);
            Collections.shuffle(dht_only_words_rand);
            for (String string : dht_only_words_rand) {
                try {
                    byte[] bytes = string.getBytes("UTF8");
                    all_bloom.add(bytes);
                    if (all_bloom.getEntryCount() < 6250) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            RelatedContentSearcher.logSearch("blooms=" + all_bloom.getSize() + "/" + all_bloom.getEntryCount() + ", " + non_dht_bloom.getSize() + "/" + non_dht_bloom.getEntryCount() + ": rcm=" + cc.related_content.size() + ", trans=" + RelatedContentManager.transient_info_cache.size() + ", dht=" + dht_infos.size());
            this.key_bloom_with_local = all_bloom;
            this.key_bloom_without_local = non_dht_bloom;
            this.last_key_bloom_update = SystemTime.getMonotonousTime();
        }
    }

    private List<RelatedContentManager.DownloadInfo> getDHTInfos(boolean search_cvs_only) {
        List<DHTPluginValue> vals = search_cvs_only ? (this.dht_plugin instanceof DHTPlugin ? ((DHTPlugin)this.dht_plugin).getValues(1, false) : this.dht_plugin.getValues()) : this.dht_plugin.getValues();
        HashSet<String> unique_keys = new HashSet<String>();
        ArrayList<RelatedContentManager.DownloadInfo> dht_infos = new ArrayList<RelatedContentManager.DownloadInfo>();
        for (DHTPluginValue val : vals) {
            byte[] bytes;
            String test;
            if (val.isLocal() || !(test = new String(bytes = val.getValue())).startsWith("d1:d") || !test.endsWith("ee") || !test.contains("1:h20:")) continue;
            try {
                Map<String, Object> map = BDecoder.decode(bytes);
                RelatedContentManager.DownloadInfo info = this.manager.decodeInfo(map, null, 1, false, unique_keys);
                if (info == null) continue;
                dht_infos.add(info);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dht_infos;
    }

    private void testKeyBloom() {
    }

    private void harvestBlooms() {
        this.harvest_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                block43: {
                    if (RelatedContentSearcher.this.harvest_dispatcher.getQueueSize() > 0) {
                        return;
                    }
                    ForeignBloom oldest = null;
                    ByteArrayHashMap byteArrayHashMap = RelatedContentSearcher.this.harvested_blooms;
                    synchronized (byteArrayHashMap) {
                        for (ForeignBloom bloom : RelatedContentSearcher.this.harvested_blooms.values()) {
                            if (oldest != null && bloom.getLastUpdateTime() >= oldest.getLastUpdateTime()) continue;
                            oldest = bloom;
                        }
                    }
                    long now = SystemTime.getMonotonousTime();
                    if (oldest != null && now - oldest.getLastUpdateTime() > 900000L) {
                        DistributedDatabaseContact ddb_contact = oldest.getContact();
                        if (now - oldest.getCreateTime() > 3600000L && RelatedContentSearcher.this.harvested_blooms.size() >= 25) {
                            RelatedContentSearcher.logSearch("Harvest: discarding " + ddb_contact.getAddress());
                            ByteArrayHashMap byteArrayHashMap2 = RelatedContentSearcher.this.harvested_blooms;
                            synchronized (byteArrayHashMap2) {
                                RelatedContentSearcher.this.harvested_blooms.remove(ddb_contact.getID());
                            }
                        } else {
                            BloomFilter updated_filter = RelatedContentSearcher.this.sendRemoteUpdate(oldest);
                            if (updated_filter == null) {
                                ByteArrayHashMap byteArrayHashMap3 = RelatedContentSearcher.this.harvested_blooms;
                                synchronized (byteArrayHashMap3) {
                                    RelatedContentSearcher.this.harvested_blooms.remove(ddb_contact.getID());
                                    RelatedContentSearcher.this.harvested_fails.put(ddb_contact.getID(), "");
                                }
                            } else {
                                oldest.updateFilter(updated_filter);
                            }
                        }
                    }
                    if (RelatedContentSearcher.this.harvested_blooms.size() < 50) {
                        try {
                            DHTPluginInterface.DHTInterface[] dhts;
                            int fail_count = 0;
                            DHTPluginInterface.DHTInterface[] dHTInterfaceArray = dhts = RelatedContentSearcher.this.dht_plugin.getDHTInterfaces();
                            int n = dhts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DHTPluginInterface.DHTInterface dht = dHTInterfaceArray[n2];
                                if (!dht.isIPV6()) {
                                    int network = dht.getNetwork();
                                    if (SEARCH_CVS_ONLY_DEFAULT && network != 1) {
                                        RelatedContentSearcher.logSearch("Harvest: ignoring main DHT");
                                    } else {
                                        DHTPluginContact[] contacts = dht.getReachableContacts();
                                        byte[] dht_id = dht.getID();
                                        DHTPluginContact[] dHTPluginContactArray = contacts;
                                        int n3 = contacts.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            block42: {
                                                DHTPluginContact contact = dHTPluginContactArray[n4];
                                                byte[] contact_id = contact.getID();
                                                if (!Arrays.equals(dht_id, contact_id)) {
                                                    ByteArrayHashMap byteArrayHashMap4;
                                                    DistributedDatabaseContact ddb_contact = RelatedContentSearcher.this.importContact(contact, network);
                                                    ByteArrayHashMap byteArrayHashMap5 = RelatedContentSearcher.this.harvested_blooms;
                                                    synchronized (byteArrayHashMap5) {
                                                        if (RelatedContentSearcher.this.harvested_fails.containsKey(contact_id)) {
                                                            break block42;
                                                        }
                                                        if (RelatedContentSearcher.this.harvested_blooms.containsKey(contact_id)) {
                                                            break block42;
                                                        }
                                                    }
                                                    BloomFilter filter2 = RelatedContentSearcher.this.sendRemoteFetch(ddb_contact);
                                                    RelatedContentSearcher.logSearch("harvest: " + contact.getString() + " -> " + (filter2 == null ? "null" : filter2.getString()));
                                                    if (filter2 != null) {
                                                        byteArrayHashMap4 = RelatedContentSearcher.this.harvested_blooms;
                                                        synchronized (byteArrayHashMap4) {
                                                            RelatedContentSearcher.this.harvested_blooms.put(contact_id, new ForeignBloom(ddb_contact, filter2));
                                                            break block43;
                                                        }
                                                    }
                                                    byteArrayHashMap4 = RelatedContentSearcher.this.harvested_blooms;
                                                    synchronized (byteArrayHashMap4) {
                                                        RelatedContentSearcher.this.harvested_fails.put(contact_id, "");
                                                    }
                                                    if (++fail_count > 5) break block43;
                                                }
                                            }
                                            ++n4;
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                ByteArrayHashMap byteArrayHashMap = RelatedContentSearcher.this.harvested_blooms;
                synchronized (byteArrayHashMap) {
                    if (RelatedContentSearcher.this.harvested_fails.size() > 128) {
                        RelatedContentSearcher.this.harvested_fails.clear();
                    }
                }
            }
        });
    }

    private DistributedDatabaseContact importContact(DHTPluginContact contact, int network) throws DistributedDatabaseException {
        InetSocketAddress address = contact.getAddress();
        if (address.isUnresolved()) {
            return this.ddb.importContact(contact.exportToMap());
        }
        return this.ddb.importContact(address, DHTTransportUDP.PROTOCOL_VERSION_MIN, network == 1 ? 2 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void foreignBloomFailed(DistributedDatabaseContact contact) {
        byte[] contact_id = contact.getID();
        ByteArrayHashMap<ForeignBloom> byteArrayHashMap = this.harvested_blooms;
        synchronized (byteArrayHashMap) {
            if (this.harvested_blooms.remove(contact_id) != null) {
                this.harvested_fails.put(contact_id, "");
            }
        }
    }

    private boolean isPopularity(String term) {
        return term.equals("(.)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DistributedDatabaseContact> searchForeignBlooms(String term) {
        boolean is_popularity = this.isPopularity(term);
        ArrayList<DistributedDatabaseContact> result = new ArrayList<DistributedDatabaseContact>();
        try {
            String[] bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
            int[] bit_types = new int[bits.length];
            byte[][] bit_bytes = new byte[bit_types.length][];
            byte[][][] extras = new byte[bit_types.length][][];
            int i = 0;
            while (true) {
                if (i >= bits.length) {
                    ByteArrayHashMap<ForeignBloom> byteArrayHashMap = this.harvested_blooms;
                    synchronized (byteArrayHashMap) {
                        Iterator<ForeignBloom> iterator = this.harvested_blooms.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                return result;
                            }
                            ForeignBloom fb = iterator.next();
                            if (is_popularity) {
                                result.add(fb.getContact());
                                continue;
                            }
                            BloomFilter filter2 = fb.getFilter();
                            boolean failed = false;
                            int matches = 0;
                            int i2 = 0;
                            while (i2 < bit_bytes.length) {
                                block33: {
                                    int type;
                                    byte[] bit = bit_bytes[i2];
                                    if (bit != null && bit.length != 0 && (type = bit_types[i2]) != 3) {
                                        if (type == 0 || type == 1) {
                                            if (filter2.contains(bit)) {
                                                ++matches;
                                                break block33;
                                            } else {
                                                failed = true;
                                                break;
                                            }
                                        }
                                        if (type == 2) {
                                            if (!filter2.contains(bit)) {
                                                ++matches;
                                                break block33;
                                            } else {
                                                failed = true;
                                                break;
                                            }
                                        }
                                        if (type == 4) {
                                            byte[][] parts = extras[i2];
                                            int old_matches = matches;
                                            byte[][] byArray = parts;
                                            int n = parts.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                byte[] p = byArray[n2];
                                                if (filter2.contains(p)) {
                                                    ++matches;
                                                    break;
                                                }
                                                ++n2;
                                            }
                                            if (matches == old_matches) {
                                                failed = true;
                                                break;
                                            }
                                        }
                                    }
                                }
                                ++i2;
                            }
                            if (matches <= 0 || failed) continue;
                            result.add(fb.getContact());
                        }
                    }
                }
                String bit = bits[i].trim();
                if (bit.length() > 0) {
                    block34: {
                        char c = bit.charAt(0);
                        if (c == '+') {
                            bit_types[i] = 1;
                            bit = bit.substring(1);
                        } else if (c == '-') {
                            bit_types[i] = 2;
                            bit = bit.substring(1);
                        }
                        if (bit.startsWith("(") && bit.endsWith(")")) {
                            bit_types[i] = 3;
                        } else if (bit.contains("|")) {
                            String[] parts = bit.split("\\|");
                            ArrayList<String> p = new ArrayList<String>();
                            String[] stringArray = parts;
                            int n = parts.length;
                            int n3 = 0;
                            while (true) {
                                if (n3 >= n) {
                                    if (p.size() != 0) break;
                                    bit_types[i] = 3;
                                    break block34;
                                }
                                String part = stringArray[n3];
                                if ((part = part.trim()).length() > 0) {
                                    p.add(part);
                                }
                                ++n3;
                            }
                            bit_types[i] = 4;
                            extras[i] = new byte[p.size()][];
                            int j = 0;
                            while (j < p.size()) {
                                extras[i][j] = ((String)p.get(j)).getBytes("UTF8");
                                ++j;
                            }
                        }
                    }
                    bit_bytes[i] = bit.getBytes("UTF8");
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
        }
        return result;
    }

    private static void logSearch(String str) {
    }

    static /* synthetic */ List access$2(RelatedContentSearcher relatedContentSearcher, String string) {
        return relatedContentSearcher.searchForeignBlooms(string);
    }

    static /* synthetic */ DistributedDatabase access$3(RelatedContentSearcher relatedContentSearcher) {
        return relatedContentSearcher.ddb;
    }

    static /* synthetic */ List access$7(RelatedContentSearcher relatedContentSearcher, String string, int n, int n2, boolean bl, boolean bl2) {
        return relatedContentSearcher.matchContent(string, n, n2, bl, bl2);
    }

    private static class ForeignBloom {
        private DistributedDatabaseContact contact;
        private BloomFilter filter;
        private long created;
        private long last_update;

        private ForeignBloom(DistributedDatabaseContact _contact, BloomFilter _filter) {
            this.contact = _contact;
            this.filter = _filter;
            this.last_update = this.created = SystemTime.getMonotonousTime();
        }

        public DistributedDatabaseContact getContact() {
            return this.contact;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        public long getCreateTime() {
            return this.created;
        }

        public long getLastUpdateTime() {
            return this.last_update;
        }

        public void updateFilter(BloomFilter f) {
            this.filter = f;
            this.last_update = SystemTime.getMonotonousTime();
        }
    }

    private static class MySearchObserver
    implements SearchObserver {
        private final SearchObserver observer;
        private final int min_seeds;
        private final int min_leechers;
        private final AtomicInteger num_results = new AtomicInteger();

        private MySearchObserver(SearchObserver _observer, int _min_seeds, int _min_leechers) {
            this.observer = _observer;
            this.min_seeds = _min_seeds;
            this.min_leechers = _min_leechers;
        }

        @Override
        public void resultReceived(SearchInstance search, SearchResult result) {
            Number leechers;
            Number seeds;
            if (this.min_seeds > 0 && (seeds = (Number)result.getProperty(5)) != null && seeds.intValue() < this.min_seeds) {
                return;
            }
            if (this.min_leechers > 0 && (leechers = (Number)result.getProperty(4)) != null && leechers.intValue() < this.min_leechers) {
                return;
            }
            this.observer.resultReceived(search, result);
            RelatedContentSearcher.logSearch("results=" + this.num_results.incrementAndGet());
        }

        private int getResultCount() {
            return this.num_results.get();
        }

        @Override
        public void complete() {
            this.observer.complete();
        }

        @Override
        public void cancelled() {
            this.observer.cancelled();
        }

        @Override
        public Object getProperty(int property) {
            return this.observer.getProperty(property);
        }

        static /* synthetic */ int access$1(MySearchObserver mySearchObserver) {
            return mySearchObserver.getResultCount();
        }
    }
}

