/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.content.AzureusContent;
import com.aelitis.azureus.core.content.AzureusContentDirectory;
import com.aelitis.azureus.core.content.AzureusContentDirectoryListener;
import com.aelitis.azureus.core.content.AzureusContentDirectoryManager;
import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ConstantsVuze;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class AzureusPlatformContentDirectory
implements AzureusContentDirectory {
    private static boolean registered = false;
    private static TorrentAttribute ta_category;
    private static CopyOnWriteList<AzureusContentDirectoryListener> listeners;

    static {
        listeners = new CopyOnWriteList();
    }

    public static synchronized void register() {
        if (!registered) {
            registered = true;
            ta_category = PluginInitializer.getDefaultInterface().getTorrentManager().getAttribute("Category");
            AzureusContentDirectoryManager.registerDirectory(new AzureusPlatformContentDirectory());
        }
    }

    @Override
    public AzureusContent lookupContent(Map attributes) {
        AzureusPlatformContent azureusPlatformContent;
        byte[] hash = (byte[])attributes.get("btih");
        if (hash == null) {
            return null;
        }
        String url_str = ConstantsVuze.getDefaultContentNetwork().getTorrentDownloadService(Base32.encode(hash), null);
        ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
        ResourceDownloader rd = rdf.create(new URL(url_str));
        InputStream is = rd.download();
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
            azureusPlatformContent = new AzureusPlatformContent(new TorrentImpl(torrent));
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        is.close();
        return azureusPlatformContent;
    }

    @Override
    public AzureusContentDownload lookupContentDownload(Map attributes) {
        byte[] hash = (byte[])attributes.get("btih");
        try {
            final Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            if (download == null) {
            }
            return new AzureusContentDownload(){

                @Override
                public Download getDownload() {
                    return download;
                }

                @Override
                public Object getProperty(String name) {
                    return null;
                }
            };
        }
        finally {
            return null;
        }
    }

    @Override
    public AzureusContentFile lookupContentFile(Map attributes) {
        byte[] hash = (byte[])attributes.get("btih");
        int index = (Integer)attributes.get("file_index");
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            if (download == null) {
            }
            Torrent t_torrent = download.getTorrent();
            if (t_torrent == null) {
            }
            String ud_key = "AzureusPlatformContentDirectory:" + index;
            AzureusContentFile acf = (AzureusContentFile)download.getUserData(ud_key);
            if (acf != null) {
                return acf;
            }
            final TOTorrent torrent = ((TorrentImpl)t_torrent).getTorrent();
            final DiskManagerFileInfo file = download.getDiskManagerFileInfo(index);
            acf = PlatformTorrentUtils.isContent(torrent, false) ? new AzureusContentFile(){

                @Override
                public DiskManagerFileInfo getFile() {
                    return file;
                }

                @Override
                public Object getProperty(String name) {
                    block17: {
                        try {
                            if (name.equals("duration")) {
                                long duration = PlatformTorrentUtils.getContentVideoRunningTime(torrent);
                                if (duration > 0L) {
                                    return new Long(duration * 1000L);
                                }
                                break block17;
                            }
                            if (name.equals("video_width")) {
                                int[] res = PlatformTorrentUtils.getContentVideoResolution(torrent);
                                if (res != null) {
                                    return new Long(res[0]);
                                }
                                break block17;
                            }
                            if (name.equals("video_height")) {
                                int[] res = PlatformTorrentUtils.getContentVideoResolution(torrent);
                                if (res != null) {
                                    return new Long(res[1]);
                                }
                                break block17;
                            }
                            if (name.equals("date")) {
                                return new Long(file.getDownload().getCreationTime());
                            }
                            if (name.equals("cats")) {
                                try {
                                    String cat = file.getDownload().getCategoryName();
                                    if (cat != null && cat.length() > 0 && !cat.equalsIgnoreCase("Categories.uncategorized")) {
                                        return new String[]{cat};
                                    }
                                }
                                catch (Throwable cat) {
                                    // empty catch block
                                }
                                return new String[0];
                            }
                            if (name.equals("tags")) {
                                List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(PluginCoreUtils.unwrap(file.getDownload()));
                                ArrayList<String> tag_names = new ArrayList<String>();
                                for (Tag tag : tags) {
                                    if (tag.getTagType().getTagType() != 3) continue;
                                    tag_names.add(tag.getTagName(true));
                                }
                                return tag_names.toArray(new String[tag_names.size()]);
                            }
                            if (name.equals("percent")) {
                                long size = file.getLength();
                                return new Long(size == 0L ? 100L : 1000L * file.getDownloaded() / size);
                            }
                            if (name.equals("eta")) {
                                return AzureusPlatformContentDirectory.this.getETA(file);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            } : new AzureusContentFile(){

                @Override
                public DiskManagerFileInfo getFile() {
                    return file;
                }

                @Override
                public Object getProperty(String name) {
                    try {
                        if (name.equals("date")) {
                            return new Long(file.getDownload().getCreationTime());
                        }
                        if (name.equals("cats")) {
                            try {
                                String cat = file.getDownload().getCategoryName();
                                if (cat != null && cat.length() > 0 && !cat.equalsIgnoreCase("Categories.uncategorized")) {
                                    return new String[]{cat};
                                }
                            }
                            catch (Throwable cat) {
                                // empty catch block
                            }
                            return new String[0];
                        }
                        if (name.equals("tags")) {
                            List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(PluginCoreUtils.unwrap(file.getDownload()));
                            ArrayList<String> tag_names = new ArrayList<String>();
                            for (Tag tag : tags) {
                                if (tag.getTagType().getTagType() != 3) continue;
                                tag_names.add(tag.getTagName(true));
                            }
                            return tag_names.toArray(new String[tag_names.size()]);
                        }
                        if (name.equals("percent")) {
                            long size = file.getLength();
                            return new Long(size == 0L ? 100L : 1000L * file.getDownloaded() / size);
                        }
                        if (name.equals("eta")) {
                            return AzureusPlatformContentDirectory.this.getETA(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            };
            download.setUserData(ud_key, acf);
            final AzureusContentFile f_acf = acf;
            download.addAttributeListener(new DownloadAttributeListener(){

                @Override
                public void attributeEventOccurred(Download download, TorrentAttribute attribute, int eventType) {
                    AzureusPlatformContentDirectory.fireCatsChanged(f_acf);
                }
            }, ta_category, 1);
            TagManagerFactory.getTagManager().getTagType(3).addTagListener(PluginCoreUtils.unwrap(download), new TagListener(){

                @Override
                public void taggableSync(Tag tag) {
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    this.update(tagged);
                }

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    this.update(tagged);
                }

                private void update(Taggable tagged) {
                    AzureusPlatformContentDirectory.fireTagsChanged(f_acf);
                }
            });
            return acf;
        }
        finally {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getETA(DiskManagerFileInfo file) {
        try {
            if (file.getDownloaded() == file.getLength()) {
                return 0L;
            }
            if (file.isDeleted() || file.isSkipped()) {
                return Long.MAX_VALUE;
            }
            long eta = file.getDownload().getStats().getETASecs();
            if (eta < 0L) {
                return Long.MAX_VALUE;
            }
            return eta;
        }
        catch (Throwable e) {
            return Long.MAX_VALUE;
        }
    }

    public static void fireCatsChanged(AzureusContentFile acf) {
        for (AzureusContentDirectoryListener l : listeners) {
            l.contentChanged(acf, "cats");
        }
    }

    public static void fireTagsChanged(AzureusContentFile acf) {
        for (AzureusContentDirectoryListener l : listeners) {
            l.contentChanged(acf, "tags");
        }
    }

    @Override
    public void addListener(AzureusContentDirectoryListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeListener(AzureusContentDirectoryListener listener) {
        listeners.remove(listener);
    }

    private static class AzureusPlatformContent
    implements AzureusContent {
        private Torrent torrent;

        protected AzureusPlatformContent(Torrent _torrent) {
            this.torrent = _torrent;
        }

        @Override
        public Torrent getTorrent() {
            return this.torrent;
        }
    }
}

