/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.pf.file.FileHandler;
import org.pf.file.FileLocator;
import org.pf.file.FileWalker;

public class FileFinder
implements FileHandler {
    private List collectedFiles = null;

    protected List getCollectedFiles() {
        return this.collectedFiles;
    }

    protected void setCollectedFiles(List newValue) {
        this.collectedFiles = newValue;
    }

    protected FileFinder() {
        this.setCollectedFiles(new ArrayList());
    }

    public static File findFileOnClasspath(String filename) {
        URL url;
        File file;
        ClassLoader cl;
        block4: {
            cl = null;
            file = null;
            url = null;
            cl = FileFinder.class.getClassLoader();
            if (cl != null) break block4;
            return null;
        }
        try {
            url = cl.getResource(filename);
            if (url != null && !FileFinder.fileExists(file = new File(url.getFile()))) {
                file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static File findFile(String filename) {
        File aFile = null;
        aFile = new File(filename);
        if (FileFinder.fileExists(aFile)) {
            return aFile;
        }
        aFile = FileFinder.findFileOnClasspath(filename);
        return aFile;
    }

    public static File[] findFiles(String dir, String pattern) {
        return FileFinder.findFiles(dir, pattern, true);
    }

    public static File[] findFiles(String dir, String pattern, boolean recursive) {
        return FileFinder.findFiles(dir, pattern, recursive, '\u0000');
    }

    public static File[] findFiles(String dir, String pattern, boolean recursive, char digitWildcard) {
        Character digitChar = null;
        if (dir == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): dir is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): pattern is null");
        }
        if (digitWildcard > '\u0000') {
            digitChar = new Character(digitWildcard);
        }
        FileFinder finder = new FileFinder();
        return finder.collectFiles(dir, pattern, recursive, digitChar);
    }

    private static boolean fileExists(File file) {
        boolean success = false;
        if (file != null) {
            try {
                FileLocator locator = FileLocator.create(file);
                success = locator.exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    @Override
    public boolean handleFile(File file) {
        this.getCollectedFiles().add(file);
        return true;
    }

    @Override
    public boolean handleException(Exception ex, File file) {
        return false;
    }

    @Override
    public boolean directoryEnd(File dir) {
        return true;
    }

    @Override
    public boolean directoryStart(File dir, int count) {
        return true;
    }

    protected File[] collectFiles(String dir, String pattern, boolean recursive, Character digitWildcard) {
        FileWalker fileWalker = new FileWalker(this);
        if (digitWildcard != null) {
            fileWalker.setDigitWildcardChar(digitWildcard.charValue());
        }
        fileWalker.walkThrough(dir, pattern, recursive);
        List list = this.getCollectedFiles();
        return list.toArray(new File[list.size()]);
    }
}

