/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.util;

import java.math.BigInteger;

public class IPAddress {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    public static boolean isValid(String address) {
        return IPAddress.isValidIPv4(address) || IPAddress.isValidIPv6(address);
    }

    private static boolean isValidIPv4(String address) {
        int pos;
        if (address.length() == 0) {
            return false;
        }
        int octets = 0;
        String temp = String.valueOf(address) + ".";
        int start = 0;
        while (start < temp.length() && (pos = temp.indexOf(46, start)) > start) {
            BigInteger octet;
            if (octets == 4) {
                return false;
            }
            try {
                octet = new BigInteger(temp.substring(start, pos));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (octet.compareTo(ZERO) == -1 || octet.compareTo(BigInteger.valueOf(255L)) == 1) {
                return false;
            }
            start = pos + 1;
            ++octets;
        }
        return octets == 4;
    }

    private static boolean isValidIPv6(String address) {
        int pos;
        if (address.length() == 0) {
            return false;
        }
        int octets = 0;
        String temp = String.valueOf(address) + ":";
        int start = 0;
        while (start < temp.length() && (pos = temp.indexOf(58, start)) > start) {
            BigInteger octet;
            if (octets == 8) {
                return false;
            }
            try {
                octet = new BigInteger(temp.substring(start, pos), 16);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (octet.compareTo(ZERO) == -1 || octet.compareTo(BigInteger.valueOf(65535L)) == 1) {
                return false;
            }
            start = pos + 1;
            ++octets;
        }
        return octets == 8;
    }
}

