/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.BERSequence;
import org.gudy.bouncycastle.asn1.BERTaggedObject;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERObjectIdentifier;
import org.gudy.bouncycastle.asn1.DERTaggedObject;
import org.gudy.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class ContentInfo
implements DEREncodable,
PKCSObjectIdentifiers {
    private DERObjectIdentifier contentType;
    private DEREncodable content;

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ContentInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public ContentInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.contentType = (DERObjectIdentifier)e.nextElement();
        if (e.hasMoreElements()) {
            this.content = ((DERTaggedObject)e.nextElement()).getObject();
        }
    }

    public ContentInfo(DERObjectIdentifier contentType, DEREncodable content2) {
        this.contentType = contentType;
        this.content = content2;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DEREncodable getContent() {
        return this.content;
    }

    @Override
    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.contentType);
        if (this.content != null) {
            v.add(new BERTaggedObject(0, this.content));
        }
        return new BERSequence(v);
    }
}

