/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.gudy.azureus2.plugins.logging.LoggerChannel;

public class UpdateJarPatcher {
    private static String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    protected Map patch_entries = new HashMap();

    protected UpdateJarPatcher(InputStream input_file, InputStream patch_file, OutputStream output_file, LoggerChannel log) throws IOException {
        JarEntry os_entry;
        InputStream eis;
        JarEntry is_entry;
        this.readPatchEntries(patch_file);
        JarInputStream jis = new JarInputStream(input_file);
        JarOutputStream jos = new JarOutputStream(output_file);
        boolean manifest_found = false;
        while ((is_entry = jis.getNextJarEntry()) != null) {
            if (is_entry.isDirectory()) continue;
            String name = is_entry.getName();
            if (name.equalsIgnoreCase(MANIFEST_NAME)) {
                manifest_found = true;
            }
            if ((eis = this.getPatch(name)) != null) {
                log.log("patch - replace: " + name);
            } else {
                eis = jis;
            }
            os_entry = new JarEntry(name);
            UpdateJarPatcher.writeEntry(jos, os_entry, eis);
        }
        for (String name : this.patch_entries.keySet()) {
            if (name.equalsIgnoreCase(MANIFEST_NAME)) {
                manifest_found = true;
            }
            log.log("patch - add: " + name);
            eis = (InputStream)this.patch_entries.get(name);
            os_entry = new JarEntry(name);
            UpdateJarPatcher.writeEntry(jos, os_entry, eis);
        }
        if (!manifest_found) {
            JarEntry entry = new JarEntry(MANIFEST_NAME);
            ByteArrayInputStream bais = new ByteArrayInputStream("Manifest-Version: 1.0\r\n\r\n".getBytes());
            UpdateJarPatcher.writeEntry(jos, entry, bais);
        }
        jos.finish();
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(entry);
        byte[] newBytes = new byte[4096];
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
    }

    protected void readPatchEntries(InputStream is) throws IOException {
        JarEntry ent;
        JarInputStream jis = new JarInputStream(is);
        while ((ent = jis.getNextJarEntry()) != null) {
            int l;
            if (ent.isDirectory()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((l = jis.read(buffer)) > 0) {
                baos.write(buffer, 0, l);
            }
            this.patch_entries.put(ent.getName(), new ByteArrayInputStream(baos.toByteArray()));
        }
    }

    public InputStream getPatch(String name) {
        return (InputStream)this.patch_entries.remove(name);
    }
}

