/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

public class TorrentHost
extends TorrentCommand {
    public TorrentHost() {
        super("host", null, "Hosting");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                TRHost host = ci.azureus_core.getTrackerHost();
                TRHostTorrent existing = host.getHostTorrent(torrent);
                if (existing == null) {
                    ci.azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
                } else {
                    try {
                        existing.remove();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (TRHostException e) {
                e.printStackTrace(ci.out);
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean performCommand(ConsoleInput ci, TRHostTorrent torrent, List args) {
        try {
            torrent.remove();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getCommandDescriptions() {
        return "host (<torrentoptions>)\t\t\tHost or stop hosting torrent(s).";
    }
}

