/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public abstract class TorrentCommand
extends IConsoleCommand {
    private final String action;

    public TorrentCommand(String main_name, String short_name, String action) {
        super(main_name, short_name);
        this.action = action;
    }

    protected String getAction() {
        return this.action;
    }

    protected abstract boolean performCommand(ConsoleInput var1, DownloadManager var2, List<String> var3);

    protected boolean performCommand(ConsoleInput ci, TRHostTorrent torrent, List<String> args) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        block16: {
            if (!args.isEmpty()) {
                subcommand = args.remove(0);
                if (ci.torrents.isEmpty()) {
                    ci.out.println("> Command '" + this.getCommandName() + "': No torrents in list (Maybe you forgot to 'show torrents' first).");
                } else {
                    block17: {
                        try {
                            number = Integer.parseInt(subcommand);
                            if (number > 0 && number <= ci.torrents.size()) {
                                dm = (DownloadManager)ci.torrents.get(number - 1);
                                name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                                this.performCommandIfAllowed(ci, args, dm, "#" + subcommand, name);
                            } else {
                                ci.out.println("> Command '" + this.getCommandName() + "': Torrent #" + subcommand + " unknown.");
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            if (!"all".equalsIgnoreCase(subcommand)) break block17;
                            ** for (dm : ci.torrents)
                        }
lbl-1000:
                        // 1 sources

                        {
                            name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                            this.performCommandIfAllowed(ci, args, dm, subcommand, name);
                            continue;
lbl21:
                            // 1 sources

                            break block16;
                        }
                    }
                    if ("hash".equalsIgnoreCase(subcommand)) {
                        hash = args.remove(0);
                        torrents = ci.getGlobalManager().getDownloadManagers();
                        foundit = false;
                        for (DownloadManager dm : torrents) {
                            if (!hash.equals(TorrentUtils.nicePrintTorrentHash(dm.getTorrent(), true))) continue;
                            name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                            this.performCommandIfAllowed(ci, args, dm, hash, name);
                            foundit = true;
                            break;
                        }
                        if (!foundit && (host = ci.getCore().getTrackerHost()) != null) {
                            h_torrents = host.getTorrents();
                            i = 0;
                            while (i < h_torrents.length) {
                                ht = h_torrents[i];
                                if (hash.equals(TorrentUtils.nicePrintTorrentHash(ht.getTorrent(), true))) {
                                    name = TorrentUtils.getLocalisedName(ht.getTorrent());
                                    this.performCommandIfAllowed(ci, args, ht, hash, name);
                                    foundit = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (!foundit) {
                            ci.out.println("> Command '" + this.getCommandName() + "': Hash '" + hash + "' unknown.");
                        }
                    } else {
                        ci.out.println("> Command '" + this.getCommandName() + "': Subcommand '" + subcommand + "' unknown.");
                    }
                }
            } else {
                ci.out.println("> Missing subcommand for '" + this.getCommandName() + "'");
                this.printHelp(ci.out, args);
            }
        }
    }

    private void performCommandIfAllowed(ConsoleInput ci, List args, DownloadManager dm, String desc, String name) {
        if (!"admin".equals(ci.getUserProfile().getUserType())) {
            if ("user".equals(ci.getUserProfile().getUserType())) {
                String owner = dm.getDownloadState().getAttribute("user");
                if (!ci.getUserProfile().getUsername().equals(owner)) {
                    ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Users can only modify their own torrents");
                    return;
                }
            } else {
                ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Guests cannot modify torrents");
                return;
            }
        }
        if (this.performCommand(ci, dm, (List<String>)args)) {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") succeeded.");
        } else {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") failed.");
        }
    }

    private void performCommandIfAllowed(ConsoleInput ci, List args, TRHostTorrent torrent, String desc, String name) {
        if (!"admin".equals(ci.getUserProfile().getUserType()) && !"user".equals(ci.getUserProfile().getUserType())) {
            ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Guests cannot modify torrents");
            return;
        }
        if (this.performCommand(ci, torrent, (List<String>)args)) {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") succeeded.");
        } else {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") failed.");
        }
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> " + this.getCommandName() + " syntax: " + this.getCommandName() + " (<#>|all|hash <hash>)");
    }
}

