/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

public class TorrentArchive
extends TorrentCommand {
    public TorrentArchive() {
        super("torrent_archive", "tar", "Archiving");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        block4: {
            try {
                Download download = PluginCoreUtils.wrap(dm);
                if (!download.canStubbify()) {
                    ci.out.println("> Can't archive as torrent is not in archiveable state");
                    break block4;
                }
                download.stubbify();
                return true;
            }
            catch (DownloadRemovalVetoException e) {
                ci.out.println("> Veto when archiving torrent (" + e.getMessage() + ")");
            }
            catch (Exception e) {
                e.printStackTrace(ci.out);
            }
        }
        return false;
    }

    @Override
    public String getCommandDescriptions() {
        return "torrent_archive (<torrentoptions>)\tr\tArchive torrent(s).";
    }
}

