/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;
import org.gudy.azureus2.ui.console.util.TextWrap;

public class Plugin
extends IConsoleCommand {
    public Plugin() {
        super("plugin");
    }

    @Override
    public String getCommandDescriptions() {
        return "plugin [various options]\t\tRun with no parameter for more help.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("Subcommands:");
        out.println("install\t[pluginid]\tLists plugins available to install or installs a given plugin");
        out.println("location\t\tLists where plugins are being loaded from");
        out.println("list\t\t\tList all running plugins");
        out.println("listall\t\t\tList all plugins - running or not");
        out.println("status pluginid\t\tPrints the status of a given plugin");
        out.println("startup pluginid on|off\tEnables or disables the plugin running at startup");
        out.println("uninstall pluginid\t\tUninstalls a plugin");
        out.println("update\t\tUpdates all plugins with outstanding updates");
        out.println("> -----");
    }

    public void execute(String commandName, final ConsoleInput ci, List args) {
        if (args.isEmpty()) {
            this.printHelpExtra(ci.out, args);
            return;
        }
        String subcmd = (String)args.get(0);
        if (!Arrays.asList("location", "list", "listall", "status", "startup", "install", "uninstall", "update").contains(subcmd)) {
            ci.out.println("Invalid subcommand: " + subcmd);
            ci.out.println();
            return;
        }
        PluginManager plugin_manager = ci.getCore().getPluginManager();
        if (subcmd.equals("list") || subcmd.equals("listall")) {
            boolean all_plugins = subcmd.equals("listall");
            ci.out.println("> -----");
            PluginInterface[] plugins = plugin_manager.getPluginInterfaces();
            TreeSet<String> plugin_ids = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < plugins.length) {
                if (all_plugins || plugins[i].getPluginState().isOperational()) {
                    String plugin_id = plugins[i].getPluginID();
                    plugin_ids.add(plugin_id);
                }
                ++i;
            }
            TextWrap.printList(plugin_ids.iterator(), ci.out, "   ");
            ci.out.println("> -----");
            return;
        }
        if (subcmd.equals("location")) {
            String sAppPluginDir;
            String sUserPluginDir;
            File fUserPluginDir = FileUtil.getUserFile("plugins");
            String sep = File.separator;
            try {
                sUserPluginDir = fUserPluginDir.getCanonicalPath();
            }
            catch (Throwable e) {
                sUserPluginDir = fUserPluginDir.toString();
            }
            if (!sUserPluginDir.endsWith(sep)) {
                sUserPluginDir = String.valueOf(sUserPluginDir) + sep;
            }
            File fAppPluginDir = FileUtil.getApplicationFile("plugins");
            try {
                sAppPluginDir = fAppPluginDir.getCanonicalPath();
            }
            catch (Throwable e) {
                sAppPluginDir = fAppPluginDir.toString();
            }
            if (!sAppPluginDir.endsWith(sep)) {
                sAppPluginDir = String.valueOf(sAppPluginDir) + sep;
            }
            ci.out.println("Shared plugin location:");
            ci.out.println("  " + sAppPluginDir);
            ci.out.println("User plugin location:");
            ci.out.println("  " + sUserPluginDir);
            ci.out.println();
            return;
        }
        if (subcmd.equals("update")) {
            if (args.size() != 1) {
                ci.out.println("Usage: update");
                return;
            }
            UpdateManager update_manager = plugin_manager.getDefaultPluginInterface().getUpdateManager();
            UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
            checker.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                    Update[] updates = instance.getUpdates();
                    try {
                        Update[] updateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Update update = updateArray[n2];
                            ci.out.println("Updating " + update.getName());
                            ResourceDownloader[] resourceDownloaderArray = update.getDownloaders();
                            int n3 = resourceDownloaderArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ResourceDownloader rd = resourceDownloaderArray[n4];
                                rd.addListener(new ResourceDownloaderAdapter(){

                                    @Override
                                    public void reportActivity(ResourceDownloader downloader, String activity) {
                                        ci.out.println("\t" + activity);
                                    }

                                    @Override
                                    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                        ci.out.println("\t" + percentage + "%");
                                    }
                                });
                                rd.download();
                                ++n4;
                            }
                            ++n2;
                        }
                        boolean restart_required = false;
                        int i = 0;
                        while (i < updates.length) {
                            if (updates[i].getRestartRequired() == 2) {
                                restart_required = true;
                            }
                            ++i;
                        }
                        if (restart_required) {
                            ci.out.println("**** Restart required to complete update ****");
                        }
                    }
                    catch (Throwable e) {
                        ci.out.println("Plugin update failed: " + Debug.getNestedExceptionMessage(e));
                    }
                }
            });
            checker.start();
            return;
        }
        if (subcmd.equals("install")) {
            if (args.size() == 1) {
                ci.out.println("Contacting plugin repository for list of available plugins...");
                try {
                    SFPluginDetails[] plugins;
                    SFPluginDetails[] sAppPluginDir = plugins = SFPluginDetailsLoaderFactory.getSingleton().getPluginDetails();
                    int fAppPluginDir = plugins.length;
                    int sUserPluginDir = 0;
                    while (sUserPluginDir < fAppPluginDir) {
                        String id;
                        SFPluginDetails p = sAppPluginDir[sUserPluginDir];
                        String category = p.getCategory();
                        if ((category == null || !category.equalsIgnoreCase("hidden") && !category.equalsIgnoreCase("core")) && plugin_manager.getPluginInterfaceByID(id = p.getId(), false) == null) {
                            String desc = p.getDescription();
                            int pos = desc.indexOf("<br");
                            if (pos > 0) {
                                desc = desc.substring(0, pos);
                            }
                            ci.out.println("\t" + id + ": \t\t" + desc);
                        }
                        ++sUserPluginDir;
                    }
                }
                catch (Throwable e) {
                    ci.out.println("Failed to list plugins: " + Debug.getNestedExceptionMessage(e));
                }
            } else {
                String target_id = (String)args.get(1);
                if (plugin_manager.getPluginInterfaceByID(target_id, false) != null) {
                    ci.out.println("Plugin '" + target_id + "' already installed");
                    return;
                }
                final PluginInstaller installer = plugin_manager.getPluginInstaller();
                try {
                    final StandardPlugin sp = installer.getStandardPlugin(target_id);
                    if (sp == null) {
                        ci.out.println("Plugin '" + target_id + "' is unknown");
                        return;
                    }
                    new AEThread2("Plugin Installer"){

                        @Override
                        public void run() {
                            try {
                                HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                                properties.put(1, 3);
                                properties.put(3, true);
                                final AESemaphore sem = new AESemaphore("plugin-install");
                                final boolean[] restart_required = new boolean[1];
                                UpdateCheckInstance instance = installer.install(new InstallablePlugin[]{sp}, false, properties, new PluginInstallationListener(){

                                    @Override
                                    public void completed() {
                                        ci.out.println("Installation complete");
                                        sem.release();
                                    }

                                    @Override
                                    public void cancelled() {
                                        ci.out.println("Installation cancelled");
                                        sem.release();
                                    }

                                    @Override
                                    public void failed(PluginException e) {
                                        ci.out.println("Installation failed: " + Debug.getNestedExceptionMessage(e));
                                        sem.release();
                                    }
                                });
                                instance.addListener(new UpdateCheckInstanceListener(){

                                    @Override
                                    public void cancelled(UpdateCheckInstance instance) {
                                        ci.out.println("Installation cancelled");
                                    }

                                    @Override
                                    public void complete(UpdateCheckInstance instance) {
                                        Update[] updates;
                                        Update[] updateArray = updates = instance.getUpdates();
                                        int n = updates.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            ResourceDownloader[] rds;
                                            Update update = updateArray[n2];
                                            ResourceDownloader[] resourceDownloaderArray = rds = update.getDownloaders();
                                            int n3 = rds.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                ResourceDownloader rd = resourceDownloaderArray[n4];
                                                rd.addListener(new ResourceDownloaderAdapter(){

                                                    @Override
                                                    public void reportActivity(ResourceDownloader downloader, String activity) {
                                                        ci.out.println("\t" + activity);
                                                    }

                                                    @Override
                                                    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                                        ci.out.println("\t" + percentage + "%");
                                                    }
                                                });
                                                try {
                                                    rd.download();
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                ++n4;
                                            }
                                            if (update.getRestartRequired() != 1) {
                                                restart_required[0] = true;
                                            }
                                            ++n2;
                                        }
                                    }
                                });
                                sem.reserve();
                                if (restart_required[0]) {
                                    ci.out.println("**** Restart required to complete installation ****");
                                }
                            }
                            catch (Throwable e) {
                                ci.out.println("Install failed: " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                    }.start();
                }
                catch (Throwable e) {
                    ci.out.println("Install failed: " + Debug.getNestedExceptionMessage(e));
                }
            }
            return;
        }
        if (args.size() == 1) {
            ci.out.println("No plugin ID given.");
            ci.out.println();
            return;
        }
        String plugin_id = (String)args.get(1);
        PluginInterface plugin = plugin_manager.getPluginInterfaceByID(plugin_id, false);
        if (plugin == null) {
            ci.out.println("Invalid plugin ID: " + plugin_id);
            ci.out.println();
            return;
        }
        if (subcmd.equals("status")) {
            ci.out.println("ID     : " + plugin.getPluginID());
            ci.out.println("Name   : " + plugin.getPluginName());
            ci.out.println("Version: " + plugin.getPluginVersion());
            ci.out.println("Running: " + plugin.getPluginState().isOperational());
            ci.out.println("Runs at startup: " + plugin.getPluginState().isLoadedAtStartup());
            if (!plugin.getPluginState().isBuiltIn()) {
                ci.out.println("Location: " + plugin.getPluginDirectoryName());
            }
            ci.out.println();
            return;
        }
        if (subcmd.equals("startup")) {
            if (args.size() == 2) {
                ci.out.println("Need to pass either \"on\" or \"off\"");
                ci.out.println();
                return;
            }
            String enabled_mode = (String)args.get(2);
            if (enabled_mode.equals("on")) {
                plugin.getPluginState().setLoadedAtStartup(true);
            } else if (enabled_mode.equals("off")) {
                plugin.getPluginState().setLoadedAtStartup(false);
            } else {
                ci.out.println("Need to pass either \"on\" or \"off\"");
                ci.out.println();
                return;
            }
            ci.out.println("Done.");
            ci.out.println();
            return;
        }
        if (subcmd.equals("uninstall")) {
            PluginInterface pi = plugin_manager.getPluginInterfaceByID(plugin_id, false);
            if (pi == null) {
                ci.out.println("Plugin '" + plugin_id + "' is not installed");
                return;
            }
            PluginInstaller installer = plugin_manager.getPluginInstaller();
            try {
                StandardPlugin sp = installer.getStandardPlugin(plugin_id);
                if (sp == null) {
                    ci.out.println("Plugin '" + plugin_id + "' is not a standard plugin");
                    return;
                }
                PluginInstaller uninstaller = plugin_manager.getPluginInstaller();
                HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                final AESemaphore sem = new AESemaphore("plugin-uninstall");
                UpdateCheckInstance instance = uninstaller.uninstall(new PluginInterface[]{pi}, new PluginInstallationListener(){

                    @Override
                    public void completed() {
                        ci.out.println("Uninstallation complete");
                        sem.release();
                    }

                    @Override
                    public void cancelled() {
                        ci.out.println("Uninstallation cancelled");
                        sem.release();
                    }

                    @Override
                    public void failed(PluginException e) {
                        ci.out.println("Uninstallation failed: " + Debug.getNestedExceptionMessage(e));
                        sem.release();
                    }
                }, properties);
                instance.addListener(new UpdateCheckInstanceListener(){

                    @Override
                    public void cancelled(UpdateCheckInstance instance) {
                        ci.out.println("InsUninstallationtallation cancelled");
                    }

                    @Override
                    public void complete(UpdateCheckInstance instance) {
                        Update[] updates;
                        Update[] updateArray = updates = instance.getUpdates();
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ResourceDownloader[] rds;
                            Update update = updateArray[n2];
                            ResourceDownloader[] resourceDownloaderArray = rds = update.getDownloaders();
                            int n3 = rds.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ResourceDownloader rd = resourceDownloaderArray[n4];
                                try {
                                    rd.download();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                });
                sem.reserve();
                Object obj = properties.get(5);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    ci.out.println("**** Restart required to complete uninstallation ****");
                }
            }
            catch (Throwable e) {
                ci.out.println("Uninstall failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }
}

