/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPChecker;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerFactory;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.tag.TagManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.LocationProvider;
import org.gudy.azureus2.plugins.utils.LocationProviderListener;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.PowerManagementListener;
import org.gudy.azureus2.plugins.utils.ScriptProvider;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.subscriptions.Subscription;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionException;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionResult;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleUtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.MonitorImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.SemaphoreImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESecurityManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSFeedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentFactoryImpl;

public class UtilitiesImpl
implements Utilities,
FeatureManager {
    private static InetAddress last_public_ip_address;
    private static long last_public_ip_address_time;
    private AzureusCore core;
    private PluginInterface pi;
    private static ThreadLocal<PluginInterface> tls;
    private static ThreadLocal<Object[]> verified_enablers_tls;
    private static List<searchManager> search_managers;
    private static List<Object[]> search_providers;
    private static CopyOnWriteList<Object[]> feature_enablers;
    private static CopyOnWriteList<FeatureManager.FeatureManagerListener> feature_listeners;
    private static FeatureManager.FeatureManagerListener feature_listener;
    private static WeakHashMap<RateLimiter, PluginLimitedRateGroup> limiter_map;
    private static CopyOnWriteList<LocationProviderListener> lp_listeners;
    private static CopyOnWriteList<LocationProvider> location_providers;
    private static CopyOnWriteList<ScriptProvider.ScriptProviderListener> sp_listeners;
    private static CopyOnWriteList<ScriptProvider> script_providers;
    private static List delayed_tasks;
    private static AESemaphore delayed_tasks_sem;
    private static AEThread2 delayed_task_thread;
    private static Map<String, Utilities.JSONServer> json_servers;
    private static Map<String, Utilities.JSONClient> json_clients;
    private TagManagerImpl tag_manager = new TagManagerImpl();

    static {
        tls = new ThreadLocal<PluginInterface>(){

            @Override
            public PluginInterface initialValue() {
                return null;
            }
        };
        verified_enablers_tls = new ThreadLocal<Object[]>(){

            @Override
            public Object[] initialValue() {
                Object[] objectArray = new Object[3];
                objectArray[0] = 0L;
                objectArray[1] = 0;
                return objectArray;
            }
        };
        search_managers = new ArrayList<searchManager>();
        search_providers = new ArrayList<Object[]>();
        feature_enablers = new CopyOnWriteList();
        feature_listeners = new CopyOnWriteList();
        feature_listener = new FeatureManager.FeatureManagerListener(){

            @Override
            public void licenceAdded(FeatureManager.Licence licence) {
                UtilitiesImpl.checkFeatureCache();
                for (FeatureManager.FeatureManagerListener listener : feature_listeners) {
                    try {
                        listener.licenceAdded(licence);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void licenceChanged(FeatureManager.Licence licence) {
                UtilitiesImpl.checkFeatureCache();
                for (FeatureManager.FeatureManagerListener listener : feature_listeners) {
                    try {
                        listener.licenceChanged(licence);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }

            @Override
            public void licenceRemoved(FeatureManager.Licence licence) {
                UtilitiesImpl.checkFeatureCache();
                for (FeatureManager.FeatureManagerListener listener : feature_listeners) {
                    try {
                        listener.licenceRemoved(licence);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        limiter_map = new WeakHashMap();
        lp_listeners = new CopyOnWriteList();
        location_providers = new CopyOnWriteList();
        sp_listeners = new CopyOnWriteList();
        script_providers = new CopyOnWriteList();
        delayed_tasks = new ArrayList();
        delayed_tasks_sem = new AESemaphore("Utilities:delayedTask");
        json_servers = new HashMap<String, Utilities.JSONServer>();
        json_clients = new HashMap<String, Utilities.JSONClient>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginLimitedRateGroup wrapLimiter(RateLimiter limiter, boolean disable_disable) {
        WeakHashMap<RateLimiter, PluginLimitedRateGroup> weakHashMap = limiter_map;
        synchronized (weakHashMap) {
            PluginLimitedRateGroup l = limiter_map.get(limiter);
            if (l == null) {
                l = new PluginLimitedRateGroup(limiter, disable_disable);
                limiter_map.put(limiter, l);
            } else if (l.isDisableDisable() != disable_disable) {
                Debug.out("Inconsistent setting for disable_disable");
            }
            return l;
        }
    }

    public static RateLimiter unwrapLmiter(PluginLimitedRateGroup l) {
        return l.limiter;
    }

    private static void checkFeatureCache() {
        TreeSet<String> features = new TreeSet<String>();
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                FeatureManager.Licence[] licences;
                FeatureManager.Licence[] licenceArray = licences = enabler.getLicences();
                int n = licences.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureManager.Licence licence = licenceArray[n2];
                    int licence_state = licence.getState();
                    if (licence_state == 2) {
                        FeatureManager.FeatureDetails[] details;
                        FeatureManager.FeatureDetails[] featureDetailsArray = details = licence.getFeatures();
                        int n3 = details.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            FeatureManager.FeatureDetails detail = featureDetailsArray[n4];
                            if (!detail.hasExpired()) {
                                features.add(detail.getID());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (!UtilitiesImpl.getFeaturesInstalled().equals(features)) {
            String str = "";
            for (String f : features) {
                str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + f;
            }
            COConfigurationManager.setParameter("featman.cache.features.installed", str);
        }
    }

    public static Set<String> getFeaturesInstalled() {
        String str = COConfigurationManager.getStringParameter("featman.cache.features.installed", "");
        TreeSet<String> result = new TreeSet<String>();
        if (str.length() > 0) {
            result.addAll(Arrays.asList(str.split(",")));
        }
        return result;
    }

    public UtilitiesImpl(AzureusCore _core, PluginInterface _pi) {
        this.core = _core;
        this.pi = _pi;
    }

    @Override
    public String getAzureusUserDir() {
        String res = SystemProperties.getUserPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    @Override
    public String getAzureusProgramDir() {
        String res = SystemProperties.getApplicationPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    @Override
    public boolean isWindows() {
        return Constants.isWindows;
    }

    @Override
    public boolean isLinux() {
        return Constants.isLinux;
    }

    @Override
    public boolean isUnix() {
        return Constants.isUnix;
    }

    @Override
    public boolean isFreeBSD() {
        return Constants.isFreeBSD;
    }

    @Override
    public boolean isSolaris() {
        return Constants.isSolaris;
    }

    @Override
    public boolean isOSX() {
        return Constants.isOSX;
    }

    @Override
    public boolean isCVSVersion() {
        return Constants.isCVSVersion();
    }

    @Override
    public InputStream getImageAsStream(String image_name) {
        return UtilitiesImpl.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/" + image_name);
    }

    @Override
    public Semaphore getSemaphore() {
        return new SemaphoreImpl(this.pi);
    }

    @Override
    public Monitor getMonitor() {
        return new MonitorImpl(this.pi);
    }

    @Override
    public ByteBuffer allocateDirectByteBuffer(int size) {
        return DirectByteBufferPool.getBuffer((byte)1, size).getBuffer((byte)1);
    }

    @Override
    public void freeDirectByteBuffer(ByteBuffer buffer) {
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(int length) {
        return new PooledByteBufferImpl(length);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(byte[] data) {
        return new PooledByteBufferImpl(data);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(Map map) throws IOException {
        return new PooledByteBufferImpl(BEncoder.encode(map));
    }

    @Override
    public Formatters getFormatters() {
        return new FormattersImpl();
    }

    @Override
    public LocaleUtilities getLocaleUtilities() {
        return new LocaleUtilitiesImpl(this.pi);
    }

    @Override
    public UTTimer createTimer(String name) {
        return new UTTimerImpl(this.pi, name, false);
    }

    @Override
    public UTTimer createTimer(String name, boolean lightweight) {
        return new UTTimerImpl(this.pi, name, lightweight);
    }

    @Override
    public UTTimer createTimer(String name, int priority) {
        return new UTTimerImpl(this.pi, name, priority);
    }

    @Override
    public void createThread(String name, final Runnable target) {
        AEThread2 t = new AEThread2(String.valueOf(this.pi.getPluginName()) + "::" + name, true){

            @Override
            public void run() {
                UtilitiesImpl.callWithPluginThreadContext(UtilitiesImpl.this.pi, target);
            }
        };
        t.start();
    }

    @Override
    public void createProcess(String command_line) throws PluginException {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            if (pm.hasCapability(PlatformManagerCapabilities.CreateCommandLineProcess)) {
                pm.createProcess(command_line, false);
                return;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            Runtime.getRuntime().exec(command_line);
        }
        catch (Throwable f) {
            throw new PluginException("Failed to create process", f);
        }
    }

    @Override
    public ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    @Override
    public ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    @Override
    public SESecurityManager getSecurityManager() {
        return new SESecurityManagerImpl(this.core);
    }

    @Override
    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory() {
        return new SimpleXMLParserDocumentFactoryImpl();
    }

    @Override
    public RSSFeed getRSSFeed(InputStream is) throws SimpleXMLParserDocumentException {
        return this.getRSSFeed(null, is);
    }

    @Override
    public RSSFeed getRSSFeed(URL source_url, InputStream is) throws SimpleXMLParserDocumentException {
        try {
            RSSFeedImpl rSSFeedImpl = new RSSFeedImpl((Utilities)this, source_url, is);
            return rSSFeedImpl;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public RSSFeed getRSSFeed(URL feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        String feed_str = feed_location.toExternalForm();
        String lc_feed_str = feed_str.toLowerCase(Locale.US);
        AEProxyFactory.PluginProxy plugin_proxy = null;
        try {
            ResourceDownloader rd;
            if (lc_feed_str.startsWith("tor:")) {
                String target_resource = feed_str.substring(4);
                try {
                    feed_location = new URL(target_resource);
                }
                catch (MalformedURLException e) {
                    throw new ResourceDownloaderException(e);
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("peer_networks", new String[]{"Tor"});
                plugin_proxy = AEProxyFactory.getPluginProxy("RSS Feed download of '" + target_resource + "'", feed_location, options, true);
                if (plugin_proxy == null) {
                    throw new ResourceDownloaderException("No Tor plugin proxy available for '" + feed_str + "'");
                }
                rd = this.getResourceDownloaderFactory().create(plugin_proxy.getURL(), plugin_proxy.getProxy());
                rd.setProperty("URL_HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (feed_location.getPort() == -1 ? "" : ":" + feed_location.getPort()));
            } else if (AENetworkClassifier.categoriseAddress(feed_location.getHost()) != "Public") {
                plugin_proxy = AEProxyFactory.getPluginProxy("RSS Feed download of '" + feed_location + "'", feed_location, true);
                if (plugin_proxy == null) {
                    throw new ResourceDownloaderException("No Plugin proxy available for '" + feed_str + "'");
                }
                rd = this.getResourceDownloaderFactory().create(plugin_proxy.getURL(), plugin_proxy.getProxy());
                rd.setProperty("URL_HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (feed_location.getPort() == -1 ? "" : ":" + feed_location.getPort()));
            } else {
                rd = this.getResourceDownloaderFactory().create(feed_location);
            }
            RSSFeed rSSFeed = this.getRSSFeed(feed_location, rd);
            return rSSFeed;
        }
        finally {
            if (plugin_proxy != null) {
                plugin_proxy.setOK(true);
            }
        }
    }

    @Override
    public RSSFeed getRSSFeed(ResourceDownloader feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return this.getRSSFeed(null, feed_location);
    }

    @Override
    public RSSFeed getRSSFeed(URL source_url, ResourceDownloader feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return new RSSFeedImpl((Utilities)this, source_url, feed_location);
    }

    @Override
    public InetAddress getPublicAddress(boolean v6) {
        if (v6) {
            String vc_ip = VersionCheckClient.getSingleton().getExternalIpAddress(false, true);
            if (vc_ip != null && vc_ip.length() > 0) {
                try {
                    return InetAddress.getByName(vc_ip);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            return null;
        }
        return this.getPublicAddress();
    }

    @Override
    public InetAddress getPublicAddress() {
        InetAddress res;
        long now;
        block14: {
            now = SystemTime.getCurrentTime();
            if (now < last_public_ip_address_time) {
                last_public_ip_address_time = now;
            } else if (last_public_ip_address != null && now - last_public_ip_address_time < 900000L) {
                return last_public_ip_address;
            }
            res = null;
            try {
                String vc_ip = VersionCheckClient.getSingleton().getExternalIpAddress(false, false);
                if (vc_ip != null && vc_ip.length() > 0) {
                    res = InetAddress.getByName(vc_ip);
                    break block14;
                }
                ExternalIPChecker checker = ExternalIPCheckerFactory.create();
                ExternalIPCheckerService[] services = checker.getServices();
                final String[] ip = new String[1];
                int i = 0;
                while (i < services.length && ip[0] == null) {
                    ExternalIPCheckerService service = services[i];
                    if (service.supportsCheck()) {
                        final AESemaphore sem = new AESemaphore("Utilities:getExtIP");
                        ExternalIPCheckerServiceListener listener = new ExternalIPCheckerServiceListener(){

                            @Override
                            public void checkComplete(ExternalIPCheckerService _service, String _ip) {
                                ip[0] = _ip;
                                sem.release();
                            }

                            @Override
                            public void checkFailed(ExternalIPCheckerService _service, String _reason) {
                                sem.release();
                            }

                            @Override
                            public void reportProgress(ExternalIPCheckerService _service, String _message) {
                            }
                        };
                        services[i].addListener(listener);
                        try {
                            services[i].initiateCheck(60000L);
                            sem.reserve(60000L);
                        }
                        finally {
                            services[i].removeListener(listener);
                        }
                    }
                    if (ip[0] != null) {
                        res = InetAddress.getByName(ip[0]);
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (res == null) {
            res = last_public_ip_address;
        } else {
            last_public_ip_address = res;
            last_public_ip_address_time = now;
        }
        return res;
    }

    @Override
    public String reverseDNSLookup(InetAddress address) {
        final AESemaphore sem = new AESemaphore("Utilities:reverseDNS");
        final String[] res = new String[1];
        IPToHostNameResolver.addResolverRequest(address.getHostAddress(), new IPToHostNameResolverListener(){

            @Override
            public void IPResolutionComplete(String result, boolean succeeded) {
                if (succeeded) {
                    res[0] = result;
                }
                sem.release();
            }
        });
        sem.reserve(60000L);
        return res[0];
    }

    @Override
    public long getCurrentSystemTime() {
        return SystemTime.getCurrentTime();
    }

    @Override
    public ByteArrayWrapper createWrapper(byte[] data) {
        return new HashWrapper(data);
    }

    @Override
    public AggregatedDispatcher createAggregatedDispatcher(long idle_dispatch_time, long max_queue_size) {
        return new AggregatedDispatcher(idle_dispatch_time, max_queue_size){
            private AggregatedList list;
            {
                this.list = UtilitiesImpl.this.createAggregatedList(new AggregatedListAcceptor(){

                    @Override
                    public void accept(List l) {
                        int i = 0;
                        while (i < l.size()) {
                            try {
                                ((Runnable)l.get(i)).run();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            ++i;
                        }
                    }
                }, l, l2);
            }

            @Override
            public void add(Runnable runnable) {
                this.list.add(runnable);
            }

            @Override
            public Runnable remove(Runnable runnable) {
                return (Runnable)this.list.remove(runnable);
            }

            @Override
            public void destroy() {
                this.list.destroy();
            }
        };
    }

    @Override
    public AggregatedList createAggregatedList(final AggregatedListAcceptor acceptor, final long idle_dispatch_time, final long max_queue_size) {
        return new AggregatedList(){
            AEMonitor timer_mon = new AEMonitor("aggregatedList");
            Timer timer = new Timer("AggregatedList");
            TimerEvent event;
            List list = new ArrayList();

            @Override
            public void add(Object obj) {
                List dispatch_now = null;
                try {
                    this.timer_mon.enter();
                    if (max_queue_size > 0L && max_queue_size == (long)this.list.size()) {
                        dispatch_now = this.list;
                        this.list = new ArrayList();
                    }
                    this.list.add(obj);
                    long now = SystemTime.getCurrentTime();
                    if (this.event != null) {
                        this.event.cancel();
                    }
                    this.event = this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            this.dispatch();
                        }
                    });
                }
                finally {
                    this.timer_mon.exit();
                }
                if (dispatch_now != null) {
                    this.dispatch(dispatch_now);
                }
            }

            @Override
            public Object remove(Object obj) {
                Object res = null;
                try {
                    this.timer_mon.enter();
                    Object object = res = this.list.remove(obj) ? obj : null;
                    if (res != null) {
                        long now = SystemTime.getCurrentTime();
                        if (this.event != null) {
                            this.event.cancel();
                        }
                        this.event = this.list.size() == 0 ? null : this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                this.dispatch();
                            }
                        });
                    }
                }
                finally {
                    this.timer_mon.exit();
                }
                return res;
            }

            protected void dispatch() {
                List dispatch_list;
                try {
                    this.timer_mon.enter();
                    dispatch_list = this.list;
                    this.list = new ArrayList();
                }
                finally {
                    this.timer_mon.exit();
                }
                this.dispatch(dispatch_list);
            }

            protected void dispatch(List l) {
                if (l.size() > 0) {
                    try {
                        acceptor.accept(l);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }

            @Override
            public void destroy() {
                this.dispatch();
                this.timer.destroy();
            }
        };
    }

    public static final void callWithPluginThreadContext(PluginInterface pi, Runnable target) {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            target.run();
        }
        finally {
            tls.set(existing);
        }
    }

    public static final <T extends Exception> void callWithPluginThreadContext(PluginInterface pi, runnableWithException<T> target) throws T {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            target.run();
        }
        finally {
            tls.set(existing);
        }
    }

    public static final <T> T callWithPluginThreadContext(PluginInterface pi, runnableWithReturn<T> target) {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            T t = target.run();
            return t;
        }
        finally {
            tls.set(existing);
        }
    }

    public static final <T, S extends Exception> T callWithPluginThreadContext(PluginInterface pi, runnableWithReturnAndException<T, S> target) throws S {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            T t = target.run();
            return t;
        }
        finally {
            tls.set(existing);
        }
    }

    public static PluginInterface getPluginThreadContext() {
        return tls.get();
    }

    @Override
    public Map readResilientBEncodedFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup);
    }

    @Override
    public void writeResilientBEncodedFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup);
    }

    @Override
    public void deleteResilientBEncodedFile(File parent_dir, String file_name, boolean use_backup) {
        FileUtil.deleteResilientFile(new File(parent_dir, file_name));
    }

    @Override
    public int compareVersions(String v1, String v2) {
        return Constants.compareVersions(v1, v2);
    }

    @Override
    public String normaliseFileName(String f_name) {
        return FileUtil.convertOSSpecificChars(f_name, false);
    }

    @Override
    public DelayedTask createDelayedTask(Runnable target) {
        return UtilitiesImpl.addDelayedTask(this.pi.getPluginName(), target);
    }

    public static DelayedTask addDelayedTask(String name, Runnable r) {
        DelayedTaskImpl res = new DelayedTaskImpl(name);
        res.setTask(r);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueTask(DelayedTaskImpl task2, int pos) {
        List list = delayed_tasks;
        synchronized (list) {
            delayed_tasks.add(pos == -1 ? delayed_tasks.size() : pos, task2);
            delayed_tasks_sem.release();
            if (delayed_task_thread == null) {
                delayed_task_thread = new AEThread2("Utilities:delayedTask", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            PluginInitializer.addInitThread();
                            while (true) {
                                DelayedTaskImpl task2;
                                if (!delayed_tasks_sem.reserve(5000L)) {
                                    List list = delayed_tasks;
                                    synchronized (list) {
                                        if (delayed_tasks.isEmpty()) {
                                            delayed_task_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = delayed_tasks;
                                synchronized (list) {
                                    task2 = (DelayedTaskImpl)delayed_tasks.remove(0);
                                }
                                task2.run();
                            }
                        }
                        finally {
                            PluginInitializer.removeInitThread();
                        }
                    }
                };
                delayed_task_thread.setPriority(1);
                delayed_task_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSearchProvider(SearchProvider provider2) throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_providers.add(new Object[]{this.pi, provider2});
            ArrayList<searchManager> managers = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            int i = 0;
            while (i < managers.size()) {
                ((searchManager)managers.get(i)).addProvider(this.pi, provider2);
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSearchProvider(SearchProvider provider2) throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            Iterator<Object[]> it = search_providers.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[0] != this.pi || entry[1] != provider2) continue;
                it.remove();
            }
            ArrayList<searchManager> managers = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            int i = 0;
            while (i < managers.size()) {
                ((searchManager)managers.get(i)).removeProvider(this.pi, provider2);
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchInitiator getSearchInitiator() throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            ArrayList<searchManager> managers = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (managers.size() == 0) {
                throw new SearchException("No search managers registered - try later");
            }
            return (SearchInitiator)managers.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchManager(searchManager manager) {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_managers.add(manager);
            ArrayList<Object[]> providers = new ArrayList<Object[]>(search_providers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int i = 0;
            while (i < providers.size()) {
                Object[] entry = (Object[])providers.get(i);
                manager.addProvider((PluginInterface)entry[0], (SearchProvider)entry[1]);
                ++i;
            }
            return;
        }
    }

    @Override
    public FeatureManager getFeatureManager() {
        return this;
    }

    @Override
    public FeatureManager.Licence[] createLicences(String[] feature_ids) throws PluginException {
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        Throwable last_error = null;
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                FeatureManager.Licence[] licences = enabler.createLicences(feature_ids);
                if (licences == null) continue;
                return licences;
            }
            catch (Throwable e) {
                Debug.out(e);
                last_error = e;
            }
        }
        if (last_error == null) {
            throw this.getLicenceException("Failed to create licence");
        }
        throw new PluginException("Licence handler failed to create licence", last_error);
    }

    @Override
    public FeatureManager.Licence addLicence(String licence_key) throws PluginException {
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        Throwable last_error = null;
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                FeatureManager.Licence licence = enabler.addLicence(licence_key);
                if (licence == null) continue;
                return licence;
            }
            catch (Throwable e) {
                last_error = e;
                Debug.out(e);
            }
        }
        if (last_error == null) {
            throw this.getLicenceException("Licence addition failed");
        }
        throw new PluginException("Licence handler failed to add licence", last_error);
    }

    private PluginException getLicenceException(String str) {
        try {
            String extra = "";
            PluginInterface fm_pi = this.core.getPluginManager().getPluginInterfaceByID("aefeatman_v", false);
            if (fm_pi == null || fm_pi.getPluginVersion() != null && fm_pi.getPluginVersion().equals("0.0")) {
                int state;
                Download[] downloads = this.pi.getDownloadManager().getDownloads();
                Download hit = null;
                Download[] downloadArray = downloads;
                int n = downloads.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    Download download = downloadArray[n2];
                    Torrent torrent = download.getTorrent();
                    if (torrent != null && torrent.isSimpleTorrent() && (name = torrent.getFiles()[0].getName()).startsWith("aefeatman_v_") && name.endsWith(".zip")) {
                        hit = download;
                        break;
                    }
                    ++n2;
                }
                extra = hit == null ? "The 'Vuze Feature Manager' plugin is required but isn't installed" : ((state = hit.getState()) == 7 && !hit.isComplete() || state == 8 ? "The 'Vuze Feature Manager' plugin has failed to download - check your Library's detailed view for errors or stopped downloads" : "The 'Vuze Feature Manager' plugin is currently downloading, please wait for it to complete and install");
            } else {
                PluginState ps = fm_pi.getPluginState();
                if (!ps.isLoadedAtStartup()) {
                    extra = "You need to set the 'Vuze Feature Manager' plugin to 'load at startup' in the plugin options";
                } else if (ps.isDisabled()) {
                    extra = "The 'Vuze Feature Manager' plugin needs to be enabled";
                } else if (!ps.isOperational()) {
                    extra = "The 'Vuze Feature Manager' plugin isn't operational";
                }
            }
            return new PluginException(String.valueOf(str) + ": " + extra);
        }
        catch (Throwable e) {
            return new PluginException(str, e);
        }
    }

    @Override
    public FeatureManager.Licence[] getLicences() {
        ArrayList<FeatureManager.Licence> all_licences = new ArrayList<FeatureManager.Licence>();
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                FeatureManager.Licence[] licence = enabler.getLicences();
                all_licences.addAll(Arrays.asList(licence));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return all_licences.toArray(new FeatureManager.Licence[all_licences.size()]);
    }

    @Override
    public void refreshLicences() {
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                enabler.refreshLicences();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public FeatureManager.FeatureDetails[] getFeatureDetails(String feature_id) {
        return UtilitiesImpl.getFeatureDetailsSupport(feature_id);
    }

    @Override
    public boolean isFeatureInstalled(String feature_id) {
        return UtilitiesImpl.getVerifiedEnablers().size() > 0 && UtilitiesImpl.getFeaturesInstalled().contains(feature_id);
    }

    private static FeatureManager.FeatureDetails[] getFeatureDetailsSupport(String feature_id) {
        ArrayList<FeatureManager.FeatureDetails> result = new ArrayList<FeatureManager.FeatureDetails>();
        List<FeatureManager.FeatureEnabler> enablers = UtilitiesImpl.getVerifiedEnablers();
        for (FeatureManager.FeatureEnabler enabler : enablers) {
            try {
                FeatureManager.Licence[] licences;
                FeatureManager.Licence[] licenceArray = licences = enabler.getLicences();
                int n = licences.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureManager.FeatureDetails[] details;
                    FeatureManager.Licence licence = licenceArray[n2];
                    FeatureManager.FeatureDetails[] featureDetailsArray = details = licence.getFeatures();
                    int n3 = details.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        FeatureManager.FeatureDetails detail = featureDetailsArray[n4];
                        if (detail.getID().equals(feature_id)) {
                            result.add(detail);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return result.toArray(new FeatureManager.FeatureDetails[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FeatureManager.FeatureManagerListener listener) {
        CopyOnWriteList<Object[]> copyOnWriteList = feature_enablers;
        synchronized (copyOnWriteList) {
            feature_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FeatureManager.FeatureManagerListener listener) {
        CopyOnWriteList<Object[]> copyOnWriteList = feature_enablers;
        synchronized (copyOnWriteList) {
            feature_listeners.remove(listener);
        }
    }

    private static final List<FeatureManager.FeatureEnabler> getVerifiedEnablers() {
        long now = SystemTime.getMonotonousTime();
        int mut = feature_enablers.getMutationCount();
        Object[] cache = verified_enablers_tls.get();
        long last_time = (Long)cache[0];
        int old_mut = (Integer)cache[1];
        if (last_time != 0L && now - last_time < 30000L && mut == old_mut) {
            return (List)cache[2];
        }
        ArrayList<FeatureManager.FeatureEnabler> enablers = new ArrayList<FeatureManager.FeatureEnabler>();
        for (Object[] entry : feature_enablers) {
            PluginInterface enabler_pi = (PluginInterface)entry[0];
            Plugin enabler_plugin = (Plugin)entry[1];
            FeatureManager.FeatureEnabler enabler = (FeatureManager.FeatureEnabler)entry[2];
            if (!PluginInitializer.isVerified(enabler_pi, enabler_plugin)) continue;
            enablers.add(enabler);
        }
        verified_enablers_tls.set(new Object[]{now, mut, enablers});
        return enablers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFeatureEnabler(FeatureManager.FeatureEnabler enabler) {
        Plugin plugin = this.pi.getPlugin();
        if (!PluginInitializer.isVerified(this.pi, plugin)) {
            Debug.out("Feature enabler not registered as plugin unverified");
            return;
        }
        CopyOnWriteList<Object[]> copyOnWriteList = feature_enablers;
        synchronized (copyOnWriteList) {
            feature_enablers.add(new Object[]{this.pi, plugin, enabler});
            enabler.addListener(feature_listener);
        }
        UtilitiesImpl.checkFeatureCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFeatureEnabler(FeatureManager.FeatureEnabler enabler) {
        CopyOnWriteList<Object[]> copyOnWriteList = feature_enablers;
        synchronized (copyOnWriteList) {
            for (Object[] entry : feature_enablers) {
                if (entry[2] != enabler) continue;
                feature_enablers.remove(entry);
                return;
            }
        }
        UtilitiesImpl.checkFeatureCache();
    }

    @Override
    public SubscriptionManager getSubscriptionManager() throws SubscriptionException {
        try {
            Method m = Class.forName("com.aelitis.azureus.core.subs.SubscriptionManagerFactory").getMethod("getSingleton", new Class[0]);
            final PluginSubscriptionManager sm = (PluginSubscriptionManager)m.invoke(null, new Object[0]);
            return new SubscriptionManager(){

                @Override
                public void requestSubscription(URL url) {
                    sm.requestSubscription(url, new HashMap<String, Object>());
                }

                @Override
                public void requestSubscription(URL url, Map<String, Object> options) {
                    sm.requestSubscription(url, options);
                }

                @Override
                public void requestSubscription(SearchProvider sp, Map<String, Object> search_parameters) throws SubscriptionException {
                    sm.requestSubscription(sp, search_parameters);
                }

                @Override
                public Subscription[] getSubscriptions() {
                    PluginSubscription[] p_subs = sm.getSubscriptions(true);
                    Subscription[] subs = new Subscription[p_subs.length];
                    int i = 0;
                    while (i < subs.length) {
                        final PluginSubscription p_sub = p_subs[i];
                        subs[i] = new Subscription(){

                            @Override
                            public String getID() {
                                return p_sub.getID();
                            }

                            @Override
                            public String getName() {
                                return p_sub.getName();
                            }

                            @Override
                            public boolean isSearchTemplate() {
                                return p_sub.isSearchTemplate();
                            }

                            @Override
                            public SubscriptionResult[] getResults() {
                                PluginSubscriptionResult[] p_results = p_sub.getResults(false);
                                SubscriptionResult[] results = new SubscriptionResult[p_results.length];
                                int i = 0;
                                while (i < results.length) {
                                    final PluginSubscriptionResult p_res = p_results[i];
                                    results[i] = new SubscriptionResult(){
                                        private Map<Integer, Object> map;
                                        {
                                            this.map = pluginSubscriptionResult.toPropertyMap();
                                        }

                                        @Override
                                        public Object getProperty(int property_name) {
                                            return this.map.get(property_name);
                                        }

                                        @Override
                                        public boolean isRead() {
                                            return p_res.getRead();
                                        }

                                        @Override
                                        public void setRead(boolean read) {
                                            p_res.setRead(read);
                                        }
                                    };
                                    ++i;
                                }
                                return results;
                            }
                        };
                        ++i;
                    }
                    return subs;
                }
            };
        }
        catch (Throwable e) {
            throw new SubscriptionException("Subscriptions unavailable", e);
        }
    }

    @Override
    public boolean supportsPowerStateControl(int state) {
        if (state == 1) {
            return PlatformManagerFactory.getPlatformManager().hasCapability(PlatformManagerCapabilities.PreventComputerSleep);
        }
        return false;
    }

    @Override
    public void addPowerManagementListener(PowerManagementListener listener) {
        this.core.addPowerManagementListener(listener);
    }

    @Override
    public void removePowerManagementListener(PowerManagementListener listener) {
        this.core.removePowerManagementListener(listener);
    }

    @Override
    public List<LocationProvider> getLocationProviders() {
        return location_providers.getList();
    }

    @Override
    public void addLocationProvider(LocationProvider provider2) {
        location_providers.add(provider2);
        for (LocationProviderListener l : lp_listeners) {
            try {
                l.locationProviderAdded(provider2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void removeLocationProvider(LocationProvider provider2) {
        location_providers.remove(provider2);
        for (LocationProviderListener l : lp_listeners) {
            try {
                l.locationProviderRemoved(provider2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addLocationProviderListener(LocationProviderListener listener) {
        lp_listeners.add(listener);
        for (LocationProvider lp : location_providers) {
            listener.locationProviderAdded(lp);
        }
    }

    @Override
    public void removeLocationProviderListener(LocationProviderListener listener) {
        lp_listeners.remove(listener);
    }

    @Override
    public List<ScriptProvider> getScriptProviders() {
        return script_providers.getList();
    }

    @Override
    public void registerScriptProvider(ScriptProvider provider2) {
        script_providers.add(provider2);
        for (ScriptProvider.ScriptProviderListener l : sp_listeners) {
            try {
                l.scriptProviderAdded(provider2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void unregisterScriptProvider(ScriptProvider provider2) {
        script_providers.remove(provider2);
        for (ScriptProvider.ScriptProviderListener l : sp_listeners) {
            try {
                l.scriptProviderRemoved(provider2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addScriptProviderListener(ScriptProvider.ScriptProviderListener listener) {
        sp_listeners.add(listener);
        for (ScriptProvider lp : script_providers) {
            listener.scriptProviderAdded(lp);
        }
    }

    @Override
    public void removeScriptProviderListener(ScriptProvider.ScriptProviderListener listener) {
        sp_listeners.remove(listener);
    }

    @Override
    public org.gudy.azureus2.plugins.tag.Tag lookupTag(String name) {
        List<TagType> tts = TagManagerFactory.getTagManager().getTagTypes();
        for (TagType tt : tts) {
            Tag t = tt.getTag(name, true);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases(String[] networks) {
        return DDBaseImpl.getDDBs(networks, null);
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases(String[] networks, Map<String, Object> options) {
        return DDBaseImpl.getDDBs(networks, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerJSONRPCServer(Utilities.JSONServer server) {
        String key = String.valueOf(this.pi == null ? "default" : this.pi.getPluginID()) + ":" + server.getName();
        Map<String, Utilities.JSONServer> map = json_servers;
        synchronized (map) {
            Utilities.JSONServer existing = json_servers.get(key);
            if (existing != null) {
                for (Utilities.JSONClient client : json_clients.values()) {
                    client.serverUnregistered(existing);
                }
            }
            json_servers.put(key, server);
            for (Utilities.JSONClient client : json_clients.values()) {
                client.serverRegistered(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterJSONRPCServer(Utilities.JSONServer server) {
        String key = String.valueOf(this.pi == null ? "default" : this.pi.getPluginID()) + ":" + server.getName();
        Map<String, Utilities.JSONServer> map = json_servers;
        synchronized (map) {
            Utilities.JSONServer existing = json_servers.remove(key);
            if (existing != null) {
                for (Utilities.JSONClient client : json_clients.values()) {
                    client.serverUnregistered(existing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerJSONRPCClient(Utilities.JSONClient client) {
        String key = this.pi == null ? "default" : this.pi.getPluginID();
        Map<String, Utilities.JSONServer> map = json_servers;
        synchronized (map) {
            json_clients.put(key, client);
            for (Utilities.JSONServer server : json_servers.values()) {
                client.serverRegistered(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterJSONRPCClient(Utilities.JSONClient client) {
        String key = this.pi == null ? "default" : this.pi.getPluginID();
        Map<String, Utilities.JSONServer> map = json_servers;
        synchronized (map) {
            json_clients.remove(key);
        }
    }

    @Override
    public TagManager getTagManager() {
        return this.tag_manager;
    }

    static class DelayedTaskImpl
    implements DelayedTask {
        private String name;
        private Runnable target;
        private long create_time = SystemTime.getCurrentTime();
        private long run_time;

        private DelayedTaskImpl(String _name) {
            this.name = _name;
        }

        public void setTask(Runnable _target) {
            this.target = _target;
        }

        @Override
        public void queue() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, -1);
        }

        @Override
        public void queueFirst() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, 0);
        }

        protected void run() {
            try {
                this.run_time = SystemTime.getCurrentTime();
                this.target.run();
                long now = SystemTime.getCurrentTime();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LogIDs.PLUGIN, 0, "Delayed task '" + this.getName() + "': queue_time=" + (this.run_time - this.create_time) + ", exec_time=" + (now - this.run_time)));
                }
            }
            catch (Throwable e) {
                Debug.out("Initialisation task " + this.getName() + " failed to complete", e);
            }
        }

        protected String getName() {
            return String.valueOf(this.name) + " (" + this.target.getClass() + ")";
        }
    }

    public static class PluginLimitedRateGroup
    implements LimitedRateGroup {
        private RateLimiter limiter;
        private ConnectionManagerImpl.PluginRateLimiter plimiter;
        private CopyOnWriteList<PluginLimitedRateGroupListener> listeners;
        private final boolean disable_disable;
        private boolean current_disabled = false;
        private long last_sync;

        private PluginLimitedRateGroup(RateLimiter _limiter, boolean _disable_disable) {
            this.limiter = _limiter;
            this.disable_disable = _disable_disable;
            if (this.limiter instanceof ConnectionManagerImpl.PluginRateLimiter) {
                this.plimiter = (ConnectionManagerImpl.PluginRateLimiter)this.limiter;
            }
        }

        public boolean isDisableDisable() {
            return this.disable_disable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(PluginLimitedRateGroupListener listener) {
            if (this.disable_disable) {
                this.getRateLimitBytesPerSecond();
                PluginLimitedRateGroup pluginLimitedRateGroup = this;
                synchronized (pluginLimitedRateGroup) {
                    if (this.listeners == null) {
                        this.listeners = new CopyOnWriteList();
                    }
                    this.listeners.add(listener);
                    if (this.current_disabled) {
                        try {
                            listener.disabledChanged(this, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(PluginLimitedRateGroupListener listener) {
            if (this.disable_disable) {
                PluginLimitedRateGroup pluginLimitedRateGroup = this;
                synchronized (pluginLimitedRateGroup) {
                    if (this.listeners != null && this.listeners.remove(listener) && this.current_disabled) {
                        try {
                            listener.disabledChanged(this, false);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getName() {
            String name = this.limiter.getName();
            if (Constants.IS_CVS_VERSION && this.disable_disable) {
                String str = "";
                if (this.current_disabled) {
                    str = String.valueOf(str) + "Disabled";
                }
                PluginLimitedRateGroup pluginLimitedRateGroup = this;
                synchronized (pluginLimitedRateGroup) {
                    if (this.listeners != null) {
                        str = String.valueOf(str) + (str.length() == 0 ? "" : "/") + this.listeners.size();
                    }
                }
                if (str.length() > 0) {
                    name = String.valueOf(name) + " (" + str + ")";
                }
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getRateLimitBytesPerSecond() {
            int value = this.limiter.getRateLimitBytesPerSecond();
            if (this.disable_disable) {
                boolean is_disabled;
                boolean bl = is_disabled = value == -1;
                if (is_disabled != this.current_disabled) {
                    PluginLimitedRateGroup pluginLimitedRateGroup = this;
                    synchronized (pluginLimitedRateGroup) {
                        this.current_disabled = is_disabled;
                        if (this.listeners != null) {
                            for (PluginLimitedRateGroupListener l : this.listeners) {
                                try {
                                    l.disabledChanged(this, is_disabled);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    }
                }
                long now = SystemTime.getMonotonousTime();
                if (now - this.last_sync > 60000L) {
                    this.last_sync = now;
                    PluginLimitedRateGroup pluginLimitedRateGroup = this;
                    synchronized (pluginLimitedRateGroup) {
                        if (this.listeners != null) {
                            for (PluginLimitedRateGroupListener l : this.listeners) {
                                try {
                                    l.sync(this, this.current_disabled);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    }
                }
                return is_disabled ? 0 : value;
            }
            return value;
        }

        @Override
        public boolean isDisabled() {
            return this.limiter.getRateLimitBytesPerSecond() < 0;
        }

        @Override
        public void updateBytesUsed(int used) {
            if (this.plimiter != null) {
                this.plimiter.updateBytesUsed(used);
            }
        }
    }

    public static interface PluginLimitedRateGroupListener {
        public void disabledChanged(PluginLimitedRateGroup var1, boolean var2);

        public void sync(PluginLimitedRateGroup var1, boolean var2);
    }

    public static interface PluginSubscription {
        public String getID();

        public String getName();

        public boolean isSearchTemplate();

        public PluginSubscriptionResult[] getResults(boolean var1);
    }

    public static interface PluginSubscriptionManager {
        public void requestSubscription(URL var1, Map<String, Object> var2);

        public void requestSubscription(SearchProvider var1, Map<String, Object> var2) throws SubscriptionException;

        public PluginSubscription[] getSubscriptions(boolean var1);
    }

    public static interface PluginSubscriptionResult {
        public Map<Integer, Object> toPropertyMap();

        public void setRead(boolean var1);

        public boolean getRead();
    }

    private static class TagManagerImpl
    implements TagManager {
        private TagManagerImpl() {
        }

        @Override
        public List<org.gudy.azureus2.plugins.tag.Tag> getTags() {
            List<Tag> tags = TagManagerFactory.getTagManager().getTagType(3).getTags();
            return new ArrayList<org.gudy.azureus2.plugins.tag.Tag>(tags);
        }

        @Override
        public org.gudy.azureus2.plugins.tag.Tag lookupTag(String name) {
            return TagManagerFactory.getTagManager().getTagType(3).getTag(name, true);
        }

        @Override
        public org.gudy.azureus2.plugins.tag.Tag createTag(String name) {
            try {
                return TagManagerFactory.getTagManager().getTagType(3).createTag(name, true);
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
    }

    public static interface runnableWithException<T extends Exception> {
        public void run() throws T;
    }

    public static interface runnableWithReturn<T> {
        public T run();
    }

    public static interface runnableWithReturnAndException<T, S extends Exception> {
        public T run() throws S;
    }

    public static interface searchManager
    extends SearchInitiator {
        public void addProvider(PluginInterface var1, SearchProvider var2);

        public void removeProvider(PluginInterface var1, SearchProvider var2);
    }
}

