/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.InputStream;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;

public class UpdateImpl
implements Update {
    private UpdateCheckInstanceImpl instance;
    private UpdatableComponentImpl component;
    private String name;
    private String[] description;
    private String relative_url_base = "";
    private String old_version;
    private String new_version;
    private ResourceDownloader[] downloaders;
    private boolean mandatory;
    private int restart_required;
    private String description_url;
    private Object user_object;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private volatile boolean cancelled;
    private volatile boolean complete;
    private volatile boolean succeeded;

    protected UpdateImpl(UpdateCheckInstanceImpl _instance, UpdatableComponentImpl _component, String _name, String[] _desc, String _old_version, String _new_version, ResourceDownloader[] _downloaders, boolean _mandatory, int _restart_required) {
        this.instance = _instance;
        this.component = _component;
        this.name = _name;
        this.description = _desc;
        this.old_version = _old_version;
        this.new_version = _new_version;
        this.downloaders = _downloaders;
        this.mandatory = _mandatory;
        this.restart_required = _restart_required;
    }

    @Override
    public UpdateCheckInstance getCheckInstance() {
        return this.instance;
    }

    protected UpdatableComponentImpl getComponent() {
        return this.component;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public String getRelativeURLBase() {
        return this.relative_url_base;
    }

    @Override
    public void setRelativeURLBase(String base) {
        this.relative_url_base = base;
    }

    @Override
    public String getDesciptionURL() {
        return this.description_url;
    }

    @Override
    public void setDescriptionURL(String url) {
        this.description_url = url;
    }

    @Override
    public String getOldVersion() {
        return this.old_version;
    }

    @Override
    public String getNewVersion() {
        return this.new_version;
    }

    @Override
    public ResourceDownloader[] getDownloaders() {
        return this.downloaders;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setRestartRequired(int _restart_required) {
        this.restart_required = _restart_required;
    }

    @Override
    public int getRestartRequired() {
        return this.restart_required;
    }

    @Override
    public void setUserObject(Object obj) {
        this.user_object = obj;
    }

    @Override
    public Object getUserObject() {
        return this.user_object;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        int i = 0;
        while (i < this.downloaders.length) {
            try {
                this.downloaders[i].cancel();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((UpdateListener)it.next()).cancelled(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void complete(boolean success) {
        this.complete = true;
        this.succeeded = success;
        Iterator it = this.listeners.iterator();
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((UpdateListener)it.next()).complete(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean wasSuccessful() {
        return this.succeeded;
    }

    @Override
    public Object getDecision(int decision_type, String decision_name, String decision_description, Object decision_data) {
        return this.instance.getDecision(this, decision_type, decision_name, decision_description, decision_data);
    }

    @Override
    public InputStream verifyData(InputStream is, boolean force) throws UpdateException {
        return ((UpdateManagerImpl)this.instance.getManager()).verifyData(this, is, force);
    }

    @Override
    public void addListener(UpdateListener l) {
        this.listeners.add(l);
        if (this.cancelled) {
            l.cancelled(this);
        } else if (this.complete) {
            l.complete(this);
        }
    }

    @Override
    public void removeListener(UpdateListener l) {
        this.listeners.remove(l);
    }
}

