/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateProgressListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;

public class UpdateCheckerImpl
implements UpdateChecker {
    protected UpdateCheckInstanceImpl check_instance;
    protected UpdatableComponentImpl component;
    protected AESemaphore semaphore;
    protected boolean completed;
    protected boolean failed;
    protected boolean cancelled;
    protected boolean sem_released;
    protected List listeners = new ArrayList();
    protected List progress_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("UpdateChecker");

    protected UpdateCheckerImpl(UpdateCheckInstanceImpl _check_instance, UpdatableComponentImpl _component, AESemaphore _sem) {
        this.check_instance = _check_instance;
        this.component = _component;
        this.semaphore = _sem;
    }

    @Override
    public UpdateCheckInstance getCheckInstance() {
        return this.check_instance;
    }

    @Override
    public Update addUpdate(String name, String[] description, String old_version, String new_version, ResourceDownloader downloader, int restart_required) {
        return this.addUpdate(name, description, old_version, new_version, new ResourceDownloader[]{downloader}, restart_required);
    }

    @Override
    public Update addUpdate(String name, String[] description, String old_version, String new_version, ResourceDownloader[] downloaders, int restart_required) {
        this.reportProgress("Adding update: " + name);
        return this.check_instance.addUpdate(this.component, name, description, old_version, new_version, downloaders, restart_required);
    }

    @Override
    public UpdateInstaller createInstaller() throws UpdateException {
        return this.check_instance.createInstaller();
    }

    @Override
    public UpdatableComponent getComponent() {
        return this.component.getComponent();
    }

    @Override
    public void completed() {
        block6: {
            try {
                this.this_mon.enter();
                if (this.sem_released) break block6;
                this.completed = true;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((UpdateCheckerListener)this.listeners.get(i)).completed(this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
                this.sem_released = true;
                this.semaphore.release();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void failed() {
        block6: {
            try {
                this.this_mon.enter();
                if (this.sem_released) break block6;
                this.failed = true;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((UpdateCheckerListener)this.listeners.get(i)).failed(this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
                this.sem_released = true;
                this.semaphore.release();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected boolean getFailed() {
        return this.failed;
    }

    protected void cancel() {
        this.cancelled = true;
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((UpdateCheckerListener)this.listeners.get(i)).cancelled(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void addListener(UpdateCheckerListener l) {
        try {
            this.this_mon.enter();
            this.listeners.add(l);
            if (this.failed) {
                l.failed(this);
            } else if (this.completed) {
                l.completed(this);
            }
            if (this.cancelled) {
                l.cancelled(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(UpdateCheckerListener l) {
        try {
            this.this_mon.enter();
            this.listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void reportProgress(String str) {
        List ref = this.progress_listeners;
        int i = 0;
        while (i < ref.size()) {
            try {
                ((UpdateProgressListener)ref.get(i)).reportProgress(str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void addProgressListener(UpdateProgressListener l) {
        try {
            this.this_mon.enter();
            ArrayList<UpdateProgressListener> new_l = new ArrayList<UpdateProgressListener>(this.progress_listeners);
            new_l.add(l);
            this.progress_listeners = new_l;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeProgressListener(UpdateProgressListener l) {
        try {
            this.this_mon.enter();
            ArrayList new_l = new ArrayList(this.progress_listeners);
            new_l.remove(l);
            this.progress_listeners = new_l;
        }
        finally {
            this.this_mon.exit();
        }
    }
}

