/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.menus;

import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.menus.MenuContext;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuContextImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuItemImpl;

public class MenuManagerImpl
implements MenuManager {
    private UIManagerImpl ui_manager;

    public MenuManagerImpl(UIManagerImpl _ui_manager) {
        this.ui_manager = _ui_manager;
    }

    @Override
    public MenuItem addMenuItem(String menuID, String resource_key) {
        PluginInterface pi = this.ui_manager.getPluginInterface();
        MenuItemImpl item = new MenuItemImpl(pi, menuID, resource_key);
        UIManagerImpl.fireEvent(pi, 15, item);
        return item;
    }

    @Override
    public MenuItem addMenuItem(MenuContext context2, String resource_key) {
        MenuContextImpl context_impl = (MenuContextImpl)context2;
        MenuItemImpl result = (MenuItemImpl)this.addMenuItem(context_impl.context, resource_key);
        result.setContext(context_impl);
        context_impl.dirty();
        return result;
    }

    @Override
    public MenuItem addMenuItem(MenuItem parent, String resource_key) {
        if (!(parent instanceof MenuItemImpl)) {
            throw new UIRuntimeException("parent must have been created by addMenuItem");
        }
        if (parent.getStyle() != 5) {
            throw new UIRuntimeException("parent menu item must have the menu style associated");
        }
        MenuItemImpl item = new MenuItemImpl((MenuItemImpl)parent, resource_key);
        UIManagerImpl.fireEvent(this.ui_manager.getPluginInterface(), 16, new Object[]{item, parent});
        return item;
    }
}

