/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.components;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.Properties;
import org.gudy.azureus2.plugins.ui.components.UIComponent;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeEvent;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;

public class UIComponentImpl
implements UIComponent {
    protected Properties properties = new Properties();
    protected CopyOnWriteList<UIPropertyChangeListener> listeners = new CopyOnWriteList();

    protected UIComponentImpl() {
        this.properties.put("enabled", new Boolean(true));
        this.properties.put("visible", new Boolean(true));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", new Boolean(enabled));
    }

    @Override
    public boolean getEnabled() {
        return (Boolean)this.getProperty("enabled");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setProperty("visible", new Boolean(visible));
    }

    @Override
    public boolean getVisible() {
        return (Boolean)this.getProperty("visible");
    }

    @Override
    public void setProperty(final String property_type, final Object property_value) {
        final Object old_value = this.properties.get(property_type);
        this.properties.put(property_type, property_value);
        UIPropertyChangeEvent ev = new UIPropertyChangeEvent(){

            @Override
            public UIComponent getSource() {
                return UIComponentImpl.this;
            }

            @Override
            public String getPropertyType() {
                return property_type;
            }

            @Override
            public Object getNewPropertyValue() {
                return property_value;
            }

            @Override
            public Object getOldPropertyValue() {
                return old_value;
            }
        };
        for (UIPropertyChangeListener listener : this.listeners) {
            listener.propertyChanged(ev);
        }
    }

    @Override
    public Object getProperty(String property_type) {
        return this.properties.get(property_type);
    }

    @Override
    public void addPropertyChangeListener(UIPropertyChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removePropertyChangeListener(UIPropertyChangeListener l) {
        this.listeners.remove(l);
    }
}

