/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIInputValidator;

public abstract class AbstractUIInputReceiver
implements UIInputReceiver {
    private boolean prompted = false;
    protected String[] messages = new String[0];
    protected String title = null;
    protected boolean multiline_mode = false;
    protected String preentered_text = null;
    protected UIInputValidator validator = null;
    private boolean result_recorded = false;
    protected UIInputReceiverListener receiver_listener;
    private boolean result_input_submitted = false;
    private String result_input = null;
    protected boolean maintain_whitespace = false;
    protected boolean allow_empty_input = true;

    protected final void assertPrePrompt() {
        if (this.prompted) {
            throw new RuntimeException("cannot invoke after prompt has been called");
        }
    }

    protected final void assertPostPrompt() {
        if (!this.prompted) {
            throw new RuntimeException("cannot before after prompt has been called");
        }
    }

    @Override
    public void setLocalisedMessage(String message) {
        this.setLocalisedMessages(new String[]{message});
    }

    @Override
    public void setLocalisedMessages(String[] messages) {
        this.assertPrePrompt();
        this.messages = messages;
    }

    @Override
    public void setLocalisedTitle(String title) {
        this.assertPrePrompt();
        this.title = title;
    }

    @Override
    public void setMessage(String message) {
        this.setLocalisedMessage(this.localise(message));
    }

    @Override
    public void setMessages(String[] messages) {
        String[] new_messages = new String[messages.length];
        int i = 0;
        while (i < new_messages.length) {
            new_messages[i] = this.localise(messages[i]);
            ++i;
        }
        this.setLocalisedMessages(new_messages);
    }

    @Override
    public void setMultiLine(boolean multiline) {
        this.assertPrePrompt();
        this.multiline_mode = multiline;
    }

    @Override
    public void setPreenteredText(String text, boolean as_suggested) {
        this.assertPrePrompt();
        this.preentered_text = text;
    }

    @Override
    public void setTitle(String title) {
        this.setLocalisedTitle(this.localise(title));
    }

    @Override
    public void setInputValidator(UIInputValidator validator) {
        this.assertPrePrompt();
        this.validator = validator;
    }

    @Override
    public final void prompt() {
        this.assertPrePrompt();
        this.promptForInput();
        if (!this.result_recorded) {
            throw new RuntimeException(String.valueOf(this.toString()) + " did not record a result.");
        }
        this.prompted = true;
    }

    protected boolean isResultRecorded() {
        return this.result_recorded;
    }

    @Override
    public final void prompt(UIInputReceiverListener receiver_listener) {
        this.assertPrePrompt();
        this.receiver_listener = receiver_listener;
        this.promptForInput();
    }

    public final void triggerReceiverListener() {
        if (!this.result_recorded) {
            throw new RuntimeException(String.valueOf(this.toString()) + " did not record a result.");
        }
        this.prompted = true;
        if (this.receiver_listener != null) {
            this.receiver_listener.UIInputReceiverClosed(this);
        }
    }

    protected abstract void promptForInput();

    protected final void recordUserInput(String input) {
        this.result_recorded = true;
        this.result_input_submitted = true;
        this.result_input = input;
        if (!this.maintain_whitespace) {
            this.result_input = input.trim();
        }
    }

    protected final void recordUserAbort() {
        this.result_recorded = true;
        this.result_input_submitted = false;
        this.result_input = null;
    }

    @Override
    public boolean hasSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input_submitted;
    }

    @Override
    public String getSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input;
    }

    @Override
    public void maintainWhitespace(boolean keep_whitespace) {
        this.maintain_whitespace = keep_whitespace;
    }

    @Override
    public void allowEmptyInput(boolean empty_input) {
        this.allow_empty_input = empty_input;
    }

    protected final String localise(String key) {
        return MessageText.getString(key);
    }
}

