/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import java.io.IOException;
import java.util.HashMap;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessageManager;
import org.gudy.azureus2.plugins.network.IncomingMessageQueue;
import org.gudy.azureus2.plugins.network.IncomingMessageQueueListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;

public class IncomingMessageQueueImpl
implements IncomingMessageQueue {
    private final com.aelitis.azureus.core.networkmanager.IncomingMessageQueue core_queue;
    private final HashMap registrations = new HashMap();

    protected IncomingMessageQueueImpl(com.aelitis.azureus.core.networkmanager.IncomingMessageQueue core_queue) {
        this.core_queue = core_queue;
    }

    @Override
    public void registerListener(IncomingMessageQueueListener listener) {
        this.registerListenerSupport(listener, false);
    }

    @Override
    public void registerPriorityListener(IncomingMessageQueueListener listener) {
        this.registerListenerSupport(listener, true);
    }

    private void registerListenerSupport(final IncomingMessageQueueListener listener, final boolean is_priority) {
        IncomingMessageQueue.MessageQueueListener core_listener = new IncomingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageReceived(com.aelitis.azureus.core.peermanager.messaging.Message message) {
                if (message instanceof MessageAdapter) {
                    return listener.messageReceived(((MessageAdapter)message).getPluginMessage());
                }
                if (message instanceof BTMessage) {
                    return listener.messageReceived(BTMessageManager.wrapCoreMessage((BTMessage)message));
                }
                return listener.messageReceived(new MessageAdapter(message));
            }

            @Override
            public void protocolBytesReceived(int byte_count) {
                listener.bytesReceived(byte_count);
            }

            @Override
            public void dataBytesReceived(int byte_count) {
                listener.bytesReceived(byte_count);
            }

            @Override
            public boolean isPriority() {
                return is_priority;
            }
        };
        this.registrations.put(listener, core_listener);
        this.core_queue.registerQueueListener(core_listener);
    }

    @Override
    public void deregisterListener(IncomingMessageQueueListener listener) {
        IncomingMessageQueue.MessageQueueListener core_listener = (IncomingMessageQueue.MessageQueueListener)this.registrations.remove(listener);
        if (core_listener != null) {
            this.core_queue.cancelQueueListener(core_listener);
        }
    }

    @Override
    public void notifyOfExternalReceive(Message message) throws IOException {
        if (message instanceof MessageAdapter) {
            this.core_queue.notifyOfExternallyReceivedMessage(((MessageAdapter)message).getCoreMessage());
            return;
        }
        this.core_queue.notifyOfExternallyReceivedMessage(new MessageAdapter(message));
    }

    @Override
    public int getPercentDoneOfCurrentMessage() {
        return this.core_queue.getPercentDoneOfCurrentMessage();
    }
}

