/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class LoggerChannelImpl
implements LoggerChannel {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private final Logger logger;
    private final String name;
    private final boolean timestamp;
    final boolean no_output;
    final List listeners = new ArrayList();
    private AEDiagnosticsLogger diagnostic_logger;

    protected LoggerChannelImpl(Logger _logger, String _name, boolean _timestamp, boolean _no_output) {
        this.logger = _logger;
        this.name = _name;
        this.timestamp = _timestamp;
        this.no_output = _no_output;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return org.gudy.azureus2.core3.logging.Logger.isEnabled();
    }

    @Override
    public void setDiagnostic() {
        this.setDiagnostic(0L, true);
    }

    @Override
    public void setForce(boolean forceToFile) {
        this.diagnostic_logger.setForced(forceToFile);
    }

    @Override
    public boolean getForce() {
        return this.diagnostic_logger.isForced();
    }

    @Override
    public void setDiagnostic(long max_file_size, boolean diag_timestamp) {
        if (this.diagnostic_logger == null) {
            this.diagnostic_logger = AEDiagnostics.getLogger(FileUtil.convertOSSpecificChars(this.name, false));
            if (max_file_size > 0L) {
                this.diagnostic_logger.setMaxFileSize((int)max_file_size);
            }
            this.diagnostic_logger.enableTimeStamp(!this.timestamp && diag_timestamp);
            this.addListener(new LoggerChannelListener(){

                @Override
                public void messageLogged(int type, String content2) {
                    LoggerChannelImpl.this.diagnostic_logger.log(content2);
                }

                @Override
                public void messageLogged(String str, Throwable error) {
                    LoggerChannelImpl.this.diagnostic_logger.log(str);
                    LoggerChannelImpl.this.diagnostic_logger.log(error);
                }
            });
        }
    }

    private int LogTypePluginToCore(int pluginLogType) {
        switch (pluginLogType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private void notifyListeners(int log_type, String data) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                LoggerChannelListener l = (LoggerChannelListener)this.listeners.get(i);
                l.messageLogged(log_type, data);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    private void notifyListeners(String listenersText, Throwable error) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                LoggerChannelListener l = (LoggerChannelListener)this.listeners.get(i);
                l.messageLogged(listenersText, error);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void log(int log_type, String data) {
        this.notifyListeners(log_type, this.addTimeStamp(data));
        if (this.isEnabled() && !this.no_output) {
            data = "[" + this.name + "] " + data;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, this.LogTypePluginToCore(log_type), data));
        }
    }

    @Override
    public void log(String data) {
        this.log(1, data);
    }

    @Override
    public void log(Object[] relatedTo, int log_type, String data) {
        String listenerData;
        if (relatedTo != null) {
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < relatedTo.length) {
                Object obj = relatedTo[i];
                if (obj != null) {
                    if (i > 0) {
                        text.append("; ");
                    }
                    if (obj instanceof LogRelation) {
                        text.append(((LogRelation)obj).getRelationText());
                    } else {
                        text.append("RelatedTo[").append(obj.toString()).append("]");
                    }
                }
                ++i;
            }
            listenerData = String.valueOf(text.toString()) + "] " + data;
        } else {
            listenerData = data;
        }
        this.notifyListeners(log_type, this.addTimeStamp(listenerData));
        if (this.isEnabled() && !this.no_output) {
            data = "[" + this.name + "] " + data;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(relatedTo, LOGID, this.LogTypePluginToCore(log_type), data));
        }
    }

    @Override
    public void log(Object relatedTo, int log_type, String data) {
        this.log(new Object[]{relatedTo}, log_type, data);
    }

    @Override
    public void log(Throwable error) {
        this.log("", error);
    }

    @Override
    public void log(String str, Throwable error) {
        this.notifyListeners(str.equals("") ? "" : this.addTimeStamp(str), error);
        if (!this.no_output) {
            LogEvent event2 = new LogEvent(LOGID, "[" + this.name + "] " + str, error);
            org.gudy.azureus2.core3.logging.Logger.log(event2);
        }
    }

    @Override
    public void log(Object[] relatedTo, String str, Throwable error) {
        this.notifyListeners(str.equals("") ? "" : this.addTimeStamp(str), error);
        if (this.isEnabled() && !this.no_output) {
            str = "[" + this.name + "] " + str;
            org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(relatedTo, LOGID, str, error));
        }
    }

    @Override
    public void log(Object relatedTo, String str, Throwable error) {
        this.log(new Object[]{relatedTo}, str, error);
    }

    @Override
    public void log(Object[] relatedTo, String data) {
        this.log(relatedTo, 1, data);
    }

    @Override
    public void log(Object relatedTo, String data) {
        this.log(relatedTo, 1, data);
    }

    protected void logAlert(int alert_type, String message, boolean repeatable) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(alert_type, this.addTimeStamp(message));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        if (!this.no_output) {
            int at;
            switch (alert_type) {
                case 1: {
                    at = 0;
                    break;
                }
                case 2: {
                    at = 1;
                    break;
                }
                default: {
                    at = 3;
                }
            }
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(repeatable, at, message));
        }
    }

    @Override
    public void logAlert(int alert_type, String message) {
        this.logAlert(alert_type, message, false);
    }

    @Override
    public void logAlertRepeatable(int alert_type, String message) {
        this.logAlert(alert_type, message, true);
    }

    @Override
    public void logAlert(String message, Throwable e) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(message), e);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(false, message, e));
        }
    }

    @Override
    public void logAlertRepeatable(String message, Throwable e) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(this.addTimeStamp(message), e);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
        if (!this.no_output) {
            org.gudy.azureus2.core3.logging.Logger.log(new LogAlert(true, message, e));
        }
    }

    @Override
    public void addListener(LoggerChannelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(LoggerChannelListener l) {
        this.listeners.remove(l);
    }

    protected String addTimeStamp(String data) {
        if (this.timestamp) {
            return String.valueOf(this.getTimeStamp()) + data;
        }
        return data;
    }

    protected String getTimeStamp() {
        Calendar now = GregorianCalendar.getInstance();
        String timeStamp = "[" + now.get(11) + ":" + LoggerChannelImpl.format(now.get(12)) + ":" + LoggerChannelImpl.format(now.get(13)) + "] ";
        return timeStamp;
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }
}

