/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.net.URL;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadScrapeResultImpl
implements DownloadScrapeResult {
    protected DownloadImpl download;
    protected TRTrackerScraperResponse response;

    protected DownloadScrapeResultImpl(DownloadImpl _download, TRTrackerScraperResponse _response) {
        this.download = _download;
        this.response = _response;
    }

    protected void setContent(TRTrackerScraperResponse _response) {
        this.response = _response;
    }

    @Override
    public Download getDownload() {
        return this.download;
    }

    @Override
    public int getResponseType() {
        if (this.response != null && this.response.isValid()) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getSeedCount() {
        return this.response == null ? -1 : this.response.getSeeds();
    }

    @Override
    public int getNonSeedCount() {
        return this.response == null ? -1 : this.response.getPeers();
    }

    @Override
    public long getScrapeStartTime() {
        return this.response == null ? -1L : this.response.getScrapeStartTime();
    }

    @Override
    public void setNextScrapeStartTime(long nextScrapeStartTime) {
        TRTrackerScraperResponse current_response = this.getCurrentResponse();
        if (current_response != null) {
            current_response.setNextScrapeStartTime(nextScrapeStartTime);
        }
    }

    @Override
    public long getNextScrapeStartTime() {
        TRTrackerScraperResponse current_response = this.getCurrentResponse();
        return current_response == null ? -1L : current_response.getNextScrapeStartTime();
    }

    @Override
    public String getStatus() {
        if (this.response != null) {
            return this.response.getStatusString();
        }
        return "";
    }

    @Override
    public URL getURL() {
        if (this.response != null) {
            return this.response.getURL();
        }
        return null;
    }

    protected TRTrackerScraperResponse getCurrentResponse() {
        TRTrackerScraperResponse current = this.download.getDownload().getTrackerScrapeResponse();
        if (current == null) {
            current = this.response;
        }
        return current;
    }
}

