/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;

public class PluginManagerImpl
extends PluginManager {
    protected static boolean running = false;
    private static final boolean GET_PI_METHODS_OPERATIONAL_FLAG_DEFAULT = true;
    protected static PluginManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected static AzureusCore azureus_core;
    protected PluginInitializer pi;

    static {
        class_mon = new AEMonitor("PluginManager");
    }

    protected static PluginManagerImpl getSingleton(PluginInitializer pi) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginManagerImpl(pi);
            }
            PluginManagerImpl pluginManagerImpl = singleton;
            return pluginManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public static PluginManager startAzureus(int ui_type, Properties properties) {
        String disable_native;
        String doc_dir;
        String user_dir;
        try {
            class_mon.enter();
            if (running) {
                throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is already running");
            }
            running = true;
        }
        finally {
            class_mon.exit();
        }
        String config_dir = (String)properties.get("USER_DIR");
        if (config_dir != null) {
            System.setProperty("azureus.config.path", config_dir);
        }
        if ((user_dir = (String)properties.get("APP_DIR")) != null) {
            System.setProperty("azureus.install.path", user_dir);
            System.setProperty("user.dir", user_dir);
        }
        if ((doc_dir = (String)properties.get("DOC_DIR")) != null) {
            System.setProperty("azureus.doc.path", doc_dir);
        }
        if ((disable_native = (String)properties.get("DISABLE_NATIVE")) != null && disable_native.equalsIgnoreCase("true")) {
            System.setProperty("azureus.platform.manager.disable", "true");
        }
        if (ui_type == 0) {
            try {
                azureus_core = AzureusCoreFactory.create();
                azureus_core.start();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " failed to start", e);
            }
        }
        if (ui_type == 1) {
            String mi = (String)properties.get("MULTI_INSTANCE");
            if (mi != null && mi.equalsIgnoreCase("true")) {
                System.setProperty("MULTI_INSTANCE", "true");
            }
            try {
                Class.forName("org.gudy.azureus2.ui.swt.Main").getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
            }
            catch (Throwable e) {
                throw new RuntimeException("Main method invocation failed", e);
            }
        }
        if (azureus_core == null) {
            throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " core failed to initialise");
        }
        return azureus_core.getPluginManager();
    }

    public static void stopAzureus() throws PluginException {
        try {
            class_mon.enter();
            if (!running) {
                throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is not running");
            }
            try {
                azureus_core.requestStop();
            }
            catch (Throwable e) {
                throw new PluginException("PluginManager: " + Constants.APP_NAME + " close action failed", e);
            }
            running = false;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void restartAzureus() throws PluginException {
        if (!running) {
            throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is not running");
        }
        try {
            azureus_core.requestRestart();
        }
        catch (Throwable e) {
            throw new PluginException("PluginManager: " + Constants.APP_NAME + " restart action failed", e);
        }
        running = false;
    }

    public static void setStartDetails(AzureusCore _core) {
        azureus_core = _core;
        running = true;
    }

    public static void registerPlugin(Class plugin_class) {
        PluginInitializer.queueRegistration(plugin_class);
    }

    public static void registerPlugin(Plugin plugin, String id, String config_key) {
        PluginInitializer.queueRegistration(plugin, id, config_key);
    }

    @Override
    public PluginInterface getPluginInterfaceByID(String id) {
        return this.getPluginInterfaceByID(id, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByID(String id, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPluginID().equalsIgnoreCase(id)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(Class c) {
        return this.getPluginInterfaceByClass(c, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(Class c, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPlugin().getClass().equals(c)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(String class_name) {
        return this.getPluginInterfaceByClass(class_name, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(String class_name, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPlugin().getClass().getName().equals(class_name)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface[] getPluginInterfaces() {
        List<PluginInterfaceImpl> l = PluginInitializer.getPluginInterfaces();
        PluginInterface[] res = new PluginInterface[l.size()];
        l.toArray(res);
        return res;
    }

    @Override
    public PluginInterface getDefaultPluginInterface() {
        return PluginInitializer.getDefaultInterface();
    }

    protected PluginManagerImpl(PluginInitializer _pi) {
        this.pi = _pi;
        this.getPluginInstaller();
    }

    @Override
    public PluginInterface[] getPlugins() {
        return this.pi.getPlugins();
    }

    @Override
    public PluginInterface[] getPlugins(boolean expect_partial_result) {
        return this.pi.getPlugins(expect_partial_result);
    }

    @Override
    public void firePluginEvent(int ev) {
        PluginInitializer.fireEvent(ev);
    }

    @Override
    public PluginInstaller getPluginInstaller() {
        return PluginInstallerImpl.getSingleton(this);
    }

    @Override
    public void refreshPluginList(boolean initialise) {
        List loadedPlugins = this.pi.loadPlugins(this.pi.getAzureusCore(), true, true, false, initialise);
        for (PluginInterfaceImpl plugin : loadedPlugins) {
            if (plugin.getPluginState().isOperational()) continue;
            try {
                this.pi.reloadPlugin(plugin, false, initialise);
            }
            catch (PluginException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean isSilentRestartEnabled() {
        PluginInterface[] pis = this.pi.getPlugins();
        int i = 0;
        while (i < pis.length) {
            if (pis[i].getPluginProperties().getProperty("plugin.silentrestart.disabled", "").equalsIgnoreCase("true")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.pi.isInitialized();
    }

    @Override
    public void executeCloseAction(String action) throws PluginException {
        if (azureus_core == null) {
            throw new PluginException(String.valueOf(Constants.APP_NAME) + " is not running");
        }
        try {
            azureus_core.executeCloseAction(action, "plugin requested");
        }
        catch (Throwable e) {
            throw new PluginException("PluginManager: " + Constants.APP_NAME + " restart action failed", e);
        }
    }

    @Override
    public List<PluginInterface> getPluginsWithMethod(String name, Class<?>[] parameters) {
        ArrayList<PluginInterface> result = new ArrayList<PluginInterface>();
        List<PluginInterfaceImpl> pis = PluginInitializer.getPluginInterfaces();
        for (PluginInterfaceImpl pi : pis) {
            if (!pi.getIPC().canInvoke(name, parameters)) continue;
            result.add(pi);
        }
        return result;
    }
}

